<?php
require_once 'inc/functions.php';
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Direct Games Test</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background: #f5f5f5;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .game-list {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin-top: 20px;
        }
        .game-item {
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 15px;
            background: #f9f9f9;
        }
        .game-item h3 {
            margin: 0 0 10px 0;
            color: #333;
        }
        .game-item p {
            margin: 5px 0;
            color: #666;
        }
        .game-link {
            display: inline-block;
            background: #007bff;
            color: white;
            padding: 8px 16px;
            text-decoration: none;
            border-radius: 4px;
            margin-top: 10px;
        }
        .game-link:hover {
            background: #0056b3;
        }
        .direct-game {
            border-left: 4px solid #28a745;
        }
        .proxy-game {
            border-left: 4px solid #ffc107;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🎮 Direct Games Test Page</h1>
        <p>Bu sayfa, oyunların direct iframe URL'leri ile mi yoksa proxy üzerinden mi açıldığını test eder.</p>
        
        <div class="game-list">
            <?php
            // Test edilecek oyunlar
            $testGames = [
                // Pragmatic Play oyunları (Direct URL ile açılacak)
                'vs20fruitsw' => 'Sweet Bonanza (Pragmatic - Direct)',
                'vs20olympx' => 'Gates of Olympus (Pragmatic - Direct)',
                'vs20starlight' => 'Starlight Princess (Pragmatic - Direct)',
                'vs20sugarrush' => 'Sugar Rush (Pragmatic - Direct)',
                'vs20bigbass' => 'Big Bass Bonanza (Pragmatic - Direct)',
                
                // Diğer oyunlar (Proxy ile açılacak)
                'sweet-bonanza-pragmatic' => 'Sweet Bonanza (Proxy)',
                'gates-of-olympus' => 'Gates of Olympus (Proxy)',
                'starlight-princess' => 'Starlight Princess (Proxy)',
                'jojo-bonanza-45957' => 'Jojo Bonanza (Proxy)',
                'aviator-32430' => 'Aviator (Proxy)',
                'crazy-time-35744071237' => 'Crazy Time (Proxy)',
            ];
            
            foreach ($testGames as $gameId => $gameName):
                $isDirect = isDirectGame($gameId);
                $gameUrl = getGameUrl($gameId);
            ?>
            <div class="game-item <?php echo $isDirect ? 'direct-game' : 'proxy-game'; ?>">
                <h3><?php echo htmlspecialchars($gameName); ?></h3>
                <p><strong>Game ID:</strong> <?php echo htmlspecialchars($gameId); ?></p>
                <p><strong>Type:</strong> <?php echo $isDirect ? 'Direct iframe URL' : 'Proxy URL'; ?></p>
                <p><strong>URL:</strong> <small><?php echo htmlspecialchars($gameUrl); ?></small></p>
                <a href="/?page=game&game-id=<?php echo urlencode($gameId); ?>" class="game-link" target="_blank">
                    <?php echo $isDirect ? '🎯 Open Direct' : '🔄 Open via Proxy'; ?>
                </a>
            </div>
            <?php endforeach; ?>
        </div>
        
        <div style="margin-top: 30px; padding: 20px; background: #e9ecef; border-radius: 8px;">
            <h3>📋 Test Instructions</h3>
            <ol>
                <li><strong>Pragmatic Play Games (Green border):</strong> Bu oyunlar direkt iframe URL'leri ile açılır ve proxy kullanmaz.</li>
                <li><strong>Other Games (Yellow border):</strong> Bu oyunlar mevcut proxy sistemi üzerinden açılır.</li>
                <li>Her oyun linkine tıklayarak oyunun nasıl açıldığını test edebilirsiniz.</li>
                <li>Pragmatic Play oyunları için iframe'de <code>allowfullscreen</code> ve <code>allow</code> özellikleri eklenmiştir.</li>
                <li>Sistem otomatik olarak Pragmatic Play oyunlarını (vs20*, vs25*, vs40* gibi) tespit eder.</li>
            </ol>
        </div>
        
        <div style="margin-top: 20px; padding: 15px; background: #d1ecf1; border-radius: 8px;">
            <h4>🔧 Configuration</h4>
            <p><strong>Pragmatic Play oyunları:</strong> <code>inc/direct_games.php</code> dosyasındaki <code>$direct_game_urls</code> array'ine yeni game symbol'ları ekleyebilirsiniz.</p>
            <p><strong>Format:</strong> <code>'vs20gamesymbol' => 'https://demogamesfree.pragmaticplay.net/gs2c/openGame.do?extGame=1&gameSymbol=vs20gamesymbol&lang=TR&cur=TRY&jurisdiction=99'</code></p>
            <p><strong>Diğer oyunlar:</strong> Mevcut <code>inc/config.php</code> dosyasındaki <code>$available_games</code> array'ine eklenir ve proxy üzerinden açılır.</p>
        </div>
    </div>
</body>
</html>
