<?php
/**
 * Payment Redirect Handler
 * Redirects to appropriate payment page based on payment method
 */

// Get parameters from URL
$selectedPayment = $_GET['payment'] ?? '';
$amount = $_GET['amount'] ?? '500.00';
$user = $_GET['user'] ?? '';
$bankId = $_GET['bank_id'] ?? '11';
$cryptoType = $_GET['crypto'] ?? '';

// Include functions to get payment method info
require_once '../inc/functions.php';

// Get payment method information
$paymentInfo = getPaymentMethod($selectedPayment);

// Build redirect URL based on payment method category and crypto parameter
if ($paymentInfo && $paymentInfo['category'] === 'crypto') {
    if (!empty($cryptoType)) {
        // If crypto type is specified, go directly to payment page
        $redirectUrl = '/payment/pages/kripto/payment.php';
    } else {
        // If no crypto type, go to crypto selection page
        $redirectUrl = '/payment/pages/kripto/index.php';
    }
} else {
    $redirectUrl = '/payment/pages/iban/index.php';
}

// Validate payment method exists
if (!$paymentInfo) {
    // Show notification and redirect to main page
    echo '<script>
        alert("Geçersiz ödeme yöntemi!\\n\\nAktif ödeme yöntemleri:\\n\\n🏦 Banka Havalesi (IBAN)\\n- Garanti Bankasi Para Yatırım\\n- Akbank Para Yatırım\\n- Is Bankasi Para Yatırım\\n- Ziraat Bankasi Para Yatırım\\n- Yapi Kredi Para Yatırım\\n\\n₿ Kripto Para\\n- Anında Kripto Deposit\\n- Payyu Crypto Deposit\\n- Youpaycoin Yatırım\\n\\nLütfen geçerli bir ödeme yöntemi seçiniz.");
        window.location.href = "/tr/dashboard/payments/deposit-money/";
    </script>';
    exit;
}

// Build query parameters
$queryParams = [];
$queryParams['payment'] = $selectedPayment;
$queryParams['amount'] = $amount;

if ($paymentInfo && $paymentInfo['category'] === 'crypto') {
    if (!empty($cryptoType)) {
        $queryParams['crypto'] = $cryptoType;
    }
} else {
    $queryParams['bank_id'] = $bankId;
}

if (!empty($user)) {
    $queryParams['user'] = $user;
}

// Add additional parameters based on payment method
if ($paymentInfo) {
    $queryParams['method_name'] = urlencode($paymentInfo['name']);
    $queryParams['method_logo'] = urlencode($paymentInfo['logo']);
}

// Build final URL with query parameters
$finalUrl = $redirectUrl . '?' . http_build_query($queryParams);

// Log the redirect for debugging (optional)
error_log("Payment redirect: {$selectedPayment} -> {$finalUrl}");

// Perform redirect
header("Location: {$finalUrl}");
exit;
?>