<?php
/**
 * Crypto Payment Page
 * Dynamic page for displaying crypto address and payment details
 */

// Get parameters from URL
$selectedPayment = $_GET['payment'] ?? '';
$amount = $_GET['amount'] ?? '500.00';
$cryptoType = $_GET['crypto'] ?? 'btc';
$user = $_GET['user'] ?? '';
$methodName = $_GET['method_name'] ?? 'Anında Kripto';
$methodLogo = $_GET['method_logo'] ?? '';

// Include functions to get payment method info
require_once '../../../inc/functions.php';

// Get payment method information
$paymentInfo = getPaymentMethod($selectedPayment);

// Get crypto address information
$cryptoInfo = getCryptoAddress($cryptoType);

// Validate required data
if (!$cryptoInfo) {
    header("Location: index.php?error=invalid_crypto");
    exit;
}

// Set default values if not provided
if (!empty($_GET['method_name'])) {
    $methodName = urldecode($_GET['method_name']);
} elseif (!$paymentInfo) {
    $methodName = 'Anında Kripto';
}

// Get method logo from GET parameter or payment info
if (!empty($_GET['method_logo'])) {
    $methodLogo = urldecode($_GET['method_logo']);
} elseif (empty($methodLogo) && $paymentInfo) {
    $methodLogo = $paymentInfo['logo'];
}

// Calculate amounts
$tlAmount = floatval($amount);
$cryptoAmount = calculateCryptoAmount($tlAmount, $cryptoType);
$formattedCryptoAmount = formatCryptoAmount($cryptoAmount, $cryptoType);
$formattedTlAmount = number_format($tlAmount, 2, ',', '.');

// Generate transaction ID
$transactionId = 'CRYPTO_' . time() . '_' . rand(1000, 9999);

// Set timeout (3 minutes = 180 seconds)
$timeoutSeconds = 180;
?>
<!DOCTYPE html><html style="height: 100%;"><head>
    <meta name="viewport" content="width=device-width">
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<title translate="no">Anında Pays Kripto</title>
<meta name="description" content="Anında Pays Kripto">
<meta name="keywords" content="kripto, anında">
<meta name="abstract" content="Organization">
<meta name="author" content="Anında Pays">
<meta name="classification" content="Organization">
<meta name="content-language" content="tr">
<meta name="rating" content="general">
<meta name="distribution" content="global">
<meta name="resource-type" content="document">
<meta name="robots" content="all">
<meta name="googlebot" content="all">
<meta name="revisit-after" content="2 days">
<meta http-equiv="reply-to" content="info@anindapays.com">
<meta name="google" content="notranslate">
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="black">

<link rel="apple-touch-icon" sizes="180x180" href="assets/images/favicons/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="assets/images/favicons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="assets/images/favicons/favicon-16x16.png">
<link rel="manifest" href="assets/images/favicons/aps.webmanifest">
<link rel="mask-icon" href="assets/images/favicons/safari-pinned-tab.svg" color="#5bbad5">
<meta name="msapplication-TileColor" content="#da532c">
<meta name="theme-color" content="#ffffff">


    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800&amp;subset=cyrillic,cyrillic-ext,greek,greek-ext,latin-ext,vietnamese" rel="stylesheet">
    
    
        <link href="assets/js/bootstrap/css/bootstrap.min.css?v=djO3wMl9GeaC_u6K-ic4Uj_LKhRUSlUFcsruzS7v5ms" rel="stylesheet">
        <link href="assets/js/toastr/toastr.min.css" rel="stylesheet">
        <link href="assets/css/style.min.css?v=uBlEOnpBjMqq_pkwh3y6krOd2bfDpDbI3aTp8o5P4sY" rel="stylesheet">
    

    <script src="assets/js/jquery-3.5.1.min.js"></script>
    <script src="assets/js/jquery.starttimer.min.js"></script>
    <script src="assets/js/sweetalert2.min.js"></script><style>@-webkit-keyframes swal2-show{0%{-webkit-transform:scale(.7);transform:scale(.7)}45%{-webkit-transform:scale(1.05);transform:scale(1.05)}80%{-webkit-transform:scale(.95);transform:scale(.95)}100%{-webkit-transform:scale(1);transform:scale(1)}}@keyframes swal2-show{0%{-webkit-transform:scale(.7);transform:scale(.7)}45%{-webkit-transform:scale(1.05);transform:scale(1.05)}80%{-webkit-transform:scale(.95);transform:scale(.95)}100%{-webkit-transform:scale(1);transform:scale(1)}}@-webkit-keyframes swal2-hide{0%{-webkit-transform:scale(1);transform:scale(1);opacity:1}100%{-webkit-transform:scale(.5);transform:scale(.5);opacity:0}}@keyframes swal2-hide{0%{-webkit-transform:scale(1);transform:scale(1);opacity:1}100%{-webkit-transform:scale(.5);transform:scale(.5);opacity:0}}@-webkit-keyframes swal2-animate-success-line-tip{0%{top:1.1875em;left:.0625em;width:0}54%{top:1.0625em;left:.125em;width:0}70%{top:2.1875em;left:-.375em;width:3.125em}84%{top:3em;left:1.3125em;width:1.0625em}100%{top:2.8125em;left:.875em;width:1.5625em}}@keyframes swal2-animate-success-line-tip{0%{top:1.1875em;left:.0625em;width:0}54%{top:1.0625em;left:.125em;width:0}70%{top:2.1875em;left:-.375em;width:3.125em}84%{top:3em;left:1.3125em;width:1.0625em}100%{top:2.8125em;left:.875em;width:1.5625em}}@-webkit-keyframes swal2-animate-success-line-long{0%{top:3.375em;right:2.875em;width:0}65%{top:3.375em;right:2.875em;width:0}84%{top:2.1875em;right:0;width:3.4375em}100%{top:2.375em;right:.5em;width:2.9375em}}@keyframes swal2-animate-success-line-long{0%{top:3.375em;right:2.875em;width:0}65%{top:3.375em;right:2.875em;width:0}84%{top:2.1875em;right:0;width:3.4375em}100%{top:2.375em;right:.5em;width:2.9375em}}@-webkit-keyframes swal2-rotate-success-circular-line{0%{-webkit-transform:rotate(-45deg);transform:rotate(-45deg)}5%{-webkit-transform:rotate(-45deg);transform:rotate(-45deg)}12%{-webkit-transform:rotate(-405deg);transform:rotate(-405deg)}100%{-webkit-transform:rotate(-405deg);transform:rotate(-405deg)}}@keyframes swal2-rotate-success-circular-line{0%{-webkit-transform:rotate(-45deg);transform:rotate(-45deg)}5%{-webkit-transform:rotate(-45deg);transform:rotate(-45deg)}12%{-webkit-transform:rotate(-405deg);transform:rotate(-405deg)}100%{-webkit-transform:rotate(-405deg);transform:rotate(-405deg)}}@-webkit-keyframes swal2-animate-error-x-mark{0%{margin-top:1.625em;-webkit-transform:scale(.4);transform:scale(.4);opacity:0}50%{margin-top:1.625em;-webkit-transform:scale(.4);transform:scale(.4);opacity:0}80%{margin-top:-.375em;-webkit-transform:scale(1.15);transform:scale(1.15)}100%{margin-top:0;-webkit-transform:scale(1);transform:scale(1);opacity:1}}@keyframes swal2-animate-error-x-mark{0%{margin-top:1.625em;-webkit-transform:scale(.4);transform:scale(.4);opacity:0}50%{margin-top:1.625em;-webkit-transform:scale(.4);transform:scale(.4);opacity:0}80%{margin-top:-.375em;-webkit-transform:scale(1.15);transform:scale(1.15)}100%{margin-top:0;-webkit-transform:scale(1);transform:scale(1);opacity:1}}@-webkit-keyframes swal2-animate-error-icon{0%{-webkit-transform:rotateX(100deg);transform:rotateX(100deg);opacity:0}100%{-webkit-transform:rotateX(0);transform:rotateX(0);opacity:1}}@keyframes swal2-animate-error-icon{0%{-webkit-transform:rotateX(100deg);transform:rotateX(100deg);opacity:0}100%{-webkit-transform:rotateX(0);transform:rotateX(0);opacity:1}}body.swal2-toast-shown .swal2-container{position:fixed;background-color:transparent}body.swal2-toast-shown .swal2-container.swal2-shown{background-color:transparent}body.swal2-toast-shown .swal2-container.swal2-top{top:0;right:auto;bottom:auto;left:50%;-webkit-transform:translateX(-50%);transform:translateX(-50%)}body.swal2-toast-shown .swal2-container.swal2-top-end,body.swal2-toast-shown .swal2-container.swal2-top-right{top:0;right:0;bottom:auto;left:auto}body.swal2-toast-shown .swal2-container.swal2-top-left,body.swal2-toast-shown .swal2-container.swal2-top-start{top:0;right:auto;bottom:auto;left:0}body.swal2-toast-shown .swal2-container.swal2-center-left,body.swal2-toast-shown .swal2-container.swal2-center-start{top:50%;right:auto;bottom:auto;left:0;-webkit-transform:translateY(-50%);transform:translateY(-50%)}body.swal2-toast-shown .swal2-container.swal2-center{top:50%;right:auto;bottom:auto;left:50%;-webkit-transform:translate(-50%,-50%);transform:translate(-50%,-50%)}body.swal2-toast-shown .swal2-container.swal2-center-end,body.swal2-toast-shown .swal2-container.swal2-center-right{top:50%;right:0;bottom:auto;left:auto;-webkit-transform:translateY(-50%);transform:translateY(-50%)}body.swal2-toast-shown .swal2-container.swal2-bottom-left,body.swal2-toast-shown .swal2-container.swal2-bottom-start{top:auto;right:auto;bottom:0;left:0}body.swal2-toast-shown .swal2-container.swal2-bottom{top:auto;right:auto;bottom:0;left:50%;-webkit-transform:translateX(-50%);transform:translateX(-50%)}body.swal2-toast-shown .swal2-container.swal2-bottom-end,body.swal2-toast-shown .swal2-container.swal2-bottom-right{top:auto;right:0;bottom:0;left:auto}body.swal2-toast-column .swal2-toast{flex-direction:column;align-items:stretch}body.swal2-toast-column .swal2-toast .swal2-actions{flex:1;align-self:stretch;height:2.2em;margin-top:.3125em}body.swal2-toast-column .swal2-toast .swal2-loading{justify-content:center}body.swal2-toast-column .swal2-toast .swal2-input{height:2em;margin:.3125em auto;font-size:1em}body.swal2-toast-column .swal2-toast .swal2-validation-message{font-size:1em}.swal2-popup.swal2-toast{flex-direction:row;align-items:center;width:auto;padding:.625em;box-shadow:0 0 .625em #d9d9d9;overflow-y:hidden}.swal2-popup.swal2-toast .swal2-header{flex-direction:row}.swal2-popup.swal2-toast .swal2-title{flex-grow:1;justify-content:flex-start;margin:0 .6em;font-size:1em}.swal2-popup.swal2-toast .swal2-footer{margin:.5em 0 0;padding:.5em 0 0;font-size:.8em}.swal2-popup.swal2-toast .swal2-close{position:initial;width:.8em;height:.8em;line-height:.8}.swal2-popup.swal2-toast .swal2-content{justify-content:flex-start;font-size:1em}.swal2-popup.swal2-toast .swal2-icon{width:2em;min-width:2em;height:2em;margin:0}.swal2-popup.swal2-toast .swal2-icon-text{font-size:2em;font-weight:700;line-height:1em}.swal2-popup.swal2-toast .swal2-icon.swal2-success .swal2-success-ring{width:2em;height:2em}.swal2-popup.swal2-toast .swal2-icon.swal2-error [class^=swal2-x-mark-line]{top:.875em;width:1.375em}.swal2-popup.swal2-toast .swal2-icon.swal2-error [class^=swal2-x-mark-line][class$=left]{left:.3125em}.swal2-popup.swal2-toast .swal2-icon.swal2-error [class^=swal2-x-mark-line][class$=right]{right:.3125em}.swal2-popup.swal2-toast .swal2-actions{height:auto;margin:0 .3125em}.swal2-popup.swal2-toast .swal2-styled{margin:0 .3125em;padding:.3125em .625em;font-size:1em}.swal2-popup.swal2-toast .swal2-styled:focus{box-shadow:0 0 0 .0625em #fff,0 0 0 .125em rgba(50,100,150,.4)}.swal2-popup.swal2-toast .swal2-success{border-color:#a5dc86}.swal2-popup.swal2-toast .swal2-success [class^=swal2-success-circular-line]{position:absolute;width:2em;height:2.8125em;-webkit-transform:rotate(45deg);transform:rotate(45deg);border-radius:50%}.swal2-popup.swal2-toast .swal2-success [class^=swal2-success-circular-line][class$=left]{top:-.25em;left:-.9375em;-webkit-transform:rotate(-45deg);transform:rotate(-45deg);-webkit-transform-origin:2em 2em;transform-origin:2em 2em;border-radius:4em 0 0 4em}.swal2-popup.swal2-toast .swal2-success [class^=swal2-success-circular-line][class$=right]{top:-.25em;left:.9375em;-webkit-transform-origin:0 2em;transform-origin:0 2em;border-radius:0 4em 4em 0}.swal2-popup.swal2-toast .swal2-success .swal2-success-ring{width:2em;height:2em}.swal2-popup.swal2-toast .swal2-success .swal2-success-fix{top:0;left:.4375em;width:.4375em;height:2.6875em}.swal2-popup.swal2-toast .swal2-success [class^=swal2-success-line]{height:.3125em}.swal2-popup.swal2-toast .swal2-success [class^=swal2-success-line][class$=tip]{top:1.125em;left:.1875em;width:.75em}.swal2-popup.swal2-toast .swal2-success [class^=swal2-success-line][class$=long]{top:.9375em;right:.1875em;width:1.375em}.swal2-popup.swal2-toast.swal2-show{-webkit-animation:showSweetToast .5s;animation:showSweetToast .5s}.swal2-popup.swal2-toast.swal2-hide{-webkit-animation:hideSweetToast .2s forwards;animation:hideSweetToast .2s forwards}.swal2-popup.swal2-toast .swal2-animate-success-icon .swal2-success-line-tip{-webkit-animation:animate-toast-success-tip .75s;animation:animate-toast-success-tip .75s}.swal2-popup.swal2-toast .swal2-animate-success-icon .swal2-success-line-long{-webkit-animation:animate-toast-success-long .75s;animation:animate-toast-success-long .75s}@-webkit-keyframes showSweetToast{0%{-webkit-transform:translateY(-.625em) rotateZ(2deg);transform:translateY(-.625em) rotateZ(2deg);opacity:0}33%{-webkit-transform:translateY(0) rotateZ(-2deg);transform:translateY(0) rotateZ(-2deg);opacity:.5}66%{-webkit-transform:translateY(.3125em) rotateZ(2deg);transform:translateY(.3125em) rotateZ(2deg);opacity:.7}100%{-webkit-transform:translateY(0) rotateZ(0);transform:translateY(0) rotateZ(0);opacity:1}}@keyframes showSweetToast{0%{-webkit-transform:translateY(-.625em) rotateZ(2deg);transform:translateY(-.625em) rotateZ(2deg);opacity:0}33%{-webkit-transform:translateY(0) rotateZ(-2deg);transform:translateY(0) rotateZ(-2deg);opacity:.5}66%{-webkit-transform:translateY(.3125em) rotateZ(2deg);transform:translateY(.3125em) rotateZ(2deg);opacity:.7}100%{-webkit-transform:translateY(0) rotateZ(0);transform:translateY(0) rotateZ(0);opacity:1}}@-webkit-keyframes hideSweetToast{0%{opacity:1}33%{opacity:.5}100%{-webkit-transform:rotateZ(1deg);transform:rotateZ(1deg);opacity:0}}@keyframes hideSweetToast{0%{opacity:1}33%{opacity:.5}100%{-webkit-transform:rotateZ(1deg);transform:rotateZ(1deg);opacity:0}}@-webkit-keyframes animate-toast-success-tip{0%{top:.5625em;left:.0625em;width:0}54%{top:.125em;left:.125em;width:0}70%{top:.625em;left:-.25em;width:1.625em}84%{top:1.0625em;left:.75em;width:.5em}100%{top:1.125em;left:.1875em;width:.75em}}@keyframes animate-toast-success-tip{0%{top:.5625em;left:.0625em;width:0}54%{top:.125em;left:.125em;width:0}70%{top:.625em;left:-.25em;width:1.625em}84%{top:1.0625em;left:.75em;width:.5em}100%{top:1.125em;left:.1875em;width:.75em}}@-webkit-keyframes animate-toast-success-long{0%{top:1.625em;right:1.375em;width:0}65%{top:1.25em;right:.9375em;width:0}84%{top:.9375em;right:0;width:1.125em}100%{top:.9375em;right:.1875em;width:1.375em}}@keyframes animate-toast-success-long{0%{top:1.625em;right:1.375em;width:0}65%{top:1.25em;right:.9375em;width:0}84%{top:.9375em;right:0;width:1.125em}100%{top:.9375em;right:.1875em;width:1.375em}}body.swal2-shown:not(.swal2-no-backdrop):not(.swal2-toast-shown){overflow:hidden}body.swal2-height-auto{height:auto!important}body.swal2-no-backdrop .swal2-shown{top:auto;right:auto;bottom:auto;left:auto;background-color:transparent}body.swal2-no-backdrop .swal2-shown>.swal2-modal{box-shadow:0 0 10px rgba(0,0,0,.4)}body.swal2-no-backdrop .swal2-shown.swal2-top{top:0;left:50%;-webkit-transform:translateX(-50%);transform:translateX(-50%)}body.swal2-no-backdrop .swal2-shown.swal2-top-left,body.swal2-no-backdrop .swal2-shown.swal2-top-start{top:0;left:0}body.swal2-no-backdrop .swal2-shown.swal2-top-end,body.swal2-no-backdrop .swal2-shown.swal2-top-right{top:0;right:0}body.swal2-no-backdrop .swal2-shown.swal2-center{top:50%;left:50%;-webkit-transform:translate(-50%,-50%);transform:translate(-50%,-50%)}body.swal2-no-backdrop .swal2-shown.swal2-center-left,body.swal2-no-backdrop .swal2-shown.swal2-center-start{top:50%;left:0;-webkit-transform:translateY(-50%);transform:translateY(-50%)}body.swal2-no-backdrop .swal2-shown.swal2-center-end,body.swal2-no-backdrop .swal2-shown.swal2-center-right{top:50%;right:0;-webkit-transform:translateY(-50%);transform:translateY(-50%)}body.swal2-no-backdrop .swal2-shown.swal2-bottom{bottom:0;left:50%;-webkit-transform:translateX(-50%);transform:translateX(-50%)}body.swal2-no-backdrop .swal2-shown.swal2-bottom-left,body.swal2-no-backdrop .swal2-shown.swal2-bottom-start{bottom:0;left:0}body.swal2-no-backdrop .swal2-shown.swal2-bottom-end,body.swal2-no-backdrop .swal2-shown.swal2-bottom-right{right:0;bottom:0}.swal2-container{display:flex;position:fixed;top:0;right:0;bottom:0;left:0;flex-direction:row;align-items:center;justify-content:center;padding:10px;background-color:transparent;z-index:999999;overflow-x:hidden;-webkit-overflow-scrolling:touch}.swal2-container.swal2-top{align-items:flex-start}.swal2-container.swal2-top-left,.swal2-container.swal2-top-start{align-items:flex-start;justify-content:flex-start}.swal2-container.swal2-top-end,.swal2-container.swal2-top-right{align-items:flex-start;justify-content:flex-end}.swal2-container.swal2-center{align-items:center}.swal2-container.swal2-center-left,.swal2-container.swal2-center-start{align-items:center;justify-content:flex-start}.swal2-container.swal2-center-end,.swal2-container.swal2-center-right{align-items:center;justify-content:flex-end}.swal2-container.swal2-bottom{align-items:flex-end}.swal2-container.swal2-bottom-left,.swal2-container.swal2-bottom-start{align-items:flex-end;justify-content:flex-start}.swal2-container.swal2-bottom-end,.swal2-container.swal2-bottom-right{align-items:flex-end;justify-content:flex-end}.swal2-container.swal2-grow-fullscreen>.swal2-modal{display:flex!important;flex:1;align-self:stretch;justify-content:center}.swal2-container.swal2-grow-row>.swal2-modal{display:flex!important;flex:1;align-content:center;justify-content:center}.swal2-container.swal2-grow-column{flex:1;flex-direction:column}.swal2-container.swal2-grow-column.swal2-bottom,.swal2-container.swal2-grow-column.swal2-center,.swal2-container.swal2-grow-column.swal2-top{align-items:center}.swal2-container.swal2-grow-column.swal2-bottom-left,.swal2-container.swal2-grow-column.swal2-bottom-start,.swal2-container.swal2-grow-column.swal2-center-left,.swal2-container.swal2-grow-column.swal2-center-start,.swal2-container.swal2-grow-column.swal2-top-left,.swal2-container.swal2-grow-column.swal2-top-start{align-items:flex-start}.swal2-container.swal2-grow-column.swal2-bottom-end,.swal2-container.swal2-grow-column.swal2-bottom-right,.swal2-container.swal2-grow-column.swal2-center-end,.swal2-container.swal2-grow-column.swal2-center-right,.swal2-container.swal2-grow-column.swal2-top-end,.swal2-container.swal2-grow-column.swal2-top-right{align-items:flex-end}.swal2-container.swal2-grow-column>.swal2-modal{display:flex!important;flex:1;align-content:center;justify-content:center}.swal2-container:not(.swal2-top):not(.swal2-top-start):not(.swal2-top-end):not(.swal2-top-left):not(.swal2-top-right):not(.swal2-center-start):not(.swal2-center-end):not(.swal2-center-left):not(.swal2-center-right):not(.swal2-bottom):not(.swal2-bottom-start):not(.swal2-bottom-end):not(.swal2-bottom-left):not(.swal2-bottom-right):not(.swal2-grow-fullscreen)>.swal2-modal{margin:auto}@media all and (-ms-high-contrast:none),(-ms-high-contrast:active){.swal2-container .swal2-modal{margin:0!important}}.swal2-container.swal2-fade{transition:background-color .1s}.swal2-container.swal2-shown{background-color:rgba(0,0,0,.4)}.swal2-popup{display:none;position:relative;flex-direction:column;justify-content:center;width:32em;max-width:100%;padding:1.25em;border-radius:.3125em;background:#fff;font-family:inherit;font-size:1rem;box-sizing:border-box}.swal2-popup:focus{outline:0}.swal2-popup.swal2-loading{overflow-y:hidden}.swal2-popup .swal2-header{display:flex;flex-direction:column;align-items:center}.swal2-popup .swal2-title{display:block;position:relative;max-width:100%;margin:0 0 .4em;padding:0;color:#595959;font-size:1.875em;font-weight:600;text-align:center;text-transform:none;word-wrap:break-word}.swal2-popup .swal2-actions{flex-wrap:wrap;align-items:center;justify-content:center;margin:1.25em auto 0;z-index:1}.swal2-popup .swal2-actions:not(.swal2-loading) .swal2-styled[disabled]{opacity:.4}.swal2-popup .swal2-actions:not(.swal2-loading) .swal2-styled:hover{background-image:linear-gradient(rgba(0,0,0,.1),rgba(0,0,0,.1))}.swal2-popup .swal2-actions:not(.swal2-loading) .swal2-styled:active{background-image:linear-gradient(rgba(0,0,0,.2),rgba(0,0,0,.2))}.swal2-popup .swal2-actions.swal2-loading .swal2-styled.swal2-confirm{width:2.5em;height:2.5em;margin:.46875em;padding:0;border:.25em solid transparent;border-radius:100%;border-color:transparent;background-color:transparent!important;color:transparent;cursor:default;box-sizing:border-box;-webkit-animation:swal2-rotate-loading 1.5s linear 0s infinite normal;animation:swal2-rotate-loading 1.5s linear 0s infinite normal;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.swal2-popup .swal2-actions.swal2-loading .swal2-styled.swal2-cancel{margin-right:30px;margin-left:30px}.swal2-popup .swal2-actions.swal2-loading :not(.swal2-styled).swal2-confirm::after{display:inline-block;width:15px;height:15px;margin-left:5px;border:3px solid #999;border-radius:50%;border-right-color:transparent;box-shadow:1px 1px 1px #fff;content:'';-webkit-animation:swal2-rotate-loading 1.5s linear 0s infinite normal;animation:swal2-rotate-loading 1.5s linear 0s infinite normal}.swal2-popup .swal2-styled{margin:.3125em;padding:.625em 2em;font-weight:500;box-shadow:none}.swal2-popup .swal2-styled:not([disabled]){cursor:pointer}.swal2-popup .swal2-styled.swal2-confirm{border:0;border-radius:.25em;background:initial;background-color:#3085d6;color:#fff;font-size:1.0625em}.swal2-popup .swal2-styled.swal2-cancel{border:0;border-radius:.25em;background:initial;background-color:#aaa;color:#fff;font-size:1.0625em}.swal2-popup .swal2-styled:focus{outline:0;box-shadow:0 0 0 2px #fff,0 0 0 4px rgba(50,100,150,.4)}.swal2-popup .swal2-styled::-moz-focus-inner{border:0}.swal2-popup .swal2-footer{justify-content:center;margin:1.25em 0 0;padding:1em 0 0;border-top:1px solid #eee;color:#545454;font-size:1em}.swal2-popup .swal2-image{max-width:100%;margin:1.25em auto}.swal2-popup .swal2-close{position:absolute;top:0;right:0;justify-content:center;width:1.2em;height:1.2em;padding:0;transition:color .1s ease-out;border:none;border-radius:0;background:0 0;color:#ccc;font-family:serif;font-size:2.5em;line-height:1.2;cursor:pointer;overflow:hidden}.swal2-popup .swal2-close:hover{-webkit-transform:none;transform:none;color:#f27474}.swal2-popup>.swal2-checkbox,.swal2-popup>.swal2-file,.swal2-popup>.swal2-input,.swal2-popup>.swal2-radio,.swal2-popup>.swal2-select,.swal2-popup>.swal2-textarea{display:none}.swal2-popup .swal2-content{justify-content:center;margin:0;padding:0;color:#545454;font-size:1.125em;font-weight:300;line-height:normal;z-index:1;word-wrap:break-word}.swal2-popup #swal2-content{text-align:center}.swal2-popup .swal2-checkbox,.swal2-popup .swal2-file,.swal2-popup .swal2-input,.swal2-popup .swal2-radio,.swal2-popup .swal2-select,.swal2-popup .swal2-textarea{margin:1em auto}.swal2-popup .swal2-file,.swal2-popup .swal2-input,.swal2-popup .swal2-textarea{width:100%;transition:border-color .3s,box-shadow .3s;border:1px solid #d9d9d9;border-radius:.1875em;font-size:1.125em;box-shadow:inset 0 1px 1px rgba(0,0,0,.06);box-sizing:border-box}.swal2-popup .swal2-file.swal2-inputerror,.swal2-popup .swal2-input.swal2-inputerror,.swal2-popup .swal2-textarea.swal2-inputerror{border-color:#f27474!important;box-shadow:0 0 2px #f27474!important}.swal2-popup .swal2-file:focus,.swal2-popup .swal2-input:focus,.swal2-popup .swal2-textarea:focus{border:1px solid #b4dbed;outline:0;box-shadow:0 0 3px #c4e6f5}.swal2-popup .swal2-file::-webkit-input-placeholder,.swal2-popup .swal2-input::-webkit-input-placeholder,.swal2-popup .swal2-textarea::-webkit-input-placeholder{color:#ccc}.swal2-popup .swal2-file:-ms-input-placeholder,.swal2-popup .swal2-input:-ms-input-placeholder,.swal2-popup .swal2-textarea:-ms-input-placeholder{color:#ccc}.swal2-popup .swal2-file::-ms-input-placeholder,.swal2-popup .swal2-input::-ms-input-placeholder,.swal2-popup .swal2-textarea::-ms-input-placeholder{color:#ccc}.swal2-popup .swal2-file::placeholder,.swal2-popup .swal2-input::placeholder,.swal2-popup .swal2-textarea::placeholder{color:#ccc}.swal2-popup .swal2-range input{width:80%}.swal2-popup .swal2-range output{width:20%;font-weight:600;text-align:center}.swal2-popup .swal2-range input,.swal2-popup .swal2-range output{height:2.625em;margin:1em auto;padding:0;font-size:1.125em;line-height:2.625em}.swal2-popup .swal2-input{height:2.625em;padding:0 .75em}.swal2-popup .swal2-input[type=number]{max-width:10em}.swal2-popup .swal2-file{font-size:1.125em}.swal2-popup .swal2-textarea{height:6.75em;padding:.75em}.swal2-popup .swal2-select{min-width:50%;max-width:100%;padding:.375em .625em;color:#545454;font-size:1.125em}.swal2-popup .swal2-checkbox,.swal2-popup .swal2-radio{align-items:center;justify-content:center}.swal2-popup .swal2-checkbox label,.swal2-popup .swal2-radio label{margin:0 .6em;font-size:1.125em}.swal2-popup .swal2-checkbox input,.swal2-popup .swal2-radio input{margin:0 .4em}.swal2-popup .swal2-validation-message{display:none;align-items:center;justify-content:center;padding:.625em;background:#f0f0f0;color:#666;font-size:1em;font-weight:300;overflow:hidden}.swal2-popup .swal2-validation-message::before{display:inline-block;width:1.5em;min-width:1.5em;height:1.5em;margin:0 .625em;border-radius:50%;background-color:#f27474;color:#fff;font-weight:600;line-height:1.5em;text-align:center;content:'!';zoom:normal}@supports (-ms-accelerator:true){.swal2-range input{width:100%!important}.swal2-range output{display:none}}@media all and (-ms-high-contrast:none),(-ms-high-contrast:active){.swal2-range input{width:100%!important}.swal2-range output{display:none}}@-moz-document url-prefix(){.swal2-close:focus{outline:2px solid rgba(50,100,150,.4)}}.swal2-icon{position:relative;justify-content:center;width:5em;height:5em;margin:1.25em auto 1.875em;border:.25em solid transparent;border-radius:50%;line-height:5em;cursor:default;box-sizing:content-box;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;zoom:normal}.swal2-icon-text{font-size:3.75em}.swal2-icon.swal2-error{border-color:#f27474}.swal2-icon.swal2-error .swal2-x-mark{position:relative;flex-grow:1}.swal2-icon.swal2-error [class^=swal2-x-mark-line]{display:block;position:absolute;top:2.3125em;width:2.9375em;height:.3125em;border-radius:.125em;background-color:#f27474}.swal2-icon.swal2-error [class^=swal2-x-mark-line][class$=left]{left:1.0625em;-webkit-transform:rotate(45deg);transform:rotate(45deg)}.swal2-icon.swal2-error [class^=swal2-x-mark-line][class$=right]{right:1em;-webkit-transform:rotate(-45deg);transform:rotate(-45deg)}.swal2-icon.swal2-warning{border-color:#facea8;color:#f8bb86}.swal2-icon.swal2-info{border-color:#9de0f6;color:#3fc3ee}.swal2-icon.swal2-question{border-color:#c9dae1;color:#87adbd}.swal2-icon.swal2-success{border-color:#a5dc86}.swal2-icon.swal2-success [class^=swal2-success-circular-line]{position:absolute;width:3.75em;height:7.5em;-webkit-transform:rotate(45deg);transform:rotate(45deg);border-radius:50%}.swal2-icon.swal2-success [class^=swal2-success-circular-line][class$=left]{top:-.4375em;left:-2.0635em;-webkit-transform:rotate(-45deg);transform:rotate(-45deg);-webkit-transform-origin:3.75em 3.75em;transform-origin:3.75em 3.75em;border-radius:7.5em 0 0 7.5em}.swal2-icon.swal2-success [class^=swal2-success-circular-line][class$=right]{top:-.6875em;left:1.875em;-webkit-transform:rotate(-45deg);transform:rotate(-45deg);-webkit-transform-origin:0 3.75em;transform-origin:0 3.75em;border-radius:0 7.5em 7.5em 0}.swal2-icon.swal2-success .swal2-success-ring{position:absolute;top:-.25em;left:-.25em;width:100%;height:100%;border:.25em solid rgba(165,220,134,.3);border-radius:50%;z-index:2;box-sizing:content-box}.swal2-icon.swal2-success .swal2-success-fix{position:absolute;top:.5em;left:1.625em;width:.4375em;height:5.625em;-webkit-transform:rotate(-45deg);transform:rotate(-45deg);z-index:1}.swal2-icon.swal2-success [class^=swal2-success-line]{display:block;position:absolute;height:.3125em;border-radius:.125em;background-color:#a5dc86;z-index:2}.swal2-icon.swal2-success [class^=swal2-success-line][class$=tip]{top:2.875em;left:.875em;width:1.5625em;-webkit-transform:rotate(45deg);transform:rotate(45deg)}.swal2-icon.swal2-success [class^=swal2-success-line][class$=long]{top:2.375em;right:.5em;width:2.9375em;-webkit-transform:rotate(-45deg);transform:rotate(-45deg)}.swal2-progresssteps{align-items:center;margin:0 0 1.25em;padding:0;font-weight:600}.swal2-progresssteps li{display:inline-block;position:relative}.swal2-progresssteps .swal2-progresscircle{width:2em;height:2em;border-radius:2em;background:#3085d6;color:#fff;line-height:2em;text-align:center;z-index:20}.swal2-progresssteps .swal2-progresscircle:first-child{margin-left:0}.swal2-progresssteps .swal2-progresscircle:last-child{margin-right:0}.swal2-progresssteps .swal2-progresscircle.swal2-activeprogressstep{background:#3085d6}.swal2-progresssteps .swal2-progresscircle.swal2-activeprogressstep~.swal2-progresscircle{background:#add8e6}.swal2-progresssteps .swal2-progresscircle.swal2-activeprogressstep~.swal2-progressline{background:#add8e6}.swal2-progresssteps .swal2-progressline{width:2.5em;height:.4em;margin:0 -1px;background:#3085d6;z-index:10}[class^=swal2]{-webkit-tap-highlight-color:transparent}.swal2-show{-webkit-animation:swal2-show .3s;animation:swal2-show .3s}.swal2-show.swal2-noanimation{-webkit-animation:none;animation:none}.swal2-hide{-webkit-animation:swal2-hide .15s forwards;animation:swal2-hide .15s forwards}.swal2-hide.swal2-noanimation{-webkit-animation:none;animation:none}.swal2-rtl .swal2-close{right:auto;left:0}.swal2-animate-success-icon .swal2-success-line-tip{-webkit-animation:swal2-animate-success-line-tip .75s;animation:swal2-animate-success-line-tip .75s}.swal2-animate-success-icon .swal2-success-line-long{-webkit-animation:swal2-animate-success-line-long .75s;animation:swal2-animate-success-line-long .75s}.swal2-animate-success-icon .swal2-success-circular-line-right{-webkit-animation:swal2-rotate-success-circular-line 4.25s ease-in;animation:swal2-rotate-success-circular-line 4.25s ease-in}.swal2-animate-error-icon{-webkit-animation:swal2-animate-error-icon .5s;animation:swal2-animate-error-icon .5s}.swal2-animate-error-icon .swal2-x-mark{-webkit-animation:swal2-animate-error-x-mark .5s;animation:swal2-animate-error-x-mark .5s}@-webkit-keyframes swal2-rotate-loading{0%{-webkit-transform:rotate(0);transform:rotate(0)}100%{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}@keyframes swal2-rotate-loading{0%{-webkit-transform:rotate(0);transform:rotate(0)}100%{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}@media print{body.swal2-shown:not(.swal2-no-backdrop):not(.swal2-toast-shown){overflow-y:scroll!important}body.swal2-shown:not(.swal2-no-backdrop):not(.swal2-toast-shown)>[aria-hidden=true]{display:none}body.swal2-shown:not(.swal2-no-backdrop):not(.swal2-toast-shown) .swal2-container{position:initial!important}}</style>

    <script src="assets/js/jquery.priceformat.min.js"></script>
    <script src="assets/js/jquery.mask.min.js"></script>
    <script src="assets/js/clipboard.min.js"></script>
    <script src="assets/js/toastr/toastr.min.js"></script>

    
    
        <script src="assets/js/qrcode.min.js?v=3uTnTmsCmy526qLaVK2i6utIuxJi0znb75uoJDvBVQI"></script>
    

<link type="text/css" rel="stylesheet" charset="UTF-8" href="https://www.gstatic.com/_/translate_http/_/ss/k=translate_http.tr.pgV-E-68K-A.L.W.O/am=gMA/d=0/rs=AN8SPfpszKJssl6IA0boGClFdsaAZGtXEQ/m=el_main_css"><script type="text/javascript" charset="UTF-8" src="https://translate.googleapis.com/_/translate_http/_/js/k=translate_http.tr.tr.QEbx-X4H-is.O/am=AAAE/d=1/exm=el_conf/ed=1/rs=AN8SPfoyYV2BqwcbD2RuY3C3Z7ToWzK8hw/m=el_main"></script></head>

<body style="max-height: 900px; position: relative; min-height: 100%; top: 0px;">

    <svg b-jvhkvz8bj1="" aria-hidden="true" style="position: absolute; width: 0px; height: 0px; overflow: hidden;">
        <symbol b-jvhkvz8bj1="" id="icon-icon-usdt" viewBox="0 0 1137 1024">
            <path b-jvhkvz8bj1="" d="M292.010667 0h530.090666c42.097778 0 80.952889 22.755556 101.603556 59.392l206.563555 367.331556c13.084444 23.267556 8.704 52.451556-10.638222 70.826666l-509.781333 484.295111a58.311111 58.311111 0 0 1-80.270222 0l-511.431111-485.831111a58.311111 58.311111 0 0 1-11.946667-68.323555L187.733333 64.455111A116.622222 116.622222 0 0 1 292.010667 0zM890.311111 432.924444c-22.300444-58.254222-256.568889-66.56-256.568889-66.56V291.384889h176.014222V174.876444H331.605333v116.508445h175.957334v74.069333c-29.525333 0-260.209778 18.147556-257.308445 72.476445 3.356444 61.610667 257.308444 71.68 257.308445 71.68v248.035555h126.122666v-248.035555c288.881778-18.375111 256.568889-76.686222 256.568889-76.686223zM507.562667 366.307556c4.380444-0.568889 3.982222-0.853333 0-0.853334v0.853334z m68.551111 123.278222s-227.783111 0.967111-286.776889-43.690667c0 0-28.103111-18.716444 22.812444-38.286222 0 0 69.233778-26.225778 195.356445-29.582222v89.998222h126.179555V378.026667s219.192889 8.305778 222.435556 54.897777c0 0 9.955556 50.005333-280.007111 56.661334z" fill="#26A17B"></path>
        </symbol>
        <symbol b-jvhkvz8bj1="" id="icon-icon-btc" viewBox="0 0 1024 1024">
            <path b-jvhkvz8bj1="" d="M369.615238 960.853333c261.36381 65.097143 525.994667-93.866667 591.140572-355.181714C1025.852952 344.405333 866.840381 79.725714 605.574095 14.628571 344.356571-50.566095 79.725714 108.446476 14.57981 369.761524c-65.145905 261.266286 93.866667 525.897143 355.08419 591.091809zM496.39619 453.583238c33.499429 8.923429 106.691048 28.476952 119.466667-22.576762 12.970667-52.175238-58.12419-67.974095-92.842667-75.629714a422.619429 422.619429 0 0 1-10.142476-2.340572l-24.576 98.401524 8.094476 2.145524z m-38.034285 158.524952c40.228571 10.630095 128.24381 33.889524 142.238476-22.28419 14.287238-57.441524-70.948571-76.55619-112.591238-85.918476-4.632381-0.975238-8.728381-1.950476-12.092953-2.779429l-27.062857 108.495238 9.557334 2.486857z m156.038095-293.546666c62.268952 21.455238 107.76381 53.540571 98.840381 113.322666-6.485333 43.78819-30.72 64.950857-62.951619 72.411429 44.227048 23.015619 66.706286 58.368 45.299809 119.564191-26.624 75.971048-89.819429 82.407619-173.884952 66.511238l-20.382476 81.724952-49.298286-12.288 20.138667-80.65219c-12.824381-3.169524-25.84381-6.534095-39.302095-10.191239l-20.187429 81.042286-49.249524-12.288 20.431238-81.92-14.043428-3.608381a2619.63581 2619.63581 0 0 0-21.113905-5.412571l-64.170667-15.993905 24.478476-56.466286s36.327619 9.654857 35.84 8.923429c13.945905 3.462095 20.138667-5.607619 22.576762-11.702857l55.344762-221.866667c0.585143-10.435048-3.023238-23.649524-23.015619-28.623238 0.78019-0.487619-35.791238-8.923429-35.791238-8.923429l13.165714-52.662857 67.925334 17.017905v0.24381c10.191238 2.535619 20.72381 4.973714 31.451428 7.411809l20.187429-80.944762 49.249524 12.239238-19.748572 79.384381c13.165714 3.023238 26.526476 6.046476 39.497143 9.264762l19.602286-78.799238 49.298286 12.288-20.187429 80.944762z" fill="#F7931A" fill-opacity=".9"></path>
        </symbol>
        <symbol b-jvhkvz8bj1="" id="icon-icon-trx" viewBox="0 0 64 64">
            <path b-jvhkvz8bj1="" fill="#ff060a" d="M61.55,19.28c-3-2.77-7.15-7-10.53-10l-.2-.14a3.82,3.82,0,0,0-1.11-.62l0,0C41.56,7,3.63-.09,2.89,0a1.4,1.4,0,0,0-.58.22L2.12.37a2.23,2.23,0,0,0-.52.84l-.05.13v.71l0,.11C5.82,14.05,22.68,53,26,62.14c.2.62.58,1.8,1.29,1.86h.16c.38,0,2-2.14,2-2.14S58.41,26.74,61.34,23a9.46,9.46,0,0,0,1-1.48A2.41,2.41,0,0,0,61.55,19.28ZM36.88,23.37,49.24,13.12l7.25,6.68Zm-4.8-.67L10.8,5.26l34.43,6.35ZM34,27.27l21.78-3.51-24.9,30ZM7.91,7,30.3,26,27.06,53.78Z"></path>
        </symbol>
    </svg>

    <div b-jvhkvz8bj1="" class="loading page-laoding" style="display: none;">
        <div b-jvhkvz8bj1="">
            <div b-jvhkvz8bj1="" class="loading-gif"><img b-jvhkvz8bj1="" src="assets/images/loader.gif" alt=""></div>
            <div b-jvhkvz8bj1="" class="text">İşleminiz yapılıyor, lütfen bekleyiniz.<br b-jvhkvz8bj1="">İşlem sürecinde sayfadan ayrılmayınız aksi takdirde yatırımınız hesabınıza yansımayacaktır.</div>
        </div>
    </div>








    <form method="post" name="FormAction" id="FormAction" autocomplete="off" action="" style="margin-bottom: 0px;width:100%;height:100vh;">
        
<input type="hidden" value="68c5ec58d6200b6dc79e1a62" name="txtToken">

<div class="container">
    <div class="row d-flex flex-column min-vh-100 justify-content-center align-items-center">
        <div class="col-lg-9 col-xs-12">
            <div class="cards">
                <div class="card-header">
                    <div class="row row-cols-2">
                        <div class="col-lg-5 col-xs-12">
                            <?php if (!empty($methodLogo)): ?>
                                <img src="<?php echo htmlspecialchars($methodLogo); ?>" class="mb-2" height="50" alt="<?php echo htmlspecialchars($methodName); ?>" onerror="this.src='assets/images/aninda_kripto_dark.svg'">
                            <?php else: ?>
                                <img src="assets/images/aninda_kripto_dark.svg" class="mb-2" height="50" alt="Anında Kripto">
                            <?php endif; ?>
                        </div>
                        <div class="col-lg-7 col-xs-12">
                            
    <style>
        body {
            top: 0 !important;
        }

        .skiptranslate {
            display: none;
        }

        #google_translate_element .skiptranslate {
            display: block;
            font-size: 0;
        }

            #google_translate_element .skiptranslate span {
                display: none;
            }

            #google_translate_element .skiptranslate select,
            .aps-lang{
                width: 100%;
                cursor: pointer;
                padding: 6px 8px;
                margin: 0 !important;
                font-size: 13px !important;
                color: #3f4254;
                transition: color .2s ease, background-color .2s ease;
                -moz-appearance: none;
                -webkit-appearance: none;
                appearance: none;
                background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%237E8299' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
                background-repeat: no-repeat;
                background-position: right 8px center;
                background-size: 12px 9px;
                border-radius: 6px;
                border: 1px solid #e1e1e1;
            }

                #google_translate_element .skiptranslate select option,
                .aps-lang option{
                    font-size: 13px;
                }

                #google_translate_element .skiptranslate select:focus,
                .aps-lang:focus{
                    outline: 0;
                }

            .aps-lang-holder{
                width: 100px;
                margin-left: auto;
            }

        .aps-lang-label{
            font-size: 12px;
            font-weight: 600;
            margin-bottom: 3px;
        }
    </style>
    <div class="d-flex h-100">
    
        <div class="aps-lang-holder">
            <div class="aps-lang-label">Dil Seçiniz</div>
            <select class="aps-lang" onchange="changeLanguage(this.value)">
                <option value="tr">Türkçe</option>
                <option value="en">İngilizce</option>
                <option value="mn">Moğolca</option>
                <option value="ru">Rusça</option>
            </select>
            <div id="google_translate_element" class="d-none"><div class="skiptranslate goog-te-gadget" dir="ltr" style=""><div id=":0.targetLanguage"><select class="goog-te-combo" aria-label="Dil Çeviri Widget'ı"><option value="">Dili Seçin</option><option value="ab">Abhazca</option><option value="ace">Açece</option><option value="ach">Açoli dili</option><option value="aa">Afar dili</option><option value="af">Afrikaanca</option><option value="de">Almanca</option><option value="alz">Alur dili</option><option value="ar">Arapça</option><option value="sq">Arnavutça</option><option value="as">Assamca</option><option value="av">Avarca</option><option value="awa">Awadhi dili</option><option value="ay">Aymaraca</option><option value="az">Azerbaycan dili</option><option value="ban">Bali dili</option><option value="bm">Bambara dili</option><option value="bci">Baoulé dili</option><option value="eu">Baskça</option><option value="ba">Başkurtça</option><option value="btx">Batak Karo dili</option><option value="bts">Batak Simalungun dili</option><option value="bbc">Batak Toba dili</option><option value="bew">Batavi dili</option><option value="be">Belarusça</option><option value="bal">Beluçça</option><option value="bem">Bemba dili</option><option value="bn">Bengalce</option><option value="ber-Latn">Berber dili</option><option value="ber">Berberi dili (Tifinag)</option><option value="bho">Bhojpuri dili</option><option value="bik">Bikol dili</option><option value="bs">Boşnakça</option><option value="br">Bretonca</option><option value="bg">Bulgarca</option><option value="my">Burmaca</option><option value="bua">Buryat dili</option><option value="jw">Cava dili</option><option value="ch">Chamorro dili</option><option value="chk">Chuukece</option><option value="ce">Çeçence</option><option value="cs">Çekçe</option><option value="ny">Çevaca</option><option value="zh-CN">Çince (Basitleştirilmiş)</option><option value="zh-TW">Çince (Geleneksel)</option><option value="cv">Çuvaşça</option><option value="da">Danca</option><option value="fa-AF">Darice</option><option value="dv">Dhivehi dili</option><option value="din">Dinka dili</option><option value="doi">Dogri dili</option><option value="dov">Dombe dili</option><option value="dyu">Dyula dili</option><option value="dz">Dzongka dili</option><option value="id">Endonezce</option><option value="hy">Ermenice</option><option value="eo">Esperanto</option><option value="et">Estonyaca</option><option value="ee">Ewe dili</option><option value="fo">Faroece</option><option value="fa">Farsça</option><option value="nl">Felemenkçe</option><option value="fj">Fijice</option><option value="tl">Filipince</option><option value="fi">Fince</option><option value="fon">Fon dili</option><option value="fr">Fransızca</option><option value="fr-CA">Fransızca (Kanada)</option><option value="fy">Frizce</option><option value="ff">Fulani dili</option><option value="fur">Furlan dili</option><option value="gaa">Gaa dili</option><option value="cy">Galce</option><option value="gl">Galiçyaca</option><option value="gn">Guarani</option><option value="gu">Güceratça</option><option value="ka">Gürcüce</option><option value="am">Habeşçe</option><option value="ht">Haiti Kreyolu</option><option value="cnh">Hakha Chin dili</option><option value="ha">Hausa dili</option><option value="haw">Hawai dili</option><option value="hr">Hırvatça</option><option value="hil">Hiligaynon dili</option><option value="hi">Hintçe</option><option value="hmn">Hmong dili</option><option value="xh">Hosa</option><option value="hrx">Hunsrik dili</option><option value="ilo">Ilocano dili</option><option value="iba">İbanca</option><option value="ig">İbo dili</option><option value="iw">İbranice</option><option value="en">İngilizce</option><option value="iu">İnuitçe (Hece)</option><option value="iu-Latn">İnuitçe (Latin)</option><option value="ga">İrlandaca</option><option value="gd">İskoç Gaelcesi</option><option value="es">İspanyolca</option><option value="sv">İsveççe</option><option value="it">İtalyanca</option><option value="is">İzlandaca</option><option value="jam">Jamaika lehçesi</option><option value="ja">Japonca</option><option value="kac">Jingpo dili</option><option value="kl">Kalaallisut dili</option><option value="km">Kamboçyaca</option><option value="kn">Kannada dili</option><option value="yue">Kantonca</option><option value="kr">Kanuri dili</option><option value="pam">Kapampangan dili</option><option value="ca">Katalanca</option><option value="kk">Kazakça</option><option value="kek">Kekçice</option><option value="kha">Khasi dili</option><option value="ky">Kırgızca</option><option value="crh">Kırım Tatarcası (Kiril)</option><option value="crh-Latn">Kırım Tatarcası (Latin)</option><option value="cgg">Kiga dili</option><option value="ktu">Kituba dili</option><option value="trp">Kokborok dili</option><option value="kv">Komi dili</option><option value="kg">Kongoca</option><option value="gom">Konkani dili</option><option value="ko">Korece</option><option value="co">Korsikaca</option><option value="kri">Krio dili</option><option value="ku">Kürtçe (Kurmançça)</option><option value="ckb">Kürtçe (Sorani)</option><option value="lo">Laoca</option><option value="ltg">Latgalya dili</option><option value="la">Latince</option><option value="pl">Lehçe</option><option value="lv">Letonca</option><option value="lij">Liguryaca</option><option value="li">Limburgca</option><option value="ln">Lingala</option><option value="lt">Litvanca</option><option value="lmo">Lombard dili</option><option value="lg">Luganda dili</option><option value="luo">Luo dili</option><option value="lb">Lüksemburgca</option><option value="hu">Macarca</option><option value="mad">Madurese dili</option><option value="mai">Maithili dili</option><option value="mak">Makassar dili</option><option value="mk">Makedonca</option><option value="ml">Malayalam dili</option><option value="ms">Malayca</option><option value="ms-Arab">Malayca (Javi)</option><option value="mg">Malgaşça</option><option value="mt">Maltaca</option><option value="mam">Mam dili</option><option value="gv">Manksça</option><option value="mi">Maori dili</option><option value="mr">Marathi</option><option value="mh">Marshall Adaları dili</option><option value="mwr">Marwadi dili</option><option value="mni-Mtei">Meiteilon dili (Manipuri)</option><option value="min">Minang dili</option><option value="lus">Mizo dili</option><option value="mn">Moğolca</option><option value="mfe">Morisyen Kreolü</option><option value="nhe">Nahuatl dili (Doğu Huasteca)</option><option value="ndc-ZW">Ndau dili</option><option value="nr">Ndebele dili (Güney)</option><option value="new">Nepal Bhasa dili (Newari)</option><option value="ne">Nepalce</option><option value="bm-Nkoo">NKo dili</option><option value="no">Norveççe</option><option value="nus">Nuer dili</option><option value="or">Odiya (Oriya) dili</option><option value="oc">Oksitanca</option><option value="om">Oromo dili</option><option value="os">Osetçe</option><option value="chm">Ova Marice</option><option value="uz">Özbekçe</option><option value="pag">Pangasinan dili</option><option value="pap">Papiamento dili</option><option value="pa">Pencapça (Gurmukhi)</option><option value="pa-Arab">Pencapça (Shahmukhi)</option><option value="ps">Peştuca</option><option value="pt">Portekizce (Brezilya)</option><option value="pt-PT">Portekizce (Portekiz)</option><option value="qu">Quechua dili</option><option value="rom">Romanca</option><option value="ro">Romence</option><option value="rw">Ruandaca</option><option value="rn">Rundice</option><option value="ru">Rusça</option><option value="ceb">Sabuanca</option><option value="se">Sami dili (Kuzey)</option><option value="sm">Samoaca</option><option value="sg">Sango dili</option><option value="sa">Sanskritçe</option><option value="sat-Latn">Santali (Latince)</option><option value="sat">Santali (Ol Chiki)</option><option value="nso">Sepedi dili</option><option value="st">Sesotho dili</option><option value="si">Seylanca</option><option value="crs">Seyşeller Kreolü</option><option value="shn">Shan dili</option><option value="sn">Shona</option><option value="sr">Sırpça</option><option value="scn">Sicilyaca</option><option value="szl">Silezya dili</option><option value="sd">Sint</option><option value="sk">Slovakça</option><option value="sl">Slovence</option><option value="so">Somalice</option><option value="su">Sunda dili</option><option value="sus">Susu dili</option><option value="sw">Svahili dili</option><option value="ss">Swazi dili</option><option value="tg">Tacikce</option><option value="ty">Tahitice</option><option value="ta">Tamil</option><option value="tt">Tatarca</option><option value="th">Tayca</option><option value="te">Telugu dili</option><option value="tet">Tetum dili</option><option value="bo">Tibetçe</option><option value="ti">Tigrinya dili</option><option value="tiv">Tiv dili</option><option value="tpi">Tok Pisin dili</option><option value="to">Tongaca</option><option value="lua">Tshiluba dili</option><option value="ts">Tsongaca</option><option value="tn">Tsvana dili</option><option value="tcy">Tuluca</option><option value="tum">Tumbuka dili</option><option value="tyv">Tuvaca</option><option value="tk">Türkmence</option><option value="ak">Twi dili</option><option value="udm">Udmurt dili</option><option value="uk">Ukraynaca</option><option value="ur">Urduca</option><option value="ug">Uygurca</option><option value="war">Varayca</option><option value="ve">Venda dili</option><option value="vec">Venedikçe</option><option value="vi">Vietnamca</option><option value="wo">Wolof dili</option><option value="sah">Yakutça</option><option value="yi">Yidce</option><option value="yo">Yoruba dili</option><option value="yua">Yucatec Maya dili</option><option value="el">Yunanca</option><option value="zap">Zapotek dili</option><option value="zu">Zulu</option></select></div><span style="white-space:nowrap"><a class="VIpgJd-ZVi9od-l4eHX-hSRGPd" href="https://translate.google.com" target="_blank"><img src="https://www.gstatic.com/images/branding/googlelogo/1x/googlelogo_color_42x16dp.png" width="37px" height="14px" style="padding-right: 3px" alt="Google Çeviri">Çeviri</a></span> tarafından desteklenmektedir</div></div>
        </div>
    </div>
    <script type="text/javascript">
                let suppressChange = false;
        let isGoogleTranslateInitialized = false;

        function changeLanguage(lang) {
            if (suppressChange) return;

            localStorage.setItem("lang", lang);

            const interval = setInterval(() => {
                const select = document.querySelector("select.goog-te-combo");
                if (select && select.options.length > 1) {
                    select.value = lang;
                    select.dispatchEvent(new Event("change"));
                    clearInterval(interval);
                }
            }, 100);
        }

        function getLanguage(){
            const langs = ["tr", "en", "mn", "ru"];
            let lang = localStorage.getItem("lang") || "";

            if(!lang){
                const bwLang = navigator.language || navigator.userLanguage;

                if (bwLang && langs.includes(bwLang)) {
                    lang = bwLang.substring(0, 2);
                    localStorage.setItem("lang", lang);
                }
            }

            return lang;
        }

        function googleTranslateElementInit() {
            if (isGoogleTranslateInitialized) return;
            isGoogleTranslateInitialized = true;

            new google.translate.TranslateElement({ pageLanguage: "tr" }, "google_translate_element");

            let lang = getLanguage();

            if (lang != "") {
                suppressChange = true;

                const mySelect = document.querySelector(".aps-lang");
                if (mySelect) {
                    mySelect.value = lang;
                }

                suppressChange = false;

                const interval = setInterval(() => {
                    const select = document.querySelector("select.goog-te-combo");
                    if (select && select.options.length > 1) {
                        select.value = lang;
                        select.dispatchEvent(new Event("change"));
                        clearInterval(interval);
                    }
                }, 200);
            }
        }

        window.addEventListener("load", () => { googleTranslateElementInit(); });
    </script>
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>

                        </div>
                    </div>
                </div>
                    <div class="card-body">
                        <div class="row justify-content-center ">
                            <div class="col-md-6 col-lg-6 col-xl-5">
                                <div class="mt-2">
                                    <ul class="account-info ps-0">
                                        <li class="rounded">
                                            <span class="fs-8 mb-1 d-block">Yatırım Tutarı</span>
                                            <span class="fs-6 fw-bold"><?php echo $formattedTlAmount; ?> TL</span>
                                        </li>
                                        <li class="rounded copy-t">
                                            <span class="fs-8 mb-1 d-block"><?php echo $cryptoInfo['name']; ?> Miktarı</span>
                                            <span class="fs-6 fw-bold">
                                                <?php echo $formattedCryptoAmount; ?> <a href="javascript:void(0);" data-copy="<?php echo $formattedCryptoAmount; ?>">
                                                    <img src="assets/images/copy-btn.png" width="24" alt="Kopyala">
                                                </a>
                                            </span>
                                        </li>
                                        <li class="subtext text-danger fs-9">Yukarıda belirtilen miktar kadar ödeme yapınız</li>
                                        <li class="rounded relative">
                                            <span class="text-counter fs-7 text-danger fw-bold" id="timeOut" data-seconds-left="<?php echo $timeoutSeconds; ?>"><?php echo gmdate('i:s', $timeoutSeconds); ?></span>
                                            <span class="fs-8 mb-1 d-block">Sabitlenen Kur Fiyatı</span>
                                            <span class="fs-6 fw-bold"><?php echo number_format(calculateCryptoAmount(1, $cryptoType) > 0 ? (1 / calculateCryptoAmount(1, $cryptoType)) : 0, 2, ',', '.'); ?> TL</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>

                            <div class="col-md-6 col-lg-6 col-xl-7">
                                <div class="d-flex justify-content-center my-4 my-md-2">
                                    <div id="qrcode" class="text-center" style="width:150px;" title="<?php echo htmlspecialchars($cryptoInfo['address']); ?>">
                                    </div>
                                </div>

                                <span class="fs-6 fw-bold d-block text-center mb-2 copy-t">
                                    <?php echo htmlspecialchars($cryptoInfo['address']); ?> <a href="javascript:void(0);" data-copy="<?php echo htmlspecialchars($cryptoInfo['address']); ?>">
                                        <img src="assets/images/copy-btn.png" width="24" alt="Kopyala">
                                    </a>
                                </span>

                                <span class="subtext text-danger fs-9">
                                    Sadece <?php echo $cryptoInfo['name']; ?> gönderiniz, farklı bir kripto
                                    gönderirseniz işleminiz gerçekleşmez
                                </span>
                            </div>

                            <div class="col-md-12 mt-3">
                                <div class="alert alert-danger text-dark fs-8 fw-normal mb-0">
                                    Bu sayfadaki kur sizin için 3dk boyunca
                                    sabitlenmiştir. Yatırım ekranını açmadan yapacağınız yatırımlar <strong>"Anlık Kurdan"</strong>
                                    çevirilerek hesaplanıp bakiyenize eklenecektir.
                                </div>
                            </div>
                            
                            <!-- Navigation Buttons -->
                            <div class="col-md-12 mt-3">
                                <div class="d-flex justify-content-between">
                                    <a href="javascript:void(0);" id="backBtn" class="btn btn-secondary text-white fs-8 fw-bold p-2 px-3">
                                        ← Geri Dön
                                    </a>
                                    <a href="javascript:void(0);" id="homeBtn" class="btn btn-primary text-white fs-8 fw-bold p-2 px-3">
                                        🏠 Ana Sayfa
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <script type="text/javascript">
                        $(document).ready(function() {
                            // Generate QR code function
                            function generateQRCode(address) {
                                // Clear any existing QR code
                                $('#qrcode').empty();
                                
                                console.log('Generating QR code for address:', address);
                                
                                try {
                                    var qrcode = new QRCode("qrcode", {
                                        text: address,
                                        width: 128,
                                        height: 128,
                                        colorDark: "#000000",
                                        colorLight: "#ffffff",
                                        correctLevel: QRCode.CorrectLevel.H
                                    });
                                } catch(e) {
                                    console.error('QR Code generation failed:', e);
                                    $('#qrcode').html('<div style="width:128px;height:128px;border:1px solid #ccc;display:flex;align-items:center;justify-content:center;color:#666;">QR Error</div>');
                                }
                            }
                            
                            // Generate initial QR code
                            var cryptoAddress = "<?php echo htmlspecialchars($cryptoInfo['address']); ?>";
                            var cryptoType = "<?php echo htmlspecialchars($cryptoType); ?>";
                            
                            console.log('Initial QR generation - Address:', cryptoAddress, 'Type:', cryptoType);
                            generateQRCode(cryptoAddress);
                            
                            // Make function globally available for potential updates
                            window.updateQRCode = generateQRCode;
                            
                            // Navigation button handlers
                            $('#backBtn').on('click', function(e) {
                                e.preventDefault();
                                
                                // Check if we're in an iframe
                                if (window.self !== window.top) {
                                    // We're in an iframe, try to go back in iframe history
                                    console.log("Running in iframe, going back in iframe history");
                                    try {
                                        window.history.back();
                                    } catch(e) {
                                        console.log("Could not go back in iframe history");
                                    }
                                    return;
                                }
                                
                                // Go back to crypto selection page with current parameters (only if not in iframe)
                                var backUrl = 'index.php?payment=<?php echo urlencode($selectedPayment); ?>&amount=<?php echo urlencode($amount); ?>';
                                <?php if (!empty($user)): ?>
                                backUrl += '&user=' + encodeURIComponent('<?php echo urlencode($user); ?>');
                                <?php endif; ?>
                                <?php if (!empty($methodName)): ?>
                                backUrl += '&method_name=' + encodeURIComponent('<?php echo urlencode($methodName); ?>');
                                <?php endif; ?>
                                <?php if (!empty($methodLogo)): ?>
                                backUrl += '&method_logo=' + encodeURIComponent('<?php echo urlencode($methodLogo); ?>');
                                <?php endif; ?>
                                
                                console.log('Going back to:', backUrl);
                                window.location.href = backUrl;
                            });
                            
                            $('#homeBtn').on('click', function(e) {
                                e.preventDefault();
                                
                                // Check if we're in an iframe
                                if (window.self !== window.top) {
                                    // We're in an iframe, don't redirect to parent window
                                    console.log("Running in iframe, preventing redirect to main page");
                                    
                                    // Try to go back to first page in iframe
                                    try {
                                        // Go to the first page in iframe history
                                        window.location.href = 'index.php';
                                    } catch(e) {
                                        console.log("Could not redirect within iframe");
                                    }
                                    return;
                                }
                                
                                // Go to main dashboard payment page (only if not in iframe)
                                var homeUrl = '/tr/dashboard/payments/deposit-money/';
                                
                                console.log('Going to home:', homeUrl);
                                window.location.href = homeUrl;
                            });
                        });
                    </script>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function () {
        $('#timeOut').startTimer({
            onComplete: function (element) {

            }
        });

        var isWorking = true;
        var allInTimer = setInterval(async function () {
            if (isWorking == true) {
                isWorking = false;
                $.post("/api/fast/get-check-request", $("#FormAction").serialize(), function (res) {
                    if (res.ID == 1) {
                        document.location.href = res.HtmlPage;
                    } else {
                        isWorking = true;
                    }
                });
            }
        }, 3000);
    });
</script>
    <input name="__RequestVerificationToken" type="hidden" value="CfDJ8NMtpjPbItdGg-0HKgwGj7Y4ci6qn9Q-ZFurMlZtB5L1c6F-Vm3rXWPpR48KjBXwXGO0MHIMO90A-Wy-lAkPdGhyPbHFDy7g2xmtbhHwzIhcXyJtRmMUNNbNUP2Or8vgmaDXOLG1ZENto2JO5lOld9w"></form>

    
    
        <script src="assets/js/akripto.scripts.min.js?v=_AfjIR7RKf96W7yCpBoelCBS4cVduPzKjroGjTa5kXQ"></script>
        <script src="assets/js/jquery.main.min.js?v=HtZhRq_upG8VjfaAf2GbjTATzXRtSdVziu7yuNPYrVU"></script>
    

    <script>
        $('.loading').hide();
    </script><div id="goog-gt-tt" class="VIpgJd-yAWNEb-L7lbkb skiptranslate" style="border-radius: 12px; margin: 0 0 0 -23px; padding: 0; font-family: 'Google Sans', Arial, sans-serif;" data-id=""><div id="goog-gt-vt" class="VIpgJd-yAWNEb-hvhgNd"><div class="VIpgJd-yAWNEb-hvhgNd-Ud7fr"><img src="https://fonts.gstatic.com/s/i/productlogos/translate/v14/24px.svg" width="24" height="24" alt=""><div class=" VIpgJd-yAWNEb-hvhgNd-IuizWc-i3jM8c " dir="ltr">Orijinal metin</div></div><div class="VIpgJd-yAWNEb-hvhgNd-k77Iif"><div id="goog-gt-original-text" class="VIpgJd-yAWNEb-nVMfcd-fmcmS VIpgJd-yAWNEb-hvhgNd-axAV1"></div></div><div class="VIpgJd-yAWNEb-hvhgNd-N7Eqid ltr"><div class="VIpgJd-yAWNEb-hvhgNd-N7Eqid-B7I4Od ltr" dir="ltr"><div class="VIpgJd-yAWNEb-hvhgNd-UTujCb">Bu çeviriyi değerlendirin</div><div class="VIpgJd-yAWNEb-hvhgNd-eO9mKe">Geri bildiriminiz, Google Çeviri'yi iyileştirmek için kullanılacaktır</div></div><div class="VIpgJd-yAWNEb-hvhgNd-xgov5 ltr"><button id="goog-gt-thumbUpButton" type="button" class="VIpgJd-yAWNEb-hvhgNd-bgm6sf" title="İyi çeviri" aria-label="İyi çeviri" aria-pressed="false"><span id="goog-gt-thumbUpIcon"><svg width="24" height="24" viewBox="0 0 24 24" focusable="false" class="VIpgJd-yAWNEb-hvhgNd-THI6Vb NMm5M"><path d="M21 7h-6.31l.95-4.57.03-.32c0-.41-.17-.79-.44-1.06L14.17 0S7.08 6.85 7 7H2v13h16c.83 0 1.54-.5 1.84-1.22l3.02-7.05c.09-.23.14-.47.14-.73V9c0-1.1-.9-2-2-2zM7 18H4V9h3v9zm14-7l-3 7H9V8l4.34-4.34L12 9h9v2z"></path></svg></span><span id="goog-gt-thumbUpIconFilled"><svg width="24" height="24" viewBox="0 0 24 24" focusable="false" class="VIpgJd-yAWNEb-hvhgNd-THI6Vb NMm5M"><path d="M21 7h-6.31l.95-4.57.03-.32c0-.41-.17-.79-.44-1.06L14.17 0S7.08 6.85 7 7v13h11c.83 0 1.54-.5 1.84-1.22l3.02-7.05c.09-.23.14-.47.14-.73V9c0-1.1-.9-2-2-2zM5 7H1v13h4V7z"></path></svg></span></button><button id="goog-gt-thumbDownButton" type="button" class="VIpgJd-yAWNEb-hvhgNd-bgm6sf" title="Kötü çeviri" aria-label="Kötü çeviri" aria-pressed="false"><span id="goog-gt-thumbDownIcon"><svg width="24" height="24" viewBox="0 0 24 24" focusable="false" class="VIpgJd-yAWNEb-hvhgNd-THI6Vb NMm5M"><path d="M3 17h6.31l-.95 4.57-.03.32c0 .41.17.79.44 1.06L9.83 24s7.09-6.85 7.17-7h5V4H6c-.83 0-1.54.5-1.84 1.22l-3.02 7.05c-.09.23-.14.47-.14.73v2c0 1.1.9 2 2 2zM17 6h3v9h-3V6zM3 13l3-7h9v10l-4.34 4.34L12 15H3v-2z"></path></svg></span><span id="goog-gt-thumbDownIconFilled"><svg width="24" height="24" viewBox="0 0 24 24" focusable="false" class="VIpgJd-yAWNEb-hvhgNd-THI6Vb NMm5M"><path d="M3 17h6.31l-.95 4.57-.03.32c0 .41.17.79.44 1.06L9.83 24s7.09-6.85 7.17-7V4H6c-.83 0-1.54.5-1.84 1.22l-3.02 7.05c-.09.23-.14.47-.14.73v2c0 1.1.9 2 2 2zm16 0h4V4h-4v13z"></path></svg></span></button></div></div><div id="goog-gt-votingHiddenPane" class="VIpgJd-yAWNEb-hvhgNd-aXYTce"><form id="goog-gt-votingForm" action="//translate.googleapis.com/translate_voting?client=te" method="post" target="votingFrame" class="VIpgJd-yAWNEb-hvhgNd-aXYTce"><input type="text" name="sl" id="goog-gt-votingInputSrcLang"><input type="text" name="tl" id="goog-gt-votingInputTrgLang"><input type="text" name="query" id="goog-gt-votingInputSrcText"><input type="text" name="gtrans" id="goog-gt-votingInputTrgText"><input type="text" name="vote" id="goog-gt-votingInputVote"></form><iframe name="votingFrame" frameborder="0"></iframe></div></div></div>


<div class="VIpgJd-ZVi9od-aZ2wEe-wOHMyf"><div class="VIpgJd-ZVi9od-aZ2wEe-OiiCO"><svg xmlns="http://www.w3.org/2000/svg" class="VIpgJd-ZVi9od-aZ2wEe" width="96px" height="96px" viewBox="0 0 66 66"><circle class="VIpgJd-ZVi9od-aZ2wEe-Jt5cK" fill="none" stroke-width="6" stroke-linecap="round" cx="33" cy="33" r="30"></circle></svg></div></div></body></html>