<?php
// Include functions
require_once '../../../inc/functions.php';

// Get parameters from URL
$bankId = $_GET['bank_id'] ?? '11'; // Default to TEB
$paymentId = $_GET['payment'] ?? '';
$amount = $_GET['amount'] ?? '500.00';
$userName = $_GET['user'] ?? '';

// Validate bank ID
if (!isValidBankId($bankId)) {
    $bankId = '11'; // Default to TEB if invalid
}

// Validate payment method - only allow bank transfer methods
$paymentInfo = getPaymentMethod($paymentId);

if (!$paymentInfo) {
    // If no payment method found, redirect to main page with error
    header("Location: /tr/dashboard/payments/deposit-money/?error=payment_not_found");
    exit;
}

if ($paymentInfo['category'] !== 'bank_transfer') {
    // If not a bank transfer method, redirect to main page with error
    header("Location: /tr/dashboard/payments/deposit-money/?error=invalid_method");
    exit;
}

// Validate that the payment method supports IBAN
$validIbanMethods = [
    'ekofix-deposit-bank-transfer',
    'ngspay-deposit', 
    'anindabankav2-deposit',
    'garanti-bankasi-deposit-transfer',
    'akbank-deposit-transfer',
    'isbank-deposit-transfer',
    'ziraat-deposit-transfer',
    'yapikredi-deposit-transfer',
    'finansbank-deposit-transfer',
    'vakifbank-deposit-transfer',
    'denizbank-deposit-transfer',
    'halkbank-deposit-transfer',
    'teb-deposit-transfer',
    'ing-deposit-transfer',
    'sekerbank-deposit-transfer',
    'kuveytturk-deposit-transfer',
    'fibabank-deposit-transfer',
    'albarakaturk-deposit-transfer',
    // Yeni eklenen ödeme yöntemleri
    'hemenode-havale',
    'turbo-havale',
    'safepays',
    'fastpara-banktransfer',
    'kasamda-havale',
    'aninda-banktransfer',
    'aninda-ahavale',
    'enhizli-havale',
    'flexpep-fasthavale',
    'ekofix-wiretransfer-havale',
    'hizliode-havale',
    'paratim',
    'papel',
    'parolapara-hemenode',
    'parolapara-aninda',
    'papara-vip',
    'papara-aninda',
    'papara-premium'
];

if (!in_array($paymentId, $validIbanMethods)) {
    // If payment method doesn't support IBAN, redirect with error
    header("Location: /tr/dashboard/payments/deposit-money/?error=method_not_supported");
    exit;
}

// Get IBAN information
$ibanInfo = getIban($bankId);
$userInfo = getUserInfo();

// Use GET parameters if provided, otherwise use default values
$displayUserName = !empty($userName) ? $userName : $userInfo['name'];
$displayAmount = !empty($amount) ? $amount : '500.00';

// Generate CSRF token
$csrfToken = generateCSRFToken();
?>
<!DOCTYPE html>
<html class="no-focus" lang="tr" xml:lang="tr">
<head>
    <meta charset="utf-8">
    <title><?php echo $paymentInfo ? $paymentInfo['name'] : 'Hızlı Havale'; ?></title>
    <meta name="description" content="">
    <meta name="author" content="Karga Inc.">
    <meta name="robots" content="noindex, nofollow">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">

    <link rel="shortcut icon" href="assets/img/favicons/favicon.png">
    <link rel="icon" type="image/png" href="assets/img/favicons/favicon-192x192.png" sizes="192x192">
    <link rel="apple-touch-icon" sizes="180x180" href="assets/img/favicons/apple-touch-icon-180x180.png">

    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&amp;display=swap&amp;subset=latin,latin-ext">
    <link rel="stylesheet" id="css-main" href="assets/css/oneui.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>
<div id="page-container">
    <main id="main-container">
        <div class="bg-image" style="background-image: url('assets/img/bg/plane@2x.jpg');">
            <div class="row g-0 bg-primary-dark-op">
                <div class="hero-static col-lg-4 d-none d-lg-flex flex-column justify-content-center">
                    <div class="p-4 p-xl-5 flex-grow-1 d-flex align-items-center">
                        <div class="w-100">
                            <?php if ($paymentInfo): ?>
                                <img src="<?php echo $paymentInfo['logo']; ?>" alt="<?php echo $paymentInfo['name']; ?>" style="max-height: 80px; max-width: 140px;">
                            <?php else: ?>
                                <img src="assets/img/companies/ngs.png" alt="NGS" style="max-height: 80px; max-width: 140px;">
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="hero-static col-lg-8 col-sm-12 d-flex flex-column align-items-center bg-body-light">
                    <div class="p-3 w-100 d-lg-none text-center">
                        <?php if ($paymentInfo): ?>
                            <img src="<?php echo $paymentInfo['logo']; ?>" alt="<?php echo $paymentInfo['name']; ?>" style="max-height: 80px; max-width: 140px;">
                        <?php else: ?>
                            <img src="assets/img/companies/ngs.png" alt="NGS" style="max-height: 80px; max-width: 140px;">
                        <?php endif; ?>
                    </div>
                    <div class="p-4 w-100 flex-grow-1 d-flex align-items-center">
                        <div class="w-100">
                            <div class="text-center mb-5">
                                <h1 class="fw-bold mb-2">
                                    <?php echo $paymentInfo ? $paymentInfo['name'] : 'Hızlı Havale Ödeme'; ?>
                                </h1>
                                <p class="fw-medium text-muted">
                                    Sayın <span class="text-primary"><?php echo htmlspecialchars($displayUserName); ?></span>,
                                    lütfen ödeme detaylarınızı kontrol edip ödemenizi yapın.
                                </p>
                            </div>

                            <div class="row justify-content-center">
                                <div class="col-lg-8 col-sm-12">
                                    <!-- Payment Details Section -->
                                    <div class="block block-rounded block-themed">
                                        <div class="block-header bg-amethyst-dark">
                                            <h3 class="block-title">1. Ödeme Detayları</h3>
                                        </div>
                                        <div class="block-content block-content-full">
                                            <div class="row mx-xl-12">
                                                <div class="col-lg-4">
                                                    <p class="fs-sm text-secondary">
                                                        Yalnızca kendi adınıza olan hesaplardan yaptığınız ödemeler kabul edilebilmektedir.
                                                    </p>
                                                </div>
                                                <div class="col-lg-8">
                                                    <div class="mb-4">
                                                        <label class="form-label" for="user_name">İsim <span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="user_name" name="user_name" value="<?php echo htmlspecialchars($displayUserName); ?>" required>
                                                    </div>
                                                    <div class="mb-4">
                                                        <label class="form-label" for="user_surname">Soyisim <span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="user_surname" name="user_surname" value="" required>
                                                    </div>
                                                    <div class="mb-4">
                                                        <label class="form-label" for="username">Kullanıcı Adı <span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="username" name="username" value="<?php echo htmlspecialchars($userInfo['username']); ?>" required>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Bank Account Section -->
                                    <div class="block block-rounded block-themed">
                                        <div class="block-header bg-amethyst-dark">
                                            <h3 class="block-title">2. Ödeme Yapılacak Hesap</h3>
                                        </div>
                                        <div class="block-content block-content-full">
                                            <div class="mx-xl-12">
                                                <?php if ($ibanInfo): ?>
                                                    <div class="row mb-4">
                                                        <div class="col-6">
                                                            <label class="form-label" for="val-skill">Banka <span class="text-danger">*</span></label>
                                                            <select class="form-select" id="bank">
                                                                <option value="">SEÇİNİZ</option>
                                                                <?php 
                                                                $allBanks = getAllBanks();
                                                                foreach ($allBanks as $bank): 
                                                                ?>
                                                                    <option value="<?php echo $bank['id']; ?>" <?php echo ($bank['id'] == $bankId) ? 'selected' : ''; ?>>
                                                                        <?php echo $bank['name']; ?>
                                                                    </option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-4">
                                                        <div class="col-12">
                                                            <label class="form-label" for="accountName">Hesap Sahibi</label>
                                                            <input type="text" readonly="" class="form-control form-control-alt is-valid text-center text-black" id="accountName" name="accountName" value="<?php echo htmlspecialchars($ibanInfo['account_holder']); ?>">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-4">
                                                        <div class="col-3">
                                                            <label class="form-label" for="branchCode">Şube Kodu</label>
                                                            <input type="text" readonly="" class="form-control form-control-alt is-valid text-center text-black" id="branchCode" name="branchCode" value="<?php echo htmlspecialchars($ibanInfo['branch_code']); ?>">
                                                        </div>
                                                        <div class="col-9">
                                                            <label class="form-label" for="accountNumber">Hesap No</label>
                                                            <input type="text" readonly="" class="form-control form-control-alt is-valid text-center text-black" id="accountNumber" name="accountNumber" value="<?php echo htmlspecialchars($ibanInfo['account_number']); ?>">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-4">
                                                        <div class="col-12">
                                                            <label class="form-label" for="iban">IBAN</label>
                                                            <div class="input-group">
                                                                <input type="text" class="form-control form-control-alt is-valid text-center text-black" id="iban" name="iban" value="<?php echo htmlspecialchars($ibanInfo['iban']); ?>">
                                                                <button type="button" class="btn btn-secondary d-flex align-items-center justify-content-center" onclick="copyToClipboard('iban')">
                                                                    <i class="fas fa-copy"></i>
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-4">
                                                        <div class="col-12">
                                                            <label class="form-label" for="amount">Yatırılacak Tutar</label>
                                                            <input type="text" readonly="" class="form-control form-control-alt is-valid text-center text-black" id="amount" name="amount" value="<?php echo formatAmount($displayAmount); ?>">
                                                        </div>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="alert alert-danger">
                                                        <i class="fas fa-exclamation-triangle"></i>
                                                        Banka bilgileri bulunamadı!
                                                    </div>
                                                <?php endif; ?>

                                                <!-- Information Alerts -->
                                                <div class="alert alert-info d-flex align-items-center" role="alert">
                                                    <div class="flex-shrink-0">
                                                        <i class="fas fa-fw fa-info-circle"></i>
                                                    </div>
                                                    <div class="flex-grow-1 ms-3">
                                                        <p class="mb-0">
                                                            Hesaplar tek kullanımlıktır. Hesabın geçerlilik süresi 10 dakikadır.
                                                            Para gönderdiğiniz hesap ile üyelikteki bilgilerinizin aynı olması gerekmektedir.
                                                        </p>
                                                    </div>
                                                </div>
                                                <div class="alert alert-danger d-flex align-items-center" role="alert">
                                                    <div class="flex-shrink-0">
                                                        <i class="fas fa-fw fa-exclamation-circle"></i>
                                                    </div>
                                                    <div class="flex-grow-1 ms-3">
                                                        <p class="mb-0">
                                                            Ödemenize açıklama yazdığınız takdirde, yatırımınız iade edilecek - işleminiz iptal edilecektir!
                                                        </p>
                                                    </div>
                                                </div>
                                                <div class="alert alert-info d-flex align-items-center" role="alert">
                                                    <div class="flex-shrink-0">
                                                        <i class="fas fa-fw fa-info-circle"></i>
                                                    </div>
                                                    <div class="flex-grow-1 ms-3">
                                                        <p class="mb-0">
                                                            Ödeme yaptığınız tutarın farklı olması durumunda işleminiz onaylanmayacaktır.
                                                            Lütfen <em><?php echo formatAmount($displayAmount); ?></em> gönderdiğinizden emin olun.
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Submit Form -->
                                            <div class="mx-xl-12">
                                                <form method="POST" id="odemeForm" action="confirm.php">
                                                    <!-- Payment Information -->
                                                    <input hidden="hidden" type="number" id="BankId" name="BankId" value="<?php echo $bankId; ?>">
                                                    <input hidden="hidden" type="text" id="PaymentId" name="PaymentId" value="<?php echo $paymentId; ?>">
                                                    <input hidden="hidden" type="text" id="Amount" name="Amount" value="<?php echo $displayAmount; ?>">
                                                    
                                                    <!-- User Information -->
                                                    <input hidden="hidden" type="text" id="user_name_hidden" name="user_name" value="">
                                                    <input hidden="hidden" type="text" id="user_surname_hidden" name="user_surname" value="">
                                                    <input hidden="hidden" type="text" id="username_hidden" name="username" value="">
                                                    
                                                    <!-- Bank Information -->
                                                    <input hidden="hidden" type="text" id="accountName_hidden" name="accountName" value="<?php echo htmlspecialchars($ibanInfo['account_holder']); ?>">
                                                    <input hidden="hidden" type="text" id="branchCode_hidden" name="branchCode" value="<?php echo htmlspecialchars($ibanInfo['branch_code']); ?>">
                                                    <input hidden="hidden" type="text" id="accountNumber_hidden" name="accountNumber" value="<?php echo htmlspecialchars($ibanInfo['account_number']); ?>">
                                                    <input hidden="hidden" type="text" id="iban_hidden" name="iban" value="<?php echo htmlspecialchars($ibanInfo['iban']); ?>">
                                                    
                                                    <!-- CSRF Token -->
                                                    <input name="__RequestVerificationToken" type="hidden" value="<?php echo $csrfToken; ?>">
                                                    
                                                    <!-- Action -->
                                                    <input type="hidden" name="action" value="ack">

                                                    <!-- Navigation buttons -->
                                                    <div class="d-flex justify-content-between mb-3">
                                                        <a href="javascript:void(0);" id="backBtn" class="btn btn-secondary text-white fs-8 fw-bold p-2 px-3">
                                                            ← Geri Dön
                                                        </a>
                                                        <a href="javascript:void(0);" id="helpBtn" class="btn btn-outline-info fs-8 fw-bold p-2 px-3">
                                                            ❓ Yardım
                                                        </a>
                                                    </div>

                                                    <button type="submit" class="btn btn-primary btn-lg w-100 me-1 mb-3 d-flex align-items-center justify-content-center">
                                                        <i class="fas fa-exclamation-triangle me-2"></i>
                                                        Ödememi yaptım, onaya gönder
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
</div>

<script src="assets/js/oneui.app.min.js"></script>
<script src="assets/js/lib/jquery.min.js"></script>
<script src="assets/js/plugins/qrcode-js/qrcode.js"></script>

<script type="text/javascript">
    const bank = document.getElementById("bank");
    const odemeForm = document.getElementById("odemeForm");

    // Bank change handler
    bank.onchange = function() {
        if(!bank.value) {
            return;
        }

        // Check if we're in an iframe
        if (window.self !== window.top) {
            console.log("Bank change in iframe - staying within iframe");
            
            // Redirect with new bank ID within iframe
            const url = new URL(window.location);
            url.searchParams.set('bank_id', bank.value);
            window.location.href = url.toString();
        } else {
            // Normal redirect if not in iframe
            const url = new URL(window.location);
            url.searchParams.set('bank_id', bank.value);
            window.location.href = url.toString();
        }
    }
    
    // Check if we're in an iframe and log it for debugging
    if (window.self !== window.top) {
        console.log("Running in iframe - form submissions will work normally");
    }

    // Form validation function
    function validateForm() {
        const userName = document.getElementById('user_name').value.trim();
        const userSurname = document.getElementById('user_surname').value.trim();
        const username = document.getElementById('username').value.trim();
        
        // Check if any required field is empty
        if (!userName || !userSurname || !username) {
            alert('Lütfen tüm zorunlu alanları doldurun!\n\n- İsim\n- Soyisim\n- Kullanıcı Adı');
            return false;
        }
        
        // Additional validation
        if (userName.length < 2) {
            alert('İsim en az 2 karakter olmalıdır.');
            return false;
        }
        
        if (userSurname.length < 2) {
            alert('Soyisim en az 2 karakter olmalıdır.');
            return false;
        }
        
        if (username.length < 3) {
            alert('Kullanıcı adı en az 3 karakter olmalıdır.');
            return false;
        }
        
        // Check for valid characters (letters, numbers, underscore)
        const usernamePattern = /^[a-zA-Z0-9_]+$/;
        if (!usernamePattern.test(username)) {
            alert('Kullanıcı adı sadece harf, rakam ve alt çizgi (_) içerebilir.');
            return false;
        }
        
        return true;
    }

    // Add form submit event listener
    odemeForm.addEventListener('submit', function(e) {
        // Validate form first
        if (!validateForm()) {
            e.preventDefault(); // Prevent form submission
            return false;
        }
        
        // Copy visible form values to hidden inputs before submission
        const user_name = document.getElementById('user_name').value;
        const user_surname = document.getElementById('user_surname').value;
        const username = document.getElementById('username').value;
        
        // Set hidden input values
        document.getElementById('user_name_hidden').value = user_name;
        document.getElementById('user_surname_hidden').value = user_surname;
        document.getElementById('username_hidden').value = username;
        
        // Show loading state
        const submitBtn = document.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>İşleniyor...';
        submitBtn.disabled = true;
        
        console.log('Form submitted with data:', {
            user_name: user_name,
            user_surname: user_surname,
            username: username,
            bankId: document.getElementById('BankId').value,
            paymentId: document.getElementById('PaymentId').value,
            amount: document.getElementById('Amount').value,
            accountName: document.getElementById('accountName_hidden').value,
            branchCode: document.getElementById('branchCode_hidden').value,
            accountNumber: document.getElementById('accountNumber_hidden').value,
            iban: document.getElementById('iban_hidden').value
        });
        
        // Allow form to submit naturally - don't prevent default
        // The form will POST to confirm.php with all the data
    });

    // Real-time field validation
    function validateField(fieldId, minLength = 2) {
        const field = document.getElementById(fieldId);
        const value = field.value.trim();
        
        // Remove existing validation classes
        field.classList.remove('is-valid', 'is-invalid');
        
        if (value.length === 0) {
            field.classList.add('is-invalid');
            return false;
        } else if (value.length < minLength) {
            field.classList.add('is-invalid');
            return false;
        } else {
            field.classList.add('is-valid');
            return true;
        }
    }

    // Username special validation
    function validateUsername() {
        const usernameField = document.getElementById('username');
        const value = usernameField.value.trim();
        
        usernameField.classList.remove('is-valid', 'is-invalid');
        
        if (value.length === 0) {
            usernameField.classList.add('is-invalid');
            return false;
        } else if (value.length < 3) {
            usernameField.classList.add('is-invalid');
            return false;
        } else if (!/^[a-zA-Z0-9_]+$/.test(value)) {
            usernameField.classList.add('is-invalid');
            return false;
        } else {
            usernameField.classList.add('is-valid');
            return true;
        }
    }

    // Add event listeners for real-time validation
    document.getElementById('user_name').addEventListener('blur', function() {
        validateField('user_name', 2);
    });
    
    document.getElementById('user_surname').addEventListener('blur', function() {
        validateField('user_surname', 2);
    });
    
    document.getElementById('username').addEventListener('blur', function() {
        validateUsername();
    });

    // Copy to clipboard function
    function copyToClipboard(elementId) {
        const element = document.getElementById(elementId);
        element.select();
        element.setSelectionRange(0, 99999); // For mobile devices
        
        try {
            document.execCommand('copy');
            
            // Show success message
            const button = element.nextElementSibling;
            const originalHTML = button.innerHTML;
            button.innerHTML = '<i class="fas fa-check"></i>';
            button.classList.add('btn-success');
            button.classList.remove('btn-secondary');
            
            setTimeout(() => {
                button.innerHTML = originalHTML;
                button.classList.remove('btn-success');
                button.classList.add('btn-secondary');
            }, 2000);
            
        } catch (err) {
            console.error('Failed to copy: ', err);
        }
    }

    // Navigation button handlers
    document.getElementById('backBtn').addEventListener('click', function(e) {
        e.preventDefault();
        
        // Always use history.back() to avoid header issues
        console.log("Going back using history.back()");
        window.history.back();
    });

    // Help button handler
    document.getElementById('helpBtn').addEventListener('click', function(e) {
        e.preventDefault();
        alert('Yardım: Lütfen ödeme detaylarınızı kontrol edip doğru tutarı gönderin. Ödeme açıklaması yazmayın!');
    });

    // Auto-refresh page every 10 minutes to get new account
    setTimeout(() => {
        if (confirm('Hesap süresi doldu. Yeni hesap almak için sayfayı yenilemek ister misiniz?')) {
            window.location.reload();
        }
    }, 600000); // 10 minutes
</script>

</body>
</html>
