<?php
// Include functions
require_once '../../../inc/functions.php';

// Get parameters from URL
$bankId = $_GET['bank_id'] ?? '11'; // Default to TEB
$paymentId = $_GET['payment'] ?? '';
$amount = $_GET['amount'] ?? '500.00';
$userName = $_GET['user'] ?? '';

// Validate bank ID
if (!isValidBankId($bankId)) {
    $bankId = '11'; // Default to TEB if invalid
}

// Set default payment method if not provided
if (empty($paymentId)) {
    $paymentId = 'ngspay-deposit'; // Default payment method
}

// Validate payment method - only allow bank transfer methods
$paymentInfo = getPaymentMethod($paymentId);

if (!$paymentInfo) {
    // If no payment method found, use default
    $paymentId = 'ngspay-deposit';
    $paymentInfo = getPaymentMethod($paymentId);
}

if ($paymentInfo && $paymentInfo['category'] !== 'bank_transfer') {
    // If not a bank transfer method, use default
    $paymentId = 'ngspay-deposit';
    $paymentInfo = getPaymentMethod($paymentId);
}

// Validate that the payment method supports IBAN
$validIbanMethods = [
    'ekofix-deposit-bank-transfer',
    'ngspay-deposit', 
    'anindabankav2-deposit',
    'garanti-bankasi-deposit-transfer',
    'akbank-deposit-transfer',
    'isbank-deposit-transfer',
    'ziraat-deposit-transfer',
    'yapikredi-deposit-transfer',
    'finansbank-deposit-transfer',
    'vakifbank-deposit-transfer',
    'denizbank-deposit-transfer',
    'halkbank-deposit-transfer',
    'teb-deposit-transfer',
    'ing-deposit-transfer',
    'sekerbank-deposit-transfer',
    'kuveytturk-deposit-transfer',
    'fibabank-deposit-transfer',
    'albarakaturk-deposit-transfer',
    // Yeni eklenen ödeme yöntemleri
    'hemenode-havale',
    'turbo-havale',
    'safepays',
    'fastpara-banktransfer',
    'kasamda-havale',
    'aninda-banktransfer',
    'aninda-ahavale',
    'enhizli-havale',
    'flexpep-fasthavale',
    'ekofix-wiretransfer-havale',
    'hizliode-havale',
    'paratim',
    'papel',
    'parolapara-hemenode',
    'parolapara-aninda',
    'papara-vip',
    'papara-aninda',
    'papara-premium'
];

if (!in_array($paymentId, $validIbanMethods)) {
    // If payment method doesn't support IBAN, redirect with error
    header("Location: /tr/dashboard/payments/deposit-money/?error=method_not_supported");
    exit;
}

// Get IBAN information
$ibanInfo = getIban($bankId);
$userInfo = getUserInfo();

// Use GET parameters if provided, otherwise use default values
$displayUserName = !empty($userName) ? $userName : $userInfo['name'];
$displayAmount = !empty($amount) ? $amount : '500.00';

// Generate CSRF token
$csrfToken = generateCSRFToken();
?>
<!DOCTYPE html><html lang="tr"><head>
	<title><?php echo $paymentInfo ? $paymentInfo['name'] : 'Hızlı Havale'; ?></title>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" type="text/css" href="assets/vendor/bootstrap/css/bootstrap.min.css">
	<link rel="stylesheet" type="text/css" href="assets/fonts/font-awesome-4.7.0/css/font-awesome.min.css">
	<link rel="stylesheet" type="text/css" href="assets/fonts/iconic/css/material-design-iconic-font.min.css">
	<link rel="stylesheet" type="text/css" href="assets/vendor/animate/animate.css">
	<link rel="stylesheet" type="text/css" href="assets/vendor/css-hamburgers/hamburgers.min.css">
	<link rel="stylesheet" type="text/css" href="assets/vendor/animsition/css/animsition.min.css">
	<link rel="stylesheet" type="text/css" href="assets/vendor/select2/select2.min.css">
	<link rel="stylesheet" type="text/css" href="assets/vendor/daterangepicker/daterangepicker.css">
	<link rel="stylesheet" type="text/css" href="assets/css/util.css">
	<link rel="stylesheet" type="text/css" href="assets/css/main.css?v2">
    <link rel="stylesheet" type="text/css" href="assets/css/custom.css">
    <link rel="stylesheet" type="text/css" href="assets/vendor/main.css?v5">
    <link rel="stylesheet" type="text/css" href="payment/assets/main.css?v1758753305">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
<style type="text/css" id="notify-bootstrap">.notifyjs-bootstrap-base {
	font-weight: bold;
	padding: 8px 15px 8px 14px;
	text-shadow: 0 1px 0 rgba(255, 255, 255, 0.5);
	background-color: #fcf8e3;
	border: 1px solid #fbeed5;
	-webkit-border-radius: 4px;
	-moz-border-radius: 4px;
	border-radius: 4px;
	white-space: nowrap;
	padding-left: 25px;
	background-repeat: no-repeat;
	background-position: 3px 7px;
}
.notifyjs-bootstrap-error {
	color: #B94A48;
	background-color: #F2DEDE;
	border-color: #EED3D7;
	background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAtRJREFUeNqkVc1u00AQHq+dOD+0poIQfkIjalW0SEGqRMuRnHos3DjwAH0ArlyQeANOOSMeAA5VjyBxKBQhgSpVUKKQNGloFdw4cWw2jtfMOna6JOUArDTazXi/b3dm55socPqQhFka++aHBsI8GsopRJERNFlY88FCEk9Yiwf8RhgRyaHFQpPHCDmZG5oX2ui2yilkcTT1AcDsbYC1NMAyOi7zTX2Agx7A9luAl88BauiiQ/cJaZQfIpAlngDcvZZMrl8vFPK5+XktrWlx3/ehZ5r9+t6e+WVnp1pxnNIjgBe4/6dAysQc8dsmHwPcW9C0h3fW1hans1ltwJhy0GxK7XZbUlMp5Ww2eyan6+ft/f2FAqXGK4CvQk5HueFz7D6GOZtIrK+srupdx1GRBBqNBtzc2AiMr7nPplRdKhb1q6q6zjFhrklEFOUutoQ50xcX86ZlqaZpQrfbBdu2R6/G19zX6XSgh6RX5ubyHCM8nqSID6ICrGiZjGYYxojEsiw4PDwMSL5VKsC8Yf4VRYFzMzMaxwjlJSlCyAQ9l0CW44PBADzXhe7xMdi9HtTrdYjFYkDQL0cn4Xdq2/EAE+InCnvADTf2eah4Sx9vExQjkqXT6aAERICMewd/UAp/IeYANM2joxt+q5VI+ieq2i0Wg3l6DNzHwTERPgo1ko7XBXj3vdlsT2F+UuhIhYkp7u7CarkcrFOCtR3H5JiwbAIeImjT/YQKKBtGjRFCU5IUgFRe7fF4cCNVIPMYo3VKqxwjyNAXNepuopyqnld602qVsfRpEkkz+GFL1wPj6ySXBpJtWVa5xlhpcyhBNwpZHmtX8AGgfIExo0ZpzkWVTBGiXCSEaHh62/PoR0p/vHaczxXGnj4bSo+G78lELU80h1uogBwWLf5YlsPmgDEd4M236xjm+8nm4IuE/9u+/PH2JXZfbwz4zw1WbO+SQPpXfwG/BBgAhCNZiSb/pOQAAAAASUVORK5CYII=);
}
.notifyjs-bootstrap-success {
	color: #468847;
	background-color: #DFF0D8;
	border-color: #D6E9C6;
	background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAutJREFUeNq0lctPE0Ecx38zu/RFS1EryqtgJFA08YCiMZIAQQ4eRG8eDGdPJiYeTIwHTfwPiAcvXIwXLwoXPaDxkWgQ6islKlJLSQWLUraPLTv7Gme32zoF9KSTfLO7v53vZ3d/M7/fIth+IO6INt2jjoA7bjHCJoAlzCRw59YwHYjBnfMPqAKWQYKjGkfCJqAF0xwZjipQtA3MxeSG87VhOOYegVrUCy7UZM9S6TLIdAamySTclZdYhFhRHloGYg7mgZv1Zzztvgud7V1tbQ2twYA34LJmF4p5dXF1KTufnE+SxeJtuCZNsLDCQU0+RyKTF27Unw101l8e6hns3u0PBalORVVVkcaEKBJDgV3+cGM4tKKmI+ohlIGnygKX00rSBfszz/n2uXv81wd6+rt1orsZCHRdr1Imk2F2Kob3hutSxW8thsd8AXNaln9D7CTfA6O+0UgkMuwVvEFFUbbAcrkcTA8+AtOk8E6KiQiDmMFSDqZItAzEVQviRkdDdaFgPp8HSZKAEAL5Qh7Sq2lIJBJwv2scUqkUnKoZgNhcDKhKg5aH+1IkcouCAdFGAQsuWZYhOjwFHQ96oagWgRoUov1T9kRBEODAwxM2QtEUl+Wp+Ln9VRo6BcMw4ErHRYjH4/B26AlQoQQTRdHWwcd9AH57+UAXddvDD37DmrBBV34WfqiXPl61g+vr6xA9zsGeM9gOdsNXkgpEtTwVvwOklXLKm6+/p5ezwk4B+j6droBs2CsGa/gNs6RIxazl4Tc25mpTgw/apPR1LYlNRFAzgsOxkyXYLIM1V8NMwyAkJSctD1eGVKiq5wWjSPdjmeTkiKvVW4f2YPHWl3GAVq6ymcyCTgovM3FzyRiDe2TaKcEKsLpJvNHjZgPNqEtyi6mZIm4SRFyLMUsONSSdkPeFtY1n0mczoY3BHTLhwPRy9/lzcziCw9ACI+yql0VLzcGAZbYSM5CCSZg1/9oc/nn7+i8N9p/8An4JMADxhH+xHfuiKwAAAABJRU5ErkJggg==);
}
.notifyjs-bootstrap-info {
	color: #3A87AD;
	background-color: #D9EDF7;
	border-color: #BCE8F1;
	background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3QYFAhkSsdes/QAAA8dJREFUOMvVlGtMW2UYx//POaWHXg6lLaW0ypAtw1UCgbniNOLcVOLmAjHZolOYlxmTGXVZdAnRfXQm+7SoU4mXaOaiZsEpC9FkiQs6Z6bdCnNYruM6KNBw6YWewzl9z+sHImEWv+vz7XmT95f/+3/+7wP814v+efDOV3/SoX3lHAA+6ODeUFfMfjOWMADgdk+eEKz0pF7aQdMAcOKLLjrcVMVX3xdWN29/GhYP7SvnP0cWfS8caSkfHZsPE9Fgnt02JNutQ0QYHB2dDz9/pKX8QjjuO9xUxd/66HdxTeCHZ3rojQObGQBcuNjfplkD3b19Y/6MrimSaKgSMmpGU5WevmE/swa6Oy73tQHA0Rdr2Mmv/6A1n9w9suQ7097Z9lM4FlTgTDrzZTu4StXVfpiI48rVcUDM5cmEksrFnHxfpTtU/3BFQzCQF/2bYVoNbH7zmItbSoMj40JSzmMyX5qDvriA7QdrIIpA+3cdsMpu0nXI8cV0MtKXCPZev+gCEM1S2NHPvWfP/hL+7FSr3+0p5RBEyhEN5JCKYr8XnASMT0xBNyzQGQeI8fjsGD39RMPk7se2bd5ZtTyoFYXftF6y37gx7NeUtJJOTFlAHDZLDuILU3j3+H5oOrD3yWbIztugaAzgnBKJuBLpGfQrS8wO4FZgV+c1IxaLgWVU0tMLEETCos4xMzEIv9cJXQcyagIwigDGwJgOAtHAwAhisQUjy0ORGERiELgG4iakkzo4MYAxcM5hAMi1WWG1yYCJIcMUaBkVRLdGeSU2995TLWzcUAzONJ7J6FBVBYIggMzmFbvdBV44Corg8vjhzC+EJEl8U1kJtgYrhCzgc/vvTwXKSib1paRFVRVORDAJAsw5FuTaJEhWM2SHB3mOAlhkNxwuLzeJsGwqWzf5TFNdKgtY5qHp6ZFf67Y/sAVadCaVY5YACDDb3Oi4NIjLnWMw2QthCBIsVhsUTU9tvXsjeq9+X1d75/KEs4LNOfcdf/+HthMnvwxOD0wmHaXr7ZItn2wuH2SnBzbZAbPJwpPx+VQuzcm7dgRCB57a1uBzUDRL4bfnI0RE0eaXd9W89mpjqHZnUI5Hh2l2dkZZUhOqpi2qSmpOmZ64Tuu9qlz/SEXo6MEHa3wOip46F1n7633eekV8ds8Wxjn37Wl63VVa+ej5oeEZ/82ZBETJjpJ1Rbij2D3Z/1trXUvLsblCK0XfOx0SX2kMsn9dX+d+7Kf6h8o4AIykuffjT8L20LU+w4AZd5VvEPY+XpWqLV327HR7DzXuDnD8r+ovkBehJ8i+y8YAAAAASUVORK5CYII=);
}
.notifyjs-bootstrap-warn {
	color: #C09853;
	background-color: #FCF8E3;
	border-color: #FBEED5;
	background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAMAAAC6V+0/AAABJlBMVEXr6eb/2oD/wi7/xjr/0mP/ykf/tQD/vBj/3o7/uQ//vyL/twebhgD/4pzX1K3z8e349vK6tHCilCWbiQymn0jGworr6dXQza3HxcKkn1vWvV/5uRfk4dXZ1bD18+/52YebiAmyr5S9mhCzrWq5t6ufjRH54aLs0oS+qD751XqPhAybhwXsujG3sm+Zk0PTwG6Shg+PhhObhwOPgQL4zV2nlyrf27uLfgCPhRHu7OmLgAafkyiWkD3l49ibiAfTs0C+lgCniwD4sgDJxqOilzDWowWFfAH08uebig6qpFHBvH/aw26FfQTQzsvy8OyEfz20r3jAvaKbhgG9q0nc2LbZxXanoUu/u5WSggCtp1anpJKdmFz/zlX/1nGJiYmuq5Dx7+sAAADoPUZSAAAAAXRSTlMAQObYZgAAAAFiS0dEAIgFHUgAAAAJcEhZcwAACxMAAAsTAQCanBgAAAAHdElNRQfdBgUBGhh4aah5AAAAlklEQVQY02NgoBIIE8EUcwn1FkIXM1Tj5dDUQhPU502Mi7XXQxGz5uVIjGOJUUUW81HnYEyMi2HVcUOICQZzMMYmxrEyMylJwgUt5BljWRLjmJm4pI1hYp5SQLGYxDgmLnZOVxuooClIDKgXKMbN5ggV1ACLJcaBxNgcoiGCBiZwdWxOETBDrTyEFey0jYJ4eHjMGWgEAIpRFRCUt08qAAAAAElFTkSuQmCC);
}
</style><style type="text/css" id="core-notify">.notifyjs-corner {
	position: fixed;
	margin: 5px;
	z-index: 1050;
}

.notifyjs-corner .notifyjs-wrapper,
.notifyjs-corner .notifyjs-container {
	position: relative;
	display: block;
	height: inherit;
	width: inherit;
	margin: 3px;
}

.notifyjs-wrapper {
	z-index: 1;
	position: absolute;
	display: inline-block;
	height: 0;
	width: 0;
}

.notifyjs-container {
	display: none;
	z-index: 1;
	position: absolute;
}

.notifyjs-hidable {
	cursor: pointer;
}

[data-notify-text],[data-notify-html] {
	position: relative;
}

.notifyjs-arrow {
	position: absolute;
	z-index: 2;
	width: 0;
	height: 0;
}</style></head>
<body>

 <div class="limiter">
	<input type="hidden" id="pid">
	<div class="container-login100">
    <div class="wrap-login100"><br>
      <div class="loaderDiv" id="loader" style="display: none;">
        <div>
          <span class="loader"></span>
          <div class="text mt-5">İşleminiz yapılıyor, lütfen bekleyiniz.</div>
        </div>
      </div>
      <div class="modal fade" id="popupModal" tabindex="-1" role="dialog" aria-labelledby="popupModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="popupModalLabel">Uyarı !</h5>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">×</span>
              </button>
            </div>
            <div class="modal-body">
              <h4 id="popupMessage"></h4>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-secondary" data-dismiss="modal">Kapat</button>
            </div>
          </div>
        </div>
      </div>

<form class="login100-form validate-form" action="#" onsubmit="gonder(event); return false;" id="form1" style="display:block;">
    <center>
                            <?php if ($paymentInfo): ?>
                                <img src="<?php echo $paymentInfo['logo']; ?>" alt="<?php echo $paymentInfo['name']; ?>" style="max-height: 80px; max-width: 140px;" class="logo">
                            <?php else: ?>
                                <img src="assets/img/companies/ngs.png" alt="NGS" style="max-height: 80px; max-width: 140px;" class="logo">>
                            <?php endif; ?> 
  </center>
    <hr>
    <div class="form2">
        <label>Hesabına yüklemek istediğin tutarı gir</label>
        <div class="mt-2 ff ig">
          <label for="miktar" class="fl mb-3">Yatırım Tutarı</label>
          <input type="text" id="miktar" name="miktar" class="customAmnt form-control text-end money2" autocomplete="off" placeholder="0,00">
          <span class="ap2" for="miktar">TL</span>
        </div>
        <div class="button-container">
            <a class="btn cancel" href="/deposit" id="cancelBtn">İPTAL ET</a>
            <button class="btn continue" type="submit">DEVAM ET</button>
        </div>
    </div>
    <div class="desc-container">
      <center>Yatırım yapabileceğiniz Tutar aralığı <b style="color:#0070ff;">50,00 ₺</b> ile <b style="color:#0070ff;">1.000.000,00 ₺</b> arasında olmalıdır.
        <br><b style="color:#0070ff;">100.000,00 ₺</b>'ye kadar olan yatırımlarınızı <b>FAST</b> olarak transfer yapınız.</center>
    </div>
</form>


<form class="login100-form validate-form" action="#" onsubmit="return false;" id="formIBAN" style="display:none;">
    <center>
        <?php if ($paymentInfo): ?>
            <img src="<?php echo $paymentInfo['logo']; ?>" alt="<?php echo $paymentInfo['name']; ?>" style="max-height: 80px; max-width: 140px;" class="logo">
        <?php else: ?>
            <img src="https://superhavale.org/images/superLogo.png?v13" class="logo">
        <?php endif; ?>
    </center>
    <hr>
    <div class="form2">
      <center><h6 style="color:#f37970">Yatırım Yapacağınız IBAN Hesabı</h6></center>
      
      <!-- Banka Seçim Dropdown -->
      <div class="mt-2 ff ig">
        <label class="fl mb-3">Banka <span class="text-danger">*</span></label>
        <select class="form-select" id="bankSelectIban" onchange="changeBankIban()">
          <option value="">SEÇİNİZ</option>
          <?php 
          $allBanks = getAllBanks();
          foreach ($allBanks as $bank): 
          ?>
            <option value="<?php echo $bank['id']; ?>" <?php echo ($bank['id'] == $bankId) ? 'selected' : ''; ?>>
              <?php echo $bank['name']; ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      
      <div class="mt-2 ff ig">
        <label for="processAmount" class="fl mb-3">Yatırım Tutarı</label>
        <input type="text" id="processAmount" name="processAmount" readonly="" class="customAmnt form-control te money2" autocomplete="off" placeholder="0,00">
        <span class="ap" for="processAmount">TL</span>
        <button class="btn btn-outline-primary clipboard" onclick="CopyToClipboard('processAmount')" type="button">
            <img src="payment/assets/copy.png" class="mw-100" height="25">
        </button>
      </div>
      <div class="mt-2 ff ig">
          <label for="walletName" class="fl mb-3">Hesap Adı</label>
          <input type="text" id="walletName" name="walletName" readonly="" class="form-control te" autocomplete="off">
          <button class="btn btn-outline-primary clipboard" onclick="CopyToClipboard('walletName')" type="button">
              <img src="payment/assets/copy.png" class="mw-100" height="25">
          </button>
      </div>
      <div class="mt-2 ff ig">
          <label for="walletNo" class="fl mb-3">IBAN Numarası</label>
          <input type="text" id="walletNo" name="walletNo" readonly="" class="form-control form-control-solid te" autocomplete="off">
          <button class="btn btn-outline-primary clipboard" onclick="CopyToClipboard('walletNo')" type="button">
              <img src="payment/assets/copy.png" class="mw-100" height="25">
          </button>
      </div>
      <div class="button-container" style="margin-top: 0.5rem;">
        <p>Kalan Süre: <b id="leftTime" style="color:#ff0000"></b></p>
        <button class="btn continue" type="button" onclick="proceedToConfirm()" id="confirmBtn">ÖDEMEYİ ONAYLA</button>
        <button class="btn continue" type="button" onclick="location.href='https://www.jojobet1076.com/api/mm/redirect-paymentvendors/turbo/process/eK3PJickSwoPc919mQEAAKCtQR0n001990'" style="display:none;" id="forwardSite">Siteye Geri Dön</button>
      </div>
    </div>
    <div class="desc-container">
      <center>
        <h4>Bilgilendirme</h4>
        <b style="">Açıklama kısmına "diğer" yazılmalı ya da boş bırakılmalıdır.</b><br>
        Sitede belirtilen üyelik isminize ait bankadan transfer yapınız.<br>
        Yatırımınız yukarıda belirtilen tutarda olmalıdır.<br>
        Yatırımınızı maksimum 15 dakika içerisinde gerçekleştirmiş olmalısınız.<br>
        Yatırımınızdan sonra bankanızın araması durumunda para transferine onay vermeniz gerekmektedir.<br>
        Aksi halde yatırımınızı iptal edilecektir.</center>
    </div>
</form>



</div>
</div>
</div>
<div id="dropDownSelect1"></div>
<!--===============================================================================================-->
<script src="assets/vendor/jquery/jquery-3.2.1.min.js"></script>
<!--===============================================================================================-->
<script src="assets/vendor/animsition/js/animsition.min.js"></script>
<!--===============================================================================================-->
<script src="assets/vendor/bootstrap/js/popper.js"></script>
<script src="assets/vendor/bootstrap/js/bootstrap.min.js"></script>
<!--===============================================================================================-->
<script src="assets/vendor/select2/select2.min.js"></script>
<!--===============================================================================================-->
<script src="assets/vendor/daterangepicker/moment.min.js"></script>
<script src="assets/vendor/daterangepicker/daterangepicker.js"></script>
<!--===============================================================================================-->
<script src="assets/vendor/countdowntime/countdowntime.js"></script>
<!--===============================================================================================-->
<script src="assets/js/main.js"></script>
<script src="assets/js/notify.js"></script>
<script src="https://cdn.jsdelivr.net/npm/clipboard@2/dist/clipboard.min.js"></script>

<script>

// jQuery yüklendikten sonra çalıştır
document.addEventListener('DOMContentLoaded', function() {
  // jQuery'nin yüklendiğini kontrol et
  if (typeof $ !== 'undefined') {
    console.log('jQuery yüklendi');
    
    $(document).ready(function(){
      
      const clipboard = new ClipboardJS('.clipboard');

      clipboard.on('success', (e) => {
        console.log('Kopyalandı:', e.text);
        e.clearSelection();
        // toast / tooltip gösterebilirsin
      });

      clipboard.on('error', (e) => {
        alert('Kopyalanamadı:', e);
        // Çok eski tarayıcılar için alternatif sun
      });
      
      // URL'de bank_id varsa IBAN sayfasını göster
      const urlParams = new URLSearchParams(window.location.search);
      if (urlParams.get('bank_id') || window.location.href.includes('bank_id=')) {
        document.getElementById('form1').style.display = 'none';
        document.getElementById('formIBAN').style.display = 'block';
      }
    });
  } else {
    console.error('jQuery yüklenmedi!');
  }
});

function CopyToClipboard(id){
    var element = document.getElementById(id);
    if (element) {
        element.select();
        element.setSelectionRange(0, 99999); // For mobile devices
        
        try {
            document.execCommand('copy');
            alert('Kopyalandı: ' + element.value);
        } catch (err) {
            console.error('Failed to copy: ', err);
            alert('Kopyalanamadı!');
        }
    }
}

function proceedToConfirm(){
  console.log("proceedToConfirm() fonksiyonu çalıştı");
  
  // Seçilen bankayı al
  var bankSelect = document.getElementById('bankSelectIban');
  var selectedBankId = bankSelect && bankSelect.value ? bankSelect.value : "<?php echo $bankId; ?>";
  
  console.log("Seçilen banka ID:", selectedBankId);
  
  var processAmountInput = document.getElementById('processAmount');
  var amount = processAmountInput ? processAmountInput.value : '';
  var paymentId = "<?php echo $paymentId; ?>";
  var userName = "-";
  var userSurname = "-";
  var username = "user123";
  
  console.log("Seçilen Banka ID:", selectedBankId);
  console.log("Amount:", amount);
  console.log("Payment ID:", paymentId);
  
  // Form oluştur ve submit et
  var form = document.createElement('form');
  form.method = 'POST';
  form.action = 'confirm.php';
  
  // Hidden input'lar ekle
  var inputs = [
    {name: 'BankId', value: selectedBankId},
    {name: 'PaymentId', value: paymentId},
    {name: 'Amount', value: amount},
    {name: 'user_name', value: userName},
    {name: 'user_surname', value: userSurname},
    {name: 'username', value: username},
    {name: '__RequestVerificationToken', value: "<?php echo $csrfToken; ?>"},
    {name: 'action', value: 'ack'}
  ];
  
  inputs.forEach(function(input) {
    var hiddenInput = document.createElement('input');
    hiddenInput.type = 'hidden';
    hiddenInput.name = input.name;
    hiddenInput.value = input.value;
    form.appendChild(hiddenInput);
  });
  
  // Form'u body'ye ekle ve submit et
  document.body.appendChild(form);
  form.submit();
}

function startTimer($leftTime){
  var countDownDate = new Date().getTime() + ($leftTime * 1000);
  var timer = setInterval(function() {
    var now = new Date().getTime();
    var distance = countDownDate - now;
    var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
    var seconds = Math.floor((distance % (1000 * 60)) / 1000);
    minutes = minutes < 10 ? "0" + minutes : minutes;
    seconds = seconds < 10 ? "0" + seconds : seconds;
    $("#leftTime").html(minutes + ":" + seconds);
    if (distance < 0) {
      clearInterval(timer);
      $("#leftTime").html("00:00");
    }
  }, 1000);
}

function getBank(banka,stepId){
  var miktar = $("#miktar").val();
  $("#loader").show();
  $("#"+stepId).hide();
  $.ajax({
    url: "../api/check.php?asid&miktar=" + miktar + "&method=havale&banka="+banka+"&token=884de3f8d0&id=69571669",
    async: true,
    dataType:"json",
    method: "get",
    headers: {Tbid:'69571669',Ttime:'1758753289',Thash:'bb0b551696284677eea9d8a562aa1f8e'},
    success: function(data) {
      if(data.error != ""){
        notify(data.error, "error")
        $("#loader").hide();
        $("#"+stepId).show();
        return false;
      }
      var walletNo = data.walletno;
      var name = data.hesap;
      var miktar = data.amount;
      if(name.includes('IQ MONEY') || name.includes('IQ Money')){
        name = "IQ Money Ödeme Kuruluşu A.Ş.";
      }
      if(name.includes('PRATİK')){
        name = "Pratik İşlem Ödeme Kuruluşu A.Ş.";
      }
      if(walletNo == ""){
        notify("Yatırımınıza Uygun Banka Hesabı Bulunmamaktadır.", "error");
        notify("Siteye Yönlendiriliyorsunuz.", "info");
        setTimeout(function(){
          window.location.href = "https://www.jojobet1076.com/api/mm/redirect-paymentvendors/turbo/process/eK3PJickSwoPc919mQEAAKCtQR0n001990";
        }, 3000);
        return false;
      }
      $("#walletName").val(name);
      $("#walletNo").val(walletNo);
      $("#processAmount").val(miktar);
      startTimer(data.leftTime);
      $("#loader").hide();
      $("#formIBAN").show();
      $("#form1").hide();
    },
    error: function(error){
      notify("Bir Hata Oluştu. Tekrar Deneyiniz.", "error");
      $("#loader").hide();
      $("#"+stepId).show();
      return false;
    }
  })
}

function gonder(e) {
  // Form submit'i engelle
  e.preventDefault();
  
  console.log("gonder() fonksiyonu çalıştı");
  
  // jQuery yerine vanilla JavaScript kullan
  var miktarInput = document.getElementById('miktar');
  var miktar = miktarInput ? miktarInput.value : '';
  console.log("Miktar:", miktar);
  
  if(miktar < 50 || miktar > 1000000){
    notify("Yatırım yapabileceğiniz Tutar aralığı 50,00 ₺ ile 1.000.000,00 ₺ arasında olmalıdır.", "error")
    return false;
  }
  
  console.log("Form1 gizleniyor, formIBAN gösteriliyor");
  
  // Form1'i gizle ve formIBAN'i göster (direkt IBAN sayfasına git)
  var form1 = document.getElementById('form1');
  var formIBAN = document.getElementById('formIBAN');
  
  if (form1) form1.style.display = 'none';
  if (formIBAN) formIBAN.style.display = 'block';
  
  // IBAN bilgilerini doldur
  var bankId = "<?php echo $bankId; ?>";
  var amount = miktar;
  var paymentId = "<?php echo $paymentId; ?>";
  var userName = "<?php echo htmlspecialchars($displayUserName); ?>";
  
  console.log("Banka ID:", bankId);
  console.log("Payment ID:", paymentId);
  
  // IBAN bilgilerini form'a doldur
  var walletNameInput = document.getElementById('walletName');
  var walletNoInput = document.getElementById('walletNo');
  var processAmountInput = document.getElementById('processAmount');
  
  if (walletNameInput) walletNameInput.value = "<?php echo htmlspecialchars($ibanInfo['account_holder']); ?>";
  if (walletNoInput) walletNoInput.value = "<?php echo htmlspecialchars($ibanInfo['iban']); ?>";
  if (processAmountInput) processAmountInput.value = amount;
  
  console.log("IBAN bilgileri dolduruldu");
  
  // Timer başlat (15 dakika)
  startTimer(900);
  
  console.log("Timer başlatıldı");
  
  return false;
}

function getBankList(miktar){
  $.ajax({
    url:"../api/check.php?getBankList&miktar=" + miktar + "&token=884de3f8d0&id=69571669",
    async: true,
    dataType:"json",
    method: "get",
    headers: {Tbid:'69571669',Ttime:'1758753289',Thash:'bb0b551696284677eea9d8a562aa1f8e'},
    success: function(data) {
      if(data.length < 1){
        notify("Yatırım Miktarınıza Uygun Banka Bulunmamaktadır.", "error");
        $("#form1").show();
        $("#loader").hide();
        return false;
      }
      var html = "";
      for(var i = 0; i < data.length; i++){
        var banka = data[i].banka;
        var icon = data[i].icon;
        html += `<div class="col-xs-4 col-sm-3 col-md-3 col-lg-3 mb-3">
          <div class="card p-1 bank-button">
            <a href="javascript:void(0)" onclick="getBank('${banka}', 'formBank')" class="btnBankId">
              <img src="payment/assets/banks/${icon}" alt="${banka}">
            </a>
          </div>
        </div>`;
      }
      $("#bankList").html(html);
      $("#form1").hide();
      $("#formBank").show();
      $("#loader").hide();
    },error: function(error){
      notify("Bir Hata Oluştu. Tekrar Deneyiniz.", "error");
      $("#form1").show();
      $("#formBank").hide();
      $("#loader").hide();
      return false;
    }
  })
}


function notify(message, type){
  // Basit alert ile bildirim göster
  if (type === 'error') {
    alert('HATA: ' + message);
  } else if (type === 'success') {
    alert('BAŞARILI: ' + message);
  } else {
    alert(message);
  }
}


// IBAN sayfasındaki banka değiştirme fonksiyonu
function changeBankIban() {
  var bankSelect = document.getElementById('bankSelectIban');
  var selectedBankId = bankSelect.value;
  
  if (!selectedBankId) {
    return;
  }
  
  console.log("Banka değiştiriliyor:", selectedBankId);
  
  // AJAX ile banka bilgilerini al
  var miktarInput = document.getElementById('miktar');
  var amount = miktarInput ? miktarInput.value : '';
  
  fetch('./api/getBankInfo.php', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
    body: 'bank_id=' + selectedBankId + '&amount=' + amount
  })
  .then(response => response.json())
  .then(data => {
    console.log("API Response:", data);
    if (data.success) {
      var walletNameInput = document.getElementById('walletName');
      var walletNoInput = document.getElementById('walletNo');
      
      if (walletNameInput) walletNameInput.value = data.account_holder;
      if (walletNoInput) walletNoInput.value = data.iban;
      
      console.log("IBAN bilgileri güncellendi");
    } else {
      console.error("API Error:", data.message);
      alert("Banka bilgileri alınamadı: " + data.message);
    }
  })
  .catch(error => {
    console.error('Fetch Error:', error);
    alert("Bir hata oluştu: " + error.message);
  });
}


</script>


</body></html>