<?php
// Include functions
require_once '../../../inc/functions.php';

// Check if form was submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'ack') {
    
    // Get form data
    $bankId = $_POST['BankId'] ?? '';
    $paymentId = $_POST['PaymentId'] ?? '';
    $amount = $_POST['Amount'] ?? '';
    $userName = $_POST['user_name'] ?? '';
    $userSurname = $_POST['user_surname'] ?? '';
    $username = $_POST['username'] ?? '';
    $csrfToken = $_POST['__RequestVerificationToken'] ?? '';
    
    // Validate data
    if (!isValidBankId($bankId)) {
        die('Geçersiz banka ID!');
    }
    
    // İsim/soyisim boşsa varsayılan değerler kullan
    if (empty($userName)) {
        $userName = '-';
    }
    if (empty($userSurname)) {
        $userSurname = '-';
    }
    if (empty($username)) {
        $username = 'user123';
    }
    
    $username = isset($_SESSION['username']) ? htmlspecialchars($_SESSION['username']) : 'Kullanıcı';
    
    // Get IBAN information
    $ibanInfo = getIban($bankId);
    $paymentInfo = getPaymentMethod($paymentId);
    $userInfo = getUserInfo();
    
    if (!$ibanInfo) {
        die('Banka bilgileri bulunamadı!');
    }
    
    // Prepare payment data for approval function
    $paymentData = [
        'bank_id' => $bankId,
        'payment_id' => $paymentId,
        'amount' => $amount,
        'user_name' => $userName,
        'user_surname' => $userSurname,
        'username' => $username
    ];
    
    // Process payment approval
    $approvalResult = processPaymentApproval($paymentData);
    
    if ($approvalResult['success']) {
        $transactionId = $approvalResult['transaction_id'];
        $transactionData = $approvalResult['data'];
        $status = 'pending';
        
        // Telegram mesajı gönder
        $telegramData = [
            'bank_name' => $ibanInfo['bank_name'],
            'amount' => $amount,
            'user_name' => $userName,
            'user_surname' => $userSurname,
            'username' => $username,
            'iban' => $ibanInfo['iban'],
            'account_holder' => $ibanInfo['account_holder'],
            'transaction_id' => $transactionId
        ];
        
        $telegramMessage = createIbanPaymentTelegramMessage($telegramData);
        $telegramSent = sendTelegramMessage($telegramMessage);
        
        // Telegram gönderim durumunu logla
        if ($telegramSent) {
            error_log("IBAN ödeme onayı Telegram'a gönderildi. Transaction ID: " . $transactionId);
        } else {
            error_log("IBAN ödeme onayı Telegram'a gönderilemedi. Transaction ID: " . $transactionId);
        }
        
    } else {
        die('Ödeme onayı işlenemedi: ' . $approvalResult['message']);
    }
    
} else {
    // Redirect back if not POST request
    echo 'Ödeme onayı işlenemedi:';
    //header('Location: index.php');
    exit;
}
?>
<!DOCTYPE html>
<html class="no-focus" lang="tr" xml:lang="tr">
<head>
    <meta charset="utf-8">
    <title>Ödeme Onayı</title>
    <meta name="description" content="">
    <meta name="author" content="Karga Inc.">
    <meta name="robots" content="noindex, nofollow">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">

    <link rel="shortcut icon" href="assets/img/favicons/favicon.png">
    <link rel="icon" type="image/png" href="assets/img/favicons/favicon-192x192.png" sizes="192x192">
    <link rel="apple-touch-icon" sizes="180x180" href="assets/img/favicons/apple-touch-icon-180x180.png">

    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&amp;display=swap&amp;subset=latin,latin-ext">
    <link rel="stylesheet" id="css-main" href="assets/css/oneui.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>
<div id="page-container">
    <main id="main-container">
        <div class="bg-image" style="background-image: url('assets/img/bg/plane@2x.jpg');">
            <div class="row g-0 bg-primary-dark-op">
                <div class="hero-static col-lg-4 d-none d-lg-flex flex-column justify-content-center">
                    <div class="p-4 p-xl-5 flex-grow-1 d-flex align-items-center">
                        <div class="w-100 text-center">
                            <i class="fas fa-check-circle fa-5x text-success"></i>
                            <h3 class="text-white mt-3">Ödeme Onayı</h3>
                        </div>
                    </div>
                </div>
                <div class="hero-static col-lg-8 col-sm-12 d-flex flex-column align-items-center bg-body-light">
                    <div class="p-4 w-100 flex-grow-1 d-flex align-items-center">
                        <div class="w-100">
                            <div class="text-center mb-5">
                                <h1 class="fw-bold mb-2">Ödeme Onaylandı</h1>
                                <p class="fw-medium text-muted">
                                    Sayın <span class="text-primary"><?php echo htmlspecialchars($userName . ' ' . $userSurname); ?></span>,
                                    ödeme onay talebiniz başarıyla alınmıştır.
                                </p>
                            </div>

                            <div class="row justify-content-center">
                                <div class="col-lg-8 col-sm-12">
                                    
                                    <!-- Success Message -->
                                    <div class="alert alert-success d-flex align-items-center" role="alert">
                                        <div class="flex-shrink-0">
                                            <i class="fas fa-fw fa-check-circle"></i>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <h6 class="mb-1">Ödeme Onay Talebi Alındı</h6>
                                            <p class="mb-0">
                                                Ödeme onay talebiniz başarıyla sistemimize iletildi. 
                                                İşleminiz en kısa sürede kontrol edilip onaylanacaktır.
                                            </p>
                                        </div>
                                    </div>

                                    <!-- Transaction Details -->
                                    <div class="block block-rounded block-themed">
                                        <div class="block-header bg-success-dark">
                                            <h3 class="block-title">İşlem Detayları</h3>
                                        </div>
                                        <div class="block-content block-content-full">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <table class="table table-borderless">
                                                        <tr>
                                                            <td class="fw-bold">İşlem No:</td>
                                                            <td><?php echo $transactionId; ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-bold">Durum:</td>
                                                            <td><span class="badge bg-warning">Onay Bekliyor</span></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-bold">Ad Soyad:</td>
                                                            <td><?php echo htmlspecialchars($userName . ' ' . $userSurname); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-bold">Kullanıcı Adı:</td>
                                                            <td><?php echo htmlspecialchars($username); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-bold">Ödeme Yöntemi:</td>
                                                            <td><?php echo $paymentInfo ? $paymentInfo['name'] : 'Bank Transfer'; ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-bold">Banka:</td>
                                                            <td><?php echo $ibanInfo['bank_name']; ?></td>
                                                        </tr>
                                                    </table>
                                                </div>
                                                <div class="col-md-6">
                                                    <table class="table table-borderless">
                                                        <tr>
                                                            <td class="fw-bold">Hesap Sahibi:</td>
                                                            <td><?php echo htmlspecialchars($ibanInfo['account_holder']); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-bold">IBAN:</td>
                                                            <td><?php echo htmlspecialchars($ibanInfo['iban']); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-bold">Tutar:</td>
                                                            <td><?php echo formatAmount($amount); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-bold">Tarih:</td>
                                                            <td><?php echo date('d.m.Y H:i:s'); ?></td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Important Information -->
                                    <div class="block block-rounded block-themed">
                                        <div class="block-header bg-info-dark">
                                            <h3 class="block-title">Önemli Bilgiler</h3>
                                        </div>
                                        <div class="block-content block-content-full">
                                            <div class="alert alert-info">
                                                <h6><i class="fas fa-info-circle"></i> İşlem Süreci</h6>
                                                <ul class="mb-0">
                                                    <li>Ödeme onay talebiniz sistemimize iletildi</li>
                                                    <li>İşleminiz 5-10 dakika içinde kontrol edilecektir</li>
                                                    <li>Onaylandıktan sonra bakiyeniz otomatik olarak güncellenecektir</li>
                                                    <li>Herhangi bir sorun olması durumunda destek ekibimizle iletişime geçebilirsiniz</li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Action Buttons -->
                                    <div class="text-center">
                                        <a href="javascript:void(0);" onclick="goToHome()" class="btn btn-primary btn-lg d-flex align-items-center justify-content-center">
                                            <i class="fas fa-home me-2"></i> Ana Sayfaya Dön
                                        </a>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
</div>

<script src="assets/js/oneui.app.min.js"></script>
<script src="assets/js/lib/jquery.min.js"></script>

<script type="text/javascript">
    // Navigation button handler
    document.getElementById('backBtn').addEventListener('click', function(e) {
        e.preventDefault();
        
        // Always use history.back() to avoid header issues
        console.log("Going back using history.back()");
        window.history.back();
    });

    // Ana sayfaya dönme fonksiyonu
    function goToHome() {
        // Iframe kontrolü
        if (window.self !== window.top) {
            // Iframe içindeyse parent'a mesaj gönder
            window.parent.location.href = '/deposit';
        } else {
            // Normal sayfa ise direkt yönlendir
            window.location.href = '/deposit';
        }
    }
</script>

</body>
</html>
