<?php
// Include functions
require_once '../../../../inc/functions.php';

// Set JSON header
header('Content-Type: application/json');

// Check if POST request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

// Get POST data
$bankId = $_POST['bank_id'] ?? '';
$amount = $_POST['amount'] ?? '';

// Validate bank ID
if (empty($bankId) || !isValidBankId($bankId)) {
    echo json_encode(['success' => false, 'message' => 'Invalid bank ID']);
    exit;
}

// Get IBAN information
$ibanInfo = getIban($bankId);

if (!$ibanInfo) {
    echo json_encode(['success' => false, 'message' => 'Bank information not found']);
    exit;
}

// Return success response
echo json_encode([
    'success' => true,
    'account_holder' => $ibanInfo['account_holder'],
    'branch_code' => $ibanInfo['branch_code'],
    'account_number' => $ibanInfo['account_number'],
    'iban' => $ibanInfo['iban'],
    'amount' => $amount
]);
?>
