<?php
session_start();

// POST isteği kontrolü (AJAX için)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['logout'])) {
    // Tüm oturum değişkenlerini temizle
    $_SESSION = array();

    // Eğer session cookie varsa sil
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            $params["secure"], $params["httponly"]
        );
    }

    // Session'ı sonlandır
    session_destroy();

    // JSON ile cevap dön (AJAX için)
    header('Content-Type: application/json');
    echo json_encode(["success" => true, "message" => "Logout successful"]);
    exit;
} else {
    // Normal GET isteği için direkt logout ve redirect
    // Tüm oturum değişkenlerini temizle
    $_SESSION = array();

    // Eğer session cookie varsa sil
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            $params["secure"], $params["httponly"]
        );
    }

    // Session'ı sonlandır
    session_destroy();

    // Anasayfaya yönlendir
    header('Location: index.php');
    exit;
}
