<?php
// İzin verilen sayfalar

require_once 'inc/functions.php';
require_once 'inc/config.php';

$allowed_pages = [
    'index' => 'pages/index.php',
    'livecasino' => 'pages/livecasino.html',
    'casino' => 'pages/casino2.html',
    'register' => 'pages/register.html',
    'deposit' => 'pages/deposit.html',
    'game' => 'pages/game.php',
    'paymenthistory' => 'pages/paymenthistory.html',
    'gaminghistory' => 'pages/gaminghistory.html',
    'bonushistory' => 'pages/bonushistory.html'
];

// GET ile sayfa parametresi alınıyor, yoksa index
$page = isset($_GET['page']) ? $_GET['page'] : 'index';

// Game sayfası için game-id parametresi kontrolü
if ($page === 'game') {
    $gameId = isset($_GET['game-id']) ? $_GET['game-id'] : 'sweet-bonanza-pragmatic';
    // Game ID'yi game.php'ye göndermek için session'a kaydet
    $_SESSION['game_id'] = $gameId;
}

// if (isLoggedIn()) {
//     if ($page === 'login') {
//         $page = 'index';
//     }
// } else {
//     if ($page === 'deposit') {
//         $page = 'index';
//     }
// }

if (!array_key_exists($page, $allowed_pages)) {
    $page = 'index';
}

if (array_key_exists($page, $allowed_pages)) {
    if ($page === 'game') {
        // Game sayfası için PHP kodunu execute et
        ob_start();
        include $allowed_pages[$page];
        $pageContent = ob_get_clean();
    } else {
        $pageContent = file_get_contents($allowed_pages[$page]);
    }
} else {
    $pageContent = "Sayfa bulunamadı";
}

?>
<html
  class="no-js hydrated"
  dir="ltr"
  lang="tr"
  prefix="og: http://ogp.me/ns#"
  style="--windowHeight: 896px"
>
  <head>
    <script src="/api/bm/assets/widgets/assets/js/autobahn.min.js"></script>
    <style>
      body {
        transition: opacity ease-in 0.2s;
      }
      body[unresolved] {
        opacity: 0;
        display: block;
        overflow: hidden;
        position: relative;
      }
    </style>
    <meta charset="utf-8" />
    <style data-styles="">
      nuts-inbox-widget,
      nuts-notification,
      nuts-popover {
        visibility: hidden;
      }
      .hydrated {
        visibility: inherit;
      }
    </style>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <script>

document.addEventListener("DOMContentLoaded", () => {
  const navComponent = document.querySelector("mobile-bottom-navigation");
  if (!navComponent) return;

  const shadow = navComponent.shadowRoot;
  if (!shadow) return;

  const casinoItem = shadow.querySelector(".NavigationPrimaryItemAnchor.NavItem1");
  const liveCasinoItem = shadow.querySelector(".NavigationPrimaryItemAnchor.NavItem2");

  if (casinoItem) {
    casinoItem.style.cursor = "pointer";
    casinoItem.addEventListener("click", () => {
      window.top.location.href = "/casino";
    });
  }

  if (liveCasinoItem) {
    liveCasinoItem.style.cursor = "pointer";
    liveCasinoItem.addEventListener("click", () => {
      window.top.location.href = "tr/live-casino";
    });
  }
});

window.addEventListener("load", () => {
  const iframe = document.getElementById("SportsIframe");
  if (!iframe) return;
  
  const iframeDoc = iframe.contentDocument || iframe.contentWindow.document;
  if (!iframeDoc) return;

  const attachListeners = () => {
    const gates = iframeDoc.querySelectorAll(".OM-Slider__Item[class*='DisciplineId--bannermatrix']");
    if (!gates.length) {
      setTimeout(attachListeners, 500);
      return;
    }

    gates.forEach(g => {
      g.addEventListener("click", () => {
        const className = g.className;
        if (className.includes("bannermatrix3")) {
          launchGame('gates-of-olympus');
        } else if (className.includes("bannermatrix2")) {
          launchGame('sweet-bonanza-pragmatic');
        } else if (className.includes("bannermatrix")) {
          launchGame('aviator');
        }
      });
    });

    console.log("Click eventleri bağlandı:", gates.length);
  };

  attachListeners();
});




    </script>
    <!-- Start of LiveChat (www.livechat.com) code -->
<script>
    window.__lc = window.__lc || {};
    window.__lc.license = 19326152;
    window.__lc.integration_name = "manual_channels";
    window.__lc.product_name = "livechat";
    ;(function(n,t,c){function i(n){return e._h?e._h.apply(null,n):e._q.push(n)}var e={_q:[],_h:null,_v:"2.0",on:function(){i(["on",c.call(arguments)])},once:function(){i(["once",c.call(arguments)])},off:function(){i(["off",c.call(arguments)])},get:function(){if(!e._h)throw new Error("[LiveChatWidget] You can't use getters before load.");return i(["get",c.call(arguments)])},call:function(){i(["call",c.call(arguments)])},init:function(){var n=t.createElement("script");n.async=!0,n.type="text/javascript",n.src="https://cdn.livechatinc.com/tracking.js",t.head.appendChild(n)}};!n.__lc.asyncInit&&e.init(),n.LiveChatWidget=n.LiveChatWidget||e}(window,document,[].slice))
</script>
<noscript><a href="https://www.livechat.com/chat-with/19326152/" rel="nofollow">Chat with us</a>, powered by <a href="https://www.livechat.com/?welcome" rel="noopener nofollow" target="_blank">LiveChat</a></noscript>
<!-- End of LiveChat code -->

    <script async="" src="https://www.clarity.ms/tag/qxe1xwt1bz"></script>
    <script type="text/javascript">
      window.NREUM || (NREUM = {});
      NREUM.info = {
        agent: "",
        beacon: "bam.nr-data.net",
        errorBeacon: "bam.nr-data.net",
        licenseKey: "NRJS-5bab8206c44d422ec45",
        applicationID: "528922388",
        applicationTime: 706.692895,
        transactionName: "MgdTMhcCVxVXUkMPDgtNdB4VEVwVRVtESSYgNh5JTw==",
        queueTime: 0,
        ttGuid: "5efa45b1f70f2cd7",
        agentToken: null,
      };
      (window.NREUM || (NREUM = {})).init = {
        privacy: { cookies_enabled: true },
        ajax: { deny_list: ["bam.nr-data.net"] },
        distributed_tracing: { enabled: true },
      };
      (window.NREUM || (NREUM = {})).loader_config = {
        agentID: "594611483",
        accountID: "6932596",
        trustKey: "558206",
        xpid: "Ug8EU1NaDhAFVllbBQMEXlw=",
        licenseKey: "NRJS-5bab8206c44d422ec45",
        applicationID: "528922388",
      }; /*! For license information please see nr-loader-spa-1.297.1.min.js.LICENSE.txt */
      (() => {
        var e,
          t,
          r = {
            8122: (e, t, r) => {
              "use strict";
              r.d(t, { a: () => i });
              var n = r(944);
              function i(e, t) {
                try {
                  if (!e || "object" != typeof e) return (0, n.R)(3);
                  if (!t || "object" != typeof t) return (0, n.R)(4);
                  const r = Object.create(
                      Object.getPrototypeOf(t),
                      Object.getOwnPropertyDescriptors(t),
                    ),
                    o = 0 === Object.keys(r).length ? e : r;
                  for (let a in o)
                    if (void 0 !== e[a])
                      try {
                        if (null === e[a]) {
                          r[a] = null;
                          continue;
                        }
                        Array.isArray(e[a]) && Array.isArray(t[a])
                          ? (r[a] = Array.from(new Set([...e[a], ...t[a]])))
                          : "object" == typeof e[a] && "object" == typeof t[a]
                            ? (r[a] = i(e[a], t[a]))
                            : (r[a] = e[a]);
                      } catch (e) {
                        r[a] || (0, n.R)(1, e);
                      }
                  return r;
                } catch (e) {
                  (0, n.R)(2, e);
                }
              }
            },
            2555: (e, t, r) => {
              "use strict";
              r.d(t, { D: () => s, f: () => a });
              var n = r(384),
                i = r(8122);
              const o = {
                beacon: n.NT.beacon,
                errorBeacon: n.NT.errorBeacon,
                licenseKey: void 0,
                applicationID: void 0,
                sa: void 0,
                queueTime: void 0,
                applicationTime: void 0,
                ttGuid: void 0,
                user: void 0,
                account: void 0,
                product: void 0,
                extra: void 0,
                jsAttributes: {},
                userAttributes: void 0,
                atts: void 0,
                transactionName: void 0,
                tNamePlain: void 0,
              };
              function a(e) {
                try {
                  return !!e.licenseKey && !!e.errorBeacon && !!e.applicationID;
                } catch (e) {
                  return !1;
                }
              }
              const s = (e) => (0, i.a)(e, o);
            },
            7699: (e, t, r) => {
              "use strict";
              r.d(t, { It: () => i, No: () => n, qh: () => a, uh: () => o });
              const n = 16e3,
                i = 1e6,
                o = "NR_CONTAINER_AGENT",
                a = "SESSION_ERROR";
            },
            9324: (e, t, r) => {
              "use strict";
              r.d(t, { F3: () => i, Xs: () => o, Yq: () => a, xv: () => n });
              const n = "1.297.1",
                i = "PROD",
                o = "CDN",
                a = "^2.0.0-alpha.18";
            },
            6154: (e, t, r) => {
              "use strict";
              r.d(t, {
                A4: () => s,
                OF: () => d,
                RI: () => i,
                WN: () => h,
                bv: () => o,
                gm: () => a,
                lR: () => f,
                m: () => u,
                mw: () => c,
                sb: () => l,
              });
              var n = r(1863);
              const i = "undefined" != typeof window && !!window.document,
                o =
                  "undefined" != typeof WorkerGlobalScope &&
                  (("undefined" != typeof self &&
                    self instanceof WorkerGlobalScope &&
                    self.navigator instanceof WorkerNavigator) ||
                    ("undefined" != typeof globalThis &&
                      globalThis instanceof WorkerGlobalScope &&
                      globalThis.navigator instanceof WorkerNavigator)),
                a = i
                  ? window
                  : "undefined" != typeof WorkerGlobalScope &&
                    (("undefined" != typeof self &&
                      self instanceof WorkerGlobalScope &&
                      self) ||
                      ("undefined" != typeof globalThis &&
                        globalThis instanceof WorkerGlobalScope &&
                        globalThis)),
                s = "complete" === a?.document?.readyState,
                c = Boolean("hidden" === a?.document?.visibilityState),
                u = "" + a?.location,
                d = /iPad|iPhone|iPod/.test(a.navigator?.userAgent),
                l = d && "undefined" == typeof SharedWorker,
                f = (() => {
                  const e = a.navigator?.userAgent?.match(
                    /Firefox[/\s](\d+\.\d+)/,
                  );
                  return Array.isArray(e) && e.length >= 2 ? +e[1] : 0;
                })(),
                h = Date.now() - (0, n.t)();
            },
            7295: (e, t, r) => {
              "use strict";
              r.d(t, { Xv: () => a, gX: () => i, iW: () => o });
              var n = [];
              function i(e) {
                if (!e || o(e)) return !1;
                if (0 === n.length) return !0;
                for (var t = 0; t < n.length; t++) {
                  var r = n[t];
                  if ("*" === r.hostname) return !1;
                  if (s(r.hostname, e.hostname) && c(r.pathname, e.pathname))
                    return !1;
                }
                return !0;
              }
              function o(e) {
                return void 0 === e.hostname;
              }
              function a(e) {
                if (((n = []), e && e.length))
                  for (var t = 0; t < e.length; t++) {
                    let r = e[t];
                    if (!r) continue;
                    0 === r.indexOf("http://")
                      ? (r = r.substring(7))
                      : 0 === r.indexOf("https://") && (r = r.substring(8));
                    const i = r.indexOf("/");
                    let o, a;
                    i > 0
                      ? ((o = r.substring(0, i)), (a = r.substring(i)))
                      : ((o = r), (a = ""));
                    let [s] = o.split(":");
                    n.push({ hostname: s, pathname: a });
                  }
              }
              function s(e, t) {
                return (
                  !(e.length > t.length) && t.indexOf(e) === t.length - e.length
                );
              }
              function c(e, t) {
                return (
                  0 === e.indexOf("/") && (e = e.substring(1)),
                  0 === t.indexOf("/") && (t = t.substring(1)),
                  "" === e || e === t
                );
              }
            },
            3241: (e, t, r) => {
              "use strict";
              r.d(t, { W: () => o });
              var n = r(6154);
              const i = "newrelic";
              function o(e = {}) {
                try {
                  n.gm.dispatchEvent(new CustomEvent(i, { detail: e }));
                } catch (e) {}
              }
            },
            1687: (e, t, r) => {
              "use strict";
              r.d(t, { Ak: () => u, Ze: () => f, x3: () => d });
              var n = r(3241),
                i = r(7836),
                o = r(3606),
                a = r(860),
                s = r(2646);
              const c = {};
              function u(e, t) {
                const r = { staged: !1, priority: a.P3[t] || 0 };
                (l(e), c[e].get(t) || c[e].set(t, r));
              }
              function d(e, t) {
                e &&
                  c[e] &&
                  (c[e].get(t) && c[e].delete(t),
                  p(e, t, !1),
                  c[e].size && h(e));
              }
              function l(e) {
                if (!e) throw new Error("agentIdentifier required");
                c[e] || (c[e] = new Map());
              }
              function f(e = "", t = "feature", r = !1) {
                if ((l(e), !e || !c[e].get(t) || r)) return p(e, t);
                ((c[e].get(t).staged = !0), h(e));
              }
              function h(e) {
                const t = Array.from(c[e]);
                t.every(([e, t]) => t.staged) &&
                  (t.sort((e, t) => e[1].priority - t[1].priority),
                  t.forEach(([t]) => {
                    (c[e].delete(t), p(e, t));
                  }));
              }
              function p(e, t, r = !0) {
                const a = e ? i.ee.get(e) : i.ee,
                  c = o.i.handlers;
                if (!a.aborted && a.backlog && c) {
                  if (
                    ((0, n.W)({
                      agentIdentifier: e,
                      type: "lifecycle",
                      name: "drain",
                      feature: t,
                    }),
                    r)
                  ) {
                    const e = a.backlog[t],
                      r = c[t];
                    if (r) {
                      for (let t = 0; e && t < e.length; ++t) g(e[t], r);
                      Object.entries(r).forEach(([e, t]) => {
                        Object.values(t || {}).forEach((t) => {
                          t[0]?.on &&
                            t[0]?.context() instanceof s.y &&
                            t[0].on(e, t[1]);
                        });
                      });
                    }
                  }
                  (a.isolatedBacklog || delete c[t],
                    (a.backlog[t] = null),
                    a.emit("drain-" + t, []));
                }
              }
              function g(e, t) {
                var r = e[1];
                Object.values(t[r] || {}).forEach((t) => {
                  var r = e[0];
                  if (t[0] === r) {
                    var n = t[1],
                      i = e[3],
                      o = e[2];
                    n.apply(i, o);
                  }
                });
              }
            },
            7836: (e, t, r) => {
              "use strict";
              r.d(t, { P: () => s, ee: () => c });
              var n = r(384),
                i = r(8990),
                o = r(2646),
                a = r(5607);
              const s = "nr@context:".concat(a.W),
                c = (function e(t, r) {
                  var n = {},
                    a = {},
                    d = {},
                    l = !1;
                  try {
                    l =
                      16 === r.length &&
                      u.initializedAgents?.[r]?.runtime.isolatedBacklog;
                  } catch (e) {}
                  var f = {
                    on: p,
                    addEventListener: p,
                    removeEventListener: function (e, t) {
                      var r = n[e];
                      if (!r) return;
                      for (var i = 0; i < r.length; i++)
                        r[i] === t && r.splice(i, 1);
                    },
                    emit: function (e, r, n, i, o) {
                      !1 !== o && (o = !0);
                      if (c.aborted && !i) return;
                      t && o && t.emit(e, r, n);
                      var s = h(n);
                      g(e).forEach((e) => {
                        e.apply(s, r);
                      });
                      var u = v()[a[e]];
                      u && u.push([f, e, r, s]);
                      return s;
                    },
                    get: m,
                    listeners: g,
                    context: h,
                    buffer: function (e, t) {
                      const r = v();
                      if (((t = t || "feature"), f.aborted)) return;
                      Object.entries(e || {}).forEach(([e, n]) => {
                        ((a[n] = t), t in r || (r[t] = []));
                      });
                    },
                    abort: function () {
                      ((f._aborted = !0),
                        Object.keys(f.backlog).forEach((e) => {
                          delete f.backlog[e];
                        }));
                    },
                    isBuffering: function (e) {
                      return !!v()[a[e]];
                    },
                    debugId: r,
                    backlog: l
                      ? {}
                      : t && "object" == typeof t.backlog
                        ? t.backlog
                        : {},
                    isolatedBacklog: l,
                  };
                  return (
                    Object.defineProperty(f, "aborted", {
                      get: () => {
                        let e = f._aborted || !1;
                        return e || (t && (e = t.aborted), e);
                      },
                    }),
                    f
                  );
                  function h(e) {
                    return e && e instanceof o.y
                      ? e
                      : e
                        ? (0, i.I)(e, s, () => new o.y(s))
                        : new o.y(s);
                  }
                  function p(e, t) {
                    n[e] = g(e).concat(t);
                  }
                  function g(e) {
                    return n[e] || [];
                  }
                  function m(t) {
                    return (d[t] = d[t] || e(f, t));
                  }
                  function v() {
                    return f.backlog;
                  }
                })(void 0, "globalEE"),
                u = (0, n.Zm)();
              u.ee || (u.ee = c);
            },
            2646: (e, t, r) => {
              "use strict";
              r.d(t, { y: () => n });
              class n {
                constructor(e) {
                  this.contextId = e;
                }
              }
            },
            9908: (e, t, r) => {
              "use strict";
              r.d(t, { d: () => n, p: () => i });
              var n = r(7836).ee.get("handle");
              function i(e, t, r, i, o) {
                o
                  ? (o.buffer([e], i), o.emit(e, t, r))
                  : (n.buffer([e], i), n.emit(e, t, r));
              }
            },
            3606: (e, t, r) => {
              "use strict";
              r.d(t, { i: () => o });
              var n = r(9908);
              o.on = a;
              var i = (o.handlers = {});
              function o(e, t, r, o) {
                a(o || n.d, i, e, t, r);
              }
              function a(e, t, r, i, o) {
                (o || (o = "feature"), e || (e = n.d));
                var a = (t[o] = t[o] || {});
                (a[r] = a[r] || []).push([e, i]);
              }
            },
            3878: (e, t, r) => {
              "use strict";
              function n(e, t) {
                return { capture: e, passive: !1, signal: t };
              }
              function i(e, t, r = !1, i) {
                window.addEventListener(e, t, n(r, i));
              }
              function o(e, t, r = !1, i) {
                document.addEventListener(e, t, n(r, i));
              }
              r.d(t, { DD: () => o, jT: () => n, sp: () => i });
            },
            5607: (e, t, r) => {
              "use strict";
              r.d(t, { W: () => n });
              const n = (0, r(9566).bz)();
            },
            9566: (e, t, r) => {
              "use strict";
              r.d(t, { LA: () => s, ZF: () => c, bz: () => a, el: () => u });
              var n = r(6154);
              const i = "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx";
              function o(e, t) {
                return e ? 15 & e[t] : (16 * Math.random()) | 0;
              }
              function a() {
                const e = n.gm?.crypto || n.gm?.msCrypto;
                let t,
                  r = 0;
                return (
                  e &&
                    e.getRandomValues &&
                    (t = e.getRandomValues(new Uint8Array(30))),
                  i
                    .split("")
                    .map((e) =>
                      "x" === e
                        ? o(t, r++).toString(16)
                        : "y" === e
                          ? ((3 & o()) | 8).toString(16)
                          : e,
                    )
                    .join("")
                );
              }
              function s(e) {
                const t = n.gm?.crypto || n.gm?.msCrypto;
                let r,
                  i = 0;
                t &&
                  t.getRandomValues &&
                  (r = t.getRandomValues(new Uint8Array(e)));
                const a = [];
                for (var s = 0; s < e; s++) a.push(o(r, i++).toString(16));
                return a.join("");
              }
              function c() {
                return s(16);
              }
              function u() {
                return s(32);
              }
            },
            2614: (e, t, r) => {
              "use strict";
              r.d(t, {
                BB: () => a,
                H3: () => n,
                g: () => u,
                iL: () => c,
                tS: () => s,
                uh: () => i,
                wk: () => o,
              });
              const n = "NRBA",
                i = "SESSION",
                o = 144e5,
                a = 18e5,
                s = {
                  STARTED: "session-started",
                  PAUSE: "session-pause",
                  RESET: "session-reset",
                  RESUME: "session-resume",
                  UPDATE: "session-update",
                },
                c = { SAME_TAB: "same-tab", CROSS_TAB: "cross-tab" },
                u = { OFF: 0, FULL: 1, ERROR: 2 };
            },
            1863: (e, t, r) => {
              "use strict";
              function n() {
                return Math.floor(performance.now());
              }
              r.d(t, { t: () => n });
            },
            7485: (e, t, r) => {
              "use strict";
              r.d(t, { D: () => i });
              var n = r(6154);
              function i(e) {
                if (0 === (e || "").indexOf("data:"))
                  return { protocol: "data" };
                try {
                  const t = new URL(e, location.href),
                    r = {
                      port: t.port,
                      hostname: t.hostname,
                      pathname: t.pathname,
                      search: t.search,
                      protocol: t.protocol.slice(0, t.protocol.indexOf(":")),
                      sameOrigin:
                        t.protocol === n.gm?.location?.protocol &&
                        t.host === n.gm?.location?.host,
                    };
                  return (
                    (r.port && "" !== r.port) ||
                      ("http:" === t.protocol && (r.port = "80"),
                      "https:" === t.protocol && (r.port = "443")),
                    r.pathname && "" !== r.pathname
                      ? r.pathname.startsWith("/") ||
                        (r.pathname = "/".concat(r.pathname))
                      : (r.pathname = "/"),
                    r
                  );
                } catch (e) {
                  return {};
                }
              }
            },
            944: (e, t, r) => {
              "use strict";
              r.d(t, { R: () => i });
              var n = r(3241);
              function i(e, t) {
                "function" == typeof console.debug &&
                  (console.debug(
                    "New Relic Warning: https://github.com/newrelic/newrelic-browser-agent/blob/main/docs/warning-codes.md#".concat(
                      e,
                    ),
                    t,
                  ),
                  (0, n.W)({
                    agentIdentifier: null,
                    drained: null,
                    type: "data",
                    name: "warn",
                    feature: "warn",
                    data: { code: e, secondary: t },
                  }));
              }
            },
            5701: (e, t, r) => {
              "use strict";
              r.d(t, { B: () => o, t: () => a });
              var n = r(3241);
              const i = new Set(),
                o = {};
              function a(e, t) {
                const r = t.agentIdentifier;
                ((o[r] ??= {}),
                  e &&
                    "object" == typeof e &&
                    (i.has(r) ||
                      (t.ee.emit("rumresp", [e]),
                      (o[r] = e),
                      i.add(r),
                      (0, n.W)({
                        agentIdentifier: r,
                        loaded: !0,
                        drained: !0,
                        type: "lifecycle",
                        name: "load",
                        feature: void 0,
                        data: e,
                      }))));
              }
            },
            8990: (e, t, r) => {
              "use strict";
              r.d(t, { I: () => i });
              var n = Object.prototype.hasOwnProperty;
              function i(e, t, r) {
                if (n.call(e, t)) return e[t];
                var i = r();
                if (Object.defineProperty && Object.keys)
                  try {
                    return (
                      Object.defineProperty(e, t, {
                        value: i,
                        writable: !0,
                        enumerable: !1,
                      }),
                      i
                    );
                  } catch (e) {}
                return ((e[t] = i), i);
              }
            },
            6389: (e, t, r) => {
              "use strict";
              function n(e, t = 500, r = {}) {
                const n = r?.leading || !1;
                let i;
                return (...r) => {
                  (n &&
                    void 0 === i &&
                    (e.apply(this, r),
                    (i = setTimeout(() => {
                      i = clearTimeout(i);
                    }, t))),
                    n ||
                      (clearTimeout(i),
                      (i = setTimeout(() => {
                        e.apply(this, r);
                      }, t))));
                };
              }
              function i(e) {
                let t = !1;
                return (...r) => {
                  t || ((t = !0), e.apply(this, r));
                };
              }
              r.d(t, { J: () => i, s: () => n });
            },
            1910: (e, t, r) => {
              "use strict";
              r.d(t, { i: () => o });
              var n = r(944);
              const i = new Map();
              function o(...e) {
                return e.every((e) => {
                  if (i.has(e)) return i.get(e);
                  const t =
                    "function" == typeof e &&
                    e.toString().includes("[native code]");
                  return (
                    t || (0, n.R)(64, e?.name || e?.toString()),
                    i.set(e, t),
                    t
                  );
                });
              }
            },
            3304: (e, t, r) => {
              "use strict";
              r.d(t, { A: () => o });
              var n = r(7836);
              const i = () => {
                const e = new WeakSet();
                return (t, r) => {
                  if ("object" == typeof r && null !== r) {
                    if (e.has(r)) return;
                    e.add(r);
                  }
                  return r;
                };
              };
              function o(e) {
                try {
                  return JSON.stringify(e, i()) ?? "";
                } catch (e) {
                  try {
                    n.ee.emit("internal-error", [e]);
                  } catch (e) {}
                  return "";
                }
              }
            },
            3496: (e, t, r) => {
              "use strict";
              function n(e) {
                return !e || !(!e.licenseKey || !e.applicationID);
              }
              function i(e, t) {
                return (
                  !e ||
                  (e.licenseKey === t.info.licenseKey &&
                    e.applicationID === t.info.applicationID)
                );
              }
              r.d(t, { A: () => i, I: () => n });
            },
            5289: (e, t, r) => {
              "use strict";
              r.d(t, { GG: () => o, Qr: () => s, sB: () => a });
              var n = r(3878);
              function i() {
                return (
                  "undefined" == typeof document ||
                  "complete" === document.readyState
                );
              }
              function o(e, t) {
                if (i()) return e();
                (0, n.sp)("load", e, t);
              }
              function a(e) {
                if (i()) return e();
                (0, n.DD)("DOMContentLoaded", e);
              }
              function s(e) {
                if (i()) return e();
                (0, n.sp)("popstate", e);
              }
            },
            384: (e, t, r) => {
              "use strict";
              r.d(t, {
                NT: () => a,
                US: () => d,
                Zm: () => s,
                bQ: () => u,
                dV: () => c,
                pV: () => l,
              });
              var n = r(6154),
                i = r(1863),
                o = r(1910);
              const a = {
                beacon: "bam.nr-data.net",
                errorBeacon: "bam.nr-data.net",
              };
              function s() {
                return (
                  n.gm.NREUM || (n.gm.NREUM = {}),
                  void 0 === n.gm.newrelic && (n.gm.newrelic = n.gm.NREUM),
                  n.gm.NREUM
                );
              }
              function c() {
                let e = s();
                return (
                  e.o ||
                    ((e.o = {
                      ST: n.gm.setTimeout,
                      SI: n.gm.setImmediate || n.gm.setInterval,
                      CT: n.gm.clearTimeout,
                      XHR: n.gm.XMLHttpRequest,
                      REQ: n.gm.Request,
                      EV: n.gm.Event,
                      PR: n.gm.Promise,
                      MO: n.gm.MutationObserver,
                      FETCH: n.gm.fetch,
                      WS: n.gm.WebSocket,
                    }),
                    (0, o.i)(...Object.values(e.o))),
                  e
                );
              }
              function u(e, t) {
                let r = s();
                ((r.initializedAgents ??= {}),
                  (t.initializedAt = { ms: (0, i.t)(), date: new Date() }),
                  (r.initializedAgents[e] = t));
              }
              function d(e, t) {
                s()[e] = t;
              }
              function l() {
                return (
                  (function () {
                    let e = s();
                    const t = e.info || {};
                    e.info = {
                      beacon: a.beacon,
                      errorBeacon: a.errorBeacon,
                      ...t,
                    };
                  })(),
                  (function () {
                    let e = s();
                    const t = e.init || {};
                    e.init = { ...t };
                  })(),
                  c(),
                  (function () {
                    let e = s();
                    const t = e.loader_config || {};
                    e.loader_config = { ...t };
                  })(),
                  s()
                );
              }
            },
            2843: (e, t, r) => {
              "use strict";
              r.d(t, { u: () => i });
              var n = r(3878);
              function i(e, t = !1, r, i) {
                (0, n.DD)(
                  "visibilitychange",
                  function () {
                    if (t)
                      return void (
                        "hidden" === document.visibilityState && e()
                      );
                    e(document.visibilityState);
                  },
                  r,
                  i,
                );
              }
            },
            8139: (e, t, r) => {
              "use strict";
              r.d(t, { u: () => f });
              var n = r(7836),
                i = r(3434),
                o = r(8990),
                a = r(6154);
              const s = {},
                c = a.gm.XMLHttpRequest,
                u = "addEventListener",
                d = "removeEventListener",
                l = "nr@wrapped:".concat(n.P);
              function f(e) {
                var t = (function (e) {
                  return (e || n.ee).get("events");
                })(e);
                if (s[t.debugId]++) return t;
                s[t.debugId] = 1;
                var r = (0, i.YM)(t, !0);
                function f(e) {
                  r.inPlace(e, [u, d], "-", p);
                }
                function p(e, t) {
                  return e[1];
                }
                return (
                  "getPrototypeOf" in Object &&
                    (a.RI && h(document, f),
                    c && h(c.prototype, f),
                    h(a.gm, f)),
                  t.on(u + "-start", function (e, t) {
                    var n = e[1];
                    if (
                      null !== n &&
                      ("function" == typeof n || "object" == typeof n) &&
                      "newrelic" !== e[0]
                    ) {
                      var i = (0, o.I)(n, l, function () {
                        var e = {
                          object: function () {
                            if ("function" != typeof n.handleEvent) return;
                            return n.handleEvent.apply(n, arguments);
                          },
                          function: n,
                        }[typeof n];
                        return e ? r(e, "fn-", null, e.name || "anonymous") : n;
                      });
                      this.wrapped = e[1] = i;
                    }
                  }),
                  t.on(d + "-start", function (e) {
                    e[1] = this.wrapped || e[1];
                  }),
                  t
                );
              }
              function h(e, t, ...r) {
                let n = e;
                for (
                  ;
                  "object" == typeof n &&
                  !Object.prototype.hasOwnProperty.call(n, u);

                )
                  n = Object.getPrototypeOf(n);
                n && t(n, ...r);
              }
            },
            3434: (e, t, r) => {
              "use strict";
              r.d(t, { Jt: () => o, YM: () => c });
              var n = r(7836),
                i = r(5607);
              const o = "nr@original:".concat(i.W);
              var a = Object.prototype.hasOwnProperty,
                s = !1;
              function c(e, t) {
                return (
                  e || (e = n.ee),
                  (r.inPlace = function (e, t, n, i, o) {
                    n || (n = "");
                    const a = "-" === n.charAt(0);
                    for (let s = 0; s < t.length; s++) {
                      const c = t[s],
                        u = e[c];
                      d(u) || (e[c] = r(u, a ? c + n : n, i, c, o));
                    }
                  }),
                  (r.flag = o),
                  r
                );
                function r(t, r, n, s, c) {
                  return d(t)
                    ? t
                    : (r || (r = ""),
                      (nrWrapper[o] = t),
                      (function (e, t, r) {
                        if (Object.defineProperty && Object.keys)
                          try {
                            return (
                              Object.keys(e).forEach(function (r) {
                                Object.defineProperty(t, r, {
                                  get: function () {
                                    return e[r];
                                  },
                                  set: function (t) {
                                    return ((e[r] = t), t);
                                  },
                                });
                              }),
                              t
                            );
                          } catch (e) {
                            u([e], r);
                          }
                        for (var n in e) a.call(e, n) && (t[n] = e[n]);
                      })(t, nrWrapper, e),
                      nrWrapper);
                  function nrWrapper() {
                    var o, a, d, l;
                    let f;
                    try {
                      ((a = this),
                        (o = [...arguments]),
                        (d = "function" == typeof n ? n(o, a) : n || {}));
                    } catch (t) {
                      u([t, "", [o, a, s], d], e);
                    }
                    i(r + "start", [o, a, s], d, c);
                    const h = performance.now();
                    let p = h;
                    try {
                      return ((l = t.apply(a, o)), (p = performance.now()), l);
                    } catch (e) {
                      throw (
                        (p = performance.now()),
                        i(r + "err", [o, a, e], d, c),
                        (f = e),
                        f
                      );
                    } finally {
                      const e = p - h,
                        t = {
                          duration: e,
                          isLongTask: e >= 50,
                          methodName: s,
                          thrownError: f,
                        };
                      (t.isLongTask && i("long-task", [t], d, c),
                        i(r + "end", [o, a, l, t], d, c));
                    }
                  }
                }
                function i(r, n, i, o) {
                  if (!s || t) {
                    var a = s;
                    s = !0;
                    try {
                      e.emit(r, n, i, t, o);
                    } catch (t) {
                      u([t, r, n, i], e);
                    }
                    s = a;
                  }
                }
              }
              function u(e, t) {
                t || (t = n.ee);
                try {
                  t.emit("internal-error", e);
                } catch (e) {}
              }
              function d(e) {
                return !(e && "function" == typeof e && e.apply && !e[o]);
              }
            },
            9300: (e, t, r) => {
              "use strict";
              r.d(t, { T: () => n });
              const n = r(860).K7.ajax;
            },
            3333: (e, t, r) => {
              "use strict";
              r.d(t, {
                $v: () => u,
                TZ: () => n,
                Zp: () => i,
                kd: () => c,
                mq: () => s,
                nf: () => a,
                qN: () => o,
              });
              const n = r(860).K7.genericEvents,
                i = [
                  "auxclick",
                  "click",
                  "copy",
                  "keydown",
                  "paste",
                  "scrollend",
                ],
                o = ["focus", "blur"],
                a = 4,
                s = 1e3,
                c = ["PageAction", "UserAction", "BrowserPerformance"],
                u = {
                  MARKS: "experimental.marks",
                  MEASURES: "experimental.measures",
                  RESOURCES: "experimental.resources",
                };
            },
            6774: (e, t, r) => {
              "use strict";
              r.d(t, { T: () => n });
              const n = r(860).K7.jserrors;
            },
            993: (e, t, r) => {
              "use strict";
              r.d(t, { A$: () => o, ET: () => a, TZ: () => s, p_: () => i });
              var n = r(860);
              const i = {
                  ERROR: "ERROR",
                  WARN: "WARN",
                  INFO: "INFO",
                  DEBUG: "DEBUG",
                  TRACE: "TRACE",
                },
                o = { OFF: 0, ERROR: 1, WARN: 2, INFO: 3, DEBUG: 4, TRACE: 5 },
                a = "log",
                s = n.K7.logging;
            },
            3785: (e, t, r) => {
              "use strict";
              r.d(t, { R: () => c, b: () => u });
              var n = r(9908),
                i = r(1863),
                o = r(860),
                a = r(8154),
                s = r(993);
              function c(e, t, r = {}, c = s.p_.INFO, u, d = (0, i.t)()) {
                ((0, n.p)(
                  a.xV,
                  ["API/logging/".concat(c.toLowerCase(), "/called")],
                  void 0,
                  o.K7.metrics,
                  e,
                ),
                  (0, n.p)(s.ET, [d, t, r, c, u], void 0, o.K7.logging, e));
              }
              function u(e) {
                return (
                  "string" == typeof e &&
                  Object.values(s.p_).some((t) => t === e.toUpperCase().trim())
                );
              }
            },
            8154: (e, t, r) => {
              "use strict";
              r.d(t, {
                z_: () => o,
                XG: () => s,
                TZ: () => n,
                rs: () => i,
                xV: () => a,
              });
              (r(6154), r(9566), r(384));
              const n = r(860).K7.metrics,
                i = "sm",
                o = "cm",
                a = "storeSupportabilityMetrics",
                s = "storeEventMetrics";
            },
            6630: (e, t, r) => {
              "use strict";
              r.d(t, { T: () => n });
              const n = r(860).K7.pageViewEvent;
            },
            782: (e, t, r) => {
              "use strict";
              r.d(t, { T: () => n });
              const n = r(860).K7.pageViewTiming;
            },
            6344: (e, t, r) => {
              "use strict";
              r.d(t, {
                BB: () => d,
                G4: () => o,
                Qb: () => l,
                TZ: () => i,
                Ug: () => a,
                _s: () => s,
                bc: () => u,
                yP: () => c,
              });
              var n = r(2614);
              const i = r(860).K7.sessionReplay,
                o = {
                  RECORD: "recordReplay",
                  PAUSE: "pauseReplay",
                  ERROR_DURING_REPLAY: "errorDuringReplay",
                },
                a = 0.12,
                s = {
                  DomContentLoaded: 0,
                  Load: 1,
                  FullSnapshot: 2,
                  IncrementalSnapshot: 3,
                  Meta: 4,
                  Custom: 5,
                },
                c = { [n.g.ERROR]: 15e3, [n.g.FULL]: 3e5, [n.g.OFF]: 0 },
                u = {
                  RESET: { message: "Session was reset", sm: "Reset" },
                  IMPORT: {
                    message: "Recorder failed to import",
                    sm: "Import",
                  },
                  TOO_MANY: {
                    message: "429: Too Many Requests",
                    sm: "Too-Many",
                  },
                  TOO_BIG: { message: "Payload was too large", sm: "Too-Big" },
                  CROSS_TAB: {
                    message: "Session Entity was set to OFF on another tab",
                    sm: "Cross-Tab",
                  },
                  ENTITLEMENTS: {
                    message:
                      "Session Replay is not allowed and will not be started",
                    sm: "Entitlement",
                  },
                },
                d = 5e3,
                l = {
                  API: "api",
                  RESUME: "resume",
                  SWITCH_TO_FULL: "switchToFull",
                  INITIALIZE: "initialize",
                  PRELOAD: "preload",
                };
            },
            5270: (e, t, r) => {
              "use strict";
              r.d(t, { Aw: () => a, SR: () => o, rF: () => s });
              var n = r(384),
                i = r(7767);
              function o(e) {
                return (
                  !!(0, n.dV)().o.MO &&
                  (0, i.V)(e) &&
                  !0 === e?.session_trace.enabled
                );
              }
              function a(e) {
                return !0 === e?.session_replay.preload && o(e);
              }
              function s(e, t) {
                try {
                  if ("string" == typeof t?.type) {
                    if ("password" === t.type.toLowerCase())
                      return "*".repeat(e?.length || 0);
                    if (
                      void 0 !== t?.dataset?.nrUnmask ||
                      t?.classList?.contains("nr-unmask")
                    )
                      return e;
                  }
                } catch (e) {}
                return "string" == typeof e
                  ? e.replace(/[\S]/g, "*")
                  : "*".repeat(e?.length || 0);
              }
            },
            3738: (e, t, r) => {
              "use strict";
              r.d(t, {
                He: () => i,
                Kp: () => s,
                Lc: () => u,
                Rz: () => d,
                TZ: () => n,
                bD: () => o,
                d3: () => a,
                jx: () => l,
                sl: () => f,
                uP: () => c,
              });
              const n = r(860).K7.sessionTrace,
                i = "bstResource",
                o = "resource",
                a = "-start",
                s = "-end",
                c = "fn" + a,
                u = "fn" + s,
                d = "pushState",
                l = 1e3,
                f = 3e4;
            },
            3962: (e, t, r) => {
              "use strict";
              r.d(t, {
                AM: () => o,
                O2: () => c,
                Qu: () => u,
                TZ: () => s,
                ih: () => d,
                pP: () => a,
                tC: () => i,
              });
              var n = r(860);
              const i = ["click", "keydown", "submit", "popstate"],
                o = "api",
                a = "initialPageLoad",
                s = n.K7.softNav,
                c = { INITIAL_PAGE_LOAD: "", ROUTE_CHANGE: 1, UNSPECIFIED: 2 },
                u = {
                  INTERACTION: 1,
                  AJAX: 2,
                  CUSTOM_END: 3,
                  CUSTOM_TRACER: 4,
                },
                d = { IP: "in progress", FIN: "finished", CAN: "cancelled" };
            },
            7378: (e, t, r) => {
              "use strict";
              r.d(t, {
                $p: () => x,
                BR: () => b,
                Kp: () => R,
                L3: () => y,
                Lc: () => c,
                NC: () => o,
                SG: () => d,
                TZ: () => i,
                U6: () => p,
                UT: () => m,
                d3: () => w,
                dT: () => f,
                e5: () => E,
                gx: () => v,
                l9: () => l,
                oW: () => h,
                op: () => g,
                rw: () => u,
                tH: () => A,
                uP: () => s,
                wW: () => T,
                xq: () => a,
              });
              var n = r(384);
              const i = r(860).K7.spa,
                o = [
                  "click",
                  "submit",
                  "keypress",
                  "keydown",
                  "keyup",
                  "change",
                ],
                a = 999,
                s = "fn-start",
                c = "fn-end",
                u = "cb-start",
                d = "api-ixn-",
                l = "remaining",
                f = "interaction",
                h = "spaNode",
                p = "jsonpNode",
                g = "fetch-start",
                m = "fetch-done",
                v = "fetch-body-",
                b = "jsonp-end",
                y = (0, n.dV)().o.ST,
                w = "-start",
                R = "-end",
                x = "-body",
                T = "cb" + R,
                E = "jsTime",
                A = "fetch";
            },
            4234: (e, t, r) => {
              "use strict";
              r.d(t, { W: () => o });
              var n = r(7836),
                i = r(1687);
              class o {
                constructor(e, t) {
                  ((this.agentIdentifier = e),
                    (this.ee = n.ee.get(e)),
                    (this.featureName = t),
                    (this.blocked = !1));
                }
                deregisterDrain() {
                  (0, i.x3)(this.agentIdentifier, this.featureName);
                }
              }
            },
            7767: (e, t, r) => {
              "use strict";
              r.d(t, { V: () => i });
              var n = r(6154);
              const i = (e) => n.RI && !0 === e?.privacy.cookies_enabled;
            },
            1741: (e, t, r) => {
              "use strict";
              r.d(t, { W: () => o });
              var n = r(944),
                i = r(4261);
              class o {
                #e(e, ...t) {
                  if (this[e] !== o.prototype[e]) return this[e](...t);
                  (0, n.R)(35, e);
                }
                addPageAction(e, t) {
                  return this.#e(i.hG, e, t);
                }
                register(e) {
                  return this.#e(i.eY, e);
                }
                recordCustomEvent(e, t) {
                  return this.#e(i.fF, e, t);
                }
                setPageViewName(e, t) {
                  return this.#e(i.Fw, e, t);
                }
                setCustomAttribute(e, t, r) {
                  return this.#e(i.cD, e, t, r);
                }
                noticeError(e, t) {
                  return this.#e(i.o5, e, t);
                }
                setUserId(e) {
                  return this.#e(i.Dl, e);
                }
                setApplicationVersion(e) {
                  return this.#e(i.nb, e);
                }
                setErrorHandler(e) {
                  return this.#e(i.bt, e);
                }
                addRelease(e, t) {
                  return this.#e(i.k6, e, t);
                }
                log(e, t) {
                  return this.#e(i.$9, e, t);
                }
                start() {
                  return this.#e(i.d3);
                }
                finished(e) {
                  return this.#e(i.BL, e);
                }
                recordReplay() {
                  return this.#e(i.CH);
                }
                pauseReplay() {
                  return this.#e(i.Tb);
                }
                addToTrace(e) {
                  return this.#e(i.U2, e);
                }
                setCurrentRouteName(e) {
                  return this.#e(i.PA, e);
                }
                interaction() {
                  return this.#e(i.dT);
                }
                wrapLogger(e, t, r) {
                  return this.#e(i.Wb, e, t, r);
                }
                measure(e, t) {
                  return this.#e(i.V1, e, t);
                }
              }
            },
            4261: (e, t, r) => {
              "use strict";
              r.d(t, {
                $9: () => d,
                BL: () => c,
                CH: () => p,
                Dl: () => R,
                Fw: () => w,
                PA: () => v,
                Pl: () => n,
                Tb: () => f,
                U2: () => a,
                V1: () => E,
                Wb: () => T,
                bt: () => y,
                cD: () => b,
                d3: () => x,
                dT: () => u,
                eY: () => g,
                fF: () => h,
                hG: () => o,
                hw: () => i,
                k6: () => s,
                nb: () => m,
                o5: () => l,
              });
              const n = "api-",
                i = n + "ixn-",
                o = "addPageAction",
                a = "addToTrace",
                s = "addRelease",
                c = "finished",
                u = "interaction",
                d = "log",
                l = "noticeError",
                f = "pauseReplay",
                h = "recordCustomEvent",
                p = "recordReplay",
                g = "register",
                m = "setApplicationVersion",
                v = "setCurrentRouteName",
                b = "setCustomAttribute",
                y = "setErrorHandler",
                w = "setPageViewName",
                R = "setUserId",
                x = "start",
                T = "wrapLogger",
                E = "measure";
            },
            5205: (e, t, r) => {
              "use strict";
              r.d(t, { j: () => S });
              var n = r(384),
                i = r(1741);
              var o = r(2555),
                a = r(3333);
              const s = (e) => {
                if (!e || "string" != typeof e) return !1;
                try {
                  document.createDocumentFragment().querySelector(e);
                } catch {
                  return !1;
                }
                return !0;
              };
              var c = r(2614),
                u = r(944),
                d = r(8122);
              const l = "[data-nr-mask]",
                f = (e) =>
                  (0, d.a)(
                    e,
                    (() => {
                      const e = {
                        feature_flags: [],
                        experimental: {
                          marks: !1,
                          measures: !1,
                          resources: !1,
                        },
                        mask_selector: "*",
                        block_selector: "[data-nr-block]",
                        mask_input_options: {
                          color: !1,
                          date: !1,
                          "datetime-local": !1,
                          email: !1,
                          month: !1,
                          number: !1,
                          range: !1,
                          search: !1,
                          tel: !1,
                          text: !1,
                          time: !1,
                          url: !1,
                          week: !1,
                          textarea: !1,
                          select: !1,
                          password: !0,
                        },
                      };
                      return {
                        ajax: {
                          deny_list: void 0,
                          block_internal: !0,
                          enabled: !0,
                          autoStart: !0,
                        },
                        api: {
                          allow_registered_children: !0,
                          duplicate_registered_data: !1,
                        },
                        distributed_tracing: {
                          enabled: void 0,
                          exclude_newrelic_header: void 0,
                          cors_use_newrelic_header: void 0,
                          cors_use_tracecontext_headers: void 0,
                          allowed_origins: void 0,
                        },
                        get feature_flags() {
                          return e.feature_flags;
                        },
                        set feature_flags(t) {
                          e.feature_flags = t;
                        },
                        generic_events: { enabled: !0, autoStart: !0 },
                        harvest: { interval: 30 },
                        jserrors: { enabled: !0, autoStart: !0 },
                        logging: { enabled: !0, autoStart: !0 },
                        metrics: { enabled: !0, autoStart: !0 },
                        obfuscate: void 0,
                        page_action: { enabled: !0 },
                        page_view_event: { enabled: !0, autoStart: !0 },
                        page_view_timing: { enabled: !0, autoStart: !0 },
                        performance: {
                          get capture_marks() {
                            return (
                              e.feature_flags.includes(a.$v.MARKS) ||
                              e.experimental.marks
                            );
                          },
                          set capture_marks(t) {
                            e.experimental.marks = t;
                          },
                          get capture_measures() {
                            return (
                              e.feature_flags.includes(a.$v.MEASURES) ||
                              e.experimental.measures
                            );
                          },
                          set capture_measures(t) {
                            e.experimental.measures = t;
                          },
                          capture_detail: !0,
                          resources: {
                            get enabled() {
                              return (
                                e.feature_flags.includes(a.$v.RESOURCES) ||
                                e.experimental.resources
                              );
                            },
                            set enabled(t) {
                              e.experimental.resources = t;
                            },
                            asset_types: [],
                            first_party_domains: [],
                            ignore_newrelic: !0,
                          },
                        },
                        privacy: { cookies_enabled: !0 },
                        proxy: { assets: void 0, beacon: void 0 },
                        session: { expiresMs: c.wk, inactiveMs: c.BB },
                        session_replay: {
                          autoStart: !0,
                          enabled: !1,
                          preload: !1,
                          sampling_rate: 10,
                          error_sampling_rate: 100,
                          collect_fonts: !1,
                          inline_images: !1,
                          fix_stylesheets: !0,
                          mask_all_inputs: !0,
                          get mask_text_selector() {
                            return e.mask_selector;
                          },
                          set mask_text_selector(t) {
                            s(t)
                              ? (e.mask_selector = "".concat(t, ",").concat(l))
                              : "" === t || null === t
                                ? (e.mask_selector = l)
                                : (0, u.R)(5, t);
                          },
                          get block_class() {
                            return "nr-block";
                          },
                          get ignore_class() {
                            return "nr-ignore";
                          },
                          get mask_text_class() {
                            return "nr-mask";
                          },
                          get block_selector() {
                            return e.block_selector;
                          },
                          set block_selector(t) {
                            s(t)
                              ? (e.block_selector += ",".concat(t))
                              : "" !== t && (0, u.R)(6, t);
                          },
                          get mask_input_options() {
                            return e.mask_input_options;
                          },
                          set mask_input_options(t) {
                            t && "object" == typeof t
                              ? (e.mask_input_options = { ...t, password: !0 })
                              : (0, u.R)(7, t);
                          },
                        },
                        session_trace: { enabled: !0, autoStart: !0 },
                        soft_navigations: { enabled: !0, autoStart: !0 },
                        spa: { enabled: !0, autoStart: !0 },
                        ssl: void 0,
                        user_actions: {
                          enabled: !0,
                          elementAttributes: [
                            "id",
                            "className",
                            "tagName",
                            "type",
                          ],
                        },
                      };
                    })(),
                  );
              var h = r(6154),
                p = r(9324);
              let g = 0;
              const m = {
                  buildEnv: p.F3,
                  distMethod: p.Xs,
                  version: p.xv,
                  originTime: h.WN,
                },
                v = {
                  appMetadata: {},
                  customTransaction: void 0,
                  denyList: void 0,
                  disabled: !1,
                  entityManager: void 0,
                  harvester: void 0,
                  isolatedBacklog: !1,
                  isRecording: !1,
                  loaderType: void 0,
                  maxBytes: 3e4,
                  obfuscator: void 0,
                  onerror: void 0,
                  ptid: void 0,
                  releaseIds: {},
                  session: void 0,
                  timeKeeper: void 0,
                  jsAttributesMetadata: { bytes: 0 },
                  get harvestCount() {
                    return ++g;
                  },
                },
                b = (e) => {
                  const t = (0, d.a)(e, v),
                    r = Object.keys(m).reduce(
                      (e, t) => (
                        (e[t] = {
                          value: m[t],
                          writable: !1,
                          configurable: !0,
                          enumerable: !0,
                        }),
                        e
                      ),
                      {},
                    );
                  return Object.defineProperties(t, r);
                };
              var y = r(5701);
              const w = (e) => {
                const t = e.startsWith("http");
                ((e += "/"), (r.p = t ? e : "https://" + e));
              };
              var R = r(7836),
                x = r(3241);
              const T = {
                  accountID: void 0,
                  trustKey: void 0,
                  agentID: void 0,
                  licenseKey: void 0,
                  applicationID: void 0,
                  xpid: void 0,
                },
                E = (e) => (0, d.a)(e, T),
                A = new Set();
              function S(e, t = {}, r, a) {
                let {
                  init: s,
                  info: c,
                  loader_config: u,
                  runtime: d = {},
                  exposed: l = !0,
                } = t;
                if (!c) {
                  const e = (0, n.pV)();
                  ((s = e.init), (c = e.info), (u = e.loader_config));
                }
                ((e.init = f(s || {})),
                  (e.loader_config = E(u || {})),
                  (c.jsAttributes ??= {}),
                  h.bv && (c.jsAttributes.isWorker = !0),
                  (e.info = (0, o.D)(c)));
                const p = e.init,
                  g = [c.beacon, c.errorBeacon];
                (A.has(e.agentIdentifier) ||
                  (p.proxy.assets &&
                    (w(p.proxy.assets), g.push(p.proxy.assets)),
                  p.proxy.beacon && g.push(p.proxy.beacon),
                  (function (e) {
                    const t = (0, n.pV)();
                    Object.getOwnPropertyNames(i.W.prototype).forEach((r) => {
                      const n = i.W.prototype[r];
                      if ("function" != typeof n || "constructor" === n) return;
                      let o = t[r];
                      e[r] &&
                        !1 !== e.exposed &&
                        "micro-agent" !== e.runtime?.loaderType &&
                        (t[r] = (...t) => {
                          const n = e[r](...t);
                          return o ? o(...t) : n;
                        });
                    });
                  })(e),
                  (0, n.US)("activatedFeatures", y.B),
                  (e.runSoftNavOverSpa &&=
                    !0 === p.soft_navigations.enabled &&
                    p.feature_flags.includes("soft_nav"))),
                  (d.denyList = [
                    ...(p.ajax.deny_list || []),
                    ...(p.ajax.block_internal ? g : []),
                  ]),
                  (d.ptid = e.agentIdentifier),
                  (d.loaderType = r),
                  (e.runtime = b(d)),
                  A.has(e.agentIdentifier) ||
                    ((e.ee = R.ee.get(e.agentIdentifier)),
                    (e.exposed = l),
                    (0, x.W)({
                      agentIdentifier: e.agentIdentifier,
                      drained: !!y.B?.[e.agentIdentifier],
                      type: "lifecycle",
                      name: "initialize",
                      feature: void 0,
                      data: e.config,
                    })),
                  A.add(e.agentIdentifier));
              }
            },
            8374: (e, t, r) => {
              r.nc = (() => {
                try {
                  return document?.currentScript?.nonce;
                } catch (e) {}
                return "";
              })();
            },
            860: (e, t, r) => {
              "use strict";
              r.d(t, {
                $J: () => d,
                K7: () => c,
                P3: () => u,
                XX: () => i,
                Yy: () => s,
                df: () => o,
                qY: () => n,
                v4: () => a,
              });
              const n = "events",
                i = "jserrors",
                o = "browser/blobs",
                a = "rum",
                s = "browser/logs",
                c = {
                  ajax: "ajax",
                  genericEvents: "generic_events",
                  jserrors: i,
                  logging: "logging",
                  metrics: "metrics",
                  pageAction: "page_action",
                  pageViewEvent: "page_view_event",
                  pageViewTiming: "page_view_timing",
                  sessionReplay: "session_replay",
                  sessionTrace: "session_trace",
                  softNav: "soft_navigations",
                  spa: "spa",
                },
                u = {
                  [c.pageViewEvent]: 1,
                  [c.pageViewTiming]: 2,
                  [c.metrics]: 3,
                  [c.jserrors]: 4,
                  [c.spa]: 5,
                  [c.ajax]: 6,
                  [c.sessionTrace]: 7,
                  [c.softNav]: 8,
                  [c.sessionReplay]: 9,
                  [c.logging]: 10,
                  [c.genericEvents]: 11,
                },
                d = {
                  [c.pageViewEvent]: a,
                  [c.pageViewTiming]: n,
                  [c.ajax]: n,
                  [c.spa]: n,
                  [c.softNav]: n,
                  [c.metrics]: i,
                  [c.jserrors]: i,
                  [c.sessionTrace]: o,
                  [c.sessionReplay]: o,
                  [c.logging]: s,
                  [c.genericEvents]: "ins",
                };
            },
          },
          n = {};
        function i(e) {
          var t = n[e];
          if (void 0 !== t) return t.exports;
          var o = (n[e] = { exports: {} });
          return (r[e](o, o.exports, i), o.exports);
        }
        ((i.m = r),
          (i.d = (e, t) => {
            for (var r in t)
              i.o(t, r) &&
                !i.o(e, r) &&
                Object.defineProperty(e, r, { enumerable: !0, get: t[r] });
          }),
          (i.f = {}),
          (i.e = (e) =>
            Promise.all(
              Object.keys(i.f).reduce((t, r) => (i.f[r](e, t), t), []),
            )),
          (i.u = (e) =>
            ({
              212: "nr-spa-compressor",
              249: "nr-spa-recorder",
              478: "nr-spa",
            })[e] + "-1.297.1.min.js"),
          (i.o = (e, t) => Object.prototype.hasOwnProperty.call(e, t)),
          (e = {}),
          (t = "NRBA-1.297.1.PROD:"),
          (i.l = (r, n, o, a) => {
            if (e[r]) e[r].push(n);
            else {
              var s, c;
              if (void 0 !== o)
                for (
                  var u = document.getElementsByTagName("script"), d = 0;
                  d < u.length;
                  d++
                ) {
                  var l = u[d];
                  if (
                    l.getAttribute("src") == r ||
                    l.getAttribute("data-webpack") == t + o
                  ) {
                    s = l;
                    break;
                  }
                }
              if (!s) {
                c = !0;
                var f = {
                  478: "sha512-1vrrDMllaSQzaG727/ANdY3fXj27K8V7HNMIwQBDzCBxhGO9QGsFYFLcuV25Ml4BULgcePXjYIgAR0ZGeNX3Og==",
                  249: "sha512-rXCzuqRJpuGVq/7lHZE3HSbWW6ZwrxiTFkQKRLGxCUort+scqEIOaw9J6Q6aZxdc2+moEtfq6zr2C7N+BfdZXg==",
                  212: "sha512-YmdTCuUK8EASpeTRq8497ZzABHaNWk9Me/ykR9mHZyTXTDYNj7RXXnqqWZt3myuErn084ywDfDNq7wo5ei/5kQ==",
                };
                (((s = document.createElement("script")).charset = "utf-8"),
                  (s.timeout = 120),
                  i.nc && s.setAttribute("nonce", i.nc),
                  s.setAttribute("data-webpack", t + o),
                  (s.src = r),
                  0 !== s.src.indexOf(window.location.origin + "/") &&
                    (s.crossOrigin = "anonymous"),
                  f[a] && (s.integrity = f[a]));
              }
              e[r] = [n];
              var h = (t, n) => {
                  ((s.onerror = s.onload = null), clearTimeout(p));
                  var i = e[r];
                  if (
                    (delete e[r],
                    s.parentNode && s.parentNode.removeChild(s),
                    i && i.forEach((e) => e(n)),
                    t)
                  )
                    return t(n);
                },
                p = setTimeout(
                  h.bind(null, void 0, { type: "timeout", target: s }),
                  12e4,
                );
              ((s.onerror = h.bind(null, s.onerror)),
                (s.onload = h.bind(null, s.onload)),
                c && document.head.appendChild(s));
            }
          }),
          (i.r = (e) => {
            ("undefined" != typeof Symbol &&
              Symbol.toStringTag &&
              Object.defineProperty(e, Symbol.toStringTag, { value: "Module" }),
              Object.defineProperty(e, "__esModule", { value: !0 }));
          }),
          (i.p = "https://js-agent.newrelic.com/"),
          (() => {
            var e = { 38: 0, 788: 0 };
            i.f.j = (t, r) => {
              var n = i.o(e, t) ? e[t] : void 0;
              if (0 !== n)
                if (n) r.push(n[2]);
                else {
                  var o = new Promise((r, i) => (n = e[t] = [r, i]));
                  r.push((n[2] = o));
                  var a = i.p + i.u(t),
                    s = new Error();
                  i.l(
                    a,
                    (r) => {
                      if (
                        i.o(e, t) &&
                        (0 !== (n = e[t]) && (e[t] = void 0), n)
                      ) {
                        var o = r && ("load" === r.type ? "missing" : r.type),
                          a = r && r.target && r.target.src;
                        ((s.message =
                          "Loading chunk " +
                          t +
                          " failed.\n(" +
                          o +
                          ": " +
                          a +
                          ")"),
                          (s.name = "ChunkLoadError"),
                          (s.type = o),
                          (s.request = a),
                          n[1](s));
                      }
                    },
                    "chunk-" + t,
                    t,
                  );
                }
            };
            var t = (t, r) => {
                var n,
                  o,
                  [a, s, c] = r,
                  u = 0;
                if (a.some((t) => 0 !== e[t])) {
                  for (n in s) i.o(s, n) && (i.m[n] = s[n]);
                  if (c) c(i);
                }
                for (t && t(r); u < a.length; u++)
                  ((o = a[u]), i.o(e, o) && e[o] && e[o][0](), (e[o] = 0));
              },
              r = (self["webpackChunk:NRBA-1.297.1.PROD"] =
                self["webpackChunk:NRBA-1.297.1.PROD"] || []);
            (r.forEach(t.bind(null, 0)),
              (r.push = t.bind(null, r.push.bind(r))));
          })(),
          (() => {
            "use strict";
            i(8374);
            var e = i(9566),
              t = i(1741);
            class r extends t.W {
              agentIdentifier = (0, e.LA)(16);
            }
            var n = i(860);
            const o = Object.values(n.K7);
            var a = i(5205);
            var s = i(9908),
              c = i(1863),
              u = i(4261),
              d = i(3241),
              l = i(944),
              f = i(5701),
              h = i(8154);
            function p(e, t, i, o) {
              const a = o || i;
              !a ||
                (a[e] && a[e] !== r.prototype[e]) ||
                (a[e] = function () {
                  ((0, s.p)(
                    h.xV,
                    ["API/" + e + "/called"],
                    void 0,
                    n.K7.metrics,
                    i.ee,
                  ),
                    (0, d.W)({
                      agentIdentifier: i.agentIdentifier,
                      drained: !!f.B?.[i.agentIdentifier],
                      type: "data",
                      name: "api",
                      feature: u.Pl + e,
                      data: {},
                    }));
                  try {
                    return t.apply(this, arguments);
                  } catch (e) {
                    (0, l.R)(23, e);
                  }
                });
            }
            function g(e, t, r, n, i) {
              const o = e.info;
              (null === r ? delete o.jsAttributes[t] : (o.jsAttributes[t] = r),
                (i || null === r) &&
                  (0, s.p)(
                    u.Pl + n,
                    [(0, c.t)(), t, r],
                    void 0,
                    "session",
                    e.ee,
                  ));
            }
            var m = i(1687),
              v = i(4234),
              b = i(5289),
              y = i(6154),
              w = i(5270),
              R = i(7767),
              x = i(6389),
              T = i(7699);
            class E extends v.W {
              constructor(e, t) {
                (super(e.agentIdentifier, t),
                  (this.agentRef = e),
                  (this.abortHandler = void 0),
                  (this.featAggregate = void 0),
                  (this.onAggregateImported = void 0),
                  (this.deferred = Promise.resolve()),
                  !1 === e.init[this.featureName].autoStart
                    ? (this.deferred = new Promise((t, r) => {
                        this.ee.on(
                          "manual-start-all",
                          (0, x.J)(() => {
                            ((0, m.Ak)(e.agentIdentifier, this.featureName),
                              t());
                          }),
                        );
                      }))
                    : (0, m.Ak)(e.agentIdentifier, t));
              }
              importAggregator(e, t, r = {}) {
                if (this.featAggregate) return;
                let n;
                this.onAggregateImported = new Promise((e) => {
                  n = e;
                });
                const o = async () => {
                  let o;
                  await this.deferred;
                  try {
                    if ((0, R.V)(e.init)) {
                      const { setupAgentSession: t } = await i
                        .e(478)
                        .then(i.bind(i, 2955));
                      o = t(e);
                    }
                  } catch (e) {
                    ((0, l.R)(20, e),
                      this.ee.emit("internal-error", [e]),
                      (0, s.p)(T.qh, [e], void 0, this.featureName, this.ee));
                  }
                  try {
                    if (!this.#t(this.featureName, o, e.init))
                      return (
                        (0, m.Ze)(this.agentIdentifier, this.featureName),
                        void n(!1)
                      );
                    const { Aggregate: i } = await t();
                    ((this.featAggregate = new i(e, r)),
                      e.runtime.harvester.initializedAggregates.push(
                        this.featAggregate,
                      ),
                      n(!0));
                  } catch (e) {
                    ((0, l.R)(34, e),
                      this.abortHandler?.(),
                      (0, m.Ze)(this.agentIdentifier, this.featureName, !0),
                      n(!1),
                      this.ee && this.ee.abort());
                  }
                };
                y.RI ? (0, b.GG)(() => o(), !0) : o();
              }
              #t(e, t, r) {
                if (this.blocked) return !1;
                switch (e) {
                  case n.K7.sessionReplay:
                    return (0, w.SR)(r) && !!t;
                  case n.K7.sessionTrace:
                    return !!t;
                  default:
                    return !0;
                }
              }
            }
            var A = i(6630),
              S = i(2614);
            class _ extends E {
              static featureName = A.T;
              constructor(e) {
                var t;
                (super(e, A.T),
                  this.setupInspectionEvents(e.agentIdentifier),
                  (t = e),
                  p(
                    u.Fw,
                    function (e, r) {
                      "string" == typeof e &&
                        ("/" !== e.charAt(0) && (e = "/" + e),
                        (t.runtime.customTransaction =
                          (r || "http://custom.transaction") + e),
                        (0, s.p)(
                          u.Pl + u.Fw,
                          [(0, c.t)()],
                          void 0,
                          void 0,
                          t.ee,
                        ));
                    },
                    t,
                  ),
                  this.ee.on("api-send-rum", (e, t) =>
                    (0, s.p)(
                      "send-rum",
                      [e, t],
                      void 0,
                      this.featureName,
                      this.ee,
                    ),
                  ),
                  this.importAggregator(e, () =>
                    i.e(478).then(i.bind(i, 1983)),
                  ));
              }
              setupInspectionEvents(e) {
                const t = (t, r) => {
                  t &&
                    (0, d.W)({
                      agentIdentifier: e,
                      timeStamp: t.timeStamp,
                      loaded: "complete" === t.target.readyState,
                      type: "window",
                      name: r,
                      data: t.target.location + "",
                    });
                };
                ((0, b.sB)((e) => {
                  t(e, "DOMContentLoaded");
                }),
                  (0, b.GG)((e) => {
                    t(e, "load");
                  }),
                  (0, b.Qr)((e) => {
                    t(e, "navigate");
                  }),
                  this.ee.on(S.tS.UPDATE, (t, r) => {
                    (0, d.W)({
                      agentIdentifier: e,
                      type: "lifecycle",
                      name: "session",
                      data: r,
                    });
                  }));
              }
            }
            var N = i(384);
            var O = i(2843),
              I = i(3878),
              P = i(782);
            class j extends E {
              static featureName = P.T;
              constructor(e) {
                (super(e, P.T),
                  y.RI &&
                    ((0, O.u)(
                      () =>
                        (0, s.p)(
                          "docHidden",
                          [(0, c.t)()],
                          void 0,
                          P.T,
                          this.ee,
                        ),
                      !0,
                    ),
                    (0, I.sp)("pagehide", () =>
                      (0, s.p)(
                        "winPagehide",
                        [(0, c.t)()],
                        void 0,
                        P.T,
                        this.ee,
                      ),
                    ),
                    this.importAggregator(e, () =>
                      i.e(478).then(i.bind(i, 9917)),
                    )));
              }
            }
            class k extends E {
              static featureName = h.TZ;
              constructor(e) {
                (super(e, h.TZ),
                  y.RI &&
                    document.addEventListener(
                      "securitypolicyviolation",
                      (e) => {
                        (0, s.p)(
                          h.xV,
                          ["Generic/CSPViolation/Detected"],
                          void 0,
                          this.featureName,
                          this.ee,
                        );
                      },
                    ),
                  this.importAggregator(e, () =>
                    i.e(478).then(i.bind(i, 8351)),
                  ));
              }
            }
            var C = i(6774),
              L = i(3304);
            class M {
              constructor(e, t, r, n, i) {
                ((this.name = "UncaughtError"),
                  (this.message = "string" == typeof e ? e : (0, L.A)(e)),
                  (this.sourceURL = t),
                  (this.line = r),
                  (this.column = n),
                  (this.__newrelic = i));
              }
            }
            function H(e) {
              return U(e)
                ? e
                : new M(
                    void 0 !== e?.message ? e.message : e,
                    e?.filename || e?.sourceURL,
                    e?.lineno || e?.line,
                    e?.colno || e?.col,
                    e?.__newrelic,
                    e?.cause,
                  );
            }
            function D(e) {
              const t = "Unhandled Promise Rejection: ";
              if (!e?.reason) return;
              if (U(e.reason)) {
                try {
                  e.reason.message.startsWith(t) ||
                    (e.reason.message = t + e.reason.message);
                } catch (e) {}
                return H(e.reason);
              }
              const r = H(e.reason);
              return (
                (r.message || "").startsWith(t) || (r.message = t + r.message),
                r
              );
            }
            function K(e) {
              if (
                e.error instanceof SyntaxError &&
                !/:\d+$/.test(e.error.stack?.trim())
              ) {
                const t = new M(
                  e.message,
                  e.filename,
                  e.lineno,
                  e.colno,
                  e.error.__newrelic,
                  e.cause,
                );
                return ((t.name = SyntaxError.name), t);
              }
              return U(e.error) ? e.error : H(e);
            }
            function U(e) {
              return e instanceof Error && !!e.stack;
            }
            function F(e, t, r, i, o = (0, c.t)()) {
              ("string" == typeof e && (e = new Error(e)),
                (0, s.p)(
                  "err",
                  [e, o, !1, t, r.runtime.isRecording, void 0, i],
                  void 0,
                  n.K7.jserrors,
                  r.ee,
                ));
            }
            var W = i(3496),
              B = i(993),
              G = i(3785);
            function V(
              e,
              { customAttributes: t = {}, level: r = B.p_.INFO } = {},
              n,
              i,
              o = (0, c.t)(),
            ) {
              (0, G.R)(n.ee, e, t, r, i, o);
            }
            function z(e, t, r, i, o = (0, c.t)()) {
              (0, s.p)(
                u.Pl + u.hG,
                [o, e, t, i],
                void 0,
                n.K7.genericEvents,
                r.ee,
              );
            }
            function Z(e) {
              p(
                u.eY,
                function (t) {
                  return (function (e, t) {
                    const r = {};
                    let i, o;
                    ((0, l.R)(54, "newrelic.register"),
                      e.init.api.allow_registered_children ||
                        (i = () => (0, l.R)(55)));
                    (t && (0, W.I)(t)) || (i = () => (0, l.R)(48, t));
                    const a = {
                      addPageAction: (n, i = {}) => {
                        u(z, [n, { ...r, ...i }, e], t);
                      },
                      log: (n, i = {}) => {
                        u(
                          V,
                          [
                            n,
                            {
                              ...i,
                              customAttributes: {
                                ...r,
                                ...(i.customAttributes || {}),
                              },
                            },
                            e,
                          ],
                          t,
                        );
                      },
                      noticeError: (n, i = {}) => {
                        u(F, [n, { ...r, ...i }, e], t);
                      },
                      setApplicationVersion: (e) => {
                        r["application.version"] = e;
                      },
                      setCustomAttribute: (e, t) => {
                        r[e] = t;
                      },
                      setUserId: (e) => {
                        r["enduser.id"] = e;
                      },
                      metadata: {
                        customAttributes: r,
                        target: t,
                        get connected() {
                          return (
                            o || Promise.reject(new Error("Failed to connect"))
                          );
                        },
                      },
                    };
                    i
                      ? i()
                      : (o = new Promise((n, i) => {
                          try {
                            const o = e.runtime?.entityManager;
                            let s = !!o?.get().entityGuid,
                              c = o?.getEntityGuidFor(
                                t.licenseKey,
                                t.applicationID,
                              ),
                              u = !!c;
                            if (s && u) ((t.entityGuid = c), n(a));
                            else {
                              const d = setTimeout(
                                () =>
                                  i(new Error("Failed to connect - Timeout")),
                                15e3,
                              );
                              function l(r) {
                                ((0, W.A)(r, e)
                                  ? (s ||= !0)
                                  : t.licenseKey === r.licenseKey &&
                                    t.applicationID === r.applicationID &&
                                    ((u = !0), (t.entityGuid = r.entityGuid)),
                                  s &&
                                    u &&
                                    (clearTimeout(d),
                                    e.ee.removeEventListener("entity-added", l),
                                    n(a)));
                              }
                              (e.ee.emit("api-send-rum", [r, t]),
                                e.ee.on("entity-added", l));
                            }
                          } catch (f) {
                            i(f);
                          }
                        }));
                    const u = async (t, r, a) => {
                      if (i) return i();
                      const u = (0, c.t)();
                      (0, s.p)(
                        h.xV,
                        ["API/register/".concat(t.name, "/called")],
                        void 0,
                        n.K7.metrics,
                        e.ee,
                      );
                      try {
                        await o;
                        const n = e.init.api.duplicate_registered_data;
                        ((!0 === n ||
                          (Array.isArray(n) && n.includes(a.entityGuid))) &&
                          t(...r, void 0, u),
                          t(...r, a.entityGuid, u));
                      } catch (e) {
                        (0, l.R)(50, e);
                      }
                    };
                    return a;
                  })(e, t);
                },
                e,
              );
            }
            class q extends E {
              static featureName = C.T;
              constructor(e) {
                var t;
                (super(e, C.T),
                  (t = e),
                  p(u.o5, (e, r) => F(e, r, t), t),
                  (function (e) {
                    p(
                      u.bt,
                      function (t) {
                        e.runtime.onerror = t;
                      },
                      e,
                    );
                  })(e),
                  (function (e) {
                    let t = 0;
                    p(
                      u.k6,
                      function (e, r) {
                        ++t > 10 ||
                          (this.runtime.releaseIds[e.slice(-200)] = (
                            "" + r
                          ).slice(-200));
                      },
                      e,
                    );
                  })(e),
                  Z(e));
                try {
                  this.removeOnAbort = new AbortController();
                } catch (e) {}
                (this.ee.on("internal-error", (t, r) => {
                  this.abortHandler &&
                    (0, s.p)(
                      "ierr",
                      [H(t), (0, c.t)(), !0, {}, e.runtime.isRecording, r],
                      void 0,
                      this.featureName,
                      this.ee,
                    );
                }),
                  y.gm.addEventListener(
                    "unhandledrejection",
                    (t) => {
                      this.abortHandler &&
                        (0, s.p)(
                          "err",
                          [
                            D(t),
                            (0, c.t)(),
                            !1,
                            { unhandledPromiseRejection: 1 },
                            e.runtime.isRecording,
                          ],
                          void 0,
                          this.featureName,
                          this.ee,
                        );
                    },
                    (0, I.jT)(!1, this.removeOnAbort?.signal),
                  ),
                  y.gm.addEventListener(
                    "error",
                    (t) => {
                      this.abortHandler &&
                        (0, s.p)(
                          "err",
                          [K(t), (0, c.t)(), !1, {}, e.runtime.isRecording],
                          void 0,
                          this.featureName,
                          this.ee,
                        );
                    },
                    (0, I.jT)(!1, this.removeOnAbort?.signal),
                  ),
                  (this.abortHandler = this.#r),
                  this.importAggregator(e, () =>
                    i.e(478).then(i.bind(i, 2176)),
                  ));
              }
              #r() {
                (this.removeOnAbort?.abort(), (this.abortHandler = void 0));
              }
            }
            var X = i(8990);
            let Y = 1;
            function Q(e) {
              const t = typeof e;
              return !e || ("object" !== t && "function" !== t)
                ? -1
                : e === y.gm
                  ? 0
                  : (0, X.I)(e, "nr@id", function () {
                      return Y++;
                    });
            }
            function J(e) {
              if ("string" == typeof e && e.length) return e.length;
              if ("object" == typeof e) {
                if (
                  "undefined" != typeof ArrayBuffer &&
                  e instanceof ArrayBuffer &&
                  e.byteLength
                )
                  return e.byteLength;
                if ("undefined" != typeof Blob && e instanceof Blob && e.size)
                  return e.size;
                if (!("undefined" != typeof FormData && e instanceof FormData))
                  try {
                    return (0, L.A)(e).length;
                  } catch (e) {
                    return;
                  }
              }
            }
            var ee = i(8139),
              te = i(7836),
              re = i(3434);
            const ne = {},
              ie = ["open", "send"];
            function oe(e) {
              var t = e || te.ee;
              const r = (function (e) {
                return (e || te.ee).get("xhr");
              })(t);
              if (void 0 === y.gm.XMLHttpRequest) return r;
              if (ne[r.debugId]++) return r;
              ((ne[r.debugId] = 1), (0, ee.u)(t));
              var n = (0, re.YM)(r),
                i = y.gm.XMLHttpRequest,
                o = y.gm.MutationObserver,
                a = y.gm.Promise,
                s = y.gm.setInterval,
                c = "readystatechange",
                u = [
                  "onload",
                  "onerror",
                  "onabort",
                  "onloadstart",
                  "onloadend",
                  "onprogress",
                  "ontimeout",
                ],
                d = [],
                f = (y.gm.XMLHttpRequest = function (e) {
                  const t = new i(e),
                    o = r.context(t);
                  try {
                    (r.emit("new-xhr", [t], o),
                      t.addEventListener(
                        c,
                        ((a = o),
                        function () {
                          var e = this;
                          (e.readyState > 3 &&
                            !a.resolved &&
                            ((a.resolved = !0), r.emit("xhr-resolved", [], e)),
                            n.inPlace(e, u, "fn-", b));
                        }),
                        (0, I.jT)(!1),
                      ));
                  } catch (e) {
                    (0, l.R)(15, e);
                    try {
                      r.emit("internal-error", [e]);
                    } catch (e) {}
                  }
                  var a;
                  return t;
                });
              function h(e, t) {
                n.inPlace(t, ["onreadystatechange"], "fn-", b);
              }
              if (
                ((function (e, t) {
                  for (var r in e) t[r] = e[r];
                })(i, f),
                (f.prototype = i.prototype),
                n.inPlace(f.prototype, ie, "-xhr-", b),
                r.on("send-xhr-start", function (e, t) {
                  (h(e, t),
                    (function (e) {
                      (d.push(e),
                        o &&
                          (p
                            ? p.then(v)
                            : s
                              ? s(v)
                              : ((g = -g), (m.data = g))));
                    })(t));
                }),
                r.on("open-xhr-start", h),
                o)
              ) {
                var p = a && a.resolve();
                if (!s && !a) {
                  var g = 1,
                    m = document.createTextNode(g);
                  new o(v).observe(m, { characterData: !0 });
                }
              } else
                t.on("fn-end", function (e) {
                  (e[0] && e[0].type === c) || v();
                });
              function v() {
                for (var e = 0; e < d.length; e++) h(0, d[e]);
                d.length && (d = []);
              }
              function b(e, t) {
                return t;
              }
              return r;
            }
            var ae = "fetch-",
              se = ae + "body-",
              ce = ["arrayBuffer", "blob", "json", "text", "formData"],
              ue = y.gm.Request,
              de = y.gm.Response,
              le = "prototype";
            const fe = {};
            function he(e) {
              const t = (function (e) {
                return (e || te.ee).get("fetch");
              })(e);
              if (!(ue && de && y.gm.fetch)) return t;
              if (fe[t.debugId]++) return t;
              function r(e, r, n) {
                var i = e[r];
                "function" == typeof i &&
                  (e[r] = function () {
                    var e,
                      r = [...arguments],
                      o = {};
                    (t.emit(n + "before-start", [r], o),
                      o[te.P] && o[te.P].dt && (e = o[te.P].dt));
                    var a = i.apply(this, r);
                    return (
                      t.emit(n + "start", [r, e], a),
                      a.then(
                        function (e) {
                          return (t.emit(n + "end", [null, e], a), e);
                        },
                        function (e) {
                          throw (t.emit(n + "end", [e], a), e);
                        },
                      )
                    );
                  });
              }
              return (
                (fe[t.debugId] = 1),
                ce.forEach((e) => {
                  (r(ue[le], e, se), r(de[le], e, se));
                }),
                r(y.gm, "fetch", ae),
                t.on(ae + "end", function (e, r) {
                  var n = this;
                  if (r) {
                    var i = r.headers.get("content-length");
                    (null !== i && (n.rxSize = i),
                      t.emit(ae + "done", [null, r], n));
                  } else t.emit(ae + "done", [e], n);
                }),
                t
              );
            }
            var pe = i(7485);
            class ge {
              constructor(e) {
                this.agentRef = e;
              }
              generateTracePayload(t) {
                const r = this.agentRef.loader_config;
                if (!this.shouldGenerateTrace(t) || !r) return null;
                var n = (r.accountID || "").toString() || null,
                  i = (r.agentID || "").toString() || null,
                  o = (r.trustKey || "").toString() || null;
                if (!n || !i) return null;
                var a = (0, e.ZF)(),
                  s = (0, e.el)(),
                  c = Date.now(),
                  u = { spanId: a, traceId: s, timestamp: c };
                return (
                  (t.sameOrigin ||
                    (this.isAllowedOrigin(t) &&
                      this.useTraceContextHeadersForCors())) &&
                    ((u.traceContextParentHeader =
                      this.generateTraceContextParentHeader(a, s)),
                    (u.traceContextStateHeader =
                      this.generateTraceContextStateHeader(a, c, n, i, o))),
                  ((t.sameOrigin && !this.excludeNewrelicHeader()) ||
                    (!t.sameOrigin &&
                      this.isAllowedOrigin(t) &&
                      this.useNewrelicHeaderForCors())) &&
                    (u.newrelicHeader = this.generateTraceHeader(
                      a,
                      s,
                      c,
                      n,
                      i,
                      o,
                    )),
                  u
                );
              }
              generateTraceContextParentHeader(e, t) {
                return "00-" + t + "-" + e + "-01";
              }
              generateTraceContextStateHeader(e, t, r, n, i) {
                return i + "@nr=0-1-" + r + "-" + n + "-" + e + "----" + t;
              }
              generateTraceHeader(e, t, r, n, i, o) {
                if (!("function" == typeof y.gm?.btoa)) return null;
                var a = {
                  v: [0, 1],
                  d: { ty: "Browser", ac: n, ap: i, id: e, tr: t, ti: r },
                };
                return (o && n !== o && (a.d.tk = o), btoa((0, L.A)(a)));
              }
              shouldGenerateTrace(e) {
                return (
                  this.agentRef.init?.distributed_tracing?.enabled &&
                  this.isAllowedOrigin(e)
                );
              }
              isAllowedOrigin(e) {
                var t = !1;
                const r = this.agentRef.init?.distributed_tracing;
                if (e.sameOrigin) t = !0;
                else if (r?.allowed_origins instanceof Array)
                  for (var n = 0; n < r.allowed_origins.length; n++) {
                    var i = (0, pe.D)(r.allowed_origins[n]);
                    if (
                      e.hostname === i.hostname &&
                      e.protocol === i.protocol &&
                      e.port === i.port
                    ) {
                      t = !0;
                      break;
                    }
                  }
                return t;
              }
              excludeNewrelicHeader() {
                var e = this.agentRef.init?.distributed_tracing;
                return !!e && !!e.exclude_newrelic_header;
              }
              useNewrelicHeaderForCors() {
                var e = this.agentRef.init?.distributed_tracing;
                return !!e && !1 !== e.cors_use_newrelic_header;
              }
              useTraceContextHeadersForCors() {
                var e = this.agentRef.init?.distributed_tracing;
                return !!e && !!e.cors_use_tracecontext_headers;
              }
            }
            var me = i(9300),
              ve = i(7295),
              be = ["load", "error", "abort", "timeout"],
              ye = be.length,
              we = (0, N.dV)().o.REQ,
              Re = (0, N.dV)().o.XHR;
            const xe = "X-NewRelic-App-Data";
            class Te extends E {
              static featureName = me.T;
              constructor(e) {
                (super(e, me.T),
                  (this.dt = new ge(e)),
                  (this.handler = (e, t, r, n) =>
                    (0, s.p)(e, t, r, n, this.ee)));
                try {
                  const e = {
                    xmlhttprequest: "xhr",
                    fetch: "fetch",
                    beacon: "beacon",
                  };
                  y.gm?.performance
                    ?.getEntriesByType("resource")
                    .forEach((t) => {
                      if (t.initiatorType in e && 0 !== t.responseStatus) {
                        const r = { status: t.responseStatus },
                          i = {
                            rxSize: t.transferSize,
                            duration: Math.floor(t.duration),
                            cbTime: 0,
                          };
                        (Ee(r, t.name),
                          this.handler(
                            "xhr",
                            [
                              r,
                              i,
                              t.startTime,
                              t.responseEnd,
                              e[t.initiatorType],
                            ],
                            void 0,
                            n.K7.ajax,
                          ));
                      }
                    });
                } catch (e) {}
                (he(this.ee),
                  oe(this.ee),
                  (function (e, t, r, i) {
                    function o(e) {
                      var t = this;
                      ((t.totalCbs = 0),
                        (t.called = 0),
                        (t.cbTime = 0),
                        (t.end = E),
                        (t.ended = !1),
                        (t.xhrGuids = {}),
                        (t.lastSize = null),
                        (t.loadCaptureCalled = !1),
                        (t.params = this.params || {}),
                        (t.metrics = this.metrics || {}),
                        e.addEventListener(
                          "load",
                          function (r) {
                            A(t, e);
                          },
                          (0, I.jT)(!1),
                        ),
                        y.lR ||
                          e.addEventListener(
                            "progress",
                            function (e) {
                              t.lastSize = e.loaded;
                            },
                            (0, I.jT)(!1),
                          ));
                    }
                    function a(e) {
                      ((this.params = { method: e[0] }),
                        Ee(this, e[1]),
                        (this.metrics = {}));
                    }
                    function u(t, r) {
                      e.loader_config.xpid &&
                        this.sameOrigin &&
                        r.setRequestHeader(
                          "X-NewRelic-ID",
                          e.loader_config.xpid,
                        );
                      var n = i.generateTracePayload(this.parsedOrigin);
                      if (n) {
                        var o = !1;
                        (n.newrelicHeader &&
                          (r.setRequestHeader("newrelic", n.newrelicHeader),
                          (o = !0)),
                          n.traceContextParentHeader &&
                            (r.setRequestHeader(
                              "traceparent",
                              n.traceContextParentHeader,
                            ),
                            n.traceContextStateHeader &&
                              r.setRequestHeader(
                                "tracestate",
                                n.traceContextStateHeader,
                              ),
                            (o = !0)),
                          o && (this.dt = n));
                      }
                    }
                    function d(e, r) {
                      var n = this.metrics,
                        i = e[0],
                        o = this;
                      if (n && i) {
                        var a = J(i);
                        a && (n.txSize = a);
                      }
                      ((this.startTime = (0, c.t)()),
                        (this.body = i),
                        (this.listener = function (e) {
                          try {
                            ("abort" !== e.type ||
                              o.loadCaptureCalled ||
                              (o.params.aborted = !0),
                              ("load" !== e.type ||
                                (o.called === o.totalCbs &&
                                  (o.onloadCalled ||
                                    "function" != typeof r.onload) &&
                                  "function" == typeof o.end)) &&
                                o.end(r));
                          } catch (e) {
                            try {
                              t.emit("internal-error", [e]);
                            } catch (e) {}
                          }
                        }));
                      for (var s = 0; s < ye; s++)
                        r.addEventListener(be[s], this.listener, (0, I.jT)(!1));
                    }
                    function l(e, t, r) {
                      ((this.cbTime += e),
                        t ? (this.onloadCalled = !0) : (this.called += 1),
                        this.called !== this.totalCbs ||
                          (!this.onloadCalled &&
                            "function" == typeof r.onload) ||
                          "function" != typeof this.end ||
                          this.end(r));
                    }
                    function f(e, t) {
                      var r = "" + Q(e) + !!t;
                      this.xhrGuids &&
                        !this.xhrGuids[r] &&
                        ((this.xhrGuids[r] = !0), (this.totalCbs += 1));
                    }
                    function p(e, t) {
                      var r = "" + Q(e) + !!t;
                      this.xhrGuids &&
                        this.xhrGuids[r] &&
                        (delete this.xhrGuids[r], (this.totalCbs -= 1));
                    }
                    function g() {
                      this.endTime = (0, c.t)();
                    }
                    function m(e, r) {
                      r instanceof Re &&
                        "load" === e[0] &&
                        t.emit("xhr-load-added", [e[1], e[2]], r);
                    }
                    function v(e, r) {
                      r instanceof Re &&
                        "load" === e[0] &&
                        t.emit("xhr-load-removed", [e[1], e[2]], r);
                    }
                    function b(e, t, r) {
                      t instanceof Re &&
                        ("onload" === r && (this.onload = !0),
                        ("load" === (e[0] && e[0].type) || this.onload) &&
                          (this.xhrCbStart = (0, c.t)()));
                    }
                    function w(e, r) {
                      this.xhrCbStart &&
                        t.emit(
                          "xhr-cb-time",
                          [(0, c.t)() - this.xhrCbStart, this.onload, r],
                          r,
                        );
                    }
                    function R(e) {
                      var t,
                        r = e[1] || {};
                      if (
                        ("string" == typeof e[0]
                          ? 0 === (t = e[0]).length &&
                            y.RI &&
                            (t = "" + y.gm.location.href)
                          : e[0] && e[0].url
                            ? (t = e[0].url)
                            : y.gm?.URL && e[0] && e[0] instanceof URL
                              ? (t = e[0].href)
                              : "function" == typeof e[0].toString &&
                                (t = e[0].toString()),
                        "string" == typeof t && 0 !== t.length)
                      ) {
                        t &&
                          ((this.parsedOrigin = (0, pe.D)(t)),
                          (this.sameOrigin = this.parsedOrigin.sameOrigin));
                        var n = i.generateTracePayload(this.parsedOrigin);
                        if (
                          n &&
                          (n.newrelicHeader || n.traceContextParentHeader)
                        )
                          if (e[0] && e[0].headers)
                            s(e[0].headers, n) && (this.dt = n);
                          else {
                            var o = {};
                            for (var a in r) o[a] = r[a];
                            ((o.headers = new Headers(r.headers || {})),
                              s(o.headers, n) && (this.dt = n),
                              e.length > 1 ? (e[1] = o) : e.push(o));
                          }
                      }
                      function s(e, t) {
                        var r = !1;
                        return (
                          t.newrelicHeader &&
                            (e.set("newrelic", t.newrelicHeader), (r = !0)),
                          t.traceContextParentHeader &&
                            (e.set("traceparent", t.traceContextParentHeader),
                            t.traceContextStateHeader &&
                              e.set("tracestate", t.traceContextStateHeader),
                            (r = !0)),
                          r
                        );
                      }
                    }
                    function x(e, t) {
                      ((this.params = {}),
                        (this.metrics = {}),
                        (this.startTime = (0, c.t)()),
                        (this.dt = t),
                        e.length >= 1 && (this.target = e[0]),
                        e.length >= 2 && (this.opts = e[1]));
                      var r,
                        n = this.opts || {},
                        i = this.target;
                      ("string" == typeof i
                        ? (r = i)
                        : "object" == typeof i && i instanceof we
                          ? (r = i.url)
                          : y.gm?.URL &&
                            "object" == typeof i &&
                            i instanceof URL &&
                            (r = i.href),
                        Ee(this, r));
                      var o = (
                        "" +
                        ((i && i instanceof we && i.method) ||
                          n.method ||
                          "GET")
                      ).toUpperCase();
                      ((this.params.method = o),
                        (this.body = n.body),
                        (this.txSize = J(n.body) || 0));
                    }
                    function T(e, t) {
                      if (
                        ((this.endTime = (0, c.t)()),
                        this.params || (this.params = {}),
                        (0, ve.iW)(this.params))
                      )
                        return;
                      let i;
                      ((this.params.status = t ? t.status : 0),
                        "string" == typeof this.rxSize &&
                          this.rxSize.length > 0 &&
                          (i = +this.rxSize));
                      const o = {
                        txSize: this.txSize,
                        rxSize: i,
                        duration: (0, c.t)() - this.startTime,
                      };
                      r(
                        "xhr",
                        [this.params, o, this.startTime, this.endTime, "fetch"],
                        this,
                        n.K7.ajax,
                      );
                    }
                    function E(e) {
                      const t = this.params,
                        i = this.metrics;
                      if (!this.ended) {
                        this.ended = !0;
                        for (let t = 0; t < ye; t++)
                          e.removeEventListener(be[t], this.listener, !1);
                        t.aborted ||
                          (0, ve.iW)(t) ||
                          ((i.duration = (0, c.t)() - this.startTime),
                          this.loadCaptureCalled || 4 !== e.readyState
                            ? null == t.status && (t.status = 0)
                            : A(this, e),
                          (i.cbTime = this.cbTime),
                          r(
                            "xhr",
                            [t, i, this.startTime, this.endTime, "xhr"],
                            this,
                            n.K7.ajax,
                          ));
                      }
                    }
                    function A(e, r) {
                      e.params.status = r.status;
                      var i = (function (e, t) {
                        var r = e.responseType;
                        return "json" === r && null !== t
                          ? t
                          : "arraybuffer" === r || "blob" === r || "json" === r
                            ? J(e.response)
                            : "text" === r || "" === r || void 0 === r
                              ? J(e.responseText)
                              : void 0;
                      })(r, e.lastSize);
                      if (
                        (i && (e.metrics.rxSize = i),
                        e.sameOrigin &&
                          r.getAllResponseHeaders().indexOf(xe) >= 0)
                      ) {
                        var o = r.getResponseHeader(xe);
                        o &&
                          ((0, s.p)(
                            h.rs,
                            ["Ajax/CrossApplicationTracing/Header/Seen"],
                            void 0,
                            n.K7.metrics,
                            t,
                          ),
                          (e.params.cat = o.split(", ").pop()));
                      }
                      e.loadCaptureCalled = !0;
                    }
                    (t.on("new-xhr", o),
                      t.on("open-xhr-start", a),
                      t.on("open-xhr-end", u),
                      t.on("send-xhr-start", d),
                      t.on("xhr-cb-time", l),
                      t.on("xhr-load-added", f),
                      t.on("xhr-load-removed", p),
                      t.on("xhr-resolved", g),
                      t.on("addEventListener-end", m),
                      t.on("removeEventListener-end", v),
                      t.on("fn-end", w),
                      t.on("fetch-before-start", R),
                      t.on("fetch-start", x),
                      t.on("fn-start", b),
                      t.on("fetch-done", T));
                  })(e, this.ee, this.handler, this.dt),
                  this.importAggregator(e, () =>
                    i.e(478).then(i.bind(i, 3845)),
                  ));
              }
            }
            function Ee(e, t) {
              var r = (0, pe.D)(t),
                n = e.params || e;
              ((n.hostname = r.hostname),
                (n.port = r.port),
                (n.protocol = r.protocol),
                (n.host = r.hostname + ":" + r.port),
                (n.pathname = r.pathname),
                (e.parsedOrigin = r),
                (e.sameOrigin = r.sameOrigin));
            }
            const Ae = {},
              Se = ["pushState", "replaceState"];
            function _e(e) {
              const t = (function (e) {
                return (e || te.ee).get("history");
              })(e);
              return (
                !y.RI ||
                  Ae[t.debugId]++ ||
                  ((Ae[t.debugId] = 1),
                  (0, re.YM)(t).inPlace(window.history, Se, "-")),
                t
              );
            }
            var Ne = i(3738);
            function Oe(e) {
              p(
                u.BL,
                function (t = Date.now()) {
                  const r = t - y.WN;
                  (r < 0 && (0, l.R)(62, t),
                    (0, s.p)(
                      h.XG,
                      [u.BL, { time: r }],
                      void 0,
                      n.K7.metrics,
                      e.ee,
                    ),
                    e.addToTrace({ name: u.BL, start: t, origin: "nr" }),
                    (0, s.p)(
                      u.Pl + u.hG,
                      [r, u.BL],
                      void 0,
                      n.K7.genericEvents,
                      e.ee,
                    ));
                },
                e,
              );
            }
            const {
              He: Ie,
              bD: Pe,
              d3: je,
              Kp: ke,
              TZ: Ce,
              Lc: Le,
              uP: Me,
              Rz: He,
            } = Ne;
            class De extends E {
              static featureName = Ce;
              constructor(e) {
                var t;
                (super(e, Ce),
                  (t = e),
                  p(
                    u.U2,
                    function (e) {
                      if (!(e && "object" == typeof e && e.name && e.start))
                        return;
                      const r = {
                        n: e.name,
                        s: e.start - y.WN,
                        e: (e.end || e.start) - y.WN,
                        o: e.origin || "",
                        t: "api",
                      };
                      r.s < 0 || r.e < 0 || r.e < r.s
                        ? (0, l.R)(61, { start: r.s, end: r.e })
                        : (0, s.p)(
                            "bstApi",
                            [r],
                            void 0,
                            n.K7.sessionTrace,
                            t.ee,
                          );
                    },
                    t,
                  ),
                  Oe(e));
                if (!(0, R.V)(e.init)) return void this.deregisterDrain();
                const r = this.ee;
                let o;
                (_e(r),
                  (this.eventsEE = (0, ee.u)(r)),
                  this.eventsEE.on(Me, function (e, t) {
                    this.bstStart = (0, c.t)();
                  }),
                  this.eventsEE.on(Le, function (e, t) {
                    (0, s.p)(
                      "bst",
                      [e[0], t, this.bstStart, (0, c.t)()],
                      void 0,
                      n.K7.sessionTrace,
                      r,
                    );
                  }),
                  r.on(He + je, function (e) {
                    ((this.time = (0, c.t)()),
                      (this.startPath = location.pathname + location.hash));
                  }),
                  r.on(He + ke, function (e) {
                    (0, s.p)(
                      "bstHist",
                      [
                        location.pathname + location.hash,
                        this.startPath,
                        this.time,
                      ],
                      void 0,
                      n.K7.sessionTrace,
                      r,
                    );
                  }));
                try {
                  ((o = new PerformanceObserver((e) => {
                    const t = e.getEntries();
                    (0, s.p)(Ie, [t], void 0, n.K7.sessionTrace, r);
                  })),
                    o.observe({ type: Pe, buffered: !0 }));
                } catch (e) {}
                this.importAggregator(e, () => i.e(478).then(i.bind(i, 6974)), {
                  resourceObserver: o,
                });
              }
            }
            var Ke = i(6344);
            class Ue extends E {
              static featureName = Ke.TZ;
              #n;
              recorder;
              constructor(e) {
                var t;
                let r;
                (super(e, Ke.TZ),
                  (t = e),
                  p(
                    u.CH,
                    function () {
                      (0, s.p)(u.CH, [], void 0, n.K7.sessionReplay, t.ee);
                    },
                    t,
                  ),
                  (function (e) {
                    p(
                      u.Tb,
                      function () {
                        (0, s.p)(u.Tb, [], void 0, n.K7.sessionReplay, e.ee);
                      },
                      e,
                    );
                  })(e));
                try {
                  r = JSON.parse(
                    localStorage.getItem("".concat(S.H3, "_").concat(S.uh)),
                  );
                } catch (e) {}
                ((0, w.SR)(e.init) && this.ee.on(Ke.G4.RECORD, () => this.#i()),
                  this.#o(r) &&
                    this.importRecorder().then((e) => {
                      e.startRecording(Ke.Qb.PRELOAD, r?.sessionReplayMode);
                    }),
                  this.importAggregator(
                    this.agentRef,
                    () => i.e(478).then(i.bind(i, 6167)),
                    this,
                  ),
                  this.ee.on("err", (e) => {
                    this.blocked ||
                      (this.agentRef.runtime.isRecording &&
                        ((this.errorNoticed = !0),
                        (0, s.p)(
                          Ke.G4.ERROR_DURING_REPLAY,
                          [e],
                          void 0,
                          this.featureName,
                          this.ee,
                        )));
                  }));
              }
              #o(e) {
                return (
                  (e &&
                    (e.sessionReplayMode === S.g.FULL ||
                      e.sessionReplayMode === S.g.ERROR)) ||
                  (0, w.Aw)(this.agentRef.init)
                );
              }
              importRecorder() {
                return this.recorder
                  ? Promise.resolve(this.recorder)
                  : ((this.#n ??= Promise.all([i.e(478), i.e(249)])
                      .then(i.bind(i, 8589))
                      .then(
                        ({ Recorder: e }) => (
                          (this.recorder = new e(this)),
                          this.recorder
                        ),
                      )
                      .catch((e) => {
                        throw (
                          this.ee.emit("internal-error", [e]),
                          (this.blocked = !0),
                          e
                        );
                      })),
                    this.#n);
              }
              #i() {
                this.blocked ||
                  (this.featAggregate
                    ? this.featAggregate.mode !== S.g.FULL &&
                      this.featAggregate.initializeRecording(
                        S.g.FULL,
                        !0,
                        Ke.Qb.API,
                      )
                    : this.importRecorder().then(() => {
                        this.recorder.startRecording(Ke.Qb.API, S.g.FULL);
                      }));
              }
            }
            var Fe = i(3962);
            function We(e) {
              const t = e.ee.get("tracer");
              function r() {}
              p(
                u.dT,
                function (e) {
                  return new r().get("object" == typeof e ? e : {});
                },
                e,
              );
              const i = (r.prototype = {
                createTracer: function (r, i) {
                  var o = {},
                    a = this,
                    d = "function" == typeof i;
                  return (
                    (0, s.p)(
                      h.xV,
                      ["API/createTracer/called"],
                      void 0,
                      n.K7.metrics,
                      e.ee,
                    ),
                    e.runSoftNavOverSpa ||
                      (0, s.p)(
                        u.hw + "tracer",
                        [(0, c.t)(), r, o],
                        a,
                        n.K7.spa,
                        e.ee,
                      ),
                    function () {
                      if (
                        (t.emit(
                          (d ? "" : "no-") + "fn-start",
                          [(0, c.t)(), a, d],
                          o,
                        ),
                        d)
                      )
                        try {
                          return i.apply(this, arguments);
                        } catch (e) {
                          const r = "string" == typeof e ? new Error(e) : e;
                          throw (t.emit("fn-err", [arguments, this, r], o), r);
                        } finally {
                          t.emit("fn-end", [(0, c.t)()], o);
                        }
                    }
                  );
                },
              });
              ([
                "actionText",
                "setName",
                "setAttribute",
                "save",
                "ignore",
                "onEnd",
                "getContext",
                "end",
                "get",
              ].forEach((t) => {
                p.apply(this, [
                  t,
                  function () {
                    return (
                      (0, s.p)(
                        u.hw + t,
                        [(0, c.t)(), ...arguments],
                        this,
                        e.runSoftNavOverSpa ? n.K7.softNav : n.K7.spa,
                        e.ee,
                      ),
                      this
                    );
                  },
                  e,
                  i,
                ]);
              }),
                p(
                  u.PA,
                  function () {
                    e.runSoftNavOverSpa
                      ? (0, s.p)(
                          u.hw + "routeName",
                          [performance.now(), ...arguments],
                          void 0,
                          n.K7.softNav,
                          e.ee,
                        )
                      : (0, s.p)(
                          u.Pl + "routeName",
                          [(0, c.t)(), ...arguments],
                          this,
                          n.K7.spa,
                          e.ee,
                        );
                  },
                  e,
                ));
            }
            class Be extends E {
              static featureName = Fe.TZ;
              constructor(e) {
                if ((super(e, Fe.TZ), We(e), !y.RI || !(0, N.dV)().o.MO))
                  return;
                const t = _e(this.ee);
                Fe.tC.forEach((e) => {
                  (0, I.sp)(
                    e,
                    (e) => {
                      a(e);
                    },
                    !0,
                  );
                });
                const r = () =>
                  (0, s.p)(
                    "newURL",
                    [(0, c.t)(), "" + window.location],
                    void 0,
                    this.featureName,
                    this.ee,
                  );
                (t.on("pushState-end", r), t.on("replaceState-end", r));
                try {
                  this.removeOnAbort = new AbortController();
                } catch (e) {}
                (0, I.sp)(
                  "popstate",
                  (e) =>
                    (0, s.p)(
                      "newURL",
                      [e.timeStamp, "" + window.location],
                      void 0,
                      this.featureName,
                      this.ee,
                    ),
                  !0,
                  this.removeOnAbort?.signal,
                );
                let n = !1;
                const o = new ((0, N.dV)().o.MO)((e, t) => {
                    n ||
                      ((n = !0),
                      requestAnimationFrame(() => {
                        ((0, s.p)(
                          "newDom",
                          [(0, c.t)()],
                          void 0,
                          this.featureName,
                          this.ee,
                        ),
                          (n = !1));
                      }));
                  }),
                  a = (0, x.s)(
                    (e) => {
                      ((0, s.p)(
                        "newUIEvent",
                        [e],
                        void 0,
                        this.featureName,
                        this.ee,
                      ),
                        o.observe(document.body, {
                          attributes: !0,
                          childList: !0,
                          subtree: !0,
                          characterData: !0,
                        }));
                    },
                    100,
                    { leading: !0 },
                  );
                ((this.abortHandler = function () {
                  (this.removeOnAbort?.abort(),
                    o.disconnect(),
                    (this.abortHandler = void 0));
                }),
                  this.importAggregator(
                    e,
                    () => i.e(478).then(i.bind(i, 4393)),
                    { domObserver: o },
                  ));
              }
            }
            var Ge = i(7378);
            const Ve = {},
              ze = ["appendChild", "insertBefore", "replaceChild"];
            function Ze(e) {
              const t = (function (e) {
                return (e || te.ee).get("jsonp");
              })(e);
              if (!y.RI || Ve[t.debugId]) return t;
              Ve[t.debugId] = !0;
              var r = (0, re.YM)(t),
                n = /[?&](?:callback|cb)=([^&#]+)/,
                i = /(.*)\.([^.]+)/,
                o = /^(\w+)(\.|$)(.*)$/;
              function a(e, t) {
                if (!e) return t;
                const r = e.match(o),
                  n = r[1];
                return a(r[3], t[n]);
              }
              return (
                r.inPlace(Node.prototype, ze, "dom-"),
                t.on("dom-start", function (e) {
                  !(function (e) {
                    if (
                      !e ||
                      "string" != typeof e.nodeName ||
                      "script" !== e.nodeName.toLowerCase()
                    )
                      return;
                    if ("function" != typeof e.addEventListener) return;
                    var o = ((s = e.src), (c = s.match(n)), c ? c[1] : null);
                    var s, c;
                    if (!o) return;
                    var u = (function (e) {
                      var t = e.match(i);
                      if (t && t.length >= 3)
                        return { key: t[2], parent: a(t[1], window) };
                      return { key: e, parent: window };
                    })(o);
                    if ("function" != typeof u.parent[u.key]) return;
                    var d = {};
                    function l() {
                      (t.emit("jsonp-end", [], d),
                        e.removeEventListener("load", l, (0, I.jT)(!1)),
                        e.removeEventListener("error", f, (0, I.jT)(!1)));
                    }
                    function f() {
                      (t.emit("jsonp-error", [], d),
                        t.emit("jsonp-end", [], d),
                        e.removeEventListener("load", l, (0, I.jT)(!1)),
                        e.removeEventListener("error", f, (0, I.jT)(!1)));
                    }
                    (r.inPlace(u.parent, [u.key], "cb-", d),
                      e.addEventListener("load", l, (0, I.jT)(!1)),
                      e.addEventListener("error", f, (0, I.jT)(!1)),
                      t.emit("new-jsonp", [e.src], d));
                  })(e[0]);
                }),
                t
              );
            }
            const qe = {};
            function Xe(e) {
              const t = (function (e) {
                return (e || te.ee).get("promise");
              })(e);
              if (qe[t.debugId]) return t;
              qe[t.debugId] = !0;
              var r = t.context,
                n = (0, re.YM)(t),
                i = y.gm.Promise;
              return (
                i &&
                  (function () {
                    function e(r) {
                      var o = t.context(),
                        a = n(r, "executor-", o, null, !1);
                      const s = Reflect.construct(i, [a], e);
                      return (
                        (t.context(s).getCtx = function () {
                          return o;
                        }),
                        s
                      );
                    }
                    ((y.gm.Promise = e),
                      Object.defineProperty(e, "name", { value: "Promise" }),
                      (e.toString = function () {
                        return i.toString();
                      }),
                      Object.setPrototypeOf(e, i),
                      ["all", "race"].forEach(function (r) {
                        const n = i[r];
                        e[r] = function (e) {
                          let i = !1;
                          [...(e || [])].forEach((e) => {
                            this.resolve(e).then(a("all" === r), a(!1));
                          });
                          const o = n.apply(this, arguments);
                          return o;
                          function a(e) {
                            return function () {
                              (t.emit("propagate", [null, !i], o, !1, !1),
                                (i = i || !e));
                            };
                          }
                        };
                      }),
                      ["resolve", "reject"].forEach(function (r) {
                        const n = i[r];
                        e[r] = function (e) {
                          const r = n.apply(this, arguments);
                          return (
                            e !== r && t.emit("propagate", [e, !0], r, !1, !1),
                            r
                          );
                        };
                      }),
                      (e.prototype = i.prototype));
                    const o = i.prototype.then;
                    ((i.prototype.then = function (...e) {
                      var i = this,
                        a = r(i);
                      ((a.promise = i),
                        (e[0] = n(e[0], "cb-", a, null, !1)),
                        (e[1] = n(e[1], "cb-", a, null, !1)));
                      const s = o.apply(this, e);
                      return (
                        (a.nextPromise = s),
                        t.emit("propagate", [i, !0], s, !1, !1),
                        s
                      );
                    }),
                      (i.prototype.then[re.Jt] = o),
                      t.on("executor-start", function (e) {
                        ((e[0] = n(e[0], "resolve-", this, null, !1)),
                          (e[1] = n(e[1], "resolve-", this, null, !1)));
                      }),
                      t.on("executor-err", function (e, t, r) {
                        e[1](r);
                      }),
                      t.on("cb-end", function (e, r, n) {
                        t.emit("propagate", [n, !0], this.nextPromise, !1, !1);
                      }),
                      t.on("propagate", function (e, r, n) {
                        (this.getCtx && !r) ||
                          (this.getCtx = function () {
                            if (e instanceof Promise) var r = t.context(e);
                            return r && r.getCtx ? r.getCtx() : this;
                          });
                      }));
                  })(),
                t
              );
            }
            const Ye = {},
              $e = "setTimeout",
              Qe = "setInterval",
              Je = "clearTimeout",
              et = "-start",
              tt = [$e, "setImmediate", Qe, Je, "clearImmediate"];
            function rt(e) {
              const t = (function (e) {
                return (e || te.ee).get("timer");
              })(e);
              if (Ye[t.debugId]++) return t;
              Ye[t.debugId] = 1;
              var r = (0, re.YM)(t);
              return (
                r.inPlace(y.gm, tt.slice(0, 2), $e + "-"),
                r.inPlace(y.gm, tt.slice(2, 3), Qe + "-"),
                r.inPlace(y.gm, tt.slice(3), Je + "-"),
                t.on(Qe + et, function (e, t, n) {
                  e[0] = r(e[0], "fn-", null, n);
                }),
                t.on($e + et, function (e, t, n) {
                  ((this.method = n),
                    (this.timerDuration = isNaN(e[1]) ? 0 : +e[1]),
                    (e[0] = r(e[0], "fn-", this, n)));
                }),
                t
              );
            }
            const nt = {};
            function it(e) {
              const t = (function (e) {
                return (e || te.ee).get("mutation");
              })(e);
              if (!y.RI || nt[t.debugId]) return t;
              nt[t.debugId] = !0;
              var r = (0, re.YM)(t),
                n = y.gm.MutationObserver;
              return (
                n &&
                  ((window.MutationObserver = function (e) {
                    return this instanceof n
                      ? new n(r(e, "fn-"))
                      : n.apply(this, arguments);
                  }),
                  (MutationObserver.prototype = n.prototype)),
                t
              );
            }
            const {
              TZ: ot,
              d3: at,
              Kp: st,
              $p: ct,
              wW: ut,
              e5: dt,
              tH: lt,
              uP: ft,
              rw: ht,
              Lc: pt,
            } = Ge;
            class gt extends E {
              static featureName = ot;
              constructor(e) {
                if ((super(e, ot), We(e), !y.RI)) return;
                try {
                  this.removeOnAbort = new AbortController();
                } catch (e) {}
                let t,
                  r = 0;
                const n = this.ee.get("tracer"),
                  o = Ze(this.ee),
                  a = Xe(this.ee),
                  u = rt(this.ee),
                  d = oe(this.ee),
                  l = this.ee.get("events"),
                  f = he(this.ee),
                  h = _e(this.ee),
                  p = it(this.ee);
                function g(e, t) {
                  h.emit("newURL", ["" + window.location, t]);
                }
                function m() {
                  (r++, (t = window.location.hash), (this[ft] = (0, c.t)()));
                }
                function v() {
                  (r--, window.location.hash !== t && g(0, !0));
                  var e = (0, c.t)();
                  ((this[dt] = ~~this[dt] + e - this[ft]), (this[pt] = e));
                }
                function b(e, t) {
                  e.on(t, function () {
                    this[t] = (0, c.t)();
                  });
                }
                (this.ee.on(ft, m),
                  a.on(ht, m),
                  o.on(ht, m),
                  this.ee.on(pt, v),
                  a.on(ut, v),
                  o.on(ut, v),
                  this.ee.on("fn-err", (...t) => {
                    t[2]?.__newrelic?.[e.agentIdentifier] ||
                      (0, s.p)(
                        "function-err",
                        [...t],
                        void 0,
                        this.featureName,
                        this.ee,
                      );
                  }),
                  this.ee.buffer([ft, pt, "xhr-resolved"], this.featureName),
                  l.buffer([ft], this.featureName),
                  u.buffer(
                    ["setTimeout" + st, "clearTimeout" + at, ft],
                    this.featureName,
                  ),
                  d.buffer([ft, "new-xhr", "send-xhr" + at], this.featureName),
                  f.buffer(
                    [lt + at, lt + "-done", lt + ct + at, lt + ct + st],
                    this.featureName,
                  ),
                  h.buffer(["newURL"], this.featureName),
                  p.buffer([ft], this.featureName),
                  a.buffer(
                    ["propagate", ht, ut, "executor-err", "resolve" + at],
                    this.featureName,
                  ),
                  n.buffer([ft, "no-" + ft], this.featureName),
                  o.buffer(
                    ["new-jsonp", "cb-start", "jsonp-error", "jsonp-end"],
                    this.featureName,
                  ),
                  b(f, lt + at),
                  b(f, lt + "-done"),
                  b(o, "new-jsonp"),
                  b(o, "jsonp-end"),
                  b(o, "cb-start"),
                  h.on("pushState-end", g),
                  h.on("replaceState-end", g),
                  window.addEventListener(
                    "hashchange",
                    g,
                    (0, I.jT)(!0, this.removeOnAbort?.signal),
                  ),
                  window.addEventListener(
                    "load",
                    g,
                    (0, I.jT)(!0, this.removeOnAbort?.signal),
                  ),
                  window.addEventListener(
                    "popstate",
                    function () {
                      g(0, r > 1);
                    },
                    (0, I.jT)(!0, this.removeOnAbort?.signal),
                  ),
                  (this.abortHandler = this.#r),
                  this.importAggregator(e, () =>
                    i.e(478).then(i.bind(i, 5592)),
                  ));
              }
              #r() {
                (this.removeOnAbort?.abort(), (this.abortHandler = void 0));
              }
            }
            var mt = i(3333);
            class vt extends E {
              static featureName = mt.TZ;
              constructor(e) {
                super(e, mt.TZ);
                const t = [
                  e.init.page_action.enabled,
                  e.init.performance.capture_marks,
                  e.init.performance.capture_measures,
                  e.init.user_actions.enabled,
                  e.init.performance.resources.enabled,
                ];
                var r;
                if (
                  ((r = e),
                  p(u.hG, (e, t) => z(e, t, r), r),
                  (function (e) {
                    p(
                      u.fF,
                      function () {
                        (0, s.p)(
                          u.Pl + u.fF,
                          [(0, c.t)(), ...arguments],
                          void 0,
                          n.K7.genericEvents,
                          e.ee,
                        );
                      },
                      e,
                    );
                  })(e),
                  Oe(e),
                  Z(e),
                  (function (e) {
                    p(
                      u.V1,
                      function (t, r) {
                        const i = (0, c.t)(),
                          { start: o, end: a, customAttributes: d } = r || {},
                          f = { customAttributes: d || {} };
                        if (
                          "object" != typeof f.customAttributes ||
                          "string" != typeof t ||
                          0 === t.length
                        )
                          return void (0, l.R)(57);
                        const h = (e, t) =>
                          null == e
                            ? t
                            : "number" == typeof e
                              ? e
                              : e instanceof PerformanceMark
                                ? e.startTime
                                : Number.NaN;
                        if (
                          ((f.start = h(o, 0)),
                          (f.end = h(a, i)),
                          Number.isNaN(f.start) || Number.isNaN(f.end))
                        )
                          (0, l.R)(57);
                        else {
                          if (
                            ((f.duration = f.end - f.start), !(f.duration < 0))
                          )
                            return (
                              (0, s.p)(
                                u.Pl + u.V1,
                                [f, t],
                                void 0,
                                n.K7.genericEvents,
                                e.ee,
                              ),
                              f
                            );
                          (0, l.R)(58);
                        }
                      },
                      e,
                    );
                  })(e),
                  y.RI &&
                    (e.init.user_actions.enabled &&
                      (mt.Zp.forEach((e) =>
                        (0, I.sp)(
                          e,
                          (e) =>
                            (0, s.p)(
                              "ua",
                              [e],
                              void 0,
                              this.featureName,
                              this.ee,
                            ),
                          !0,
                        ),
                      ),
                      mt.qN.forEach((e) => {
                        const t = (0, x.s)(
                          (e) => {
                            (0, s.p)(
                              "ua",
                              [e],
                              void 0,
                              this.featureName,
                              this.ee,
                            );
                          },
                          500,
                          { leading: !0 },
                        );
                        (0, I.sp)(e, t);
                      })),
                    e.init.performance.resources.enabled &&
                      y.gm.PerformanceObserver?.supportedEntryTypes.includes(
                        "resource",
                      )))
                ) {
                  new PerformanceObserver((e) => {
                    e.getEntries().forEach((e) => {
                      (0, s.p)(
                        "browserPerformance.resource",
                        [e],
                        void 0,
                        this.featureName,
                        this.ee,
                      );
                    });
                  }).observe({ type: "resource", buffered: !0 });
                }
                t.some((e) => e)
                  ? this.importAggregator(e, () =>
                      i.e(478).then(i.bind(i, 8019)),
                    )
                  : this.deregisterDrain();
              }
            }
            var bt = i(2646);
            const yt = new Map();
            function wt(e, t, r, n) {
              if (
                "object" != typeof t ||
                !t ||
                "string" != typeof r ||
                !r ||
                "function" != typeof t[r]
              )
                return (0, l.R)(29);
              const i = (function (e) {
                  return (e || te.ee).get("logger");
                })(e),
                o = (0, re.YM)(i),
                a = new bt.y(te.P);
              ((a.level = n.level), (a.customAttributes = n.customAttributes));
              const s = t[r]?.[re.Jt] || t[r];
              return (
                yt.set(s, a),
                o.inPlace(t, [r], "wrap-logger-", () => yt.get(s)),
                i
              );
            }
            var Rt = i(1910);
            class xt extends E {
              static featureName = B.TZ;
              constructor(e) {
                var t;
                (super(e, B.TZ),
                  (t = e),
                  p(u.$9, (e, r) => V(e, r, t), t),
                  (function (e) {
                    p(
                      u.Wb,
                      (
                        t,
                        r,
                        { customAttributes: n = {}, level: i = B.p_.INFO } = {},
                      ) => {
                        wt(e.ee, t, r, { customAttributes: n, level: i });
                      },
                      e,
                    );
                  })(e),
                  Z(e));
                const r = this.ee;
                (["log", "error", "warn", "info", "debug", "trace"].forEach(
                  (e) => {
                    ((0, Rt.i)(y.gm.console[e]),
                      wt(r, y.gm.console, e, {
                        level: "log" === e ? "info" : e,
                      }));
                  },
                ),
                  this.ee.on("wrap-logger-end", function ([e]) {
                    const { level: t, customAttributes: n } = this;
                    (0, G.R)(r, e, n, t);
                  }),
                  this.importAggregator(e, () =>
                    i.e(478).then(i.bind(i, 5288)),
                  ));
              }
            }
            new (class extends r {
              constructor(e) {
                var t;
                (super(), y.gm)
                  ? ((this.features = {}),
                    (0, N.bQ)(this.agentIdentifier, this),
                    (this.desiredFeatures = new Set(e.features || [])),
                    this.desiredFeatures.add(_),
                    (this.runSoftNavOverSpa = [...this.desiredFeatures].some(
                      (e) => e.featureName === n.K7.softNav,
                    )),
                    (0, a.j)(this, e, e.loaderType || "agent"),
                    (t = this),
                    p(
                      u.cD,
                      function (e, r, n = !1) {
                        if ("string" == typeof e) {
                          if (
                            ["string", "number", "boolean"].includes(
                              typeof r,
                            ) ||
                            null === r
                          )
                            return g(t, e, r, u.cD, n);
                          (0, l.R)(40, typeof r);
                        } else (0, l.R)(39, typeof e);
                      },
                      t,
                    ),
                    (function (e) {
                      p(
                        u.Dl,
                        function (t) {
                          if ("string" == typeof t || null === t)
                            return g(e, "enduser.id", t, u.Dl, !0);
                          (0, l.R)(41, typeof t);
                        },
                        e,
                      );
                    })(this),
                    (function (e) {
                      p(
                        u.nb,
                        function (t) {
                          if ("string" == typeof t || null === t)
                            return g(e, "application.version", t, u.nb, !1);
                          (0, l.R)(42, typeof t);
                        },
                        e,
                      );
                    })(this),
                    (function (e) {
                      p(
                        u.d3,
                        function () {
                          e.ee.emit("manual-start-all");
                        },
                        e,
                      );
                    })(this),
                    this.run())
                  : (0, l.R)(21);
              }
              get config() {
                return {
                  info: this.info,
                  init: this.init,
                  loader_config: this.loader_config,
                  runtime: this.runtime,
                };
              }
              get api() {
                return this;
              }
              run() {
                try {
                  const e = (function (e) {
                      const t = {};
                      return (
                        o.forEach((r) => {
                          t[r] = !!e[r]?.enabled;
                        }),
                        t
                      );
                    })(this.init),
                    t = [...this.desiredFeatures];
                  (t.sort((e, t) => n.P3[e.featureName] - n.P3[t.featureName]),
                    t.forEach((t) => {
                      if (
                        !e[t.featureName] &&
                        t.featureName !== n.K7.pageViewEvent
                      )
                        return;
                      if (this.runSoftNavOverSpa && t.featureName === n.K7.spa)
                        return;
                      if (
                        !this.runSoftNavOverSpa &&
                        t.featureName === n.K7.softNav
                      )
                        return;
                      const r = (function (e) {
                        switch (e) {
                          case n.K7.ajax:
                            return [n.K7.jserrors];
                          case n.K7.sessionTrace:
                            return [n.K7.ajax, n.K7.pageViewEvent];
                          case n.K7.sessionReplay:
                            return [n.K7.sessionTrace];
                          case n.K7.pageViewTiming:
                            return [n.K7.pageViewEvent];
                          default:
                            return [];
                        }
                      })(t.featureName).filter((e) => !(e in this.features));
                      (r.length > 0 &&
                        (0, l.R)(36, {
                          targetFeature: t.featureName,
                          missingDependencies: r,
                        }),
                        (this.features[t.featureName] = new t(this)));
                    }));
                } catch (e) {
                  (0, l.R)(22, e);
                  for (const e in this.features)
                    this.features[e].abortHandler?.();
                  const t = (0, N.Zm)();
                  (delete t.initializedAgents[this.agentIdentifier]?.features,
                    delete this.sharedAggregator);
                  return (t.ee.get(this.agentIdentifier).abort(), !1);
                }
              }
            })({
              features: [Te, _, j, De, Ue, k, q, vt, xt, Be, gt],
              loaderType: "spa",
            });
          })());
      })();
    </script>
    <meta name="Application-Name" content="Holiganbet" />

    <link
      href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:400,600,700"
      rel="stylesheet"
      type="text/css"
    />
    <link
      rel="preload"
      href="/static/css/common-d84be9782d9443a05473.css"
      as="style"
    />
    <link
      rel="preload"
      href="/static/css/bundle-32dae487fc5a692a88cb.css"
      as="style"
    />
    <link
      rel="preload"
      href="/static/js/common-ded926c5f41ec202a818.js"
      as="script"
    />

    <link
      rel="preload"
      href="/static/js/lang-tr-6b1c0150c9b96d66ec21.js"
      as="script"
    />
    <link
      rel="preload"
      href="/static/js/bundle-35bddaf45533280177d5.js"
      as="script"
    />
    <link
      rel="preload"
      href="/static/js/svg-198d9f8abeb26db3a611.js"
      as="script"
    />
    <link rel="preconnect" href="https://challenges.cloudflare.com" />
    <link rel="dns-prefetch" href="https://challenges.cloudflare.com" />

    <script>
      window.customBuildVars = {
        appName: "holiganbet-prod",
        appVersion: "1.0.820",
        disableBrowserConsole: false,
      };
    </script>

    <link
      rel="stylesheet"
      type="text/css"
      href="/static/css/common-d84be9782d9443a05473.css"
    />
    <link
      rel="stylesheet"
      type="text/css"
      href="/static/css/bundle-32dae487fc5a692a88cb.css"
    />

    <script>
      /* eslint-disable */
      (function (window) {
        if (window) {
          var startOffset = Date.now ? Date.now() : +new Date(),
            performance = window.performance || {},
            _entries = [],
            _marksIndex = {},
            _filterEntries = function (key, value) {
              var i = 0,
                n = _entries.length,
                result = [];
              for (; i < n; i++) {
                if (_entries[i][key] == value) {
                  result.push(_entries[i]);
                }
              }
              return result;
            },
            _clearEntries = function (type, name) {
              var i = _entries.length,
                entry;
              while (i--) {
                entry = _entries[i];
                if (
                  entry.entryType == type &&
                  (name === void 0 || entry.name == name)
                ) {
                  _entries.splice(i, 1);
                }
              }
            };
          if (!performance.now) {
            performance.now =
              performance.webkitNow ||
              performance.mozNow ||
              performance.msNow ||
              function () {
                return (Date.now ? Date.now() : +new Date()) - startOffset;
              };
          }
          if (!performance.mark) {
            performance.mark =
              performance.webkitMark ||
              function (name) {
                var mark = {
                  name: name,
                  entryType: "mark",
                  startTime: performance.now(),
                  duration: 0,
                };
                _entries.push(mark);
                _marksIndex[name] = mark;
              };
          }
          if (!performance.measure) {
            performance.measure =
              performance.webkitMeasure ||
              function (name, startMark, endMark) {
                if (_marksIndex[startMark] && _marksIndex[endMark]) {
                  startMark = _marksIndex[startMark].startTime;
                  endMark = _marksIndex[endMark].startTime;

                  _entries.push({
                    name: name,
                    entryType: "measure",
                    startTime: startMark,
                    duration: endMark - startMark,
                  });
                }
              };
          }
          if (!performance.getEntriesByType) {
            performance.getEntriesByType =
              performance.webkitGetEntriesByType ||
              function (type) {
                return _filterEntries("entryType", type);
              };
          }
          if (!performance.getEntriesByName) {
            performance.getEntriesByName =
              performance.webkitGetEntriesByName ||
              function (name) {
                return _filterEntries("name", name);
              };
          }
          if (!performance.clearMarks) {
            performance.clearMarks =
              performance.webkitClearMarks ||
              function (name) {
                _clearEntries("mark", name);
              };
          }
          if (!performance.clearMeasures) {
            performance.clearMeasures =
              performance.webkitClearMeasures ||
              function (name) {
                _clearEntries("measure", name);
              };
          }
          // exports
          window.performance = performance;

          if (typeof define === "function" && (define.amd || define.ajs)) {
            define("performance", [], function () {
              return performance;
            });
          }
        }
      })(typeof window !== "undefined" ? window : null);
      /* eslint-enable */

      /* eslint-disable */
      var perfSession = {
        initialTimestamp: Date.now(),
        serverTiming: [],
        cache: { type: "INC", time: "-" },
        initialRequestTimestamp: performance.timeOrigin
          ? performance.timeOrigin
          : Date.now() - performance.now(),
        addMark: (function () {
          var prevMark = "fetchStart";

          return function (name, code) {
            if (name && performance.mark) {
              var mark =
                name + " (mark " + code + ") - " + perfSession.getNetwork();

              performance.mark(mark);

              if (performance.measure) {
                performance.measure("\u2B50" + mark, prevMark, mark);
              }

              prevMark = mark;
            }
          };
        })(),
        getNetwork: function () {
          return (
            (navigator.connection && navigator.connection.effectiveType) ||
            "unknown"
          );
        },
      };

      perfSession.addMark("Init", 1);

      (function () {
        if (window.PerformanceServerTiming) {
          var navItems = performance.getEntriesByType("navigation");

          if (navItems && navItems[0] && navItems[0].serverTiming) {
            perfSession.serverTiming = navItems[0].serverTiming;
          }
        }
      })();
    </script>

    <meta name="author" content="Holiganbet 1155" />
    <meta
      name="apple-mobile-web-app-title"
      content="Holiganbet 1155 - holiganbet1155 - holiganbet1155.com - Holiganbet Giriş 2025 - Holiganbet Resmi Giriş Sayfası Holiganbet: Hızlı para çekimi, yüksek oranlar, 7/24 canlı destek ve Curaçao lisansı. Holiganbet giriş yaparak sorumlu oyun deneyimi yaşayın."
    />
    <meta name="HandheldFriendly" content="true" />
    <meta name="Robots" content="index, follow" />
    <meta
      name="viewport"
      content="width=device-width,minimum-scale=1,initial-scale=1,maximum-scale=1,user-scalable=no,viewport-fit=cover"
    />
    <meta name="mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black" />
    <link
      rel="search"
      type="application/opensearchdescription+xml"
      href="/static/xml/opensearch.xml"
      title="Search the Operator"
    />

    <style type="text/css">
      body,
      html {
        font-size: 10px;
      }
      .MRIExpand {
        width: 100%;
        max-height: calc(100vh - env(safe-area-inset-top) - 3rem);
        overflow: auto;
        position: fixed;
        top: 0;
        padding-top: calc(env(safe-area-inset-top) + 3rem);
        background-color: #fff;
        z-index: 9999;
      }

      .MRIExpand.Hidden {
        display: none;
      }

      .MRIExpand table {
        width: 100%;
      }

      .MRIExpand table tr:nth-child(odd) {
        background-color: #dedede;
      }

      .MRIExpand table tr:nth-child(even) {
        background-color: #ccc;
      }

      .MRIExpand table td,
      .MRIExpand table th {
        padding: 0.1rem 0.5rem;
        border-collapse: collapse;
        border: 1px solid #b3b3b3;
      }

      .MRIExpand .MRIClose {
        position: absolute;
        right: 0;
        background: 0 0;
        font-size: 18px;
        border-radius: 5rem;
        width: 3rem;
        height: 3rem;
        line-height: 14px;
        top: calc(env(safe-area-inset-top) + 0px);
        padding: 0;
      }

      .RootContent {
        position: relative;
        min-height: 100vh;
      }

      .BrowserUpgrade {
        display: block;
        padding: 1rem;
        background: #fff;
        color: #000;
        border: 1px solid #f33;
      }

      /* Page Spinner splash screen */
      #PageSpinner {
        position: fixed;
        margin: 0;
        padding: 0;
        display: flex;
        justify-content: center;
        align-items: center;
        width: 100%;
        height: 100vh;
        background: var(--PageSpinner-background);
        z-index: 9999999;
        visibility: visible;
        opacity: 1;
      }

      #PageSpinner.Hide {
        visibility: hidden;
        opacity: 0;
        transition:
          visibility 0.3s linear,
          opacity 0.3s linear;
      }

      #PageSpinner .MainIcon {
        display: block;
        width: 150px;
        position: absolute;
        z-index: 10;
      }

      #PageSpinner .LoadingScreen {
        position: relative;
        width: 250px;
        height: 250px;
        border-radius: 50%;
        background: linear-gradient(
          var(--LoadingScreen-color-from),
          var(--LoadingScreen-color-to)
        );
        animation: animateLoadingScreen 1.2s linear infinite;
        transform: translateZ(0);
        will-change: transform;
      }

      @keyframes animateLoadingScreen {
        0% {
          transform: rotate(0deg);
        }

        100% {
          transform: rotate(360deg);
        }
      }

      #PageSpinner .LoadingScreen span {
        position: absolute;
        width: 100%;
        height: 100%;
        border-radius: 50%;
        background: linear-gradient(
          var(--LoadingScreen-color-from),
          var(--LoadingScreen-color-to)
        );
      }

      #PageSpinner .LoadingScreen span:nth-child(1) {
        filter: blur(5px);
      }

      #PageSpinner .LoadingScreen span:nth-child(2) {
        filter: blur(10px);
      }

      #PageSpinner .LoadingScreen span:nth-child(3) {
        filter: blur(25px);
      }

      #PageSpinner .LoadingScreen span:nth-child(4) {
        filter: blur(100px);
      }

      #PageSpinner .LoadingScreen:after {
        content: "";
        position: absolute;
        top: 10px;
        left: 10px;
        right: 10px;
        bottom: 10px;
        background: var(--Circle-background);
        border-radius: 50%;
        opacity: 0.9;
      }

      #PageSpinner .SpinnerWrapper {
        z-index: 1;
        position: absolute;
      }

      .CircleBorder {
        width: 220px;
        height: 220px;
        padding: 4px;
        display: flex;
        justify-content: center;
        align-items: center;
        border-radius: 50%;
        background: var(--Circle-color);
        background: linear-gradient(
          0deg,
          rgba(128, 128, 128, 0.1) 33%,
          var(--Circle-color) 100%
        );
        animation: spin 1.1s linear 0s infinite;
        transform: translateZ(0);
        will-change: transform;
      }

      @keyframes spin {
        from {
          transform: rotate(0);
        }
        to {
          transform: rotate(359deg);
        }
      }

      .SpinnerContainer {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%) rotate(-90deg);
        overflow: visible !important;

        width: 300px;
        height: 300px;
        display: flex;
        justify-content: center;
        align-items: center;
        background-color: transparent;
        z-index: -1;
      }

      .CircleCore {
        width: 100%;
        height: 100%;
        background-color: var(--Circle-background);
        border-radius: 50%;
      }

      .AppVersion {
        position: absolute;
        bottom: 0.5rem;
        left: 50%;
        transform: translateX(-50%);
        font-size: 10px;
        color: #fff;
        text-shadow: 1px 1px 1px #000;
        z-index: 5;
      }

      .LoadingScreen .AppVersion {
        position: fixed;
      }
    </style>
    <style type="text/css">
      :root {
        --PageSpinner-background: #171c2c;
        --Circle-background: #171c2c;
        --LoadingScreen-color-from: #ffcd36;
        --LoadingScreen-color-to: #fff;
        --Circle-color: rgba(265, 205, 54, 1);
      }
    </style>

    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script
      async=""
      src="https://www.googletagmanager.com/gtag/js?id=UA-174265272-1"
    ></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag() {
        dataLayer.push(arguments);
      }
      gtag("js", new Date());

      gtag("config", "UA-174265272-1");
    </script>

    <title>
      Holiganbet 1155 - holiganbet1155 - holiganbet1155.com - Holiganbet Giriş 2025 - Holiganbet Resmi Giriş Sayfası Holiganbet: Hızlı para çekimi, yüksek oranlar, 7/24 canlı destek ve Curaçao lisansı. Holiganbet giriş yaparak sorumlu oyun deneyimi yaşayın.
    </title>
    <meta
      name="description"
      content=Holiganbet 1155 - holiganbet1155 - holiganbet1155.com - Holiganbet Giriş 2025 - Holiganbet Resmi Giriş Sayfası Holiganbet: Hızlı para çekimi, yüksek oranlar, 7/24 canlı destek ve Curaçao lisansı. Holiganbet giriş yaparak sorumlu oyun deneyimi yaşayın."
    />
    <meta
      name="keywords"
      content="Yüksek Bahis Oranları, Canlı Bahisler, Casino Oyunları"
    />

    <link
      rel="shortcut icon"
      sizes="32x32"
      href="/static/img/favicon-32x32.png"
      type="image/png"
    />
    <link
      rel="icon"
      sizes="16x16"
      href="/static/img/favicon-16x16.png"
      type="image/png"
    />
    <link
      rel="apple-touch-icon"
      sizes="180x180"
      href="/static/img/apple-touch-icon.png"
    />
    <link
      rel="icon"
      type="image/png"
      href="/static/img/android-chrome-192x192.png"
    />
    <link
      rel="mask-icon"
      href="/static/img/safari-pinned-tab.svg"
      color="#000000"
    />
    <link rel="icon" href="/static/img/favicon.ico" />
    <meta
      name="msapplication-TileImage"
      content="/static/img/mstile-150x150.png"
    />
    <meta name="msapplication-TileColor" content="#171c2c" />
    <meta name="theme-color" content="#171c2c" />
    <link rel="manifest" href="/static/xml/site.webmanifest" />

    <script
      src="https://challenges.cloudflare.com/turnstile/v0/api.js"
      async=""
    ></script>

    <link
      rel="alternate"
      hreflang="en"
      href="/en/sports"
    />
    <link
      rel="alternate"
      hreflang="tr"
      href="/sports"
    />
    <link
      rel="alternate"
      hreflang="x-default"
      href="/sports"
    />
    <meta property="og:type" content="website" />
    <meta
      property="og:title"
      content="Holiganbet 1155 - holiganbet1155 - holiganbet1155.com - Holiganbet Giriş 2025 - Holiganbet Resmi Giriş Sayfası Holiganbet: Hızlı para çekimi, yüksek oranlar, 7/24 canlı destek ve Curaçao lisansı. Holiganbet giriş yaparak sorumlu oyun deneyimi yaşayın."
    />
    <meta
      property="og:description"
      content="Holiganbet 1155 - holiganbet1155 - holiganbet1155.com - Holiganbet Giriş 2025 - Holiganbet Resmi Giriş Sayfası Holiganbet: Hızlı para çekimi, yüksek oranlar, 7/24 canlı destek ve Curaçao lisansı. Holiganbet giriş yaparak sorumlu oyun deneyimi yaşayın.."
    />
    <meta property="og:image" content="/static/img/apple-touch-icon.png" />
    <meta property="og:image:width" content="192" />
    <meta property="og:image:height" content="192" />
    <meta property="og:url" content="/sports" />
    <script type="application/ld+json">
      {"@context":"https://schema.org","@type":"Casino","name":"Holiganbet: Canlı Bahis ve Casino'nun Adresi - Holiganbet Giriş","url":"","description":"Holiganbet, spor bahisleri ve casino alanında hizmet veren en köklü bahis
              sitesi! Holiganbet giriş yapın ve kazanmaya hemen başlayın.","address":"-","image":["/static/img/apple-touch-icon.png"],"isAccessibleForFree":false,"keywords":"Yüksek Bahis Oranları, Canlı Bahisler, Casino Oyunları","areaServed":[{"@type":"Country","name":"Turkey"}],"acceptsPlayers":"TR","mainEntityOfPage":"","termsOfService":"/terms-conditions","license":"Holiganbet,
              a Coinbar NV brand, operates online e-gaming operations with legal authority under the GCB (OGL/2024/920/0382) License approved by the Curaçao Government. Please gamble responsibly. Holiganbet is not suitable for minors under the age of 18 to
              open an account or play. Holiganbet™ 2025 I All Rights Reserved.","paymentAccepted":["Credit Card","Cryptocurrency","Local Exchange Tradings System"],"currenciesAccepted":[],"sameAs":["https://twitter.com/holiganguncel","http://dub.pro/holiguncel","https://t.me/holigantg"]}
    </script>
    <style data-emotion=""></style>
    <link
      rel="stylesheet"
      href="/content/static/omfe-widgets/p/widgets/1.29.16/widgets.min.css"
    />
    <script src="/content/static/omfe-widgets/p/widgets/1.29.16/widgets.min.js"></script>
    <meta name="applicationName" content="Holiganbet" />
    <meta name="msApplicationTileColor" content="#171c2c" />
    <link
      href="/api/bm/assets/widgets/0.24.1/index.html"
      rel="import"
    />
    <script
      async=""
      type="text/javascript"
      src="https://cdn.livechatinc.com/tracking.js"
    ></script>
  </head>



  <body
    itemscope=""
    itemtype="http://schema.org/WebPage"
    dir="ltr"
    class="Page-RoundedStyleSports Page-Sports Page-Home Page-Casino Page-SportsSource Body iOSDevice HasMobileBottomNavigation"
    data-reactroot=""
  >
    <a class="Hidden SkipLink" href="#content">Sayfa içeriğine ilerle</a>
    <div class="">
    </div>
    <div id="PageSpinner" class="Hide">
      <span class="SvgIcon MainIcon"
        ><!--?xml version="1.0" encoding="utf-8"?--><svg
          xmlns="http://www.w3.org/2000/svg"
          xmlns:xlink="http://www.w3.org/1999/xlink"
          version="1.1"
          x="0px"
          y="0px"
          viewBox="0 0 219.3 119.4"
          style="enable-background: new 0 0 219.3 119.4"
          xml:space="preserve"
        >
          <image
            style="overflow: visible"
            width="219"
            height="119"
            xlink:href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAANsAAAB3CAYAAACKXTXVAAAgAElEQVR4XuxdB3iV1d3/vfPulb0n EDYBAohstbhYDqza9nNbq7Wt1dplx6fVr7uu1tZRtWqtWkVARXGwlRVGgJAAgZA9b+6+993fc96b kIQk5CYEBc15njzRcN6zf+f/P/9JYbicUyswc+ZyU5iNfFvVKAdnNDxa/NEb3nNqAl/hwVJf4bmf M1OfPGtJGhgUCYr6tWZBu1zUtFyycSaaqkky0v80UtrL2za+c/icmdBXdKDDYDtLNn7C7MtdHMVk qhoKZGCcqGrZmookr6xktCraWB5gx9l5XJ5N44r8gD7qZw/Y8HJFBB5FQ46J2WSm6MM8i400jS27 1q86cpZMbXgY7SswDLYzdBSmXrTcIathKwTKyXCwUdBYRWXsNFSrrFHxiqqlSBqVGlHUrJCiZfhU ZKuaanUyNJw8jWQjjQIng8kJKiYmiMhzhGHn5R6jDSs0ttbbsfIYh+2NEpoEFS2KijiGPuhkqRIL S5fRNA6zNF2r0aimVTEo8LK/ZO3aEADtDE1/uNleVmAYbEN0LKbMXjZVhLrIJ6nzQoqWF9Y0p6Jq dloDRQMgPwwAltLZP9g4GmlmBvl2Grl2IN8hI8MmIsUiwWaUwdK944BiNGhK79umAnCHORzxmlHu 5rGvhUG5V4VbUCFrpD0KFCADmo+mENQoeBhQR1hK3aMx1EaVD+0oWbs2OERLMtzMSSswDLbTOBJT py42U3bmUm9EubsioszLNNCYl8RhrENFhlVDvFmB06zCyiswm1QYWBUGgwKOVfUfMBoIeCiGiv43 qwEEnQyif2dV/TdBKcWoUAUGkSNGqKHotjE2VQeeFqagY6m97GnjUOal0RbR4BU1uCNAU1CDBhqq SkNSKUgKDVmlEZYYRBQagkITILYaWPVdSsNqXhTXbtu2xncayzP86TDYhuYMFM1dcnOToP6mSlBS L3DxuGeShJkZARjsKliHAtqqgDEqoAxRUA24yBRUkYEm0lBFGlqYhiYDFKeBNqlgbDIooxJtVgPU EAvFz0Lx0RA9LI75GNSEaNQFKdQFNdT4FYTk3sdBgCqrDAIih6agASGJAUdrbp5WHtq1afWjAx77 8Ae9rsAwZRvgwZg69XZOMte/VBZSvn51igF3TgyjcIQfXKIMxinqYPjCi0pBbuMhtzBQQzRUIbrN jQKDwz4GB9xAmbtv8EVkFg0BM7wRFgZGXcWAuaN401v1X/i8zvEBDINtgBs4YfaS/ftD0rh35tOY O9ID4wgBtLWn4GKAzZ7Z6nIUfGI9d4IFVTRgWyuPTxuAI21yr5KSoMCj3G0jgGvjKHX+rk2rSs7s QL/crQ+DbQD7O2n20hV7g+KynZerGJ0bgKkgNDgWcQB9DnVVqdYEoZrt1mxDhMHrxxgcaOl5aZB3 3eFWO2SVEsyMNnLHxpXVQz2mr0p7w2CLcaenz1/26+0e4VdvzWWxcJIbptEhXZhxLpbeAEfm8eox HutregJOUSmUNLoIhaso2bxyxLk457NhzMNgi2EXpsy9YkyJP1L687FG3DerGeYJQYBIDs/VogHB XVZoUs/tf2Qvh+O+dsFLl/kJMoNDrXZwtPrqnk2rrj9Xp/5FjnsYbDGs/siZi/cqmjax+Os+WMaF wdikGL46u6sIR8yQWojmr3vZ2MTjlfLe36AtQTPqAkaYDNqI4k/erji7Z3j2jW4YbP3sSeGcJY9U h+WfblgkIX9sAHxm+OzbxUGMSDxuhljfE2xvVxuwprL3y8QbMeCYxwIjr03es/7tPYPo9iv9yTDY +tn+9OmXi1flGLiHZjbDMjEEytyTxToXT5BYY4JY011QUu7n8ESJAomYovRSylscUFQcLdm8Kv9c nPMXPeZhsPWzA2NnLTmialr+c/NFTMwKwDwudG6/19rnK1aZINZ1gq3Mx+GpAyoifSi+PeEoVbNy 0sXFG99Z+0Uf3HOx/2Gw9bNrU+cunRCQ1OfLg+LUtRcxOH+cF6ax5775oHDMBKkxCjaCr6fLebRG opYmJxdiYXKg2QWG0j7eu2nlRefiQT8bxjwMthh3YcysxXsPBqSJOy7TMH6KD3zGF/h2I/aQMq3b Sw5WKho+aIHiJebR0NlGmgKOBDj8eU9PsHnCRhwlVI2VJw0rtmM8ML1UGwZbjGtHjI49PPY0R+SR h68PIW5KELT5c7IcUQG/24zmVidqGqyoadEgRmSYGBlpDg2ZqTLi4yIw2cNg7WL/+j+FQrDYCu2k t9neNg5/298TbBVuOyIyW7tv84qMGJdruNow2E7vDEyfuzi3JKgcvT7NgMeXNsE07syzkx6PFfe9 Pgqv7WoEdWw/wr5aaCCAIFb8UaeZ6I3JwZKUh6XzJuOniwIoyKkDxfcuzJHdBkQO8T0Wo9TL4bGS 7t+EJRYHW+ywcso3d21c9crpreBX++thyjbA/S+as+wHO32Rv2y+hMb0+S268fGZKKpE4ekNE/GL V6vgPbgVKiIYNSIbF85IwozxLHIzVRg4Dd4AjYMVFDbuCmHDzhq0NreCgQVFF3wNL98YRk5OYw/j aKneCOE412PYFQEWv9/dndwd99jhE5jqA1vezjoT8/wqtTkMtkHsds55i8rTOXrUBze2nhFhiSww WPT4RGz+4H0IkSZcfelE/OLbLEZkRcMhnKq8s96Fh59tQsm+Cphd+Xjy1hm4bv5hsHGdl4LUaIRw rCfYmgUGD2zvtIwhZloHmp0wsNqvdm9Y+WB/fQ//+6lXYBhsgzghU+Ys+W5JQHqiZKmMUXPdoExD p3sL+kw477d5KFv3GrJzUvD8QxmYMXHgAbQef9mFX/11D6QwjT/fuhh3LD4KNlHQZ9sXG0kEJd/d EhWakBIWWRxy22HilUt3rV/1/iCWaviTLiswDLZBHAciLNmnKZ4HCnju/qsawaUPjWRSDTGY+8dx 2LrmVUyfmod3njTAah68adi2Egeuuucw2lrD+PDHizB7TqVO4YijaajE1OvM795CQ2znJH1RixHN aBRyd3/y3vFBLNXwJ8NgO/0zMO78xf+QZfX2nbd5YB5/+oISYhT8q9eL8H9PvoRxY9Ox4XkLTMbB A61jhrtL7Vh4eylExYKah8cjblKb7j0e2G7tdRF+uJVBUIqykq0hE2p8Jj/Fs2ml69/on4c9/WX9 UrcwTNkGub1T5i2ds9sjbDxwjYKC+S39i9v76afpeBJG3V0FTm3Cjv/kIi2JBL8amvLyG3G47Tdb cNm8y/Ha9V79cgjtM0MNd7KMHT39ZAeLtkiUtDUFzKgPGN1mQc4sLl49dAMammmdc60Mg22QW7Z8 +XJmdUWg7emZnO26K+pAWwavc9MEBnc9OxrPvPxvPP7LmbjlqrZBjqr3z5SjDlz5oA9rdx/Chp8u xbTxdYBGQWruaYj8690c6gPRN2gUbIb68elc5htvvDF0D9Mhnd2509gw2E5jr5KmLSq7JZct+PUN dd2kfQNt0l/vQtrNR5EWr2HfW5aBfn7q+jIN6TMXDtZSmPm7LRgxcRZ23BCNzKX4e1K2X+7i0BiM 4qrOb0VLyHCkdMtbI4d2UF/N1obBdhr7njlj0dbLk7kZj95SBy4pKukbTPn7ikm4+/cv48F7puPe Gz2DaaLPb5QjDihVUTH/JU83YOvBYyh5+HJkmd29fnPvVhaBdrP/Wp+VxKEsPbDl7XFDOqivaGPD YDuNjc89b9FHhTbmwlfvbASXEhlUS2qEwfifpOLQjndR9UkhElyDa6e3zrWAEfIO64mYkn/7VMIj aw9j1IgCpNlY5Lk4FCbRKEqTkWWX4ZUo3L+180hUeWzwCez+/VvenjCoyQ1/1G0FhsF2Ggci77zF L4000N9cdW/DCR1WX81pYQZKgIUaoU9ENCZh73ySGXnfr0GSOYjSlbbTGM1Jnyo0pJ1OaMFOVvFg EzDnTzswZswkaFrU3Ev/rWlgaAqpTgN4MwWrOfpNtc8Bd5Baf/CzlQuGbmBf3ZaGwTbIvZ8yf8mI NkH9Z4GFnfPWjU1g7O3yA7KiGqKRikUKaoSC4GdQ2mzEgWYONX4KHgEIS9B9x1SKwZa9ZchN47Hm 7314bQ5ijHKpE2pDd+dQVdOQeP9WjBk7Wbeq7Aq2jojKUQgCcXYeEp8AQeOqQpbwqCNr1gyeTx7E +L+MnwyDbRC7Onne4rspjXq8JqxirJPHikuadRcVVQM8AoOGEINjPh7lHgb1QSCktJsNk8jFOiWJ UhRSn/wur6xBbjqL1/44NOdZrbRDPtrT0JhMNfuXe5GWNQIMw/YJNn18JD8By8OWlAVJCN+/Z9Oq PwxiqYY/6bICw2AbxHGYOGfJXhNDTSxIiMbY52hNBxspihoFE0VFf3eAi/zWw4SfYbCpDVbIpcY+ Z0XAdveiKchKMKGyVUWlW0atV0BLUISiqLovQQfYyEVgsCfCYLFJkiwUlGxcfWwQyzX8SfsKDINt EEdh0uwlf1Q03Ht+Fh1lGbu9f6INRt9C/YONYSiUHauB3SLjg3+cXng8rcUMeZ+5W5KNrtMjQE/4 0VY0/nUmTERAqfORHeMFQiKDrZUcNh/XsKMmjHpvBIKigo3PRJyB2b5t3YoZg1iu4U+GwTb4M1A0 Z9l0n6Jum5lGw8DGDjYjRyHZxaAgXcP47AhGp3nAsyo27DXilr8cQ9lq+6AHpTaZoRzoG2ik4X0N wNX/LEPF70Z3Aq0L2E6AT/8bpdcpbeLwepkV/6pQ0LTjneHLedA7pK/ocBnoCkyau/gaUaFfm5lO gSXE7STKRpEcbAYa8TYKOUlAYX4QY7NaQZMIymr7khOKqEadP2WZhvmSHTj2YSGSEyL6IZclFk1u I0JhBqII+PwsHHYFY0f4IIo8VJVq97SmoLoNUCtZ+IIU3GGA0cdE2qeQZNdgNWh63Vd3KVh7KICn vhUPGhpYStXzxbG0Gj0IHZSuC9jIn4+4LSh8TcFkl/E+ita2AFSLHb6a9evXD52eYqCbcA7WHwbb IDZt7PmLfqVq1K83/aYFDa0W+EOcnm8tziYhxeWHgZO6sGgdrGZ7R13AJkoMat1WHGmy4jcvVGPR 1CTMHhsHNaAi0aLCzGsw65STvAGjPzrISBq3rqHPO7jP9jqaFpU00uQDAH6BpIQi70lK/1tQBEQF EOToj16XgI9WSYhxcJQMC6uAZxVY2AhaggZc+y6PgKTAIysgSTl4imqxc/Q2B8euNXDqxzvWrT4w iKX8Sn0yDLZetnvGjEvtIY5mFMVMsZTMGljVoKkyJ9MkxA4lKzL1U0FWbtv/WB04pjNHmqa167S6 UYgo2EIChyaPGW6vERB4iH4DImEaVl5DnJkkStTQFNHQGNLQHFYRkDRYaCOOt0TNp1ojKoKCApm8 oRgKZpaCy0DDztNwGCmYeMBupGDnob/HOIYIbsjkCNWidICoWnS7QyKgaBooigBXA3k3aqoGmYCU UFWNAkcBPKPp43IaNRhZTW9TIfFQRArVXgrvVyj4pDqABlFBnplb6+Lo91RFXVG85Z2qrxSKYpzs MNgAFM5flkOrykKPqF7ikdRJqoYkktizfXFIVH/d3qlDB0WM4lVRRuNTfjhMUV82RaUhiBwCER4+ klDQb4QU4qGGWUCiYaChA8vGa/BL0BMUNoRUNEdUuCMqmoMa2sIaAmKUEh1vU/U6BoqCkaHA0x2x RqKUiKgNJJWk742GotOliO1/13+3pxbueg66/u3kjSfSVJJ7lLCVHE1+ExaZ0heB/L+dZ5BhYzEj lcPkNA25cYo+F0mhcKiVwXO7FKys9JMUxkqGhf/j7o0rfxLjGfzKVPtKgo2AC4o6jqEwIiip8yrC 0hU2hsb8NAvOT+dg4SjQNPTbXA+oQwFGYiBPEWrQnulTpZCXrMBoUCCKDGQ5qgIwsRps5I1E/MEi QHNYg1vQ0BJR0RJWdPcVwsIR6lLj0XCkVYUg0zBSNFg983YUTAYG4Nt10l1llARk5HtJiVKmjmJi ydtraDLSd+2vfbo6xQvLKjyiglZZhYulMcpuwPIxRpyfrSLOpMEvUFhziMZju7wwMPThVDP/w+3r V7wzcdaSAprWRtM0TWuUVr17/aqdXxmEdZnoVwZsY8cu543xwu2SSv+PT5KntUiyrhu7NMOGmyZy GJcq6SyTTqV0qhFVOhPWi7BcCnFJUTU9H3VHIRYgxKuZsHwkd7VHUOERNHgFFcEuMbxJewQgtR6g rJEIJmgwGg2KsGuE3SM5s/vYiY4/B6WoDs9hpJFio+AyA2Y+CgVvmMKhZgVeQYOVaxfanMHTTCgg 0ciROTYLMoIqkG1icd1YC66boOrvyoc3atjZGIaVo3drADFZ6SwadVyj1bdojS6Xocqqqll4lj5k h2/9l1no8pUA29R5S78nSrjPJymZNouCmZk8LsphMTGBsGdAqUfFYY+ChqBywuKdCBlkhYKiUDro SCFSPobRwJKXG4CIROsH3RfR4DBrMPEa2oJE6ECDIe8hkm5XpnQq5hc0iHKU+pAfivz0A4joW0tD SNIwJolBhosAqW9dHBnLjioiwNB06nx6WrvY0UrAR/qsCko6+/n9qXYkmin8eXsABoYIZXpvi7z/ TBwNA0ej1iMgIqmNcWbuQ7MR9237eFVj7CM4N2r2t9/nxixOMcrCOUufD0vajS6rhtl5wAVZHEY7 aZS2qShplVHr757ilhCkymZGP6h2owYzT9g5DdVuGrvrVF0wYTdEJX0BgSiuKRAOk2MoHYzSSS6W hGKRdw8BGGFNYy1kY4gEkVC0uXk0bH0bhXRrklDRHcej7z8bPzRsZaxjJmtCFOd1QYmwkUg2s1GL mj4aCIgKpmbYce1MGywGCofqZDz6cQMiitqQauUWb/+SsZtfarAVzlm6OSRqsyZmaciL17Awy4Ay j4zyNlk/BCcXIgaPSBRsxk7zq446gkRjYzkNiwGQ2wGls3+6QW/7gWoX0cd6OPuqRzaFgCYsAwtG MCfY25jbpYDSOuBomwKn4cxRuI65EwolK4TVJmw2EZpoEBUV0VAmZC2jAh4jS8PIEEpG3sFRpTkR 8hDKmGznccVkBy6YyOHuF1uws86PPJfx8p3rVr4X87zP8opfWrBNmbPkaZ+A287L12A/RZon8vAP SRTiaB7TElmkWGVEKBX7PCpq/CoERUNzgMInFSriWEZ/MzHtb5bB7G2HzuxU35Iz2hbRcEE+EzNF 69EeBRxuBMqaFTiNp97mDipKqDpRFxAqHIXJyYWCoguMaIQEGU0BQVdDOHgGFiOD/Hge41JY5CVr SLZrsJlUnStQFKDFx2D3cRor94dQ5xV19jHFxuugJP2ERQX1IRHfnJyM719mxT0vuVHS4EeymZ9Y vHHlvsGs9dn2zZcSbFPnLr7PF6H+MCVHQ7ytjxDcRF8UpnHtSA7zs8O6Qre3QgQih5pN+KiCw8Za BbuaI3BLKqwsjQSWAaMqUHVekYOZA1ioutj9xAFWolSK0D7yjiNVCVXliTif6X6gdYqmQpdezs9j dCHIaRUKONZM4UCjrOviOiSLHW2S/ycEPiBqsBsoJFhpuEMavJEOHzfCAlMwcgCviHDIDbAzfp2W O+JTceeyZGQnhWA2S2A4pf9HqI5gStc1fu95Kz447EOe06BzBwRyRNVwuC2M+bku/PmbLtzyTDNq 2yIVh7a/+6XI4/2lA9v0C6+I94eUljQnhYK0nqHgiC2jIrIodPG4amygT5D1dcgFhUaVx4DtVQw+ 3bcVLEtDVTSENCuqhUS0MXF6XvuwrMFhoJFqp+EwEZMpChxRJVBAMEJhb62i+7QRiSIBGHnrEEEI ed/NyGbgPF2gdZnA8VZgb0OUpSQsHQG+biamRqWphak0krqYZZJ3pz8C+MhPGPAGRcx07MeC+QnI zjGCpil8/FErJuebsOB8R2dPuoKvnSxSxMzlFCIalcLi/4vDkdYIgqqGVDOrs5ZkfCXNfjxxZS6S nTRufek4sq1s/s7N7x49rYvnLPj4Swe2yXOW/ickaV9fMFYBTTa8vdgMFJbkAjuOmbFolIBUe99m fVEXk+iLpC+R/N7jPqypaMGs2XGwWhhEIgref78ZH1flIj3FoWeXIRThVGV3tYYqr4p0G60LWGwG ICchmr5pqEuTD9hWTdYkSq0YKgq0C0cy/Y5TkmQojXuQmGBAOKygtU3AlRcm47ILnLqtpxbioIY5 CEEGLQEGoQgNltVgNapwWhRwBhWUQQFlkrol+1AEFm98EI9aP/DIVi9RYyLbyuuXQardgAevTMAt /6wFT9M37N688l9DvSafd3tnYFs/7yl09jd1/qLZwQi9aVyGhmRHlH1Ms9JYkqch3yahuNqG3AQB caZo3HuiOyuutqDcR6M6qCFMWD5itkT4QIJTIkWkaHAUBTtNId+hYm5eGHGmKMXcVenFhrJWhASS 5ILG3AIX/n0oG62ypIvpY5G9l9RCl2qen3fmt0KXbgpRFUa9F8h0oV+gkXmS7x5Y4kddqx92G4Os NANohYEW5NDcasAHJUa8uSeCqoiK+GQbnFYOZgOtK+WJaiXDAhTFSRjpCCMrKQLKIoMmkZ4ZFVKQ x9FDNjjNKl7by+MPW/xokxQUOIz44zUpeGhVMzxh6dv7Nq9++os7WUPT85nf4aEZ5ylbmTlzuUnk xR9V+qX/9akq7ihiMDGJwqWZMlwGVTcpagjwSHeIusEtQcHaw3b866CGBJsKWVLgDsi67aEoE7Cp OjtDHv8cQ8NuYuCwcPBEaGyvk/CNkWb8bJ7nhCChKx/1wh4H7n/fg7EpRswcQayI+1kACthwSEWG k0Z+4uewWLp+MKqGIG/GWIqoaPjRRUBGYgSQSbgHGgdrTHhsPYW3yj3gTQZML4hHVgILAwSwlII2 v4yjTSJaAxI4loHVxMFuNSLfzuGGghDGpAugjDJoq6S/cSsrrci2KLry/829Zvz6Ex/+cE02Hvuw GS3+yDony9+xffOKQ7GM92ytc06DbfKcSxMZir+9JiR92y1rmfdOsuKmyWGkk4SARMIlMzpA4kyK bs1OijvM4oF1ZmicDF9AwPGWiC4Ji6XEWTlkJxih0Tx8YQY/ni6jMI0IVzREFAorSm14aHMIFxbY kOpgUFoTRGZcbEv8yWEVhekM4sz9oTOWkfZdJySSd1H/LG5HCxdPoVDfxuK1jTJ+fzmD0kYGr+yV 8FGVH1aOwdxxSXBYNEzLEXDt1AbYFAmaCFBELWLUUB2yYMUuF974LAxvSIbZyCE33YkJ8QxuGOVD ilMGxao6tQsrNOgAA65dndISNuLF7Swe+ZQEraWQY+VXmBlsUKC+t2fjO4dPbyU+/69jOwmf/7j6 7XH6gqXXNwTlx6sFJf7eiTZ8/7wg4kwdUYk1rD9mR368iEx7Z1yPknozvvOhivOyKOytDKCNaIy7 FGLVkZdkRn4KhzQnrVvShwUNx1tVHGkQUeOO6H5hTjOL0ekWBGQO++pkxBspeEUVx4MyKH8Ee35v RlZSEN9/Lhm0JsT0BiOs2r/3SrhuIqebb52J4o8QxXtUUR9LcVkZPPD1Vt0uMvHbHEIUUfRz0EQJ hVlOZGVaIIcDePCaNqRFwlAFI1SrC6AZQAyDDrbpTnu0TUMwmcUPn07EtiNB/R2cl+5EcoINSxL8 uHh0e2RzRkOA0rB5nxULR4dOrFtQovHBQSOe+CyC0jZBl6qmW7iXLQz91I6NKz+NZS5nQ51zEmxT 5i55eZdH+MYto+z45YIQEtrfUFFqRuPJrTZ8f6YffDs1I3//z147/lUuIdehoqwuCE+oM1w4eW9d PcuBWy4D7M5MKHwKFN4JxWjX71g67APjqwfcR7C3KoR/bwE2HfQjzWnEiBQTNlSo8IkqmgMR/GZx An6wpEHf2ze3pGD1zjDirbEtM5FOflapYsFIouYd2kKAxjJaNBxCjGV8NoubLmrRa+8/7sBlv4/o 3guTRiUgPp6DFvbjyW82AD4XhNyZkFxZ0MiN1V5oKQzrZy8CqgLKDDAZCh58IxP/3ebXa6TEWzAm 14VcRsJdRe4T/neiQuF4W5S+5SXI7ax/tNHGAIv3D/L445YgqsIyxjr4FQyt3V68fnV0oGdxGeo9 PeNTnTx36fuVAfHiv11kwZLRvm79kRvwj5tt+MUCX7cNWlVqw3MHFThZEQdqA91idEzMseL39+bA kTYaMtf/o4lrrgRf9xmOhETc/5wGt1/C1HwHDtZQ+N+vaTh/VtsJfdMj/03Bsxu9WDrJ0G7P3//y EPvGgw0qzss99dboL8/2KFiEUpzKEoyI74m4nnhsD6TE21n8bHnnGX7041y8viWAyQVWGGQ/fr+0 DjI9CqFRF0Aj1OykwobcMG9/tfOvxF0nS8GvVmbgre3RpDh2iwGTCxJgFUQ8ON9zAnDk38hoK1qi +ss0R3cuhLgVvbHbgns/8iLTzO0s2bxq2kDm9kXUPafAVjR/ybU724RXV1xuw8IR3YFGHB7/vs2B u87zdKMKnxyx4Q+7ZGRYFeyu9J0AGjl8P7wmHVdeMwsKGxfz2jP+Fhi2vw+KFiGmyrjlSSN8QQVJ LivunyJhTFEAlEFDi1vCH14S8fpeC5zJTszL73SQ66+zei+l21hmxXV6IRDK5A5qaA0SkyjisR3V zZFCxPlER0UOZaqdhELoVB+0BohSWtPNzAZSpEAL6FAjln/NjllFNhxqjMNfPrLrXg+MHMBfr6qF zIxAcPTCPl0WTFU7wR3d1tktsU7JUkA7FXz3iWysPxgFnNnAYeqYRCTTKn52vrsHVQ8INLYdN2DB yHAPlvy1XRbc8n4bpjgNV+3YuOqtgczx8657DoHt13TGtB0tM1ONrheWRdmQjkKO3Iu7HLhhirfb RrWGWNz0Ho9Eo4R91YET9pDEM/kPtyVgxsWXQmViT2TBeJtgKP4IkDrfgVKihuVPUkhxGHCoicFH twVgzJLx71XNUAwMtu1oQ0lrJvymJMzPjziEbwAAACAASURBVF2HVlylIc5CQZKBaq+qB3QlUYuJ ORWhYifr/8gaEEsVUo84e07PYk4cTKJUH0gJNx9Dkj2ACy9IwMaPW3DnTaPw1KY0bDooINmm4PHl tTBEHAhOvhoa0z0QbNd+TNXF4Cq26n+ijACXJ+u54UgJRXgsfzgRlS1RfaeRZzFtbBKmWiXcUNgz 0yp50/6n2ILrigK6nrBrOf9vJPCtUnZs27tjBjLPz7vuOQO2wrlL/3rQJ9xZ+W0adkP39Ewbjlkx KzvYzf2EbOn1K+wwc2HsPd4dnPde6cI1106DaMyPeb3Ztjrwuz4hkXhOfEPxGphMEYfbjPj+XzUk Os2Y5WJx80I3vvP4Qfzil6Pg98r4+z+OY1tLPiwuJ4qyYltycrje3i/DwtGwcFEvg6jlR5S9Ioa/ EUXTDXwNbKexcYcJVl1QxcKR3IClmxF3NeJNHtx5VxaqqiJY/VYDEiYvwBvbwhiRzOPbc1pQxAUQ mnI1ZHPfHAGtSLAUvwYq5AXj1MBmEb1a9+XeVpqMW55U9NAMJyjc2CR8IyuMGZk9cy+S+a8qsWLx hGA3CvfxIROWvOnFFIfx8p0bz17D5dh2PuYjeWYqTr/wilG7WsLlvyyy495Z3bO8HGszItMh9PDz 2lBhxxvHJBRXeHTdWUeZnGvFsz9MRyj7gpgHyzUeBbd3UzQcVnuhExQwaQLQblP5j5WJ2HNYQ1kT hRVXR7DmcC0O1Ydxx3eyUF4WxIv/qsaa8HQsGUXeTrF1XdNGYX+jcgJsRN8VFKM6wDgzMQVj4Yuo aA0quqK6owgKkGihMSk9tn46aqmyAKF+H+77UT4CARlPP12F+UXpWO8di6P1AsanSfjtwmqEUhdC SBrVZ+OUpsKybzVodw2YRBVsutyn3eTNf8zCtorOzK0uuwnj8uJwT4EXeYlRFU7XQi6hPTUmFGV1 plYWZQoTHldg5+jX9m9Zfe3AZv351T7rwUaC7zSAqXUZGOumGyPdBB9NQR4ukwzuJCNiclH+eKMd FQ1+VLZ0z3f973ttyJ62BKo5thiNfNV+sAd3dNsRJlMCHd89VDjp87t/iYc7QKHAbsQDl7jxyqY6 BDngum+k4B9PVeO/u5IwemQSUuyxsXVE/bfhCIl4FRWGuMwMsuIYJNqjHt6kELegV4tDSDIzJ8Ii +AQtJjOsk49ZpPU4zpukYsEFLjzxWCVm5TuhpI7HnzeryHLReGhZE1ISxiGcWdQ30CQBltI1oNtq waapYJJPnSRyw95U3Pn37qAiaoF4pwVPzGnp1b2IAK41yCLZ1tn2j98x49l9beEcyeEsLX2jJ0o/ P0z1vTZnwRhOOYRxsxZvqgnJs8tuJ06bnYvrE1mYWaVXz+VDLRY8vkfB9sPebn5rOUkmvPmTNIRG LIxp2nxlCdjy4u5AS5dBE0uKXsqGXXF45SMKh1pofPCNkH4xvLC1FoyDgSRpeGOzGXHpmchyxZZA gwhJNlWoOoj8ooaLxxhh7yXvfL1Xw47jgu6wSYyLTSzVrzSzt/EToUi6vQktLSImZlhw1dQ0/K4s E/sbNWSYgvjjtSp8ucv6FIgQ6aNp/xpQIQ/YdBVMUmzZWC//ZToqmzvXlKZpzByfjAKDgrtn9J6v jvgdkkKEP6QQ8I1+Mox8K//K3k2rvhnTBn/Olc5qyjZ53tJndrvDt276ugVT0jpZjaDE6Do0EmCn t/K3PQ6sO+zH0aYQrEYWgUh0078134W7rp8KKaX/RJpcaw24nR92B1qqDDr51HFJb3zEBVFh8NhF EpxmCUFJwUflLWgJsvjVZym4INeAdFdsu0xu8I1HVJ1FFGQNWXEsLhnLIT+Ogsuk6uwlUVI3BWk8 ul7GwSZRd87MjWMwIik26nnySBL4NiwfryDLakRN2IKH98XD4xOxeHwIV106FWJcTq+DNzSVw1C+ AVAksKkqmJTYgEYa+9vKbPz1/XbJJMcgJClITbAiPt6OBwt9yO2FnSTfEX0cp4eoiB7j335swUPb 2zDZxY8pXr+6LLZV/vxqnbVgK5q37E873aEfvnqpvZs+LSwxMHDEu7fvw/STjVZsPxK9EZ0WDnWe qBXH32+zYNT8pVCNp86DxgQ9MGx9F5DbuRESeyRLBO3snzt55KVENLQA3ylUMSIuysIStUTRsxaE RAkzMjhkxAi2DsoWBZsKm4HBJ98hDp49KeM/t1lw30ceZJl4jE6ikRW7NqPbaStvVHHdFCuuyGvG a7VpWFkOXfr68JIAUmZf24OqUaoCU8VmsLX79XaYRA1sRk/XplMd6Sa3FcsespAYJEiy8WgOiLpH wvzJacinI7hzRnc1T9e2iAS2I+ZgSKKR92cB6SZuQ+mnq+d/fjCKraezEmzT510x84g/8umPi6z4 7nmdYmBRofVgO6dS4AoKg59vMqCsNqgbEqfHGSDJGg7WBrD2AQe0wlO/n2kxAuP2d4Fg+waTEHEj IrrRbCzl9U8S8Nl+GuEIg5+eFwbPKbj+TRMqfCLiDSzy42nkxMfSUvTm3lxBWGXoHuMmnsK/ruMx Ik4AZaKghTsvnH/vsuDO99qQYzZgZAKN3ITY+ji51v46DesbRPxqXhyOBBnsLvchO8OAZ6/3gSrs zp0xhG0sXQs60Ko3Q9sALp8YRg6875v+kI2aFgkOEwuLgcbhpjBGZMdhXAKLeyaf2jiEOMB2uCWt KLHgm6vdKEow3bB93dnlljOIZRn4Qg70i7wZi8oSTUzBJ//TXbgRSzvVHgP+vJtGVXNEl9qlx/Ew 8TS2HfHjk4ezEMrv+73GtlSB3/8pIET7Jca0zMjYgUa+2VLiwqsfMaj30VhXLSGORD2lNKSYWQQl DWl2GmNSYplJ1B1m8zFVN7EKiRpy4lksHMPjzhkhsHYaqq+Twj3ykRmPbvMiw8wj2UphQvrgtnZP DdASVNEUkUA0kIk2A9IzTHhueS3o7IUQ43NBpI2G+gPgKz7T2UZ9rTgN/GiJuKoPqtz9RDZ8ARKp TEF+ogFVbhEyb8DkbAt+PHEAgbYoDVe+aMD2hhCS7VZb6fo3euoQBjXC0/9ocDty+v322cL0uUtu 2OGOvLDuGiumZQxsncgb52cbLRBVDcebwshNNoBno3aGpbUhvP3LbIRze4r8KUmAoXwr6NruzsBs ngiq3YMg1invOOjEi2s4hCUam47JsPPRyMJER0TGR+KBTM6MbdkbvBSKa6MxRNxhBd8oskDWVNw8 VUVOtgzVEwVbjZ/HHa9rOOwW4DQwuuf3/FF0zCZiXedGInMRaaYeskHVYDTyiE9g8cq36sG1qtBc KbrujBI639Dke26EArqPEBSxrN23/5IFI83BaqT19appk9Ak0hibZcNDUwcANgANPhb5TwQw1mH6 z/7Nq66Lpf/Po05su/55jATA1LlLJxz2iyU3jLbit1/raUVwqmHsqTfj1UMUKFqDJFOoaAxiTHpn bIEjjWG8eZcGIW0+pKTcE03pgpB9m09Qs45/0PVoGQOnrB9uj8e7n9HwhBjsqJZh7WJhT0Bg4SlM y45h2SlgZ6WmB/4xspQeEHXNbRye2cFg4UgKs8cLUL1RsG2pMuGaV3zItBh0dooEa52aTiOlS8SC WLeQWK54IlGwqaoGi8mAhEQWT1/fALu79zcrE9+utI61k17qXftwJkYmGk/YRla7JdSFNIzJceJ3 06Ngi8gkbkvPyGe9dfvWXgu++Y4bU1zm+4o3vv2n0xjakH0aw64PWV/9NjRq5qIjAPJ33irpbvsD KbJK4bdbrXqgVZKtpdkbwsjUTjn5wboQVt8rQ6lhoaZkQ0nKBOOuB11T0bMbTgM3hljvxiai79rA f9clYut+ClVuGgebJJhJhor2ogcl5SnMiAFsxO9sQ4WsxzE57BPxyEUO3DI9iEc/M6MoXcPcSRGo bdE1eqfcjFve9CKPxFVANJIzkV5eVNBpshXrWu6vA+r9Koxs1P6S+J+lphrw28XNyIh0p2akTcJq 82PFQbOPpA0SQfmin6ZgzohOwdWRRgEelcGEbDseLGrExgoDvBEWi8f1HEOvc6M0LHuex66msDbK xDm2bFnV3Ywo1gUZwnpnDdimzV320M7W4AO7b7RgZHy7f9MAJxpRGDz4mQEtAQoRQUCyk9NZElL2 HA/gwwclyIf6N98YDPvYMdRHX09EdSOFfbXEHSR6aLuCjcRCmdqPyRYx/SMif6KxILaQIVnBY1dY cGFeGP/cZcbMLAXjRoonwEYo27f+40eCgdPVBGTGAQlIsdIozOw1Jl2fK1vlpnCgQdYDFBFFOs8w yMuz4nvnt6KQ76nzYjNUMImxCY/66nTj3hQ8/jaPcWmdkWh3HQ/BYDPBxXNQvWGkppjx89ltA7qE 3SEGGY+GMNrOf3pw8zuzBnichrz6WQG2aXOXnl8RlLb8bLoV35nWuxIz1pn/fqcFx9o0GBkN7oCE NFeUjys+GsBrv9DgqiV5j/pujXZoYHJjvD17aeY7f4rX45bsrI4mv+hqRkVE+U4ThSmneLMRUXZJ DdAUVGHjKezzCHhumRMpdhVZDgVbqlhcPS4Cgwsn2MhjHh4XPxOGk2dP9KcDTtSQ7WJiFsiQ6ZBQ 6euOKHpoO53qKMCEsXG4ONeDqzKaus2YItGiCVUb8Cki5i+dm3D7n7Ng53ldCtlRPinzYXR+AvYe 9GLOGCeuHydgQsLAidM7B8y4bpUHhQ7TrTs3vv1crOfoTNQb8DKdiUHkzVhUY+fp9C03nX4iyz/s tKDOH+Xry2uDmJAVteo/XB/GDRcbsGxUEEpj367Q7OiBSR9FNgsK44RBqoAQFnHL7yxgaA47alRd sNGVGW63t0VOHIM4C8l91hmSnACRCEQOtSg6G8hSmh4Ob1wKj8JMFnfOELGl2qArsi/IDYGyUdD8 0dZ9AoOrX6RQ5xN1XRzZVALakKSiJaIhw8pgZg4NI7l3+uLOqWjo9Go3hWNu5UR8kmBYxvTJybr/ 2pMX1kHrclGxOQoYV2whJcg4g6Y5cNsu1Mec7HkdvFiKD3ek46+raUzK7GT5g4KKg24VFqMBgkfA uGwL7j+vTbcYGnjRsOAfDCp9UrCh+D3rwL8fui++cLBNmrP0+bKAeGPZzQySLP0rjfub+kPbiPJY 0z2G61ojutg/zsqCbKAnJOHVnwUglZqiCcxOKnS8AiYzdqFI0DQDTZYLQGsSMjzP4+NPgbc3Uyhv YtAcUNrzbXd2RZSvZMFDUtQXjQRq7Yg+HCHnSCNpqqIZdFxmGnU+GRl2DueP5DEvl9ID9eS6FIzL EqERiXsXA+unt1jxo3VujHcadY+AgKxiZo4BdhOF0joFh1okjHAxeiBWYuJEAE3aI5l33CFVT7jY JgPpBkZ/J5LxEcsMQVQwMscJlZLw6rfqwLqjC0cZAH7MQKgai7r4H0Jhouc93r8Wwbrd+Ppv7ZiR YwVPVCTtZefxELKz4rCtpA0T081IjePx69mDd8SuauMw5R8hjLDyb+zdvOqa/s7Qmfr3LxRs0xcs vXh7a+T9lxfacMXYvq0EBjL5B7aYddE3KeQSLzkexMRsi37ID9WF8T8Ljbhygl8XlJxcuIIIcCKO Sf+9es0XIMJlwBXaDF46irv+EocWD7CzkYaLpyAoCgRNg42l4ZejocwlAjKKhpGmYWvPA0coHnGX icgkxS6Fi8eaMDmD1oOkPv1pECMSeCwaz2FMooYsp4TUZAVaoDuJKq03Yt4//RhpN6A6IOIXFzkw IZWEaqCws1bFu/sEna0lb9jasAwjRWFxvgljEigkWTU9bfARN403y0QEFQ02Io3UNN2qg/zMnpKE C/L8uD6zQV/YWN9qCpsDWmkmNwNaXLdAoq2wRg7C4vsAt/wpBRwYpDk7YzUcqItA5ni4rCas3VqD SwqTkezg8PPz3b1azvS/S9Eaf1pvwS8+bcNUh2nGzk1vb4/1u6Gs94WBbeLChZaWNq5yfLwhYcU1 A9On9bUAfonFI1ujbzQSlNRmItlARXhDCrITo4KRww1h3Lecw6z4CJTWzjcCZdLAFvT/VpPYdIT5 keDlBhjFTvO7599LxKYSBZVuHqNdNGx2kpkTmJkOJJmIzxZJjEijPkijzg+UNQEfHgvrCRBDqoo8 K48cBwvaAPxPEYuv5UeFRB8cMeP/Pg5j2UQTFuSpKIgXQNzIVF93sJE0VdOfVHHUE8FvLorH3bOj htCk/LvEgr9uDiIUgQ76eRkm/G2pFxzTk6f0CEasPJaASm80VRahkrUtEbQIgMuu4MXr60C3ajCM kwD+1BJj0XgeBON4cOIxGEMfd9u2/30xBzsPy5iS3VU9I6CiTcTY3HjsKmlFWFExNceOnCQjbp8c QJpl8M8MYo0z+lEZdpbZVf7Z6qlDCaJY2/pCwLZ8+XLmUIPwTmVQuqT8NsBmGAwv3nOKR30GPLOX 0TnEtQcV3WZu4VgWh2rDyIjndYt4QVThDSu4awmHBSkhqO7o+41JVUAnn4KFpBi4rYvgNYzV67Nq GJnuR/X/Xlcch6dWKWAZHiaah8shIdNO48ZxIZjZ3tUHHpFFWSuPp7cxePBrsu6T54/Q+PVnZtw9 E8hzdbrwrDpowYajCr5VRKEwJQzKQvWgbDUeHpMe82FBjh2vfqu729Gn1Sb86v0Iar2qHgD14Hc0 2E9hfkbSYL1TmYJdTZ3U3xOQcTSkYlx8BL9bRtxn+pdAqrQLGu0Ao9QDWud8Xlqbhac/EDF3lO2E tLi2TcLOqgAKRyWitjaC2pYAGJZGpsuEwlwrLh8hYlrK6XE/a8vMuOLNNqJ7+0KEJZ8L2ObPn8+6 VdsPAqJ2SVhW0yVVs7eFxbT/XuHEwhEDlzD1dZN8UGXB+uMaatuAvfXEoZJCjovBqGQNZbUhZCca sa8qgEQ7DwNL44rZHK4u9EGp5cBki6Adfb8Zfeb5aDXPPNF1XGgbHKFPUFzmwG9e1pDqNGBHNYML C6J50b43OQJjR3L7U1x99UEeaY7owd1Xb8YTeyl873waE7t4F5C4H88XmzAtQ8XkLAEUo0E76ZL/ 13YrHvmgFTt/YoaVJLnoUt4+aMajG8M44pYx2sVj7Y2xcRLvVKaiuDEKOELDNh7wwJlkxEWjRdxz 9fFYL/Ru9dbtSsUDr2iYk2/TU0eR0uCVUVwdxNi8OLQ2S6is98Fs4iArUUfZiybEozBFw1WjojaY gy6UhuUvGbG9Pog0K3c7Q6kHi9e/s3nQ7Q3wwzMOtqL5V4z3CtLKgKTmXZhtxvzcqJt/o5/CbVNI 8M2hKYRS/GmnQVfmfnpU0/3YiESyKqBicjKP/AQZx5sFpDh5VDSGYTYwiLeySE9k8P2lYSS5It3i 0J88Kr9pNlrNs6BRFByRUpjcH+D5d+14b3sE+clGlDdxKExToVEq7iiUkdGPsIeE0iup8iLJmYTc VJKkXkWjn8e1K4CbZ5jwrcJwN8+GGh+JgQ9kJYp6RtP25GcnhnnnGybcOVvD+NQoCqt9PMqaWQRF DfsbSSSqEAKiiulpZvx0Rg3WHYgG1kmPN2J2gROJjt6DSa6rTcbGmui/ldcEUVIXQl6mGdedJ+PG S6oGtHmrtmTg8VUqirItJ4BW75FR1iJgfH4cquoE7CxvhsPC6755Ro4mocdx0fhEXYL7gyLy9ju9 cqSFR9ETbjgsRhDPdwtLH0+xcE95LeKjR9as6e4RfHpd9fj6jIKtaP6yH5R7I3/KNHH0hzdrcJgU 1PkNEBUWuRZ/NF/REJX9rUa8UkojKEYdLkliPpuBxphkGmZOgztEw2mSdSfFvCQj/GE5GnzUwaHe LcJgoDAmk8WsCSrOG+fVrfVPLhrFQ9VYvP6hBR/tUlDnFjEq1YSQwMFmiubovqpAQ1FS3+zoofoA 1h10o7w5iLwcC+pqwnj4mrEnkoD8+kM71tWGcct5Zlw6SkKypdNdRVAoGC0aNOI4SWT7XcqL2y24 YXoQxLtr7RETXtsto6xR1G0qOYqGjWdAcqxaVQEzEsv1YD6k1NVGsLfEh3svzUaqq3eF/+6WOLxf aYFfBN7e0QgDUXRnWzEjV8Fl0/yYkOfudb06hufxm/Cn/ybjcI2KkcnEpCx67I42i2gRKYzKtuNY ZQiMTKKUGSBIKiqbw6jzRvRpTs12YESKEffN8MDK9c++nupIEXen2ogBJN2zIGl48iMDntrpRrKJ q08wMTfs3LCquxPjEJ1P0swZAVvR7CvzBE35RVlAuPGbI6z487IQDrWZ8N03ZexuCuDZJYlYXuAe wmkAH1db8FGlhtIG4ECTjPm5LBK7uK0RXB9pBeycgiZvBC4zi7T4aDzHjmBNIVFFq0/SY/6nxXPI S2WRkwLE21X9XjhaR2N7uaLnjSYHIsHBwaCyoPloDJCFORpmJPdt/UIO0HNbqzF7djymFtmwdYMX Y4xWjEjpjPBFIPTEFjse3+3HojFWXDaa1i1HiKMsARJj1HRdAgnx3bUQ59QEi4xPjppx6399enrg FCOr68vI4dYtSygK3oiKNKYFE121yMm2IDk5SrW2fObG9y8Zhez43o8EEZy8dzweW2s0vLCjAQbi TV2QCKdJgccdRHYCi9GZFKaMFJASJ0CSaRxtMGLzPhbVzSqy4g0wtbONYUlDWUMEjjgrnDYDmJCs m7Gd3HOrX8bG8jadwi8pSsY1YyIYF396zw4CNuKZ8M/tViwYLSInUUJlK4tbX1BQ2hZGgcv4hMow f9r9yVuD45NPcaqHHGxFC5bMqvHLH9KaZnp+mRlB1oyiZD8u/6eqT2Z+pg1vLQ+BpQZud3gqdL5c ZsWOOhWfHdMwb0Sn/splopBiicZUJDE9qt0MDrQoUOQwmv0S0l08kp18r7cOuVWJLxzJBRARVfgj 5DZUdQpgMbEYZeNwZ1H/BtNEErbluBErt+3GrJlxaPXQkAM0bp8dp78deyuNfhY/WmNAcWMA35vv xPWTRDgMsh4SDiSa1kmif9JGY5DF/L+JCBKvbjvXaypj8o71ywyUoB+JtB9WVtAz8JRGXGhWOPz3 SiPm5PR9oGuDFhxqM2N7hYz1RyJooo2YnGdByB9EnCGaW5zoNMkFRi40u6lzfgFBxbEWERLLITvF AppQaoUIlvo+hkSNs2pXM2aMcOLq8TQW5gzN0+MX75rx9421uHl+Bh6+OqRfpk9/YsbPP2wlljhi mo39AxPEI8XFqwdnO9jLpg4p2KbOXfrjI37xt5dkmvGTrwFra6Kk5dLMAJa+FEatoKDkFiMyLUM2 /hNTIsrsffUkME00tuLYBBqzMyTk2nqy4SRE+SNbHDjUFoadV/WEDyScGslYw7GUboBL0s8Gwgq8 YRmSosJh5pDuMujUjKNpXJWvYWrqqVUFGqXhlx85cMiv6PnaiMVIx4KTLDJ3TVWRbj21Iv/DQ1Ys f9uD/7skAd+ZEQTNUGDiKShNPS+r9w+acdUbbSiMM50I4HqqC4qorTuiKpPz7hNkVPsE3F7oxMOX ePR17K9Uthlx7xoexzQOIxM4cJpMbijQIGErSLBZoj/UoNAMrFYDzAYWiRYOlHRqb/uu/RIg7KoM 4htFZlw35jSFJO0NV7dxmP5MGOGQiJ9fkIwfXBJEjdcGKAKeXa/hhd0BchE2plu5xxWVf2b3pjdO +8E4JGAj0sZW2b76sF+45H/Ps2FaAY/1NVH+f0GmgPFOHzIfk/HAeQ7cM31obqaum1Eb5PFYMQu/ oGF0AoMrR4rI7OcQk++311jwaimHuqCAOAt0J00iWCHqAaImIApgEjmZYwkjQ2FEHIuLsiSMje/f yoSYPi39jxlbav24dWoSHlxMlNxAcQ2LdeUhtAZFjEpkcc+0cL/GtRuOWHH9q0347P5E5DhF0C7q hBFy13W47TUj3qnwI9cWFaZ0FLLJ5P8JsMjhJ5cHOcDk73rociL0MbGwWzidEm0+HoAsKnj/WxzG neL92dF+RGFxoNmG/Y2srp/b3KyB50nucWKpQoQQDFLMDOzEV22QJ67BI6MoncKtk4fm/BB3nfOf ItleVSSbWXz0Q+KqlIIqL4cJSSHEG7z443sU3ij1wcRxgTQbe0/x+pXP9nf5nOrfBzn1zianLVh2 YUtQekJWtTEvXGnCcdGKCi8NMwsUJko46GZxx/gmLHiWwx3TjLh2zNAsVtdJrTluxQt7JVw/nsPi XBLAc2CCF0mh0RZhEVFo+CQajUFGD7NNcrvFmVTEGWS4TNIp4550HU9YplAacuHe1YL+PjQZONxz zWScH9eAfFtAB3BIoLC/gUZ9i4hpSX6kdAnL1tuG3fqmGVdP4XHZ2N6paaOPw8i/+JFrNZyIyUEA RS4PcuAJoIgjbbyVQ5KTR4KdhcVIg0SHJu854rtGcgLUtYowaCqKMln8dJ0bN42x4tcXBrpkCOr/ uO1zu0CU7CRWilvgUebm0TQEzMzH+9vw3s2AjT99vSxx5J3zdwqNIRnjE4x4/Q4NTxdnYnySoF9E x9p4jE4Q4GT9eHqdhFdL/SQr6gaDgf3+7nUr9va/Cj1rnBbYpi1YcuURr/TmOAePx69g8WGtDT6R QopZQ4KJGJMymJUmYoQjgkc3sihwarhp8ulZ9Z88BZLj+uFPzchxULh54uk9ngezgB3fEKpBGLvG CI/ZTwlYdVc8RiUJyP5xC84bn4Vn/n4TfAEZi5f9FvddmIxFhRSSnDRohoYgU2jxq/B6BdhoAXaD qkeNIkVUaQgUi41HrHiuOIz3b+sZTIdkv7n5TRMEjQalRA2ZydvJbGR0KxqriQRJIlS6O7mLiMRC RIU3oOLF3c04eJcdFc0MSFyqm2dpWPSMX2qRVS7fwuGjGxQkWQcWyKdzbSg8V5qO2kD0uBE3o4I4 BQ1BWo+JOSs9BBOnwCNwqPVzONjCorVLfJWOdipbJYwwSXhg4ekjl4TCm/mUisawjNumOHH3xRqe 2x2NV2FiNV3PSUZ7oNmIGRlBVNYLs1P2EwAAHxpJREFUeGB1K4wsAzNHX7VrEHkFeoCNWHccqw9l ywyTDxU5UKkclVKTAbg0wEZpGknDLlEUZXFH5Fn/M9aMr03msK7aoKfNHeGM+mE1hynMyxCwv8Wg J4IodIZw7X/8KLuTxKIfGuEI6e/9w1Y4DBrOy+wefvx0gBPrt40BDp/VW3AwwIOEj91zNIB37lCx p8qEW18NoPgnNO56icPKMh92fnC/3uzGTUdRUJCCUFDE5g0HsH7NVlw21oJJORyykzgkOkhqmqiO UDen6hLX/vrnJFw7kcKSiZ3UrSXI4IoXgYsmO3oV8hAaT+R84YgEr1+EP6xic3UEl4xw4OcXq0g1 Rw/uI2vM+MXlIbywzY7qNhXTczTc9HpbYKTL8PXmoPK4AuSPiuMw0sUi2wnEmzSk2jTMyu2emquv tXu5PB1NYRo5Dg2X53tOqfAnY15xOB4ljd2PJ7lE/BEVi/MkXJB/ehdrrZfDzKfD+tv8yaXxuKww gnq/Bbvq7TjqiSryCejIPgQlCqPiJXjCNJ75uA7+YJhwJ8dYmgozNOXXKHgYjaoHhQYNdD1FazU0 0EJs4bmw1LRt2xrd9EWfTeGcxctUYJ6kqONkCeM0CmnkvUKUikRaRqRFhA3p4O+JMKExIGFSshFf n25EcRezHjJAwkJOSJDwWT0Hohsi5cYxXlz/ioK/XMZhcuLpmd2Q9ghcST7saZlBPSebqQ+zqFiB E0s90me114D3Dhmw4pCMnQ1BLJ2SjILU6OY0eFT8bHYIaXESFj7K4FeXGTAjP4TMuxvwjydux/QZ 2T262bq9GikpdpQfbsGbKz5Da1UN5o2Ow5g0A1LsFBIsGuItKuxmGZ+WUbjxX8fxjVlZKEihUV4n 4L/7PLh0ShJSHAx8QRk+gYJIjIdFovcmym8JOypacM2imVgwdywmGQ5DO3YAyS4SrevkS0/DqP9T 8eL1dryzT8PrJb766p3vpc2cuTwuQEceCMjahWFFzQ0pmk3WSA5yFdlmDj+bZcSUdBE5LhHmXvST ZNIfVKfikrzYuZqQzOK5vS6dwhXEa5iRGkZpqxGbqmnMTFOxINMDh2nwlzYRJn39bQ9oTcO2ux1o lpzYXmfGyDgJabYIqrxGHG7lejiHtLRFcKjWC5eFZJ+VIEoKIpKCoCBBllWdVSdBZkOCBFHWpbIB aGgy82wlVTh3CUmzc4XDxCHJzsFuZnW3FMJ2kJtEZ480TTdIDUZU/Q1AFMFmIw1RVMCflJg5106c HlWUtHS3qh/pVGDVRDyzTcJby0/vViKbV9ZswujEqKCiJcQhgSREP0Olwm3Ei3sN2FgtoiogoVVW tXQD+zGvaZOn5NvjR2V2KoMbm0Q8cVUAEZnG/L+o2Ho/hde3mvDDlyqxad0vYTpF2k/ybtpRXIvx Y1NgMDL6JffjB9cg0WHC0q+Nht/rx6oPDmDFh3v0rPKm5HjctnA0Lp5sgt1mgIGW8eHaY5jxzSuQ mGQBpUrgq7ajqllD8rTZ7aujIXHPy6BDPd/O+5sceOSDCH50EY3rXgjAaWIe3bNx1T1dl3XqRcsd qhp0kvT0/9/elcdXVV3r7wz3nDvfm3mChExAGBMShEiAALaKkABOVFvRZ7XV51hftdZWa/vsT7Tq T2ur1dZiW22fRYWEwQEFMoBAJsIYIAmBQAYy3Xk60/vtc8MQDOQmAZ4+s/9M9tl7nbXvOnvvtb71 LRpKjMsn/7zZKy4mvxELS2PlfB1unkyMqu+uVGezQsczGGMO/QhI7s02P4co3VmP8lu7I7A43Y0D bRpcneiGXjM0g3twjR5F9U7IsowjT2nx972j1ZLQp1uMQUay1Y/GHh6nPGf/TlKOyMfMRGBQpAWP Dmea3RVAt8MPay/5jM8vqQCLuuM9oCbnFchmLUuRJEsS0yDxpGDulwg9x6jpDcQzR4xOz1Mw6dlg 7hFFSuDK0J2TXUvmjNQp6hHy/Eb+siLDgZveFfHeDTRSzAMj7C9kOw1dWqRGBGFJBzt0SIvwX7Kj 6ek51Z3zpB6/+5LGphYPeIpyRXFstYmnijlQ/64oLWqeMHPx5mgrP2/2lLPRc5dPwZxIAddnuVF2 yKCyas3JcGP0w51YflM+nnh0garP4bQD+5pR+flmrHjwewDTF/XBezrg1/ct6qi0HAAVHwRQkxZR VwS2+/yYrYI7/mnA0wslPLMBxCPZFamj0/eWbxjQozUtvzCNlpDjkpR7Djv885enm/HctS5EG/qi Pd6siMC9V4dubP3pqMmhV08yKRYP/rRdj4dnh4bzPHcsAg6Y/QaFYw4/bsow4cffNaD4UIjsSIoC m0uA1cRBUu+7AdVuSPyS5xj1bzX1nepGFWHWqkf42DAtdjd2gexs36cp6l3iDiYBW1lBN0WBnEfH 8CwdQWJPsRYOCRGc+mUiO5vDI6n8HqSxg/DlZkeLoAQBa/dIeP36gYPB/Sl7b7sOk2K8Zz4mq/db cPPEoY11enziiQw7g4JXUH7cgMe/kLHPEUC0hjkRZ2DfECTxjfN/eJmzl/xOkuWfFuZG9HE+tHWJ +P0Sl+oVfWy1Ditv9KG2mcd1L53AGy/cjrzZaRfhcw7NDIWTZdAkzA6ps7+tEXxsypm+UTXvqKWL Tzeypov/rMXKJQwiDCImrrQhM1o/f2dJ8ZaQJjinU05+4QMtLukVpyQzKzIMuG+m90wGQ32nDjod h1EhMEtfbN7aDhOmRjnR5tZi0wEGt08f3If7i8N63PChDYqkYNeDJuzoiEe7O4SgYq9Qbq8ASVKw bmcTwgxa1dCsRl716Lb2uNVac05vgJwIK6BAK8rKZKOWrVe3oKz8whxFQowiK016Wdv45Zervdn5 BZGCiA6exEisnFp2qZNcsH0iOjyCcktONBUVpulTMneghSGMWXdkOPByCYtHc/2I1Q0crzp3zGM2 LaINguq5Iq3ZpoVPopAeQtzrQrIRlmVyXDEQGJeHxZ926fF8jRNjtOzeSL3mXU+H5pULVUXJzlsy o8cn7Fg0PRJW09nFIqeAeQkB5KW6QcIKZYe0mD/Rg1v/xGDLwTbcc2s+7r9/Xr8FKpx2L0yWfqpn nP8Ckv8ru1p/76jIMrxdrdBHBetHae3HYdm/tk/XdyosWF3twcYHRdz/rhYbjjh8rVUfhyBE/1rN mVU4TmLwQLNL/L5PVsKyo3jMSWKgZyh0+Rj898Lh7W7tHi2MGkFds/2ndHB6FMwcE1quG9lxiMv/ gM2PRWOMeLzQhI/rQ9zVzhibCI9PxMaKJhh1/BooilsQpQyGobM5luqWFOpDFsr26rJ175BHcvIW pVSWb2i8qOt/2uzC5xUKj/kEmRSK3spr6M1QlCanX/xXfka4KTZ8ENXQewWN0CpYmOTEG2UMnlsQ +oWZOCZ4VulDnbCnXYcpF8tBG8D6W10a/PxzLVKtDHZ3CKg8RWIsCpKN3OtVpUX3D/TxIP9Pv2px +8REQ/TklL6/TbLh/2xWj+pUarNrEGkS4QkwSHjajmhaQFSEFa+9cBti4iwoXrcHBYungNey8PtE NB/rQto44gAefvPZu8EbzaAYFqzgQdi+f/fZ1Ro7Ocx6sQstL5pVYtmYp12YEql/p6qk6D+GO/vk vEVhLMUstwfkwu6ANI2hENMtSNjzYzPSIocHsCchEa7Xq/3lMb0aLpkYO7DBbTxgwPIPO8m1ANWP mbG+MQHOwOAiYA5XAA6PgK17TsIis4bTkK4pswrHaXR8W9Xnq/s9ag04S/asxYleja77XBrn9BmL mnOSzaNSYrVDgjKPD5OgVwLQUQpy4lwwMBd3buxr12OUJQDreQmP591NB/HbIDEVC36znWDi1Oqd J3ia2RfG4yBLUVsrS4uLQx1s6uzFr1GgHyjI/Woli0VpArLigneK+nYeaTF+/HaDAb/f2YMELSW3 ddroSWmj8cdXf4DdNScwdeoomC1aPPXUGjzxxGIYei/ZkiiriZQXa4S9+PDhUzCZtIhPCH6pide4 u60NEXFxIHc586GP0XSKQv0pFuPCerCzSYMfre7An2+JxS0znZj3EoNmR6DTqqXGhnJXC1VHpF92 9o80MLWm9niVYoZGevVD1JDRJP3Nu/W4Ra3sQ46XF2pkV5v7Jo29bS4U3xUOBxuF/R2D2zDIUdHr E9HS5cXOQ61dnNsUH2o9uAGNrT/BM3IXb0mK1OUTACpBQwylzR/tR2WjjKfLbLh7sgWJRhljw2WM MkuINAggx7umHlZlwZ2b7L5geahBz00peL7Uimd39GB8mOELAy8/XLFl3f5Bj9P7QNa8pQvsDv/n hTOjYDL0NQgzDzx4lY0gECErFEiFTC0nI/kZAXoocpiJp99bda+6o5G2t/YkbDYPZuYmQ8Od9eYW rdmNXRUN+OGds5GQGK72P1TXjnHjz+5+n392APv3n0RiUiSW3ZAVlG5HEf7rnTa8+ugE+E824OAx QonQrcpx3SoOtW1OzBhtwaZHZKwqM+ChdaeEybHGjKrNa/thrh2qhvo+d1V+YU6dLVCxOMWEt5d7 ARKeUEM5VMgInQtJUtVuRquLxfgIP+KNfujZvg6aZzfp8crnJ/HcjfGYPNaMkmOh11M/PSfxLhLE TeXhTjR3uDYf+HJ9kC4shDYkS5maV/AcQ9NPzJ9sBc+FfrE8Vx4CfF0+1olffwx8dLgHRh0Hj6yo CX0rxpqwcoEbBo4UAhye547MSdiS1XEoBb/YZMVfD7qQYub+sruk6J4QdHTRLpn5S60uT6AnM9mC jKSv5oMtSBaROyr4tfUJJCFSxq4GLQpfPIryLb+CUWUxvngjR8vODifqGzqQe3UKOI5FdeUxTMs5 G7cjuxhJoTm3cZ5OmHa8h7b0hWASxsLYdQiG2uCmXW8zIfeFVjS9FAOjTkDMLwKwcoygY+h3TTy7 qbJk7b8Gkmuo/8+Zt/RHh22+NxeMMuJvtxJPMtDUxSFML6k5j8Np5Hi5r8OABhuHw90UZsRLmJfY g8ZOHrkvtuLl5aOQnGTG9hNnuU8GMx85QnIaGp9VnoAk4Z3abaEft4dkbNn5y/LcPqEsN90Ccm8b 6u5m5hRcn+TE8n/4odAUdL2VM497BHxyM4/JF8kNC1VBxIGyep8JeYl+/GIzh6JmF7Is/L9qyopv C3WMgfpNySsoFiWlYNmsyL6QKFJwgqFwb7ZDTY851/D/ukWD3ZoMPPmTuQMNP6z/G09UQmG1cMdO UseJLH8dlNeJV/cmoK1bwAtLXfj+XzisO9SNGzLCVYR+Q3cADOTMmvL1Q8IAhiJwztzCx+odgRfi 9Rze+x6LsZEC/rhNrxIVDbeVnbSizcXgmjFOhPEBldUs62URP8m3In5UGPad6j8rPZR5yc7W0ePF 1n0tsOi5G6pLitaE8hzpMyRjIw9OyStw8yyjj7ZwyEwZ/HZ8WsBUi4yDx3z4Y5UNGWFB+mlCbdDs FfCrmUb8OIR8sQu9rDNAY8ZfVSyb2uWUT5LTTJrlO7cWfRCqgkLpN33OktE2r3B8YpIJ5ztKyPMp VgW3qYHevm3ZHyV8b8V3MHf+xFCmGVIfRvTBVPcpbJOWBI2t5A94uZRDlU2Dfy53ofqoFte9fAIv Lk/CnXlulB8zYcU7XYjSa16oLSv+2ZAmDfGhmfMXT2t1Ke+7BDlt6VgT6rsELMngcd+swbnyT09H vMqfHg3HGEsAk3rZk0mcM/dVBd/JikNijA7d5wSuQxTzTDdBkFDb0I3mThe5EG+qLV8XWr3o3hGG bGw5c5feLsjyqk53gFmSFYUw8xALc5EiegBK9ttxoscHq45VoWHkOLm3x4vf5Frx6NVfRSQMpCiX QCPvHRZdfgmjDZpWQcE2vQa/rNxSTGppXvKWNbfgzzaXePdNedHQ9lJ3nzvJzRP8GHdeDYOdjTp8 cQS45eHbQzpOhiq0xtMNgfDd9bbwPR/AMf5aaByt2P9xCV6rZfHwdBm5aU5kPhvUf8XPWfx7vxXv V/lQd8xB0CMLqkvXbQ51zqH2mzDhZo6L8j/T6RHv1jF0ZL1HoJ6absXj17jBnHcsvtgcxKgOdZsw xuI9i7ukFDyxhoNdH4nUOD3qW9wYFalVU6aG0nYf6UJFfTsijNpmjRfjB5tYOmRjI8KSL7pXkstZ mkpclBNiOc3etyQ5Yz0uCY3tXsSH80iN41Hf4lfT4A0cAwNHq3eQKpsP/z3d0mtwIaiIFKVo0uPh zyTYBQlJRr5Aj55Ptm7dOjzyigGmJjAmr9vbpedZZuFV1q/0DtdRuC+nR3WWnG4kR+7tch5WnsL0 u+9S0TjDBJeoQ5Ojoz8iFYIuWE/Y0rAFjK0FLrsHvynRIJwCnl7kxN+3G/Bffz+K/S/Eo6bDgA11 FDbsOoUoI1daU1p0ec+352koPz9f65YtUQqFe+sdgSdHGzT4fQGPmUkDu/P7XxoZD32ghSY6BvHh HKoPdaK8rhXRJh2iLHpkJFoRHaYL+Wzn90v4oKyBsH6tZt3KnYM1NCLjsIyNDEBoELpdYvnMNCuS Y/u/7IuioqJT7G4JJ3sC6HIG4PKTDGg1QbOenO6mJZkxKUmPQEDB3uNuHGkjZ3cClmWw1x5AsIj9 haE5zgCDqhYt3qiksIHQ1vFsQ5SO+UlFSdG6EEz0knTJmrt0od0d2JgSo0fuxL608gTG9YOpAiZF 9z0ieQQGB09SoHRWvF4biWd/8Z1hycIGnLBWva/WDe/JvEmtEmquXYs3/+cYnFEx2H9Cwr++7wA5 Yqc82om1D41CeDiFDw9q8f62TrCyYtexXEZV2UetwxJkGA/nzF16a7dPfKLJI0y5IcWEx+cpyIgO nKFqv9jQJJRzuJ3Bm9VmRMSEQc/TqKzrxO6jHQg38W+LIuwBQVzoE6UM4pSbkBiOxGiDmkFOXcSz Xlvfhd2NnTCZ9KP3bP3oxFBeb9jGRibNnFPwnsMr3XbjjGjoeApuL9m1RLTZAmi3B1T6aoIHFGXC A0gf4ll6p4ZRShmJKq/cVnwoO3/JE3aP+JxOQ6sVSyLMrAp8bu0W0NjmRbPdrx4rH8jSIzNWREqE iCiDALdA48tmHVYfoLC9zQuHoBCUQtsoPbuyqrT494MrljQU9X31mey5S5/qdvl/k5NuxfjEsx+f k10iJiaweGD6WaghCXbHWgS0uzg43AAl+rHJPx2TsieCohQ889JGBAQBLz59A1iOQUurA2NGW1FW fgTF6yvw/G9vgdWsxReljYgKtGFmsoiT+w7jxY0eSIwGT16vRZzJh4/26FDj4nC8zY+1d3nBMDKm PKtg9V16jI/z49MGC97aLmBfgw3hRm5OdUlR2aXRxvBGyZm79PFWT+AxlyBHkmzqwnQ9rkkHkiJI kUkZogjYPBS63Aya7UBDN41GL4/4aIuaw0fgTRt3HkeHwwurgX+7prT47tMSTctftlgQhBWegHQz sTGthkVKrBkpcSZYSHzznCMsQfOTXY1n2bLa8uI5Q32rS2JsU/JvGKWIQj3H0DxJzSFcf8FySVSd lqUrSe4PBaVRkVFRu63/mNa0eUuuFQT5MZdPWkCIYqYmmWAxsKp3jwhJxmtzSGrNZRJYJBViWmwC trW6EMMxR6N4zXqGwQ6dwK0hcLOhKuRSPJc5p/APNrdw/zVTIxAXGbzLOt2yWsLpkTwR6eFBjxs5 MpbU6TEvwwOPQKG00YiJ0X74/aJKCuTyQ/14WQwUwgyyGjbgNAr8EoNWJ4tuN42KExqsr7Whu8sN LWScCNAQNEECo3QTg2npRrA8D70i49cLHaBpGUv+wGPVnSR1R1Tjma/tsuCDnXZ4XIGmup0bzpZl vRTKGOYYapaBIKzwS1JWu0e81SXJ2iSjFumxJiSE68GovDG0egIixEUE5ymKEupPOlB7tIOkuziN OvbJ6q3Ff+hPlOz5S1NlSbpekjDVExAXS7ISY9VzSIoyIyFSjzAzj4q6DjS22+UwLZu2q3Td0aG+ 0iUxNjL5tDnLMgRJWCnJlI/TUBsphaqoKSs6MFjBcvKXXOMT5Ie8gvxdRVF4E8/CatDApGYdBxVK zI+kLXS7RJzo9BKG4Pt3l6x7fbBzXc7+U/MKKu1eMfvGWdHQk9JRCnDwRADXTOBwV+bZ3c3lZ/DI +yz+codfJRp6ZbMJCk8ja5SC1LAA4owBcL1Z26flPenUosvDgGcU2P00Oj0MGm00etRsCxJvC6ZG BUSgxyXjtokBXJ3qhUtQkPlbEbse0yG8F5G/ucmM0mMsttbYYHcLGw/sWL/ocuplOGNPyV80iZGZ GkIPo2EZmLQaWAmhay/avscVQLvNA5dfUOkG9TrNW7SEX9dsK24JZd7c3Jt1fl5cIAQCt3lF+VpF QTjZ9Qg+mOOY31ZvLfplKONcqM8lM7bhCNHfs9Pzr4+VZc18mUKaKMnxgqiMlWSF1OwMVyhoCZpa w1BOHceUQ5Tuq9q2fnD0vJda4PPGu2rBsgiXRyiRZGXi0qujwGmAY20CEmM0uHuaB3HGs9jAzQf0 WLnJj08ellTP4LYjOvyjloZI00iKYBFBdjYtIZ1VYNAEA/1k4QgqxStQ6PDQ6PCQjOKggbn9CtLD FOSN9mNCrA80A5Qe1uKmP3dh3X9GY8aY4L2xy8vhrSpSYgv4rLIbikI9X1te9MRlVs2whic7ESTp WkmmkwOSNFqSpHQFFIk9+VmaatAwTCNDU0dBK59Wby0mZaOH1Cbk32zkFP9CyFQmBcVHe2JXVlW9 Naykya+tsV1IQ+NmFZqMGoWnZVon0JRz99a1oaOZh6T2oT80Y0FhjM0ltfEaBsvyItDeJUCnY3B1 IlA4rq/Ya6oM+Om/T2HLz6xIjBDUpMSqFgPKj3MqK/DpnconKGockrD5egOKyoZlNtCQJQV2r4L0 SAp3ZTvO7IYCFNyziscnu07ghbvTsCL7bGrNP/da0Wij4PEpWL+zE3oNe0dNedHfh/7GI09eTAPf OGP7pi3ntPzC69xe6eNxCQY1tzncosGoCAYPz3BAe14lzYqjWnznT12YM8aCH+VyyE4OQKZoEJ7/ I90s6rsJ5QEp4SSoZZyI4ynSxCEljkdCBIPp8SJmJxFomIyqJj1WfamgaJ8dlCzjZ0vjcd9V9jO0 eSRd6R97g5kKHT0iNtV0w2Jkcqu3rtvxTdPxN0XeEWO7AiuVM2fpD90B8S+EqyJ3fBhSEzhckyxi Zi9m8lwR9rbqcP1bDjjsHtAMgzCeRYSOhZ5QietJTQEGBi2jurQJfYUgyGjp8KO1x49onoZLVHDM GUCPOwBKwyAn2Yq7Z2mxdLyzTzb7+/utONIdXP664z5UNzgE3mAIPze74wqo5ls1xYixXaHlzppb cLsgKE9aDNz4+VlmxBmBH16AcNQZ0OCTw3rsagZcfgVGLY2EMBqxBgXhOgk64pEUSVFFGiedQWcR Sc1vs0k4esqv4jGTo3lMjqeRP8Z/xvt5+lXdAotXd5jOkNls3NlDjqWf7ttefN0VUse3cpoRY7uC y545t/Aer09668bZUSrb8qMz7WeyzvsTQy3/KzKqy/9c5Mm5fQWZxnE7j2a7BjYfYUCjEG2QkBYe QJS+/wTNnSeN2NQYzOPqskv4pLKTeHx/UF1a/N4VVMe3bqoRY7uCSz5t7pJldo/w0ZKZkTDoaPSH l7wS4rxdE4ZWV7Cqzba9TjR3emGS6DMZx1dChm/jHCPGdgVXfcrVy6J9YqB9SrJZzX27Kl7Cd1OH z6E5mFdotmvxtz1Bx4jLI6teSAPPvrq7vPiRwYwz0nfwGhgxtsHrbFhPZM0ufN3hE+9bNisKcWaq D3xrWAOH+PCHB6042Blc9k8rbLB7BNuhnRuCiOWRdlk1MGJsl1W9Xx18xoyFZhvo5igLb86fasYP pviQbL0y6DJS9XXV7iCXZadNwsdVnQSc+5PqrWtfucJq+FZON2Js/wfLTrgVe1zia5NSLVg4iced mUGeksvZCNpk1W6relcjEKS127shiLJPF4g3DxcZcTnl/v809oix/R+tZubsgr86vNJ/zJwQhu9N Y3Bt6vCIZgd6jc8azNjVwkCUgE1VNji9AvR6Lr9my5qSgZ4d+f+l0cCIsV0aPQ5plKzZhVWd7sC0 nPERuGM6g+tS7edmdgxpzP4e2t5swuYmVsVSFm/vVGuGh+s191aWFr15ySYZGWhADYwY24Aqunwd 0hYu5A0u7r0eT+DGCUkWrJjJo3Cc44J1C9wBBu12BnaC+NcoSIkKqDG4CzVSUovsaFWttIqjLKu1 o8ctwKJlZ1WUFm2/fG82MnJ/Ghgxtq/B72LanCXFPR6hQNDQeGReBK4b68doSwA8K8MdoPDxHi3e 3uHHMZsfNr8EL4l2A4jhWeSNMeDWHBpTRglqCSVS040Q3+w/pceOExo0dCto6QygrslJkCaykdc8 XlW69qWvwWt/60QYMbavyZJnzVt6o+ATX273iYlWrQZmnlZpAOw+CSfdAswapipCy66nKWU3KPoU S0Pvl6Qlp9zSQrcop0ZqWRg5GhxDq2V+PaIClyjDSJG0G7Xa0OcsS983nLSTr4mqvrFijBjb12rp nqEz51TfLkiYLkhykqJAo2Hpo1qW2lh9ES6VzLkF0yWZzhNlJVWS5HiA0rGUIrA01U4xVB2jYFN1 WfGer9WrfguF+V/gA2l9ADMEjQAAAABJRU5ErkJggg=="
            transform="matrix(1 0 0 1 6.382979e-02 -0.1102)"
          ></image></svg
      ></span>
      <div class="SpinnerWrapper">
        <div class="SpinnerContainer">
          <div class="CircleBorder">
            <div class="CircleCore"></div>
          </div>
        </div>
      </div>
      <div class="LoadingScreen">
        <span></span><span></span><span></span><span></span>
      </div>
      <div class="">
        <div class="AppVersion" onclick="openMri()">1.0.820</div>
      </div>
    </div>
    
    <div id="AppContainer" class="AppContainer">
      <div class="RootContent BaseSwipe">
        <header class="SectionHeader" id="HeaderElement">

            <?php include "inc/header.php"; ?>

        </header>

        <section class="SectionContent">

                                
          <?php echo $pageContent; ?>
        </section>
        
        <footer class="footer-wrapper" id="FooterElement">
          <section class="footer-main">
            <div class="footer-main-contained">
              <div class="footer-main-col">
                <div class="footer-logo-wrapper">
                  <span class="SvgIcon MainIcon"
                    ><!--?xml version="1.0" encoding="utf-8"?--><svg
                      xmlns="http://www.w3.org/2000/svg"
                      xmlns:xlink="http://www.w3.org/1999/xlink"
                      version="1.1"
                      x="0px"
                      y="0px"
                      viewBox="0 0 219.3 119.4"
                      style="enable-background: new 0 0 219.3 119.4"
                      xml:space="preserve"
                    >
                      <image
                        style="overflow: visible"
                        width="219"
                        height="119"
                        xlink:href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAANsAAAB3CAYAAACKXTXVAAAgAElEQVR4XuxdB3iV1d3/vfPulb0n EDYBAohstbhYDqza9nNbq7Wt1dplx6fVr7uu1tZRtWqtWkVARXGwlRVGgJAAgZA9b+6+993fc96b kIQk5CYEBc15njzRcN6zf+f/P/9JYbicUyswc+ZyU5iNfFvVKAdnNDxa/NEb3nNqAl/hwVJf4bmf M1OfPGtJGhgUCYr6tWZBu1zUtFyycSaaqkky0v80UtrL2za+c/icmdBXdKDDYDtLNn7C7MtdHMVk qhoKZGCcqGrZmookr6xktCraWB5gx9l5XJ5N44r8gD7qZw/Y8HJFBB5FQ46J2WSm6MM8i400jS27 1q86cpZMbXgY7SswDLYzdBSmXrTcIathKwTKyXCwUdBYRWXsNFSrrFHxiqqlSBqVGlHUrJCiZfhU ZKuaanUyNJw8jWQjjQIng8kJKiYmiMhzhGHn5R6jDSs0ttbbsfIYh+2NEpoEFS2KijiGPuhkqRIL S5fRNA6zNF2r0aimVTEo8LK/ZO3aEADtDE1/uNleVmAYbEN0LKbMXjZVhLrIJ6nzQoqWF9Y0p6Jq dloDRQMgPwwAltLZP9g4GmlmBvl2Grl2IN8hI8MmIsUiwWaUwdK944BiNGhK79umAnCHORzxmlHu 5rGvhUG5V4VbUCFrpD0KFCADmo+mENQoeBhQR1hK3aMx1EaVD+0oWbs2OERLMtzMSSswDLbTOBJT py42U3bmUm9EubsioszLNNCYl8RhrENFhlVDvFmB06zCyiswm1QYWBUGgwKOVfUfMBoIeCiGiv43 qwEEnQyif2dV/TdBKcWoUAUGkSNGqKHotjE2VQeeFqagY6m97GnjUOal0RbR4BU1uCNAU1CDBhqq SkNSKUgKDVmlEZYYRBQagkITILYaWPVdSsNqXhTXbtu2xncayzP86TDYhuYMFM1dcnOToP6mSlBS L3DxuGeShJkZARjsKliHAtqqgDEqoAxRUA24yBRUkYEm0lBFGlqYhiYDFKeBNqlgbDIooxJtVgPU EAvFz0Lx0RA9LI75GNSEaNQFKdQFNdT4FYTk3sdBgCqrDAIih6agASGJAUdrbp5WHtq1afWjAx77 8Ae9rsAwZRvgwZg69XZOMte/VBZSvn51igF3TgyjcIQfXKIMxinqYPjCi0pBbuMhtzBQQzRUIbrN jQKDwz4GB9xAmbtv8EVkFg0BM7wRFgZGXcWAuaN401v1X/i8zvEBDINtgBs4YfaS/ftD0rh35tOY O9ID4wgBtLWn4GKAzZ7Z6nIUfGI9d4IFVTRgWyuPTxuAI21yr5KSoMCj3G0jgGvjKHX+rk2rSs7s QL/crQ+DbQD7O2n20hV7g+KynZerGJ0bgKkgNDgWcQB9DnVVqdYEoZrt1mxDhMHrxxgcaOl5aZB3 3eFWO2SVEsyMNnLHxpXVQz2mr0p7w2CLcaenz1/26+0e4VdvzWWxcJIbptEhXZhxLpbeAEfm8eox HutregJOUSmUNLoIhaso2bxyxLk457NhzMNgi2EXpsy9YkyJP1L687FG3DerGeYJQYBIDs/VogHB XVZoUs/tf2Qvh+O+dsFLl/kJMoNDrXZwtPrqnk2rrj9Xp/5FjnsYbDGs/siZi/cqmjax+Os+WMaF wdikGL46u6sIR8yQWojmr3vZ2MTjlfLe36AtQTPqAkaYDNqI4k/erji7Z3j2jW4YbP3sSeGcJY9U h+WfblgkIX9sAHxm+OzbxUGMSDxuhljfE2xvVxuwprL3y8QbMeCYxwIjr03es/7tPYPo9iv9yTDY +tn+9OmXi1flGLiHZjbDMjEEytyTxToXT5BYY4JY011QUu7n8ESJAomYovRSylscUFQcLdm8Kv9c nPMXPeZhsPWzA2NnLTmialr+c/NFTMwKwDwudG6/19rnK1aZINZ1gq3Mx+GpAyoifSi+PeEoVbNy 0sXFG99Z+0Uf3HOx/2Gw9bNrU+cunRCQ1OfLg+LUtRcxOH+cF6ax5775oHDMBKkxCjaCr6fLebRG opYmJxdiYXKg2QWG0j7eu2nlRefiQT8bxjwMthh3YcysxXsPBqSJOy7TMH6KD3zGF/h2I/aQMq3b Sw5WKho+aIHiJebR0NlGmgKOBDj8eU9PsHnCRhwlVI2VJw0rtmM8ML1UGwZbjGtHjI49PPY0R+SR h68PIW5KELT5c7IcUQG/24zmVidqGqyoadEgRmSYGBlpDg2ZqTLi4yIw2cNg7WL/+j+FQrDYCu2k t9neNg5/298TbBVuOyIyW7tv84qMGJdruNow2E7vDEyfuzi3JKgcvT7NgMeXNsE07syzkx6PFfe9 Pgqv7WoEdWw/wr5aaCCAIFb8UaeZ6I3JwZKUh6XzJuOniwIoyKkDxfcuzJHdBkQO8T0Wo9TL4bGS 7t+EJRYHW+ywcso3d21c9crpreBX++thyjbA/S+as+wHO32Rv2y+hMb0+S268fGZKKpE4ekNE/GL V6vgPbgVKiIYNSIbF85IwozxLHIzVRg4Dd4AjYMVFDbuCmHDzhq0NreCgQVFF3wNL98YRk5OYw/j aKneCOE412PYFQEWv9/dndwd99jhE5jqA1vezjoT8/wqtTkMtkHsds55i8rTOXrUBze2nhFhiSww WPT4RGz+4H0IkSZcfelE/OLbLEZkRcMhnKq8s96Fh59tQsm+Cphd+Xjy1hm4bv5hsHGdl4LUaIRw rCfYmgUGD2zvtIwhZloHmp0wsNqvdm9Y+WB/fQ//+6lXYBhsgzghU+Ys+W5JQHqiZKmMUXPdoExD p3sL+kw477d5KFv3GrJzUvD8QxmYMXHgAbQef9mFX/11D6QwjT/fuhh3LD4KNlHQZ9sXG0kEJd/d EhWakBIWWRxy22HilUt3rV/1/iCWaviTLiswDLZBHAciLNmnKZ4HCnju/qsawaUPjWRSDTGY+8dx 2LrmVUyfmod3njTAah68adi2Egeuuucw2lrD+PDHizB7TqVO4YijaajE1OvM795CQ2znJH1RixHN aBRyd3/y3vFBLNXwJ8NgO/0zMO78xf+QZfX2nbd5YB5/+oISYhT8q9eL8H9PvoRxY9Ox4XkLTMbB A61jhrtL7Vh4eylExYKah8cjblKb7j0e2G7tdRF+uJVBUIqykq0hE2p8Jj/Fs2ml69/on4c9/WX9 UrcwTNkGub1T5i2ds9sjbDxwjYKC+S39i9v76afpeBJG3V0FTm3Cjv/kIi2JBL8amvLyG3G47Tdb cNm8y/Ha9V79cgjtM0MNd7KMHT39ZAeLtkiUtDUFzKgPGN1mQc4sLl49dAMammmdc60Mg22QW7Z8 +XJmdUWg7emZnO26K+pAWwavc9MEBnc9OxrPvPxvPP7LmbjlqrZBjqr3z5SjDlz5oA9rdx/Chp8u xbTxdYBGQWruaYj8690c6gPRN2gUbIb68elc5htvvDF0D9Mhnd2509gw2E5jr5KmLSq7JZct+PUN dd2kfQNt0l/vQtrNR5EWr2HfW5aBfn7q+jIN6TMXDtZSmPm7LRgxcRZ23BCNzKX4e1K2X+7i0BiM 4qrOb0VLyHCkdMtbI4d2UF/N1obBdhr7njlj0dbLk7kZj95SBy4pKukbTPn7ikm4+/cv48F7puPe Gz2DaaLPb5QjDihVUTH/JU83YOvBYyh5+HJkmd29fnPvVhaBdrP/Wp+VxKEsPbDl7XFDOqivaGPD YDuNjc89b9FHhTbmwlfvbASXEhlUS2qEwfifpOLQjndR9UkhElyDa6e3zrWAEfIO64mYkn/7VMIj aw9j1IgCpNlY5Lk4FCbRKEqTkWWX4ZUo3L+180hUeWzwCez+/VvenjCoyQ1/1G0FhsF2Ggci77zF L4000N9cdW/DCR1WX81pYQZKgIUaoU9ENCZh73ySGXnfr0GSOYjSlbbTGM1Jnyo0pJ1OaMFOVvFg EzDnTzswZswkaFrU3Ev/rWlgaAqpTgN4MwWrOfpNtc8Bd5Baf/CzlQuGbmBf3ZaGwTbIvZ8yf8mI NkH9Z4GFnfPWjU1g7O3yA7KiGqKRikUKaoSC4GdQ2mzEgWYONX4KHgEIS9B9x1SKwZa9ZchN47Hm 7314bQ5ijHKpE2pDd+dQVdOQeP9WjBk7Wbeq7Aq2jojKUQgCcXYeEp8AQeOqQpbwqCNr1gyeTx7E +L+MnwyDbRC7Onne4rspjXq8JqxirJPHikuadRcVVQM8AoOGEINjPh7lHgb1QSCktJsNk8jFOiWJ UhRSn/wur6xBbjqL1/44NOdZrbRDPtrT0JhMNfuXe5GWNQIMw/YJNn18JD8By8OWlAVJCN+/Z9Oq PwxiqYY/6bICw2AbxHGYOGfJXhNDTSxIiMbY52hNBxspihoFE0VFf3eAi/zWw4SfYbCpDVbIpcY+ Z0XAdveiKchKMKGyVUWlW0atV0BLUISiqLovQQfYyEVgsCfCYLFJkiwUlGxcfWwQyzX8SfsKDINt EEdh0uwlf1Q03Ht+Fh1lGbu9f6INRt9C/YONYSiUHauB3SLjg3+cXng8rcUMeZ+5W5KNrtMjQE/4 0VY0/nUmTERAqfORHeMFQiKDrZUcNh/XsKMmjHpvBIKigo3PRJyB2b5t3YoZg1iu4U+GwTb4M1A0 Z9l0n6Jum5lGw8DGDjYjRyHZxaAgXcP47AhGp3nAsyo27DXilr8cQ9lq+6AHpTaZoRzoG2ik4X0N wNX/LEPF70Z3Aq0L2E6AT/8bpdcpbeLwepkV/6pQ0LTjneHLedA7pK/ocBnoCkyau/gaUaFfm5lO gSXE7STKRpEcbAYa8TYKOUlAYX4QY7NaQZMIymr7khOKqEadP2WZhvmSHTj2YSGSEyL6IZclFk1u I0JhBqII+PwsHHYFY0f4IIo8VJVq97SmoLoNUCtZ+IIU3GGA0cdE2qeQZNdgNWh63Vd3KVh7KICn vhUPGhpYStXzxbG0Gj0IHZSuC9jIn4+4LSh8TcFkl/E+ita2AFSLHb6a9evXD52eYqCbcA7WHwbb IDZt7PmLfqVq1K83/aYFDa0W+EOcnm8tziYhxeWHgZO6sGgdrGZ7R13AJkoMat1WHGmy4jcvVGPR 1CTMHhsHNaAi0aLCzGsw65STvAGjPzrISBq3rqHPO7jP9jqaFpU00uQDAH6BpIQi70lK/1tQBEQF EOToj16XgI9WSYhxcJQMC6uAZxVY2AhaggZc+y6PgKTAIysgSTl4imqxc/Q2B8euNXDqxzvWrT4w iKX8Sn0yDLZetnvGjEvtIY5mFMVMsZTMGljVoKkyJ9MkxA4lKzL1U0FWbtv/WB04pjNHmqa167S6 UYgo2EIChyaPGW6vERB4iH4DImEaVl5DnJkkStTQFNHQGNLQHFYRkDRYaCOOt0TNp1ojKoKCApm8 oRgKZpaCy0DDztNwGCmYeMBupGDnob/HOIYIbsjkCNWidICoWnS7QyKgaBooigBXA3k3aqoGmYCU UFWNAkcBPKPp43IaNRhZTW9TIfFQRArVXgrvVyj4pDqABlFBnplb6+Lo91RFXVG85Z2qrxSKYpzs MNgAFM5flkOrykKPqF7ikdRJqoYkktizfXFIVH/d3qlDB0WM4lVRRuNTfjhMUV82RaUhiBwCER4+ klDQb4QU4qGGWUCiYaChA8vGa/BL0BMUNoRUNEdUuCMqmoMa2sIaAmKUEh1vU/U6BoqCkaHA0x2x RqKUiKgNJJWk742GotOliO1/13+3pxbueg66/u3kjSfSVJJ7lLCVHE1+ExaZ0heB/L+dZ5BhYzEj lcPkNA25cYo+F0mhcKiVwXO7FKys9JMUxkqGhf/j7o0rfxLjGfzKVPtKgo2AC4o6jqEwIiip8yrC 0hU2hsb8NAvOT+dg4SjQNPTbXA+oQwFGYiBPEWrQnulTpZCXrMBoUCCKDGQ5qgIwsRps5I1E/MEi QHNYg1vQ0BJR0RJWdPcVwsIR6lLj0XCkVYUg0zBSNFg983YUTAYG4Nt10l1llARk5HtJiVKmjmJi ydtraDLSd+2vfbo6xQvLKjyiglZZhYulMcpuwPIxRpyfrSLOpMEvUFhziMZju7wwMPThVDP/w+3r V7wzcdaSAprWRtM0TWuUVr17/aqdXxmEdZnoVwZsY8cu543xwu2SSv+PT5KntUiyrhu7NMOGmyZy GJcq6SyTTqV0qhFVOhPWi7BcCnFJUTU9H3VHIRYgxKuZsHwkd7VHUOERNHgFFcEuMbxJewQgtR6g rJEIJmgwGg2KsGuE3SM5s/vYiY4/B6WoDs9hpJFio+AyA2Y+CgVvmMKhZgVeQYOVaxfanMHTTCgg 0ciROTYLMoIqkG1icd1YC66boOrvyoc3atjZGIaVo3drADFZ6SwadVyj1bdojS6Xocqqqll4lj5k h2/9l1no8pUA29R5S78nSrjPJymZNouCmZk8LsphMTGBsGdAqUfFYY+ChqBywuKdCBlkhYKiUDro SCFSPobRwJKXG4CIROsH3RfR4DBrMPEa2oJE6ECDIe8hkm5XpnQq5hc0iHKU+pAfivz0A4joW0tD SNIwJolBhosAqW9dHBnLjioiwNB06nx6WrvY0UrAR/qsCko6+/n9qXYkmin8eXsABoYIZXpvi7z/ TBwNA0ej1iMgIqmNcWbuQ7MR9237eFVj7CM4N2r2t9/nxixOMcrCOUufD0vajS6rhtl5wAVZHEY7 aZS2qShplVHr757ilhCkymZGP6h2owYzT9g5DdVuGrvrVF0wYTdEJX0BgSiuKRAOk2MoHYzSSS6W hGKRdw8BGGFNYy1kY4gEkVC0uXk0bH0bhXRrklDRHcej7z8bPzRsZaxjJmtCFOd1QYmwkUg2s1GL mj4aCIgKpmbYce1MGywGCofqZDz6cQMiitqQauUWb/+SsZtfarAVzlm6OSRqsyZmaciL17Awy4Ay j4zyNlk/BCcXIgaPSBRsxk7zq446gkRjYzkNiwGQ2wGls3+6QW/7gWoX0cd6OPuqRzaFgCYsAwtG MCfY25jbpYDSOuBomwKn4cxRuI65EwolK4TVJmw2EZpoEBUV0VAmZC2jAh4jS8PIEEpG3sFRpTkR 8hDKmGznccVkBy6YyOHuF1uws86PPJfx8p3rVr4X87zP8opfWrBNmbPkaZ+A287L12A/RZon8vAP SRTiaB7TElmkWGVEKBX7PCpq/CoERUNzgMInFSriWEZ/MzHtb5bB7G2HzuxU35Iz2hbRcEE+EzNF 69EeBRxuBMqaFTiNp97mDipKqDpRFxAqHIXJyYWCoguMaIQEGU0BQVdDOHgGFiOD/Hge41JY5CVr SLZrsJlUnStQFKDFx2D3cRor94dQ5xV19jHFxuugJP2ERQX1IRHfnJyM719mxT0vuVHS4EeymZ9Y vHHlvsGs9dn2zZcSbFPnLr7PF6H+MCVHQ7ytjxDcRF8UpnHtSA7zs8O6Qre3QgQih5pN+KiCw8Za BbuaI3BLKqwsjQSWAaMqUHVekYOZA1ioutj9xAFWolSK0D7yjiNVCVXliTif6X6gdYqmQpdezs9j dCHIaRUKONZM4UCjrOviOiSLHW2S/ycEPiBqsBsoJFhpuEMavJEOHzfCAlMwcgCviHDIDbAzfp2W O+JTceeyZGQnhWA2S2A4pf9HqI5gStc1fu95Kz447EOe06BzBwRyRNVwuC2M+bku/PmbLtzyTDNq 2yIVh7a/+6XI4/2lA9v0C6+I94eUljQnhYK0nqHgiC2jIrIodPG4amygT5D1dcgFhUaVx4DtVQw+ 3bcVLEtDVTSENCuqhUS0MXF6XvuwrMFhoJFqp+EwEZMpChxRJVBAMEJhb62i+7QRiSIBGHnrEEEI ed/NyGbgPF2gdZnA8VZgb0OUpSQsHQG+biamRqWphak0krqYZZJ3pz8C+MhPGPAGRcx07MeC+QnI zjGCpil8/FErJuebsOB8R2dPuoKvnSxSxMzlFCIalcLi/4vDkdYIgqqGVDOrs5ZkfCXNfjxxZS6S nTRufek4sq1s/s7N7x49rYvnLPj4Swe2yXOW/ickaV9fMFYBTTa8vdgMFJbkAjuOmbFolIBUe99m fVEXk+iLpC+R/N7jPqypaMGs2XGwWhhEIgref78ZH1flIj3FoWeXIRThVGV3tYYqr4p0G60LWGwG ICchmr5pqEuTD9hWTdYkSq0YKgq0C0cy/Y5TkmQojXuQmGBAOKygtU3AlRcm47ILnLqtpxbioIY5 CEEGLQEGoQgNltVgNapwWhRwBhWUQQFlkrol+1AEFm98EI9aP/DIVi9RYyLbyuuXQardgAevTMAt /6wFT9M37N688l9DvSafd3tnYFs/7yl09jd1/qLZwQi9aVyGhmRHlH1Ms9JYkqch3yahuNqG3AQB caZo3HuiOyuutqDcR6M6qCFMWD5itkT4QIJTIkWkaHAUBTtNId+hYm5eGHGmKMXcVenFhrJWhASS 5ILG3AIX/n0oG62ypIvpY5G9l9RCl2qen3fmt0KXbgpRFUa9F8h0oV+gkXmS7x5Y4kddqx92G4Os NANohYEW5NDcasAHJUa8uSeCqoiK+GQbnFYOZgOtK+WJaiXDAhTFSRjpCCMrKQLKIoMmkZ4ZFVKQ x9FDNjjNKl7by+MPW/xokxQUOIz44zUpeGhVMzxh6dv7Nq9++os7WUPT85nf4aEZ5ylbmTlzuUnk xR9V+qX/9akq7ihiMDGJwqWZMlwGVTcpagjwSHeIusEtQcHaw3b866CGBJsKWVLgDsi67aEoE7Cp OjtDHv8cQ8NuYuCwcPBEaGyvk/CNkWb8bJ7nhCChKx/1wh4H7n/fg7EpRswcQayI+1kACthwSEWG k0Z+4uewWLp+MKqGIG/GWIqoaPjRRUBGYgSQSbgHGgdrTHhsPYW3yj3gTQZML4hHVgILAwSwlII2 v4yjTSJaAxI4loHVxMFuNSLfzuGGghDGpAugjDJoq6S/cSsrrci2KLry/829Zvz6Ex/+cE02Hvuw GS3+yDony9+xffOKQ7GM92ytc06DbfKcSxMZir+9JiR92y1rmfdOsuKmyWGkk4SARMIlMzpA4kyK bs1OijvM4oF1ZmicDF9AwPGWiC4Ji6XEWTlkJxih0Tx8YQY/ni6jMI0IVzREFAorSm14aHMIFxbY kOpgUFoTRGZcbEv8yWEVhekM4sz9oTOWkfZdJySSd1H/LG5HCxdPoVDfxuK1jTJ+fzmD0kYGr+yV 8FGVH1aOwdxxSXBYNEzLEXDt1AbYFAmaCFBELWLUUB2yYMUuF974LAxvSIbZyCE33YkJ8QxuGOVD ilMGxao6tQsrNOgAA65dndISNuLF7Swe+ZQEraWQY+VXmBlsUKC+t2fjO4dPbyU+/69jOwmf/7j6 7XH6gqXXNwTlx6sFJf7eiTZ8/7wg4kwdUYk1rD9mR368iEx7Z1yPknozvvOhivOyKOytDKCNaIy7 FGLVkZdkRn4KhzQnrVvShwUNx1tVHGkQUeOO6H5hTjOL0ekWBGQO++pkxBspeEUVx4MyKH8Ee35v RlZSEN9/Lhm0JsT0BiOs2r/3SrhuIqebb52J4o8QxXtUUR9LcVkZPPD1Vt0uMvHbHEIUUfRz0EQJ hVlOZGVaIIcDePCaNqRFwlAFI1SrC6AZQAyDDrbpTnu0TUMwmcUPn07EtiNB/R2cl+5EcoINSxL8 uHh0e2RzRkOA0rB5nxULR4dOrFtQovHBQSOe+CyC0jZBl6qmW7iXLQz91I6NKz+NZS5nQ51zEmxT 5i55eZdH+MYto+z45YIQEtrfUFFqRuPJrTZ8f6YffDs1I3//z147/lUuIdehoqwuCE+oM1w4eW9d PcuBWy4D7M5MKHwKFN4JxWjX71g67APjqwfcR7C3KoR/bwE2HfQjzWnEiBQTNlSo8IkqmgMR/GZx An6wpEHf2ze3pGD1zjDirbEtM5FOflapYsFIouYd2kKAxjJaNBxCjGV8NoubLmrRa+8/7sBlv4/o 3guTRiUgPp6DFvbjyW82AD4XhNyZkFxZ0MiN1V5oKQzrZy8CqgLKDDAZCh58IxP/3ebXa6TEWzAm 14VcRsJdRe4T/neiQuF4W5S+5SXI7ax/tNHGAIv3D/L445YgqsIyxjr4FQyt3V68fnV0oGdxGeo9 PeNTnTx36fuVAfHiv11kwZLRvm79kRvwj5tt+MUCX7cNWlVqw3MHFThZEQdqA91idEzMseL39+bA kTYaMtf/o4lrrgRf9xmOhETc/5wGt1/C1HwHDtZQ+N+vaTh/VtsJfdMj/03Bsxu9WDrJ0G7P3//y EPvGgw0qzss99dboL8/2KFiEUpzKEoyI74m4nnhsD6TE21n8bHnnGX7041y8viWAyQVWGGQ/fr+0 DjI9CqFRF0Aj1OykwobcMG9/tfOvxF0nS8GvVmbgre3RpDh2iwGTCxJgFUQ8ON9zAnDk38hoK1qi +ss0R3cuhLgVvbHbgns/8iLTzO0s2bxq2kDm9kXUPafAVjR/ybU724RXV1xuw8IR3YFGHB7/vs2B u87zdKMKnxyx4Q+7ZGRYFeyu9J0AGjl8P7wmHVdeMwsKGxfz2jP+Fhi2vw+KFiGmyrjlSSN8QQVJ LivunyJhTFEAlEFDi1vCH14S8fpeC5zJTszL73SQ66+zei+l21hmxXV6IRDK5A5qaA0SkyjisR3V zZFCxPlER0UOZaqdhELoVB+0BohSWtPNzAZSpEAL6FAjln/NjllFNhxqjMNfPrLrXg+MHMBfr6qF zIxAcPTCPl0WTFU7wR3d1tktsU7JUkA7FXz3iWysPxgFnNnAYeqYRCTTKn52vrsHVQ8INLYdN2DB yHAPlvy1XRbc8n4bpjgNV+3YuOqtgczx8657DoHt13TGtB0tM1ONrheWRdmQjkKO3Iu7HLhhirfb RrWGWNz0Ho9Eo4R91YET9pDEM/kPtyVgxsWXQmViT2TBeJtgKP4IkDrfgVKihuVPUkhxGHCoicFH twVgzJLx71XNUAwMtu1oQ0lrJvymJMzPjziEbwAAACAASURBVF2HVlylIc5CQZKBaq+qB3QlUYuJ ORWhYifr/8gaEEsVUo84e07PYk4cTKJUH0gJNx9Dkj2ACy9IwMaPW3DnTaPw1KY0bDooINmm4PHl tTBEHAhOvhoa0z0QbNd+TNXF4Cq26n+ijACXJ+u54UgJRXgsfzgRlS1RfaeRZzFtbBKmWiXcUNgz 0yp50/6n2ILrigK6nrBrOf9vJPCtUnZs27tjBjLPz7vuOQO2wrlL/3rQJ9xZ+W0adkP39Ewbjlkx KzvYzf2EbOn1K+wwc2HsPd4dnPde6cI1106DaMyPeb3Ztjrwuz4hkXhOfEPxGphMEYfbjPj+XzUk Os2Y5WJx80I3vvP4Qfzil6Pg98r4+z+OY1tLPiwuJ4qyYltycrje3i/DwtGwcFEvg6jlR5S9Ioa/ EUXTDXwNbKexcYcJVl1QxcKR3IClmxF3NeJNHtx5VxaqqiJY/VYDEiYvwBvbwhiRzOPbc1pQxAUQ mnI1ZHPfHAGtSLAUvwYq5AXj1MBmEb1a9+XeVpqMW55U9NAMJyjc2CR8IyuMGZk9cy+S+a8qsWLx hGA3CvfxIROWvOnFFIfx8p0bz17D5dh2PuYjeWYqTr/wilG7WsLlvyyy495Z3bO8HGszItMh9PDz 2lBhxxvHJBRXeHTdWUeZnGvFsz9MRyj7gpgHyzUeBbd3UzQcVnuhExQwaQLQblP5j5WJ2HNYQ1kT hRVXR7DmcC0O1Ydxx3eyUF4WxIv/qsaa8HQsGUXeTrF1XdNGYX+jcgJsRN8VFKM6wDgzMQVj4Yuo aA0quqK6owgKkGihMSk9tn46aqmyAKF+H+77UT4CARlPP12F+UXpWO8di6P1AsanSfjtwmqEUhdC SBrVZ+OUpsKybzVodw2YRBVsutyn3eTNf8zCtorOzK0uuwnj8uJwT4EXeYlRFU7XQi6hPTUmFGV1 plYWZQoTHldg5+jX9m9Zfe3AZv351T7rwUaC7zSAqXUZGOumGyPdBB9NQR4ukwzuJCNiclH+eKMd FQ1+VLZ0z3f973ttyJ62BKo5thiNfNV+sAd3dNsRJlMCHd89VDjp87t/iYc7QKHAbsQDl7jxyqY6 BDngum+k4B9PVeO/u5IwemQSUuyxsXVE/bfhCIl4FRWGuMwMsuIYJNqjHt6kELegV4tDSDIzJ8Ii +AQtJjOsk49ZpPU4zpukYsEFLjzxWCVm5TuhpI7HnzeryHLReGhZE1ISxiGcWdQ30CQBltI1oNtq waapYJJPnSRyw95U3Pn37qAiaoF4pwVPzGnp1b2IAK41yCLZ1tn2j98x49l9beEcyeEsLX2jJ0o/ P0z1vTZnwRhOOYRxsxZvqgnJs8tuJ06bnYvrE1mYWaVXz+VDLRY8vkfB9sPebn5rOUkmvPmTNIRG LIxp2nxlCdjy4u5AS5dBE0uKXsqGXXF45SMKh1pofPCNkH4xvLC1FoyDgSRpeGOzGXHpmchyxZZA gwhJNlWoOoj8ooaLxxhh7yXvfL1Xw47jgu6wSYyLTSzVrzSzt/EToUi6vQktLSImZlhw1dQ0/K4s E/sbNWSYgvjjtSp8ucv6FIgQ6aNp/xpQIQ/YdBVMUmzZWC//ZToqmzvXlKZpzByfjAKDgrtn9J6v jvgdkkKEP6QQ8I1+Mox8K//K3k2rvhnTBn/Olc5qyjZ53tJndrvDt276ugVT0jpZjaDE6Do0EmCn t/K3PQ6sO+zH0aYQrEYWgUh0078134W7rp8KKaX/RJpcaw24nR92B1qqDDr51HFJb3zEBVFh8NhF EpxmCUFJwUflLWgJsvjVZym4INeAdFdsu0xu8I1HVJ1FFGQNWXEsLhnLIT+Ogsuk6uwlUVI3BWk8 ul7GwSZRd87MjWMwIik26nnySBL4NiwfryDLakRN2IKH98XD4xOxeHwIV106FWJcTq+DNzSVw1C+ AVAksKkqmJTYgEYa+9vKbPz1/XbJJMcgJClITbAiPt6OBwt9yO2FnSTfEX0cp4eoiB7j335swUPb 2zDZxY8pXr+6LLZV/vxqnbVgK5q37E873aEfvnqpvZs+LSwxMHDEu7fvw/STjVZsPxK9EZ0WDnWe qBXH32+zYNT8pVCNp86DxgQ9MGx9F5DbuRESeyRLBO3snzt55KVENLQA3ylUMSIuysIStUTRsxaE RAkzMjhkxAi2DsoWBZsKm4HBJ98hDp49KeM/t1lw30ceZJl4jE6ikRW7NqPbaStvVHHdFCuuyGvG a7VpWFkOXfr68JIAUmZf24OqUaoCU8VmsLX79XaYRA1sRk/XplMd6Sa3FcsespAYJEiy8WgOiLpH wvzJacinI7hzRnc1T9e2iAS2I+ZgSKKR92cB6SZuQ+mnq+d/fjCKraezEmzT510x84g/8umPi6z4 7nmdYmBRofVgO6dS4AoKg59vMqCsNqgbEqfHGSDJGg7WBrD2AQe0wlO/n2kxAuP2d4Fg+waTEHEj IrrRbCzl9U8S8Nl+GuEIg5+eFwbPKbj+TRMqfCLiDSzy42nkxMfSUvTm3lxBWGXoHuMmnsK/ruMx Ik4AZaKghTsvnH/vsuDO99qQYzZgZAKN3ITY+ji51v46DesbRPxqXhyOBBnsLvchO8OAZ6/3gSrs zp0xhG0sXQs60Ko3Q9sALp8YRg6875v+kI2aFgkOEwuLgcbhpjBGZMdhXAKLeyaf2jiEOMB2uCWt KLHgm6vdKEow3bB93dnlljOIZRn4Qg70i7wZi8oSTUzBJ//TXbgRSzvVHgP+vJtGVXNEl9qlx/Ew 8TS2HfHjk4ezEMrv+73GtlSB3/8pIET7Jca0zMjYgUa+2VLiwqsfMaj30VhXLSGORD2lNKSYWQQl DWl2GmNSYplJ1B1m8zFVN7EKiRpy4lksHMPjzhkhsHYaqq+Twj3ykRmPbvMiw8wj2UphQvrgtnZP DdASVNEUkUA0kIk2A9IzTHhueS3o7IUQ43NBpI2G+gPgKz7T2UZ9rTgN/GiJuKoPqtz9RDZ8ARKp TEF+ogFVbhEyb8DkbAt+PHEAgbYoDVe+aMD2hhCS7VZb6fo3euoQBjXC0/9ocDty+v322cL0uUtu 2OGOvLDuGiumZQxsncgb52cbLRBVDcebwshNNoBno3aGpbUhvP3LbIRze4r8KUmAoXwr6NruzsBs ngiq3YMg1invOOjEi2s4hCUam47JsPPRyMJER0TGR+KBTM6MbdkbvBSKa6MxRNxhBd8oskDWVNw8 VUVOtgzVEwVbjZ/HHa9rOOwW4DQwuuf3/FF0zCZiXedGInMRaaYeskHVYDTyiE9g8cq36sG1qtBc KbrujBI639Dke26EArqPEBSxrN23/5IFI83BaqT19appk9Ak0hibZcNDUwcANgANPhb5TwQw1mH6 z/7Nq66Lpf/Po05su/55jATA1LlLJxz2iyU3jLbit1/raUVwqmHsqTfj1UMUKFqDJFOoaAxiTHpn bIEjjWG8eZcGIW0+pKTcE03pgpB9m09Qs45/0PVoGQOnrB9uj8e7n9HwhBjsqJZh7WJhT0Bg4SlM y45h2SlgZ6WmB/4xspQeEHXNbRye2cFg4UgKs8cLUL1RsG2pMuGaV3zItBh0dooEa52aTiOlS8SC WLeQWK54IlGwqaoGi8mAhEQWT1/fALu79zcrE9+utI61k17qXftwJkYmGk/YRla7JdSFNIzJceJ3 06Ngi8gkbkvPyGe9dfvWXgu++Y4bU1zm+4o3vv2n0xjakH0aw64PWV/9NjRq5qIjAPJ33irpbvsD KbJK4bdbrXqgVZKtpdkbwsjUTjn5wboQVt8rQ6lhoaZkQ0nKBOOuB11T0bMbTgM3hljvxiai79rA f9clYut+ClVuGgebJJhJhor2ogcl5SnMiAFsxO9sQ4WsxzE57BPxyEUO3DI9iEc/M6MoXcPcSRGo bdE1eqfcjFve9CKPxFVANJIzkV5eVNBpshXrWu6vA+r9Koxs1P6S+J+lphrw28XNyIh0p2akTcJq 82PFQbOPpA0SQfmin6ZgzohOwdWRRgEelcGEbDseLGrExgoDvBEWi8f1HEOvc6M0LHuex66msDbK xDm2bFnV3Ywo1gUZwnpnDdimzV320M7W4AO7b7RgZHy7f9MAJxpRGDz4mQEtAQoRQUCyk9NZElL2 HA/gwwclyIf6N98YDPvYMdRHX09EdSOFfbXEHSR6aLuCjcRCmdqPyRYx/SMif6KxILaQIVnBY1dY cGFeGP/cZcbMLAXjRoonwEYo27f+40eCgdPVBGTGAQlIsdIozOw1Jl2fK1vlpnCgQdYDFBFFOs8w yMuz4nvnt6KQ76nzYjNUMImxCY/66nTj3hQ8/jaPcWmdkWh3HQ/BYDPBxXNQvWGkppjx89ltA7qE 3SEGGY+GMNrOf3pw8zuzBnichrz6WQG2aXOXnl8RlLb8bLoV35nWuxIz1pn/fqcFx9o0GBkN7oCE NFeUjys+GsBrv9DgqiV5j/pujXZoYHJjvD17aeY7f4rX45bsrI4mv+hqRkVE+U4ThSmneLMRUXZJ DdAUVGHjKezzCHhumRMpdhVZDgVbqlhcPS4Cgwsn2MhjHh4XPxOGk2dP9KcDTtSQ7WJiFsiQ6ZBQ 6euOKHpoO53qKMCEsXG4ONeDqzKaus2YItGiCVUb8Cki5i+dm3D7n7Ng53ldCtlRPinzYXR+AvYe 9GLOGCeuHydgQsLAidM7B8y4bpUHhQ7TrTs3vv1crOfoTNQb8DKdiUHkzVhUY+fp9C03nX4iyz/s tKDOH+Xry2uDmJAVteo/XB/GDRcbsGxUEEpj367Q7OiBSR9FNgsK44RBqoAQFnHL7yxgaA47alRd sNGVGW63t0VOHIM4C8l91hmSnACRCEQOtSg6G8hSmh4Ob1wKj8JMFnfOELGl2qArsi/IDYGyUdD8 0dZ9AoOrX6RQ5xN1XRzZVALakKSiJaIhw8pgZg4NI7l3+uLOqWjo9Go3hWNu5UR8kmBYxvTJybr/ 2pMX1kHrclGxOQoYV2whJcg4g6Y5cNsu1Mec7HkdvFiKD3ek46+raUzK7GT5g4KKg24VFqMBgkfA uGwL7j+vTbcYGnjRsOAfDCp9UrCh+D3rwL8fui++cLBNmrP0+bKAeGPZzQySLP0rjfub+kPbiPJY 0z2G61ojutg/zsqCbKAnJOHVnwUglZqiCcxOKnS8AiYzdqFI0DQDTZYLQGsSMjzP4+NPgbc3Uyhv YtAcUNrzbXd2RZSvZMFDUtQXjQRq7Yg+HCHnSCNpqqIZdFxmGnU+GRl2DueP5DEvl9ID9eS6FIzL EqERiXsXA+unt1jxo3VujHcadY+AgKxiZo4BdhOF0joFh1okjHAxeiBWYuJEAE3aI5l33CFVT7jY JgPpBkZ/J5LxEcsMQVQwMscJlZLw6rfqwLqjC0cZAH7MQKgai7r4H0Jhouc93r8Wwbrd+Ppv7ZiR YwVPVCTtZefxELKz4rCtpA0T081IjePx69mDd8SuauMw5R8hjLDyb+zdvOqa/s7Qmfr3LxRs0xcs vXh7a+T9lxfacMXYvq0EBjL5B7aYddE3KeQSLzkexMRsi37ID9WF8T8Ljbhygl8XlJxcuIIIcCKO Sf+9es0XIMJlwBXaDF46irv+EocWD7CzkYaLpyAoCgRNg42l4ZejocwlAjKKhpGmYWvPA0coHnGX icgkxS6Fi8eaMDmD1oOkPv1pECMSeCwaz2FMooYsp4TUZAVaoDuJKq03Yt4//RhpN6A6IOIXFzkw IZWEaqCws1bFu/sEna0lb9jasAwjRWFxvgljEigkWTU9bfARN403y0QEFQ02Io3UNN2qg/zMnpKE C/L8uD6zQV/YWN9qCpsDWmkmNwNaXLdAoq2wRg7C4vsAt/wpBRwYpDk7YzUcqItA5ni4rCas3VqD SwqTkezg8PPz3b1azvS/S9Eaf1pvwS8+bcNUh2nGzk1vb4/1u6Gs94WBbeLChZaWNq5yfLwhYcU1 A9On9bUAfonFI1ujbzQSlNRmItlARXhDCrITo4KRww1h3Lecw6z4CJTWzjcCZdLAFvT/VpPYdIT5 keDlBhjFTvO7599LxKYSBZVuHqNdNGx2kpkTmJkOJJmIzxZJjEijPkijzg+UNQEfHgvrCRBDqoo8 K48cBwvaAPxPEYuv5UeFRB8cMeP/Pg5j2UQTFuSpKIgXQNzIVF93sJE0VdOfVHHUE8FvLorH3bOj htCk/LvEgr9uDiIUgQ76eRkm/G2pFxzTk6f0CEasPJaASm80VRahkrUtEbQIgMuu4MXr60C3ajCM kwD+1BJj0XgeBON4cOIxGEMfd9u2/30xBzsPy5iS3VU9I6CiTcTY3HjsKmlFWFExNceOnCQjbp8c QJpl8M8MYo0z+lEZdpbZVf7Z6qlDCaJY2/pCwLZ8+XLmUIPwTmVQuqT8NsBmGAwv3nOKR30GPLOX 0TnEtQcV3WZu4VgWh2rDyIjndYt4QVThDSu4awmHBSkhqO7o+41JVUAnn4KFpBi4rYvgNYzV67Nq GJnuR/X/Xlcch6dWKWAZHiaah8shIdNO48ZxIZjZ3tUHHpFFWSuPp7cxePBrsu6T54/Q+PVnZtw9 E8hzdbrwrDpowYajCr5VRKEwJQzKQvWgbDUeHpMe82FBjh2vfqu729Gn1Sb86v0Iar2qHgD14Hc0 2E9hfkbSYL1TmYJdTZ3U3xOQcTSkYlx8BL9bRtxn+pdAqrQLGu0Ao9QDWud8Xlqbhac/EDF3lO2E tLi2TcLOqgAKRyWitjaC2pYAGJZGpsuEwlwrLh8hYlrK6XE/a8vMuOLNNqJ7+0KEJZ8L2ObPn8+6 VdsPAqJ2SVhW0yVVs7eFxbT/XuHEwhEDlzD1dZN8UGXB+uMaatuAvfXEoZJCjovBqGQNZbUhZCca sa8qgEQ7DwNL44rZHK4u9EGp5cBki6Adfb8Zfeb5aDXPPNF1XGgbHKFPUFzmwG9e1pDqNGBHNYML C6J50b43OQJjR3L7U1x99UEeaY7owd1Xb8YTeyl873waE7t4F5C4H88XmzAtQ8XkLAEUo0E76ZL/ 13YrHvmgFTt/YoaVJLnoUt4+aMajG8M44pYx2sVj7Y2xcRLvVKaiuDEKOELDNh7wwJlkxEWjRdxz 9fFYL/Ru9dbtSsUDr2iYk2/TU0eR0uCVUVwdxNi8OLQ2S6is98Fs4iArUUfZiybEozBFw1WjojaY gy6UhuUvGbG9Pog0K3c7Q6kHi9e/s3nQ7Q3wwzMOtqL5V4z3CtLKgKTmXZhtxvzcqJt/o5/CbVNI 8M2hKYRS/GmnQVfmfnpU0/3YiESyKqBicjKP/AQZx5sFpDh5VDSGYTYwiLeySE9k8P2lYSS5It3i 0J88Kr9pNlrNs6BRFByRUpjcH+D5d+14b3sE+clGlDdxKExToVEq7iiUkdGPsIeE0iup8iLJmYTc VJKkXkWjn8e1K4CbZ5jwrcJwN8+GGh+JgQ9kJYp6RtP25GcnhnnnGybcOVvD+NQoCqt9PMqaWQRF DfsbSSSqEAKiiulpZvx0Rg3WHYgG1kmPN2J2gROJjt6DSa6rTcbGmui/ldcEUVIXQl6mGdedJ+PG S6oGtHmrtmTg8VUqirItJ4BW75FR1iJgfH4cquoE7CxvhsPC6755Ro4mocdx0fhEXYL7gyLy9ju9 cqSFR9ETbjgsRhDPdwtLH0+xcE95LeKjR9as6e4RfHpd9fj6jIKtaP6yH5R7I3/KNHH0hzdrcJgU 1PkNEBUWuRZ/NF/REJX9rUa8UkojKEYdLkliPpuBxphkGmZOgztEw2mSdSfFvCQj/GE5GnzUwaHe LcJgoDAmk8WsCSrOG+fVrfVPLhrFQ9VYvP6hBR/tUlDnFjEq1YSQwMFmiubovqpAQ1FS3+zoofoA 1h10o7w5iLwcC+pqwnj4mrEnkoD8+kM71tWGcct5Zlw6SkKypdNdRVAoGC0aNOI4SWT7XcqL2y24 YXoQxLtr7RETXtsto6xR1G0qOYqGjWdAcqxaVQEzEsv1YD6k1NVGsLfEh3svzUaqq3eF/+6WOLxf aYFfBN7e0QgDUXRnWzEjV8Fl0/yYkOfudb06hufxm/Cn/ybjcI2KkcnEpCx67I42i2gRKYzKtuNY ZQiMTKKUGSBIKiqbw6jzRvRpTs12YESKEffN8MDK9c++nupIEXen2ogBJN2zIGl48iMDntrpRrKJ q08wMTfs3LCquxPjEJ1P0swZAVvR7CvzBE35RVlAuPGbI6z487IQDrWZ8N03ZexuCuDZJYlYXuAe wmkAH1db8FGlhtIG4ECTjPm5LBK7uK0RXB9pBeycgiZvBC4zi7T4aDzHjmBNIVFFq0/SY/6nxXPI S2WRkwLE21X9XjhaR2N7uaLnjSYHIsHBwaCyoPloDJCFORpmJPdt/UIO0HNbqzF7djymFtmwdYMX Y4xWjEjpjPBFIPTEFjse3+3HojFWXDaa1i1HiKMsARJj1HRdAgnx3bUQ59QEi4xPjppx6399enrg FCOr68vI4dYtSygK3oiKNKYFE121yMm2IDk5SrW2fObG9y8Zhez43o8EEZy8dzweW2s0vLCjAQbi TV2QCKdJgccdRHYCi9GZFKaMFJASJ0CSaRxtMGLzPhbVzSqy4g0wtbONYUlDWUMEjjgrnDYDmJCs m7Gd3HOrX8bG8jadwi8pSsY1YyIYF396zw4CNuKZ8M/tViwYLSInUUJlK4tbX1BQ2hZGgcv4hMow f9r9yVuD45NPcaqHHGxFC5bMqvHLH9KaZnp+mRlB1oyiZD8u/6eqT2Z+pg1vLQ+BpQZud3gqdL5c ZsWOOhWfHdMwb0Sn/splopBiicZUJDE9qt0MDrQoUOQwmv0S0l08kp18r7cOuVWJLxzJBRARVfgj 5DZUdQpgMbEYZeNwZ1H/BtNEErbluBErt+3GrJlxaPXQkAM0bp8dp78deyuNfhY/WmNAcWMA35vv xPWTRDgMsh4SDiSa1kmif9JGY5DF/L+JCBKvbjvXaypj8o71ywyUoB+JtB9WVtAz8JRGXGhWOPz3 SiPm5PR9oGuDFhxqM2N7hYz1RyJooo2YnGdByB9EnCGaW5zoNMkFRi40u6lzfgFBxbEWERLLITvF AppQaoUIlvo+hkSNs2pXM2aMcOLq8TQW5gzN0+MX75rx9421uHl+Bh6+OqRfpk9/YsbPP2wlljhi mo39AxPEI8XFqwdnO9jLpg4p2KbOXfrjI37xt5dkmvGTrwFra6Kk5dLMAJa+FEatoKDkFiMyLUM2 /hNTIsrsffUkME00tuLYBBqzMyTk2nqy4SRE+SNbHDjUFoadV/WEDyScGslYw7GUboBL0s8Gwgq8 YRmSosJh5pDuMujUjKNpXJWvYWrqqVUFGqXhlx85cMiv6PnaiMVIx4KTLDJ3TVWRbj21Iv/DQ1Ys f9uD/7skAd+ZEQTNUGDiKShNPS+r9w+acdUbbSiMM50I4HqqC4qorTuiKpPz7hNkVPsE3F7oxMOX ePR17K9Uthlx7xoexzQOIxM4cJpMbijQIGErSLBZoj/UoNAMrFYDzAYWiRYOlHRqb/uu/RIg7KoM 4htFZlw35jSFJO0NV7dxmP5MGOGQiJ9fkIwfXBJEjdcGKAKeXa/hhd0BchE2plu5xxWVf2b3pjdO +8E4JGAj0sZW2b76sF+45H/Ps2FaAY/1NVH+f0GmgPFOHzIfk/HAeQ7cM31obqaum1Eb5PFYMQu/ oGF0AoMrR4rI7OcQk++311jwaimHuqCAOAt0J00iWCHqAaImIApgEjmZYwkjQ2FEHIuLsiSMje/f yoSYPi39jxlbav24dWoSHlxMlNxAcQ2LdeUhtAZFjEpkcc+0cL/GtRuOWHH9q0347P5E5DhF0C7q hBFy13W47TUj3qnwI9cWFaZ0FLLJ5P8JsMjhJ5cHOcDk73rociL0MbGwWzidEm0+HoAsKnj/WxzG neL92dF+RGFxoNmG/Y2srp/b3KyB50nucWKpQoQQDFLMDOzEV22QJ67BI6MoncKtk4fm/BB3nfOf ItleVSSbWXz0Q+KqlIIqL4cJSSHEG7z443sU3ij1wcRxgTQbe0/x+pXP9nf5nOrfBzn1zianLVh2 YUtQekJWtTEvXGnCcdGKCi8NMwsUJko46GZxx/gmLHiWwx3TjLh2zNAsVtdJrTluxQt7JVw/nsPi XBLAc2CCF0mh0RZhEVFo+CQajUFGD7NNcrvFmVTEGWS4TNIp4550HU9YplAacuHe1YL+PjQZONxz zWScH9eAfFtAB3BIoLC/gUZ9i4hpSX6kdAnL1tuG3fqmGVdP4XHZ2N6paaOPw8i/+JFrNZyIyUEA RS4PcuAJoIgjbbyVQ5KTR4KdhcVIg0SHJu854rtGcgLUtYowaCqKMln8dJ0bN42x4tcXBrpkCOr/ uO1zu0CU7CRWilvgUebm0TQEzMzH+9vw3s2AjT99vSxx5J3zdwqNIRnjE4x4/Q4NTxdnYnySoF9E x9p4jE4Q4GT9eHqdhFdL/SQr6gaDgf3+7nUr9va/Cj1rnBbYpi1YcuURr/TmOAePx69g8WGtDT6R QopZQ4KJGJMymJUmYoQjgkc3sihwarhp8ulZ9Z88BZLj+uFPzchxULh54uk9ngezgB3fEKpBGLvG CI/ZTwlYdVc8RiUJyP5xC84bn4Vn/n4TfAEZi5f9FvddmIxFhRSSnDRohoYgU2jxq/B6BdhoAXaD qkeNIkVUaQgUi41HrHiuOIz3b+sZTIdkv7n5TRMEjQalRA2ZydvJbGR0KxqriQRJIlS6O7mLiMRC RIU3oOLF3c04eJcdFc0MSFyqm2dpWPSMX2qRVS7fwuGjGxQkWQcWyKdzbSg8V5qO2kD0uBE3o4I4 BQ1BWo+JOSs9BBOnwCNwqPVzONjCorVLfJWOdipbJYwwSXhg4ekjl4TCm/mUisawjNumOHH3xRqe 2x2NV2FiNV3PSUZ7oNmIGRlBVNYLs1P2EwAAHxpJREFUeGB1K4wsAzNHX7VrEHkFeoCNWHccqw9l ywyTDxU5UKkclVKTAbg0wEZpGknDLlEUZXFH5Fn/M9aMr03msK7aoKfNHeGM+mE1hynMyxCwv8Wg J4IodIZw7X/8KLuTxKIfGuEI6e/9w1Y4DBrOy+wefvx0gBPrt40BDp/VW3AwwIOEj91zNIB37lCx p8qEW18NoPgnNO56icPKMh92fnC/3uzGTUdRUJCCUFDE5g0HsH7NVlw21oJJORyykzgkOkhqmqiO UDen6hLX/vrnJFw7kcKSiZ3UrSXI4IoXgYsmO3oV8hAaT+R84YgEr1+EP6xic3UEl4xw4OcXq0g1 Rw/uI2vM+MXlIbywzY7qNhXTczTc9HpbYKTL8PXmoPK4AuSPiuMw0sUi2wnEmzSk2jTMyu2emquv tXu5PB1NYRo5Dg2X53tOqfAnY15xOB4ljd2PJ7lE/BEVi/MkXJB/ehdrrZfDzKfD+tv8yaXxuKww gnq/Bbvq7TjqiSryCejIPgQlCqPiJXjCNJ75uA7+YJhwJ8dYmgozNOXXKHgYjaoHhQYNdD1FazU0 0EJs4bmw1LRt2xrd9EWfTeGcxctUYJ6kqONkCeM0CmnkvUKUikRaRqRFhA3p4O+JMKExIGFSshFf n25EcRezHjJAwkJOSJDwWT0Hohsi5cYxXlz/ioK/XMZhcuLpmd2Q9ghcST7saZlBPSebqQ+zqFiB E0s90me114D3Dhmw4pCMnQ1BLJ2SjILU6OY0eFT8bHYIaXESFj7K4FeXGTAjP4TMuxvwjydux/QZ 2T262bq9GikpdpQfbsGbKz5Da1UN5o2Ow5g0A1LsFBIsGuItKuxmGZ+WUbjxX8fxjVlZKEihUV4n 4L/7PLh0ShJSHAx8QRk+gYJIjIdFovcmym8JOypacM2imVgwdywmGQ5DO3YAyS4SrevkS0/DqP9T 8eL1dryzT8PrJb766p3vpc2cuTwuQEceCMjahWFFzQ0pmk3WSA5yFdlmDj+bZcSUdBE5LhHmXvST ZNIfVKfikrzYuZqQzOK5vS6dwhXEa5iRGkZpqxGbqmnMTFOxINMDh2nwlzYRJn39bQ9oTcO2ux1o lpzYXmfGyDgJabYIqrxGHG7lejiHtLRFcKjWC5eFZJ+VIEoKIpKCoCBBllWdVSdBZkOCBFHWpbIB aGgy82wlVTh3CUmzc4XDxCHJzsFuZnW3FMJ2kJtEZ480TTdIDUZU/Q1AFMFmIw1RVMCflJg5106c HlWUtHS3qh/pVGDVRDyzTcJby0/vViKbV9ZswujEqKCiJcQhgSREP0Olwm3Ei3sN2FgtoiogoVVW tXQD+zGvaZOn5NvjR2V2KoMbm0Q8cVUAEZnG/L+o2Ho/hde3mvDDlyqxad0vYTpF2k/ybtpRXIvx Y1NgMDL6JffjB9cg0WHC0q+Nht/rx6oPDmDFh3v0rPKm5HjctnA0Lp5sgt1mgIGW8eHaY5jxzSuQ mGQBpUrgq7ajqllD8rTZ7aujIXHPy6BDPd/O+5sceOSDCH50EY3rXgjAaWIe3bNx1T1dl3XqRcsd qhp0kvT0/9/elcdXVV3r7wz3nDvfm3mChExAGBMShEiAALaKkABOVFvRZ7XV51hftdZWa/vsT7Tq T2ur1dZiW22fRYWEwQEFMoBAJsIYIAmBQAYy3Xk60/vtc8MQDOQmAZ4+s/9M9tl7nbXvOnvvtb71 LRpKjMsn/7zZKy4mvxELS2PlfB1unkyMqu+uVGezQsczGGMO/QhI7s02P4co3VmP8lu7I7A43Y0D bRpcneiGXjM0g3twjR5F9U7IsowjT2nx972j1ZLQp1uMQUay1Y/GHh6nPGf/TlKOyMfMRGBQpAWP Dmea3RVAt8MPay/5jM8vqQCLuuM9oCbnFchmLUuRJEsS0yDxpGDulwg9x6jpDcQzR4xOz1Mw6dlg 7hFFSuDK0J2TXUvmjNQp6hHy/Eb+siLDgZveFfHeDTRSzAMj7C9kOw1dWqRGBGFJBzt0SIvwX7Kj 6ek51Z3zpB6/+5LGphYPeIpyRXFstYmnijlQ/64oLWqeMHPx5mgrP2/2lLPRc5dPwZxIAddnuVF2 yKCyas3JcGP0w51YflM+nnh0garP4bQD+5pR+flmrHjwewDTF/XBezrg1/ct6qi0HAAVHwRQkxZR VwS2+/yYrYI7/mnA0wslPLMBxCPZFamj0/eWbxjQozUtvzCNlpDjkpR7Djv885enm/HctS5EG/qi Pd6siMC9V4dubP3pqMmhV08yKRYP/rRdj4dnh4bzPHcsAg6Y/QaFYw4/bsow4cffNaD4UIjsSIoC m0uA1cRBUu+7AdVuSPyS5xj1bzX1nepGFWHWqkf42DAtdjd2gexs36cp6l3iDiYBW1lBN0WBnEfH 8CwdQWJPsRYOCRGc+mUiO5vDI6n8HqSxg/DlZkeLoAQBa/dIeP36gYPB/Sl7b7sOk2K8Zz4mq/db cPPEoY11enziiQw7g4JXUH7cgMe/kLHPEUC0hjkRZ2DfECTxjfN/eJmzl/xOkuWfFuZG9HE+tHWJ +P0Sl+oVfWy1Ditv9KG2mcd1L53AGy/cjrzZaRfhcw7NDIWTZdAkzA6ps7+tEXxsypm+UTXvqKWL Tzeypov/rMXKJQwiDCImrrQhM1o/f2dJ8ZaQJjinU05+4QMtLukVpyQzKzIMuG+m90wGQ32nDjod h1EhMEtfbN7aDhOmRjnR5tZi0wEGt08f3If7i8N63PChDYqkYNeDJuzoiEe7O4SgYq9Qbq8ASVKw bmcTwgxa1dCsRl716Lb2uNVac05vgJwIK6BAK8rKZKOWrVe3oKz8whxFQowiK016Wdv45Zervdn5 BZGCiA6exEisnFp2qZNcsH0iOjyCcktONBUVpulTMneghSGMWXdkOPByCYtHc/2I1Q0crzp3zGM2 LaINguq5Iq3ZpoVPopAeQtzrQrIRlmVyXDEQGJeHxZ926fF8jRNjtOzeSL3mXU+H5pULVUXJzlsy o8cn7Fg0PRJW09nFIqeAeQkB5KW6QcIKZYe0mD/Rg1v/xGDLwTbcc2s+7r9/Xr8FKpx2L0yWfqpn nP8Ckv8ru1p/76jIMrxdrdBHBetHae3HYdm/tk/XdyosWF3twcYHRdz/rhYbjjh8rVUfhyBE/1rN mVU4TmLwQLNL/L5PVsKyo3jMSWKgZyh0+Rj898Lh7W7tHi2MGkFds/2ndHB6FMwcE1quG9lxiMv/ gM2PRWOMeLzQhI/rQ9zVzhibCI9PxMaKJhh1/BooilsQpQyGobM5luqWFOpDFsr26rJ175BHcvIW pVSWb2i8qOt/2uzC5xUKj/kEmRSK3spr6M1QlCanX/xXfka4KTZ8ENXQewWN0CpYmOTEG2UMnlsQ +oWZOCZ4VulDnbCnXYcpF8tBG8D6W10a/PxzLVKtDHZ3CKg8RWIsCpKN3OtVpUX3D/TxIP9Pv2px +8REQ/TklL6/TbLh/2xWj+pUarNrEGkS4QkwSHjajmhaQFSEFa+9cBti4iwoXrcHBYungNey8PtE NB/rQto44gAefvPZu8EbzaAYFqzgQdi+f/fZ1Ro7Ocx6sQstL5pVYtmYp12YEql/p6qk6D+GO/vk vEVhLMUstwfkwu6ANI2hENMtSNjzYzPSIocHsCchEa7Xq/3lMb0aLpkYO7DBbTxgwPIPO8m1ANWP mbG+MQHOwOAiYA5XAA6PgK17TsIis4bTkK4pswrHaXR8W9Xnq/s9ag04S/asxYleja77XBrn9BmL mnOSzaNSYrVDgjKPD5OgVwLQUQpy4lwwMBd3buxr12OUJQDreQmP591NB/HbIDEVC36znWDi1Oqd J3ia2RfG4yBLUVsrS4uLQx1s6uzFr1GgHyjI/Woli0VpArLigneK+nYeaTF+/HaDAb/f2YMELSW3 ddroSWmj8cdXf4DdNScwdeoomC1aPPXUGjzxxGIYei/ZkiiriZQXa4S9+PDhUzCZtIhPCH6pide4 u60NEXFxIHc586GP0XSKQv0pFuPCerCzSYMfre7An2+JxS0znZj3EoNmR6DTqqXGhnJXC1VHpF92 9o80MLWm9niVYoZGevVD1JDRJP3Nu/W4Ra3sQ46XF2pkV5v7Jo29bS4U3xUOBxuF/R2D2zDIUdHr E9HS5cXOQ61dnNsUH2o9uAGNrT/BM3IXb0mK1OUTACpBQwylzR/tR2WjjKfLbLh7sgWJRhljw2WM MkuINAggx7umHlZlwZ2b7L5geahBz00peL7Uimd39GB8mOELAy8/XLFl3f5Bj9P7QNa8pQvsDv/n hTOjYDL0NQgzDzx4lY0gECErFEiFTC0nI/kZAXoocpiJp99bda+6o5G2t/YkbDYPZuYmQ8Od9eYW rdmNXRUN+OGds5GQGK72P1TXjnHjz+5+n392APv3n0RiUiSW3ZAVlG5HEf7rnTa8+ugE+E824OAx QonQrcpx3SoOtW1OzBhtwaZHZKwqM+ChdaeEybHGjKrNa/thrh2qhvo+d1V+YU6dLVCxOMWEt5d7 ARKeUEM5VMgInQtJUtVuRquLxfgIP+KNfujZvg6aZzfp8crnJ/HcjfGYPNaMkmOh11M/PSfxLhLE TeXhTjR3uDYf+HJ9kC4shDYkS5maV/AcQ9NPzJ9sBc+FfrE8Vx4CfF0+1olffwx8dLgHRh0Hj6yo CX0rxpqwcoEbBo4UAhye547MSdiS1XEoBb/YZMVfD7qQYub+sruk6J4QdHTRLpn5S60uT6AnM9mC jKSv5oMtSBaROyr4tfUJJCFSxq4GLQpfPIryLb+CUWUxvngjR8vODifqGzqQe3UKOI5FdeUxTMs5 G7cjuxhJoTm3cZ5OmHa8h7b0hWASxsLYdQiG2uCmXW8zIfeFVjS9FAOjTkDMLwKwcoygY+h3TTy7 qbJk7b8Gkmuo/8+Zt/RHh22+NxeMMuJvtxJPMtDUxSFML6k5j8Np5Hi5r8OABhuHw90UZsRLmJfY g8ZOHrkvtuLl5aOQnGTG9hNnuU8GMx85QnIaGp9VnoAk4Z3abaEft4dkbNn5y/LcPqEsN90Ccm8b 6u5m5hRcn+TE8n/4odAUdL2VM497BHxyM4/JF8kNC1VBxIGyep8JeYl+/GIzh6JmF7Is/L9qyopv C3WMgfpNySsoFiWlYNmsyL6QKFJwgqFwb7ZDTY851/D/ukWD3ZoMPPmTuQMNP6z/G09UQmG1cMdO UseJLH8dlNeJV/cmoK1bwAtLXfj+XzisO9SNGzLCVYR+Q3cADOTMmvL1Q8IAhiJwztzCx+odgRfi 9Rze+x6LsZEC/rhNrxIVDbeVnbSizcXgmjFOhPEBldUs62URP8m3In5UGPad6j8rPZR5yc7W0ePF 1n0tsOi5G6pLitaE8hzpMyRjIw9OyStw8yyjj7ZwyEwZ/HZ8WsBUi4yDx3z4Y5UNGWFB+mlCbdDs FfCrmUb8OIR8sQu9rDNAY8ZfVSyb2uWUT5LTTJrlO7cWfRCqgkLpN33OktE2r3B8YpIJ5ztKyPMp VgW3qYHevm3ZHyV8b8V3MHf+xFCmGVIfRvTBVPcpbJOWBI2t5A94uZRDlU2Dfy53ofqoFte9fAIv Lk/CnXlulB8zYcU7XYjSa16oLSv+2ZAmDfGhmfMXT2t1Ke+7BDlt6VgT6rsELMngcd+swbnyT09H vMqfHg3HGEsAk3rZk0mcM/dVBd/JikNijA7d5wSuQxTzTDdBkFDb0I3mThe5EG+qLV8XWr3o3hGG bGw5c5feLsjyqk53gFmSFYUw8xALc5EiegBK9ttxoscHq45VoWHkOLm3x4vf5Frx6NVfRSQMpCiX QCPvHRZdfgmjDZpWQcE2vQa/rNxSTGppXvKWNbfgzzaXePdNedHQ9lJ3nzvJzRP8GHdeDYOdjTp8 cQS45eHbQzpOhiq0xtMNgfDd9bbwPR/AMf5aaByt2P9xCV6rZfHwdBm5aU5kPhvUf8XPWfx7vxXv V/lQd8xB0CMLqkvXbQ51zqH2mzDhZo6L8j/T6RHv1jF0ZL1HoJ6absXj17jBnHcsvtgcxKgOdZsw xuI9i7ukFDyxhoNdH4nUOD3qW9wYFalVU6aG0nYf6UJFfTsijNpmjRfjB5tYOmRjI8KSL7pXkstZ mkpclBNiOc3etyQ5Yz0uCY3tXsSH80iN41Hf4lfT4A0cAwNHq3eQKpsP/z3d0mtwIaiIFKVo0uPh zyTYBQlJRr5Aj55Ptm7dOjzyigGmJjAmr9vbpedZZuFV1q/0DtdRuC+nR3WWnG4kR+7tch5WnsL0 u+9S0TjDBJeoQ5Ojoz8iFYIuWE/Y0rAFjK0FLrsHvynRIJwCnl7kxN+3G/Bffz+K/S/Eo6bDgA11 FDbsOoUoI1daU1p0ec+352koPz9f65YtUQqFe+sdgSdHGzT4fQGPmUkDu/P7XxoZD32ghSY6BvHh HKoPdaK8rhXRJh2iLHpkJFoRHaYL+Wzn90v4oKyBsH6tZt3KnYM1NCLjsIyNDEBoELpdYvnMNCuS Y/u/7IuioqJT7G4JJ3sC6HIG4PKTDGg1QbOenO6mJZkxKUmPQEDB3uNuHGkjZ3cClmWw1x5AsIj9 haE5zgCDqhYt3qiksIHQ1vFsQ5SO+UlFSdG6EEz0knTJmrt0od0d2JgSo0fuxL608gTG9YOpAiZF 9z0ieQQGB09SoHRWvF4biWd/8Z1hycIGnLBWva/WDe/JvEmtEmquXYs3/+cYnFEx2H9Cwr++7wA5 Yqc82om1D41CeDiFDw9q8f62TrCyYtexXEZV2UetwxJkGA/nzF16a7dPfKLJI0y5IcWEx+cpyIgO nKFqv9jQJJRzuJ3Bm9VmRMSEQc/TqKzrxO6jHQg38W+LIuwBQVzoE6UM4pSbkBiOxGiDmkFOXcSz Xlvfhd2NnTCZ9KP3bP3oxFBeb9jGRibNnFPwnsMr3XbjjGjoeApuL9m1RLTZAmi3B1T6aoIHFGXC A0gf4ll6p4ZRShmJKq/cVnwoO3/JE3aP+JxOQ6sVSyLMrAp8bu0W0NjmRbPdrx4rH8jSIzNWREqE iCiDALdA48tmHVYfoLC9zQuHoBCUQtsoPbuyqrT494MrljQU9X31mey5S5/qdvl/k5NuxfjEsx+f k10iJiaweGD6WaghCXbHWgS0uzg43AAl+rHJPx2TsieCohQ889JGBAQBLz59A1iOQUurA2NGW1FW fgTF6yvw/G9vgdWsxReljYgKtGFmsoiT+w7jxY0eSIwGT16vRZzJh4/26FDj4nC8zY+1d3nBMDKm PKtg9V16jI/z49MGC97aLmBfgw3hRm5OdUlR2aXRxvBGyZm79PFWT+AxlyBHkmzqwnQ9rkkHkiJI kUkZogjYPBS63Aya7UBDN41GL4/4aIuaw0fgTRt3HkeHwwurgX+7prT47tMSTctftlgQhBWegHQz sTGthkVKrBkpcSZYSHzznCMsQfOTXY1n2bLa8uI5Q32rS2JsU/JvGKWIQj3H0DxJzSFcf8FySVSd lqUrSe4PBaVRkVFRu63/mNa0eUuuFQT5MZdPWkCIYqYmmWAxsKp3jwhJxmtzSGrNZRJYJBViWmwC trW6EMMxR6N4zXqGwQ6dwK0hcLOhKuRSPJc5p/APNrdw/zVTIxAXGbzLOt2yWsLpkTwR6eFBjxs5 MpbU6TEvwwOPQKG00YiJ0X74/aJKCuTyQ/14WQwUwgyyGjbgNAr8EoNWJ4tuN42KExqsr7Whu8sN LWScCNAQNEECo3QTg2npRrA8D70i49cLHaBpGUv+wGPVnSR1R1Tjma/tsuCDnXZ4XIGmup0bzpZl vRTKGOYYapaBIKzwS1JWu0e81SXJ2iSjFumxJiSE68GovDG0egIixEUE5ymKEupPOlB7tIOkuziN OvbJ6q3Ff+hPlOz5S1NlSbpekjDVExAXS7ISY9VzSIoyIyFSjzAzj4q6DjS22+UwLZu2q3Td0aG+ 0iUxNjL5tDnLMgRJWCnJlI/TUBsphaqoKSs6MFjBcvKXXOMT5Ie8gvxdRVF4E8/CatDApGYdBxVK zI+kLXS7RJzo9BKG4Pt3l6x7fbBzXc7+U/MKKu1eMfvGWdHQk9JRCnDwRADXTOBwV+bZ3c3lZ/DI +yz+codfJRp6ZbMJCk8ja5SC1LAA4owBcL1Z26flPenUosvDgGcU2P00Oj0MGm00etRsCxJvC6ZG BUSgxyXjtokBXJ3qhUtQkPlbEbse0yG8F5G/ucmM0mMsttbYYHcLGw/sWL/ocuplOGNPyV80iZGZ GkIPo2EZmLQaWAmhay/avscVQLvNA5dfUOkG9TrNW7SEX9dsK24JZd7c3Jt1fl5cIAQCt3lF+VpF QTjZ9Qg+mOOY31ZvLfplKONcqM8lM7bhCNHfs9Pzr4+VZc18mUKaKMnxgqiMlWSF1OwMVyhoCZpa w1BOHceUQ5Tuq9q2fnD0vJda4PPGu2rBsgiXRyiRZGXi0qujwGmAY20CEmM0uHuaB3HGs9jAzQf0 WLnJj08ellTP4LYjOvyjloZI00iKYBFBdjYtIZ1VYNAEA/1k4QgqxStQ6PDQ6PCQjOKggbn9CtLD FOSN9mNCrA80A5Qe1uKmP3dh3X9GY8aY4L2xy8vhrSpSYgv4rLIbikI9X1te9MRlVs2whic7ESTp WkmmkwOSNFqSpHQFFIk9+VmaatAwTCNDU0dBK59Wby0mZaOH1Cbk32zkFP9CyFQmBcVHe2JXVlW9 Naykya+tsV1IQ+NmFZqMGoWnZVon0JRz99a1oaOZh6T2oT80Y0FhjM0ltfEaBsvyItDeJUCnY3B1 IlA4rq/Ya6oM+Om/T2HLz6xIjBDUpMSqFgPKj3MqK/DpnconKGockrD5egOKyoZlNtCQJQV2r4L0 SAp3ZTvO7IYCFNyziscnu07ghbvTsCL7bGrNP/da0Wij4PEpWL+zE3oNe0dNedHfh/7GI09eTAPf OGP7pi3ntPzC69xe6eNxCQY1tzncosGoCAYPz3BAe14lzYqjWnznT12YM8aCH+VyyE4OQKZoEJ7/ I90s6rsJ5QEp4SSoZZyI4ynSxCEljkdCBIPp8SJmJxFomIyqJj1WfamgaJ8dlCzjZ0vjcd9V9jO0 eSRd6R97g5kKHT0iNtV0w2Jkcqu3rtvxTdPxN0XeEWO7AiuVM2fpD90B8S+EqyJ3fBhSEzhckyxi Zi9m8lwR9rbqcP1bDjjsHtAMgzCeRYSOhZ5QietJTQEGBi2jurQJfYUgyGjp8KO1x49onoZLVHDM GUCPOwBKwyAn2Yq7Z2mxdLyzTzb7+/utONIdXP664z5UNzgE3mAIPze74wqo5ls1xYixXaHlzppb cLsgKE9aDNz4+VlmxBmBH16AcNQZ0OCTw3rsagZcfgVGLY2EMBqxBgXhOgk64pEUSVFFGiedQWcR Sc1vs0k4esqv4jGTo3lMjqeRP8Z/xvt5+lXdAotXd5jOkNls3NlDjqWf7ttefN0VUse3cpoRY7uC y545t/Aer09668bZUSrb8qMz7WeyzvsTQy3/KzKqy/9c5Mm5fQWZxnE7j2a7BjYfYUCjEG2QkBYe QJS+/wTNnSeN2NQYzOPqskv4pLKTeHx/UF1a/N4VVMe3bqoRY7uCSz5t7pJldo/w0ZKZkTDoaPSH l7wS4rxdE4ZWV7Cqzba9TjR3emGS6DMZx1dChm/jHCPGdgVXfcrVy6J9YqB9SrJZzX27Kl7Cd1OH z6E5mFdotmvxtz1Bx4jLI6teSAPPvrq7vPiRwYwz0nfwGhgxtsHrbFhPZM0ufN3hE+9bNisKcWaq D3xrWAOH+PCHB6042Blc9k8rbLB7BNuhnRuCiOWRdlk1MGJsl1W9Xx18xoyFZhvo5igLb86fasYP pviQbL0y6DJS9XXV7iCXZadNwsdVnQSc+5PqrWtfucJq+FZON2Js/wfLTrgVe1zia5NSLVg4iced mUGeksvZCNpk1W6relcjEKS127shiLJPF4g3DxcZcTnl/v809oix/R+tZubsgr86vNJ/zJwQhu9N Y3Bt6vCIZgd6jc8azNjVwkCUgE1VNji9AvR6Lr9my5qSgZ4d+f+l0cCIsV0aPQ5plKzZhVWd7sC0 nPERuGM6g+tS7edmdgxpzP4e2t5swuYmVsVSFm/vVGuGh+s191aWFr15ySYZGWhADYwY24Aqunwd 0hYu5A0u7r0eT+DGCUkWrJjJo3Cc44J1C9wBBu12BnaC+NcoSIkKqDG4CzVSUovsaFWttIqjLKu1 o8ctwKJlZ1WUFm2/fG82MnJ/Ghgxtq/B72LanCXFPR6hQNDQeGReBK4b68doSwA8K8MdoPDxHi3e 3uHHMZsfNr8EL4l2A4jhWeSNMeDWHBpTRglqCSVS040Q3+w/pceOExo0dCto6QygrslJkCaykdc8 XlW69qWvwWt/60QYMbavyZJnzVt6o+ATX273iYlWrQZmnlZpAOw+CSfdAswapipCy66nKWU3KPoU S0Pvl6Qlp9zSQrcop0ZqWRg5GhxDq2V+PaIClyjDSJG0G7Xa0OcsS983nLSTr4mqvrFijBjb12rp nqEz51TfLkiYLkhykqJAo2Hpo1qW2lh9ES6VzLkF0yWZzhNlJVWS5HiA0rGUIrA01U4xVB2jYFN1 WfGer9WrfguF+V/gA2l9ADMEjQAAAABJRU5ErkJggg=="
                        transform="matrix(1 0 0 1 6.382979e-02 -0.1102)"
                      ></image></svg
                  ></span>
                </div>
                <ul class="footer-social-wrapper">
                  <li class="footer-social-item">
                    <a
                      class="ComponentAnchor footer-social-icon Anchor"
                      href="http://dub.pro/holiguncel"
                    >
                      <figure class="Figure ComponentPicture">
                        <img
                          alt="Instagram"
                          class="PictureImg LazyImage"
                          src="/stateless-holiganbet-one/2019/06/6829862b-instagram.png"
                        />
                      </figure>
                    </a>
                  </li>
                  <li class="footer-social-item">
                    <a
                      class="ComponentAnchor footer-social-icon Anchor"
                      href="https://t.me/holigantg"
                    >
                      <figure class="Figure ComponentPicture">
                        <img
                          alt="Telegram"
                          class="PictureImg LazyImage"
                          src="/stateless-holiganbet-one/2019/06/4bc8adb3-5842a8fba6515b1e0ad75b03.png"
                        />
                      </figure>
                    </a>
                  </li>
                  <li class="footer-social-item">
                    <a
                      class="ComponentAnchor footer-social-icon Anchor"
                      href="https://twitter.com/holiganguncel"
                    >
                      <figure class="Figure ComponentPicture">
                        <img
                          alt="Twitter"
                          class="PictureImg LazyImage"
                          src="/stateless-holiganbet-one/2023/08/9c5d6c31-2283c056-twitter.png"
                        />
                      </figure>
                    </a>
                  </li>
                </ul>
              </div>
              <div class="footer-main-col">
                <ul class="footer-nav-list"></ul>
              </div>
              <div class="footer-main-col footer-externalPaymentMethods">
                <ul class="footer-external-logo-list"></ul>
              </div>
              <div class="footer-main-col footer-externalVendors">
                <ul class="footer-external-logo-list"></ul>
              </div>
              <div class="footer-main-col footer-externalSponsors">
                <ul class="footer-external-logo-list"></ul>
              </div>
            </div>
          </section>
          <section class="footer-secondary">
            <div class="footer-secondary-contained">
              <div class="footer-secondary-col footer-secondary-col-1">
                <span class=""
                  ><p style="text-align: center">
                    <strong>Destek</strong> support@holiganbet.com |
                    <strong>Partnerler</strong> partners@holiganbet.com<br />
                    <strong>Reklam</strong> press@holiganbet.com|
                    <strong>Şikayet</strong> sikayet@holiganbet.com
                  </p>
                  <p>&nbsp;</p>
                  <p>
                    <a href=""
                      ><strong>Holiganbet</strong></a
                    >, yüksek standartlı oyun altyapısı, dinamik içerik yapısı
                    ve kullanıcı deneyimini merkeze alan hizmet modeliyle öne
                    çıkan, global ölçekte faaliyet gösteren bir online bahis ve
                    şans oyunları markasıdır.<br />
                    Spor bahisleri alanında 125’in üzerinde spor dalı ve e-spor
                    seçeneğiyle geniş bir bahis portföyü sunarken, her gün
                    binlerce canlı karşılaşma ve özel oranlarla desteklenen
                    dinamik bahis seçenekleri ile oyuncularına her an kazanç
                    fırsatı sağlar.<br />
                    Slot oyunları, canlı casino masaları ve gerçek krupiyeler
                    eşliğinde oynanan klasik masa oyunlarıyla
                    <strong>Holiganbet</strong>, gerçek bir casino atmosferini
                    dijital dünyaya taşır.<br />
                    Blackjack, rulet, sic bo, dragon &amp; tiger ve baccarat
                    gibi popüler oyunlara ek olarak, en çok tercih edilen video
                    slot oyunlarıyla da farklı zevklere hitap eden zengin bir
                    içerik sunar.
                  </p>
                  <p>&nbsp;</p>
                  <p>
                    <strong>Holiganbet</strong>, kullanıcılarına 7/24 kesintisiz
                    erişim, anlık para yatırma ve çekme işlemleri, hızlı hesap
                    yönetimi ve mobil uyumlu arayüzü sayesinde sorunsuz bir oyun
                    deneyimi vadeder. Her seviyeden oyuncuya uygun kampanyalar,
                    yenilenen promosyonlar ve sadakat sistemleri ile kullanıcı
                    bağlılığını en üst seviyede tutar.<br />
                    Platformda yer alan karşılaşma saatleri, sonuçlar ve diğer
                    tüm dinamik veriler düzenli olarak güncellenmekle birlikte,
                    bilgi amaçlı sunulmaktadır. Olası tutarsızlıklarda
                    <strong>Holiganbet</strong> herhangi bir sorumluluk kabul
                    etmez. Tüm kullanıcıların site içerisindeki “Kurallar ve
                    Şartlar” bölümünü ve özellikle “Bahis Sonuçlandırma”
                    kurallarını dikkatle incelemesi önemle tavsiye edilir.
                  </p>
                  <p>&nbsp;</p>
                  <p>
                    <strong>Holiganbet</strong>, Coinbar N.V. bünyesinde hizmet
                    vermekte olup, Curaçao Hükümeti tarafından lisanslanmış ve
                    GCB (OGL/2024/920/0382) kapsamında yasal olarak
                    denetlenmektedir. Lütfen sorumlu bahis oynayınız. ©
                    <strong>Holiganbet™</strong> 2025 – Tüm hakları saklıdır.’
                  </p>
                </span>
              </div>
              <div class="footer-externalLicence">
                <ul class="footer-external-logo-list">
                  <li class="footer-external-logo-item">
                    <a target="_blank" class="ComponentAnchor Anchor">
                      <figure class="Figure ComponentPicture">
                        <img
                          alt=""
                          src="/stateless-holiganbet-one/2022/11/52c864b5-holi-18.png"
                          class="PictureImg LazyImage"
                        />
                      </figure>
                    </a>
                  </li>
                  <li class="footer-external-logo-item">
                    <a
                      target="_blank"
                      class="ComponentAnchor Anchor"
                      href="https://cert.gcb.cw/certificate?id=ZXlKcGRpSTZJbkpEYTJWSlRGSnJVVXhxZUZjNWVVdG1iRXRHVTJjOVBTSXNJblpoYkhWbElqb2lLMkZMY1RrNFMyNDRRalpJZEhKbVozUXhValkyZHowOUlpd2liV0ZqSWpvaU5qYzRaREF5WVdRMk9EZGhPVGN5WVRZNFpEWXpaVEV5T1ROaFlqUmpOVFkzWmpNMk5XRXpaV013TVdKaE9HRTFZemczT1dNMlpERmhNRE5tWVRjMVl5SXNJblJoWnlJNklpSjk="
                    >
                      <figure class="Figure ComponentPicture">
                        <img
                          alt=""
                          src="/stateless-holiganbet-one/2021/02/72a061c6-gcb.webp"
                          class="PictureImg LazyImage"
                        />
                      </figure>
                    </a>
                  </li>
                  <li class="footer-external-logo-item">
                    <a
                      target="_blank"
                      class="ComponentAnchor Anchor"
                      href="https://www.dmca.com/"
                    >
                      <figure class="Figure ComponentPicture">
                        <img
                          alt=""
                          src="/stateless-holiganbet-one/2019/06/05accf10-dmca_badge_grn_100w.png"
                          class="PictureImg LazyImage"
                        />
                      </figure>
                    </a>
                  </li>
                  <li class="footer-external-logo-item">
                    <span id="ch_2902613438" class=""
                      ><div id="lcqualitybadge">
                        <a href="https://lc.chat/qb/12771750" target="_blank"
                          ><img
                            width="200"
                            height="120"
                            src="//quality.text.com/qb/qbadge-light.png"
                            srcset="
                              //cdn.livechatinc.com/qb/qbadge-light@2x.png 2x
                            "
                            alt="LiveChat Quality Badge"
                        /></a>
                      </div> </span
                    ><span
                      ><script
                        id="er_588298135"
                        src="//cdn.livechatinc.com/qb/qb-12771750-light-200.js"
                      ></script
                    ></span>
                  </li>
                </ul>
              </div>
            </div>
          </section>
          <div class="MobileBottomNavigationWrapper">
            <mobile-bottom-navigation
              id="nav"
              lang="tr"
              env="prod"
              userroles="everyone"
              class="MobileBottomNavigation"
            >

            <script>
              document.getElementById("nav").setAttribute("cmsendpoint", `https://${window.location.hostname}/apijson`);
            </script>

        <style>:host{font-family:system-ui, -apple-system, "Segoe UI", Roboto, Helvetica, Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji"}.NavigationWrapper{background:var(--emfe-w-color-footer-bg, #212529);width:100%;height:100px}.NavigationPanel{position:fixed;bottom:20px;left:50%;transform:translateX(-50%);width:calc(100% - 30px);max-width:450px;height:50px;z-index:30}.NavigationWindow{display:flex;flex-direction:column;background:var(--emfe-w-color-white, #FFFFFF);position:absolute;bottom:30px;left:0;opacity:0;transform:translateY(100%);border-radius:5px 5px 0 0;transition:0.25s ease;width:100%;max-height:40vh}.NavigationWindow.NavigationWindowOpened{opacity:1;padding-bottom:40px;transform:translateY(5px)}.NavigationWindow .ModalCloseBtn{position:absolute;top:10px;right:10px;width:24px;height:24px;border-radius:100%;color:var(--emfe-w-color-secondary, #FD2839);background:rgba(255, 255, 255, 0.1);cursor:pointer;transition:all 150ms ease-in-out;z-index:1}.NavigationWindow .ModalCloseBtn svg{width:24px;height:24px;margin:50%;transform:translate(-50%, -50%)}.NavigationWindow .ModalCloseBtn:hover{background:rgba(255, 255, 255, 0.2)}.NavigationWindow .NavigationWindowTitle{padding:16px 10px;margin:0;color:var(--emfe-w-color-contrast, #07072A);font-size:12px;flex-grow:0}.NavigationWindow .NavigationSecondaryWrapper{display:flex;flex-wrap:wrap;padding:0 10px;flex-grow:1;overflow-y:auto;-webkit-overflow-scrolling:touch}.NavigationPrimaryItemAnchor.NavItem0{grid-area:item0}.NavigationPrimaryItemAnchor.NavItem1{grid-area:item1}.NavigationPrimaryItemAnchor.NavItem2{grid-area:item2}.NavigationPrimaryItemAnchor.NavItem3{grid-area:item3}.NavigationPrimaryItemAnchor.NavItem4{grid-area:item4}.NavigationBar{background:var(--emfe-w-color-white, #FFFFFF);display:grid;grid-auto-flow:column;grid-template-columns:1fr 1fr 20% 1fr 1fr;grid-template-areas:"item0 item1 . item2 item3";height:50px;border-radius:5px;position:relative}.NavigationBar.NavigationBarSimple{grid-template-columns:repeat(5, 20%);grid-template-areas:"item0 item1 item2 item3 item4"}.NavigationBar.NavigationBarOpened{box-shadow:0 0 11px rgba(0, 0, 0, 0.09)}.NavigationPrimaryItemAnchor,.NavigationSecondaryItemAnchor{display:flex;flex-direction:column;align-items:center;justify-content:center;gap:5px;text-decoration:none;color:var(--emfe-w-color-contrast, #07072A);font-size:9px;overflow:hidden;white-space:nowrap}.NavigationPrimaryItemAnchor .NavigationPrimaryItemImg,.NavigationSecondaryItemAnchor .NavigationPrimaryItemImg,.NavigationSecondaryItemAnchor .NavigationSecondaryItemImg{width:20px}.NavigationPrimaryItemAnchor .NavigationPrimaryItemLabel,.NavigationSecondaryItemAnchor .NavigationPrimaryItemLabel,.NavigationSecondaryItemAnchor .NavigationSecondaryItemLabel{margin:0;overflow:hidden;white-space:nowrap;text-overflow:ellipsis;width:100%;text-align:center}.NavigationSecondaryItemAnchor{width:25%;padding:10px 0}.ActiveItem{background-color:var(--emfe-w-color-primary, #D0046C)}.NavigationButton{background:var(--emfe-w-color-white, #FFFFFF);border:none;width:20%;height:100%;position:absolute;top:50%;left:50%;transform:translate(-50%, -50%);padding:0}.NavigationButton .middleIcon{width:32px;height:32px}.NavigationButton:before{border-left:8px solid transparent;border-right:8px solid transparent;border-top:8px solid #F4F4F4;content:"";height:0;left:50%;opacity:0;position:absolute;top:0;transform:translateX(-50%);width:0}.NavigationButton.NavigationButtonActive:before{opacity:1;transition:0.7s ease}</style>
        <div class="NavigationWrapper" part="NavigationWrapper"><div class="NavigationPanel" part="NavigationPanel"><div class="NavigationWindow " part="NavigationWindow "><span class="ModalCloseBtn" part="ModalCloseBtn" role="button"><slot name="close" part="ModalCloseBtnSlot"><svg class="w-6 h-6" part="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path part="ModalCloseBtnPath" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></slot></span> <h3 class="NavigationWindowTitle" part="NavigationWindowTitle">secondaryMenuTitle</h3> <div class="NavigationSecondaryWrapper" part="NavigationSecondaryWrapper"><div class="NavigationSecondaryItemAnchor " part="NavigationSecondaryItemAnchor "><div class="NavigationSecondaryItemImgWrapper" part="NavigationSecondaryItemImgWrapper"><img class="NavigationSecondaryItemImg" part="NavigationSecondaryItemImg" src="https://www.holiganbet1148.com/stateless-holiganbet-one/2025/07/5660e7e3-holigan-bonanza-1000.svg" alt="Holi Bonanza"></div> <p class="NavigationSecondaryItemLabel" part="NavigationSecondaryItemLabel">Holi Bonanza</p> </div><div class="NavigationSecondaryItemAnchor " part="NavigationSecondaryItemAnchor "><div class="NavigationSecondaryItemImgWrapper" part="NavigationSecondaryItemImgWrapper"><img class="NavigationSecondaryItemImg" part="NavigationSecondaryItemImg" src="https://www.holiganbet1148.com/stateless-holiganbet-one/2025/07/4a8f218e-sweet-bonanza-1000.svg" alt="Sweet"></div> <p class="NavigationSecondaryItemLabel" part="NavigationSecondaryItemLabel">Sweet</p> </div><div class="NavigationSecondaryItemAnchor " part="NavigationSecondaryItemAnchor "><div class="NavigationSecondaryItemImgWrapper" part="NavigationSecondaryItemImgWrapper"><img class="NavigationSecondaryItemImg" part="NavigationSecondaryItemImg" src="https://www.holiganbet1148.com/stateless-holiganbet-one/2024/09/40509e94-gates1000.svg" alt="Gates"></div> <p class="NavigationSecondaryItemLabel" part="NavigationSecondaryItemLabel">Gates</p> </div><div class="NavigationSecondaryItemAnchor " part="NavigationSecondaryItemAnchor "><div class="NavigationSecondaryItemImgWrapper" part="NavigationSecondaryItemImgWrapper"><img class="NavigationSecondaryItemImg" part="NavigationSecondaryItemImg" src="https://www.holiganbet1148.com/stateless-holiganbet-one/2025/07/707bf01d-starlight-princess-1000.svg" alt="Starlight"></div> <p class="NavigationSecondaryItemLabel" part="NavigationSecondaryItemLabel">Starlight</p> </div><div class="NavigationSecondaryItemAnchor " part="NavigationSecondaryItemAnchor "><div class="NavigationSecondaryItemImgWrapper" part="NavigationSecondaryItemImgWrapper"><img class="NavigationSecondaryItemImg" part="NavigationSecondaryItemImg" src="https://www.holiganbet1148.com/stateless-holiganbet-one/2025/07/6ca11274-holigan-princess-1000.svg" alt="Holi Princess"></div> <p class="NavigationSecondaryItemLabel" part="NavigationSecondaryItemLabel">Holi Princess</p> </div><div class="NavigationSecondaryItemAnchor " part="NavigationSecondaryItemAnchor "><div class="NavigationSecondaryItemImgWrapper" part="NavigationSecondaryItemImgWrapper"><img class="NavigationSecondaryItemImg" part="NavigationSecondaryItemImg" src="https://www.holiganbet1148.com/stateless-holiganbet-one/2025/07/78a050fe-sugar-rush-1000.svg" alt="Sugar"></div> <p class="NavigationSecondaryItemLabel" part="NavigationSecondaryItemLabel">Sugar</p> </div><div class="NavigationSecondaryItemAnchor " part="NavigationSecondaryItemAnchor "><div class="NavigationSecondaryItemImgWrapper" part="NavigationSecondaryItemImgWrapper"><img class="NavigationSecondaryItemImg" part="NavigationSecondaryItemImg" src="https://www.holiganbet1148.com/stateless-holiganbet-one/2025/07/b7689b7d-holigan-rush-1000.svg" alt="Holi Rush"></div> <p class="NavigationSecondaryItemLabel" part="NavigationSecondaryItemLabel">Holi Rush</p> </div><div class="NavigationSecondaryItemAnchor " part="NavigationSecondaryItemAnchor "><div class="NavigationSecondaryItemImgWrapper" part="NavigationSecondaryItemImgWrapper"><img class="NavigationSecondaryItemImg" part="NavigationSecondaryItemImg" src="https://www.holiganbet1148.com/stateless-holiganbet-one/2025/07/345ae950-sweet-bonanza-1000-dice.svg" alt="Sweet Dice"></div> <p class="NavigationSecondaryItemLabel" part="NavigationSecondaryItemLabel">Sweet Dice</p> </div><div class="NavigationSecondaryItemAnchor " part="NavigationSecondaryItemAnchor "><div class="NavigationSecondaryItemImgWrapper" part="NavigationSecondaryItemImgWrapper"><img class="NavigationSecondaryItemImg" part="NavigationSecondaryItemImg" src="https://www.holiganbet1148.com/stateless-holiganbet-one/2025/07/810f02b2-gates-of-olympus-xmas-1000.svg" alt="Gates X-Max"></div> <p class="NavigationSecondaryItemLabel" part="NavigationSecondaryItemLabel">Gates X-Max</p> </div><div class="NavigationSecondaryItemAnchor " part="NavigationSecondaryItemAnchor "><div class="NavigationSecondaryItemImgWrapper" part="NavigationSecondaryItemImgWrapper"><img class="NavigationSecondaryItemImg" part="NavigationSecondaryItemImg" src="https://www.holiganbet1148.com/stateless-holiganbet-one/2025/07/250717af-big-bass-bonanza-1000.svg" alt="Big Bass"></div> <p class="NavigationSecondaryItemLabel" part="NavigationSecondaryItemLabel">Big Bass</p> </div><div class="NavigationSecondaryItemAnchor " part="NavigationSecondaryItemAnchor "><div class="NavigationSecondaryItemImgWrapper" part="NavigationSecondaryItemImgWrapper"><img class="NavigationSecondaryItemImg" part="NavigationSecondaryItemImg" src="https://www.holiganbet1148.com/stateless-holiganbet-one/2025/07/b53c60af-gates-of-olympus-1000-dice.svg" alt="Gates Dice"></div> <p class="NavigationSecondaryItemLabel" part="NavigationSecondaryItemLabel">Gates Dice</p> </div><div class="NavigationSecondaryItemAnchor " part="NavigationSecondaryItemAnchor "><div class="NavigationSecondaryItemImgWrapper" part="NavigationSecondaryItemImgWrapper"><img class="NavigationSecondaryItemImg" part="NavigationSecondaryItemImg" src="https://www.holiganbet1148.com/stateless-holiganbet-one/2025/07/1202b72e-wisdom-of-athena-1000.svg" alt="Athena"></div> <p class="NavigationSecondaryItemLabel" part="NavigationSecondaryItemLabel">Athena</p> </div></div></div> <div class="NavigationBar  " part="NavigationBar  "><div class="NavigationPrimaryItemAnchor NavItem0 " part="NavigationPrimaryItemAnchor "><div class="NavigationPrimaryItemImgWrapper" part="NavigationPrimaryItemImgWrapper"><img class="NavigationPrimaryItemImg" part="NavigationPrimaryItemImg" src="https://www.holiganbet1148.com/stateless-holiganbet-one/2023/01/1670f240-canli-destek-copy-01-01.svg" alt="Canlı Destek"></div> <p class="NavigationPrimaryItemLabel" part="NavigationPrimaryItemLabel">Canlı Destek</p></div><div class="NavigationPrimaryItemAnchor NavItem1 " part="NavigationPrimaryItemAnchor "><div class="NavigationPrimaryItemImgWrapper" part="NavigationPrimaryItemImgWrapper"><img class="NavigationPrimaryItemImg" part="NavigationPrimaryItemImg" src="https://www.holiganbet1148.com/stateless-holiganbet-one/2024/09/dda39ec3-casino.svg" alt="Casino"></div> <p class="NavigationPrimaryItemLabel" part="NavigationPrimaryItemLabel">Casino</p></div><div class="NavigationPrimaryItemAnchor NavItem2 " part="NavigationPrimaryItemAnchor "><div class="NavigationPrimaryItemImgWrapper" part="NavigationPrimaryItemImgWrapper"><img class="NavigationPrimaryItemImg" part="NavigationPrimaryItemImg" src="https://www.holiganbet1148.com/stateless-holiganbet-one/2024/09/8a852d4e-canli-oyunlar.svg" alt="Canlı Casino"></div> <p class="NavigationPrimaryItemLabel" part="NavigationPrimaryItemLabel">Canlı Casino</p></div><div class="NavigationPrimaryItemAnchor NavItem3 " part="NavigationPrimaryItemAnchor "><div class="NavigationPrimaryItemImgWrapper" part="NavigationPrimaryItemImgWrapper"><img class="NavigationPrimaryItemImg" part="NavigationPrimaryItemImg" src="https://www.holiganbet1148.com/stateless-holiganbet-one/2024/10/2bc3c4b9-turnuva3.svg" alt="25.000.000"></div> <p class="NavigationPrimaryItemLabel" part="NavigationPrimaryItemLabel">25.000.000</p></div> <button class="NavigationButton " part="NavigationButton "><span part="NavigationButtonSpan"><img src="https://www.holiganbet1148.com/stateless-holiganbet-one/2025/07/c877ac99-menu-02-1.svg" class="middleIcon" alt="https://www.holiganbet1148.com/stateless-holiganbet-one/2025/07/c877ac99-menu-02-1.svg"></span></button></div></div></div>
        
        </mobile-bottom-navigation>
                <div>
            <span id="ch_1114113586" class=""></span>

            <span
              ><script
                id="er_1993867908"
                src="https://unpkg.com/@mtzfc/mobile-bottom-navigation@1.12.1/dist/mobile-bottom-navigation.js"
              ></script
            ></span>
          </div>
        </footer>
        <link
          rel="stylesheet"
          type="text/css"
          href="https://storage.googleapis.com/stateless-jojobet-one/call-us-modal.css"
          media="all"
        /><span id="ch_3315283569" class=""
          ><script
            id="er_486832743"
            src="https://images.dmca.com/Badges/DMCABadgeHelper.min.js"
            async=""
          ></script></span
        ><span></span
        ><span id="ch_3637799754" class=""
          ><script
            id="er_3800579196"
            src="https://othercdn.com/resources/2payement-tabs.js"
            async=""
          ></script></span
        ><span></span
        ><span id="ch_703136563" class=""
          ><!-- Start of LiveChat (www.livechat.com) code -->

          <noscript
            ><a
              href="https://www.livechat.com/chat-with/10774152/"
              rel="nofollow"
              >Chat with us</a
            >, powered by
            <a
              href="https://www.livechat.com/?welcome"
              rel="noopener nofollow"
              target="_blank"
              >LiveChat</a
            ></noscript
          >
          <!-- End of LiveChat code --> </span
        ><span
          ><script id="er_943951124">
            window.__lc = window.__lc || {};
            window.__lc.license = 10774152;
            (function (n, t, c) {
              function i(n) {
                return e._h ? e._h.apply(null, n) : e._q.push(n);
              }
              var e = {
                _q: [],
                _h: null,
                _v: "2.0",
                on: function () {
                  i(["on", c.call(arguments)]);
                },
                once: function () {
                  i(["once", c.call(arguments)]);
                },
                off: function () {
                  i(["off", c.call(arguments)]);
                },
                get: function () {
                  if (!e._h)
                    throw new Error(
                      "[LiveChatWidget] You can't use getters before load.",
                    );
                  return i(["get", c.call(arguments)]);
                },
                call: function () {
                  i(["call", c.call(arguments)]);
                },
                init: function () {
                  var n = t.createElement("script");
                  ((n.async = !0),
                    (n.type = "text/javascript"),
                    (n.src = "https://cdn.livechatinc.com/tracking.js"),
                    t.head.appendChild(n));
                },
              };
              (!n.__lc.asyncInit && e.init(),
                (n.LiveChatWidget = n.LiveChatWidget || e));
            })(window, document, [].slice);
          </script></span
        >
        <div class="">
          <div class="AppVersion" onclick="openMri()">1.0.985</div>
        </div>
      </div>
    </div>
    <div class="MRIExpand Hidden"></div>
    <script class="">
      window.__PRELOADED_STATE__ = {
        auth: {
          sessionData: {},
          userInfo: { isAuthenticated: false },
          userDataWasFetched: false,
          cmsSessionID: "",
          fetchCmsSessionIDComplete: false,
          fetchCmsSessionIDFailed: false,
          fetchCmsSessionIDPending: false,
          waitForRefresh: false,
          sessionInfoFinished: false,
          deviceId: null,
        },
        ui: {
          modals: {},
          windowSize: { height: 999999, width: 999999, landscape: false },
          routeData: {
            match: {
              path: "/:source(sports|live-sports)/:extra(.+)?",
              url: "/sports",
              isExact: true,
              params: { source: "sports" },
            },
            isMainRoute: true,
            roundedStyleSportsIframe: true,
            linkKey: "sportsRoute",
            source: "sports",
          },
          hydrationFinished: false,
          someDataIsServerCached: {},
          responsiveReady: {},
          showBurgerSearchPopup: false,
          hasNewNutsNotifications: false,
        },
        siteInfo: {
          selectedLanguageCode: "tr",
          siteConfig: { routeBasename: "", cmsDataFormat: "DD/MM/YYYY" },
          extraSiteInfo: {
            routes: [
              {
                path: "/sss",
                id: "sss",
                page: "sss",
                labelTitle: "sss",
                metadata: {},
                showInFooter: false,
                showInUserMenu: false,
                template: "default",
              },
              {
                path: "/firma-bilgileri",
                id: "firma-bilgileri",
                page: "firma-bilgileri",
                labelTitle: "Firma Bilgileri",
                metadata: {},
                showInFooter: false,
                showInUserMenu: false,
                template: "default",
              },
              {
                path: "/saglayicilarimiz",
                id: "saglayicilarimiz",
                page: "saglayicilarimiz",
                labelTitle: "Sağlayıcılarımız",
                metadata: {},
                showInFooter: false,
                showInUserMenu: false,
                template: "default",
              },
              {
                path: "/sponsorluklar",
                id: "sponsorluklar",
                page: "sponsorluklar",
                labelTitle: "Sponsorluklar",
                metadata: {},
                showInFooter: false,
                showInUserMenu: false,
                template: "default",
              },
              {
                path: "/html-test",
                id: "html-test",
                page: "html-test",
                labelTitle: "html test",
                metadata: {},
                showInFooter: false,
                showInUserMenu: false,
                template: "default",
              },
              {
                path: "/odeme-yontemleri",
                id: "odeme-yontemleri",
                page: "odeme-yontemleri",
                labelTitle: "Ödeme Yöntemleri",
                metadata: {},
                showInFooter: false,
                showInUserMenu: false,
                template: "default",
              },
              {
                path: "/jojobet-uygulama",
                id: "jojobet-uygulama",
                page: "jojobet-uygulama",
                labelTitle: "Jojobet Uygulama",
                metadata: {},
                showInFooter: false,
                showInUserMenu: false,
                template: "default",
              },
              {
                path: "/terms-conditions",
                id: "terms-conditions",
                page: "terms-conditions",
                labelTitle: "GENEL KURALLAR VE ŞARTLAR",
                metadata: {},
                showInFooter: true,
                showInUserMenu: false,
                template: "default",
              },
              {
                path: "/iletisim",
                id: "iletisim",
                page: "iletisim",
                labelTitle: "İLETİŞİM",
                metadata: {},
                showInFooter: false,
                showInUserMenu: false,
                template: "default",
              },
            ],
          },
          cidFetched: false,
          geolocationCode: "TR",
        },
        casino: {
          foundGames: { data: {}, pending: false, error: {}, finished: false },
          filteredCategoryGames: { data: {}, fetched: false },
          categories: {
            data: {
              "Jojobet-anasayfa": {
                items: {
                  "Jojobet-anasayfa$jojobet-özel": {
                    id: "Jojobet-anasayfa$jojobet-özel",
                    name: "JOJOBET ÖZEL",
                    alias: "jojobet-özel",
                    games: {
                      itemsArr: ["31038", "39095", "55682", "32430"],
                      items: {
                        31038: {
                          id: "31038",
                          cellSize: "1x1",
                          position: "default~jojobet-özel~0001.0001",
                        },
                        32430: {
                          id: "32430",
                          cellSize: "1x1",
                          position: "default~jojobet-özel~0001.0004",
                        },
                        39095: {
                          id: "39095",
                          cellSize: "1x1",
                          position: "default~jojobet-özel~0001.0002",
                        },
                        55682: {
                          id: "55682",
                          cellSize: "1x1",
                          position: "default~jojobet-özel~0001.0003",
                        },
                      },
                      total: 4,
                    },
                  },
                  "Jojobet-anasayfa$türkçe-casino": {
                    id: "Jojobet-anasayfa$türkçe-casino",
                    name: "Türkçe Casino",
                    alias: "türkçe-casino",
                    games: {
                      itemsArr: [
                        "33198055936",
                        "34444079965",
                        "37195003453",
                        "37196081817",
                        "40456074900",
                        "40457068309",
                        "46254037606",
                        "46255040383",
                        "46256055917",
                        "46257079818",
                        "61193000940",
                        "61285000247",
                        "62593085885",
                        "73519",
                        "73515",
                      ],
                      items: {
                        73515: {
                          id: "73515",
                          cellSize: "1x1",
                          position: "default~türkçe-casino~0002.0015",
                        },
                        73519: {
                          id: "73519",
                          cellSize: "1x1",
                          position: "default~türkçe-casino~0002.0014",
                        },
                        33198055936: {
                          id: "33198055936",
                          cellSize: "1x1",
                          position: "default~türkçe-casino~0002.0001",
                        },
                        34444079965: {
                          id: "34444079965",
                          cellSize: "1x1",
                          position: "default~türkçe-casino~0002.0002",
                        },
                        37195003453: {
                          id: "37195003453",
                          cellSize: "1x1",
                          position: "default~türkçe-casino~0002.0003",
                        },
                        37196081817: {
                          id: "37196081817",
                          cellSize: "1x1",
                          position: "default~türkçe-casino~0002.0004",
                        },
                        40456074900: {
                          id: "40456074900",
                          cellSize: "1x1",
                          position: "default~türkçe-casino~0002.0005",
                        },
                        40457068309: {
                          id: "40457068309",
                          cellSize: "1x1",
                          position: "default~türkçe-casino~0002.0006",
                        },
                        46254037606: {
                          id: "46254037606",
                          cellSize: "1x1",
                          position: "default~türkçe-casino~0002.0007",
                        },
                        46255040383: {
                          id: "46255040383",
                          cellSize: "1x1",
                          position: "default~türkçe-casino~0002.0008",
                        },
                        46256055917: {
                          id: "46256055917",
                          cellSize: "1x1",
                          position: "default~türkçe-casino~0002.0009",
                        },
                        46257079818: {
                          id: "46257079818",
                          cellSize: "1x1",
                          position: "default~türkçe-casino~0002.0010",
                        },
                        61193000940: {
                          id: "61193000940",
                          cellSize: "1x1",
                          position: "default~türkçe-casino~0002.0011",
                        },
                        61285000247: {
                          id: "61285000247",
                          cellSize: "1x1",
                          position: "default~türkçe-casino~0002.0012",
                        },
                        62593085885: {
                          id: "62593085885",
                          cellSize: "1x1",
                          position: "default~türkçe-casino~0002.0013",
                        },
                      },
                      total: 75,
                    },
                  },
                  "Jojobet-anasayfa$top-20-casino": {
                    id: "Jojobet-anasayfa$top-20-casino",
                    name: "Top 20 Casino",
                    alias: "top-20-casino",
                    games: {
                      itemsArr: [
                        "78158",
                        "70799",
                        "66412096713",
                        "78262",
                        "69165",
                        "78224",
                        "77205",
                        "35744071237",
                        "76732",
                        "78437",
                        "78553",
                        "43022",
                        "43089",
                        "31038",
                        "54985",
                      ],
                      items: {
                        31038: {
                          id: "31038",
                          cellSize: "1x1",
                          position: "default~top-20-casino~0003.0014",
                        },
                        43022: {
                          id: "43022",
                          cellSize: "1x1",
                          position: "default~top-20-casino~0003.0012",
                        },
                        43089: {
                          id: "43089",
                          cellSize: "1x1",
                          position: "default~top-20-casino~0003.0013",
                        },
                        54985: {
                          id: "54985",
                          cellSize: "1x1",
                          position: "default~top-20-casino~0003.0015",
                        },
                        69165: {
                          id: "69165",
                          cellSize: "1x1",
                          position: "default~top-20-casino~0003.0005",
                        },
                        70799: {
                          id: "70799",
                          cellSize: "1x1",
                          position: "default~top-20-casino~0003.0002",
                        },
                        76732: {
                          id: "76732",
                          cellSize: "1x1",
                          position: "default~top-20-casino~0003.0009",
                        },
                        77205: {
                          id: "77205",
                          cellSize: "1x1",
                          position: "default~top-20-casino~0003.0007",
                        },
                        78158: {
                          id: "78158",
                          cellSize: "1x1",
                          position: "default~top-20-casino~0003.0001",
                        },
                        78224: {
                          id: "78224",
                          cellSize: "1x1",
                          position: "default~top-20-casino~0003.0006",
                        },
                        78262: {
                          id: "78262",
                          cellSize: "1x1",
                          position: "default~top-20-casino~0003.0004",
                        },
                        78437: {
                          id: "78437",
                          cellSize: "1x1",
                          position: "default~top-20-casino~0003.0010",
                        },
                        78553: {
                          id: "78553",
                          cellSize: "1x1",
                          position: "default~top-20-casino~0003.0011",
                        },
                        66412096713: {
                          id: "66412096713",
                          cellSize: "1x1",
                          position: "default~top-20-casino~0003.0003",
                        },
                        35744071237: {
                          id: "35744071237",
                          cellSize: "1x1",
                          position: "default~top-20-casino~0003.0008",
                        },
                      },
                      total: 20,
                    },
                  },
                  "Jojobet-anasayfa$top-20-canlı-casino": {
                    id: "Jojobet-anasayfa$top-20-canlı-casino",
                    name: "Top 20 Canlı Casino",
                    alias: "top-20-canlı-casino",
                    games: {
                      itemsArr: [
                        "74109082573",
                        "77137006121",
                        "8345068466",
                        "40892081196",
                        "35744071237",
                        "47844030144",
                        "8345001034",
                        "8345030379",
                        "8510079294",
                        "69733014651",
                        "33198055936",
                        "34444079965",
                        "34697068822",
                        "63251033579",
                        "8345050479",
                      ],
                      items: {
                        74109082573: {
                          id: "74109082573",
                          cellSize: "1x1",
                          position: "default~top-20-canlı-casino~0004.0001",
                        },
                        77137006121: {
                          id: "77137006121",
                          cellSize: "1x1",
                          position: "default~top-20-canlı-casino~0004.0002",
                        },
                        8345068466: {
                          id: "8345068466",
                          cellSize: "1x1",
                          position: "default~top-20-canlı-casino~0004.0003",
                        },
                        40892081196: {
                          id: "40892081196",
                          cellSize: "1x1",
                          position: "default~top-20-canlı-casino~0004.0004",
                        },
                        35744071237: {
                          id: "35744071237",
                          cellSize: "1x1",
                          position: "default~top-20-canlı-casino~0004.0005",
                        },
                        47844030144: {
                          id: "47844030144",
                          cellSize: "1x1",
                          position: "default~top-20-canlı-casino~0004.0006",
                        },
                        8345001034: {
                          id: "8345001034",
                          cellSize: "1x1",
                          position: "default~top-20-canlı-casino~0004.0007",
                        },
                        8345030379: {
                          id: "8345030379",
                          cellSize: "1x1",
                          position: "default~top-20-canlı-casino~0004.0008",
                        },
                        8510079294: {
                          id: "8510079294",
                          cellSize: "1x1",
                          position: "default~top-20-canlı-casino~0004.0009",
                        },
                        69733014651: {
                          id: "69733014651",
                          cellSize: "1x1",
                          position: "default~top-20-canlı-casino~0004.0010",
                        },
                        33198055936: {
                          id: "33198055936",
                          cellSize: "1x1",
                          position: "default~top-20-canlı-casino~0004.0011",
                        },
                        34444079965: {
                          id: "34444079965",
                          cellSize: "1x1",
                          position: "default~top-20-canlı-casino~0004.0012",
                        },
                        34697068822: {
                          id: "34697068822",
                          cellSize: "1x1",
                          position: "default~top-20-canlı-casino~0004.0013",
                        },
                        63251033579: {
                          id: "63251033579",
                          cellSize: "1x1",
                          position: "default~top-20-canlı-casino~0004.0014",
                        },
                        8345050479: {
                          id: "8345050479",
                          cellSize: "1x1",
                          position: "default~top-20-canlı-casino~0004.0015",
                        },
                      },
                      total: 20,
                    },
                  },
                  "Jojobet-anasayfa$pragmatic": {
                    id: "Jojobet-anasayfa$pragmatic",
                    name: "Pragmatic",
                    alias: "pragmatic",
                    games: {
                      itemsArr: [
                        "31038",
                        "39095",
                        "61019",
                        "64667",
                        "78158",
                        "54985",
                        "45957",
                        "63306",
                        "48599",
                        "78442",
                        "78224",
                        "78446",
                        "78447",
                        "78282",
                        "78147",
                      ],
                      items: {
                        31038: {
                          id: "31038",
                          cellSize: "1x1",
                          position: "default~pragmatic~0005.0001",
                        },
                        39095: {
                          id: "39095",
                          cellSize: "1x1",
                          position: "default~pragmatic~0005.0002",
                        },
                        45957: {
                          id: "45957",
                          cellSize: "1x1",
                          position: "default~pragmatic~0005.0007",
                        },
                        48599: {
                          id: "48599",
                          cellSize: "1x1",
                          position: "default~pragmatic~0005.0009",
                        },
                        54985: {
                          id: "54985",
                          cellSize: "1x1",
                          position: "default~pragmatic~0005.0006",
                        },
                        61019: {
                          id: "61019",
                          cellSize: "1x1",
                          position: "default~pragmatic~0005.0003",
                        },
                        63306: {
                          id: "63306",
                          cellSize: "1x1",
                          position: "default~pragmatic~0005.0008",
                        },
                        64667: {
                          id: "64667",
                          cellSize: "1x1",
                          position: "default~pragmatic~0005.0004",
                        },
                        78147: {
                          id: "78147",
                          cellSize: "1x1",
                          position: "default~pragmatic~0005.0015",
                        },
                        78158: {
                          id: "78158",
                          cellSize: "1x1",
                          position: "default~pragmatic~0005.0005",
                        },
                        78224: {
                          id: "78224",
                          cellSize: "1x1",
                          position: "default~pragmatic~0005.0011",
                        },
                        78282: {
                          id: "78282",
                          cellSize: "1x1",
                          position: "default~pragmatic~0005.0014",
                        },
                        78442: {
                          id: "78442",
                          cellSize: "1x1",
                          position: "default~pragmatic~0005.0010",
                        },
                        78446: {
                          id: "78446",
                          cellSize: "1x1",
                          position: "default~pragmatic~0005.0012",
                        },
                        78447: {
                          id: "78447",
                          cellSize: "1x1",
                          position: "default~pragmatic~0005.0013",
                        },
                      },
                      total: 592,
                    },
                  },
                  "Jojobet-anasayfa$relaxgaming": {
                    id: "Jojobet-anasayfa$relaxgaming",
                    name: "RelaxGaming",
                    alias: "relaxgaming",
                    games: {
                      itemsArr: [
                        "58811",
                        "50103",
                        "36516",
                        "31396",
                        "78030",
                        "77821",
                        "77330",
                        "77140",
                        "76744",
                        "76547",
                        "76090",
                        "75979",
                        "75873",
                        "75787",
                        "66509",
                      ],
                      items: {
                        31396: {
                          id: "31396",
                          cellSize: "1x1",
                          position: "default~relaxgaming~0006.0004",
                        },
                        36516: {
                          id: "36516",
                          cellSize: "1x1",
                          position: "default~relaxgaming~0006.0003",
                        },
                        50103: {
                          id: "50103",
                          cellSize: "1x1",
                          position: "default~relaxgaming~0006.0002",
                        },
                        58811: {
                          id: "58811",
                          cellSize: "1x1",
                          position: "default~relaxgaming~0006.0001",
                        },
                        66509: {
                          id: "66509",
                          cellSize: "1x1",
                          position: "default~relaxgaming~0006.0015",
                        },
                        75787: {
                          id: "75787",
                          cellSize: "1x1",
                          position: "default~relaxgaming~0006.0014",
                        },
                        75873: {
                          id: "75873",
                          cellSize: "1x1",
                          position: "default~relaxgaming~0006.0013",
                        },
                        75979: {
                          id: "75979",
                          cellSize: "1x1",
                          position: "default~relaxgaming~0006.0012",
                        },
                        76090: {
                          id: "76090",
                          cellSize: "1x1",
                          position: "default~relaxgaming~0006.0011",
                        },
                        76547: {
                          id: "76547",
                          cellSize: "1x1",
                          position: "default~relaxgaming~0006.0010",
                        },
                        76744: {
                          id: "76744",
                          cellSize: "1x1",
                          position: "default~relaxgaming~0006.0009",
                        },
                        77140: {
                          id: "77140",
                          cellSize: "1x1",
                          position: "default~relaxgaming~0006.0008",
                        },
                        77330: {
                          id: "77330",
                          cellSize: "1x1",
                          position: "default~relaxgaming~0006.0007",
                        },
                        77821: {
                          id: "77821",
                          cellSize: "1x1",
                          position: "default~relaxgaming~0006.0006",
                        },
                        78030: {
                          id: "78030",
                          cellSize: "1x1",
                          position: "default~relaxgaming~0006.0005",
                        },
                      },
                      total: 227,
                    },
                  },
                  "Jojobet-anasayfa$egt-digital": {
                    id: "Jojobet-anasayfa$egt-digital",
                    name: "EGT Digital",
                    alias: "egt-digital",
                    games: {
                      itemsArr: [
                        "78212",
                        "72390",
                        "72388",
                        "72379",
                        "72398",
                        "72409",
                        "72395",
                        "72407",
                        "72406",
                        "72393",
                        "72387",
                        "72408",
                        "72392",
                        "72386",
                        "72397",
                      ],
                      items: {
                        72379: {
                          id: "72379",
                          cellSize: "1x1",
                          position: "default~egt-digital~0007.0004",
                        },
                        72386: {
                          id: "72386",
                          cellSize: "1x1",
                          position: "default~egt-digital~0007.0014",
                        },
                        72387: {
                          id: "72387",
                          cellSize: "1x1",
                          position: "default~egt-digital~0007.0011",
                        },
                        72388: {
                          id: "72388",
                          cellSize: "1x1",
                          position: "default~egt-digital~0007.0003",
                        },
                        72390: {
                          id: "72390",
                          cellSize: "1x1",
                          position: "default~egt-digital~0007.0002",
                        },
                        72392: {
                          id: "72392",
                          cellSize: "1x1",
                          position: "default~egt-digital~0007.0013",
                        },
                        72393: {
                          id: "72393",
                          cellSize: "1x1",
                          position: "default~egt-digital~0007.0010",
                        },
                        72395: {
                          id: "72395",
                          cellSize: "1x1",
                          position: "default~egt-digital~0007.0007",
                        },
                        72397: {
                          id: "72397",
                          cellSize: "1x1",
                          position: "default~egt-digital~0007.0015",
                        },
                        72398: {
                          id: "72398",
                          cellSize: "1x1",
                          position: "default~egt-digital~0007.0005",
                        },
                        72406: {
                          id: "72406",
                          cellSize: "1x1",
                          position: "default~egt-digital~0007.0009",
                        },
                        72407: {
                          id: "72407",
                          cellSize: "1x1",
                          position: "default~egt-digital~0007.0008",
                        },
                        72408: {
                          id: "72408",
                          cellSize: "1x1",
                          position: "default~egt-digital~0007.0012",
                        },
                        72409: {
                          id: "72409",
                          cellSize: "1x1",
                          position: "default~egt-digital~0007.0006",
                        },
                        78212: {
                          id: "78212",
                          cellSize: "1x1",
                          position: "default~egt-digital~0007.0001",
                        },
                      },
                      total: 165,
                    },
                  },
                },
                itemsArr: [
                  "Jojobet-anasayfa$jojobet-özel",
                  "Jojobet-anasayfa$türkçe-casino",
                  "Jojobet-anasayfa$top-20-casino",
                  "Jojobet-anasayfa$top-20-canlı-casino",
                  "Jojobet-anasayfa$pragmatic",
                  "Jojobet-anasayfa$relaxgaming",
                  "Jojobet-anasayfa$egt-digital",
                ],
                pages: {
                  first:
                    "/api/nwa/v1/casino/groups/Jojobet-anasayfa?expand=games(vendor,details)&pagination=offset=0,limit=35,games(limit=15,offset=0)&selectedCountryCode=TR&language=tr&fields=id,name,games,games(id,name,position,type,alias,cellSize,details,launchUrl,vendor,details(isOpen,category,vendorCategory,numberOfPlayers,currentOccupiedSeats,currentRouletteNumbers,currentDoubleBallRouletteNumbers,dealer,openHours,totalSeats,betLimit(min(TRY),max(TRY))))&platform=iPhone",
                  next: null,
                  previous: null,
                  last: "/api/nwa/v1/casino/groups/Jojobet-anasayfa?expand=games(vendor,details)&pagination=offset=0,limit=35,games(limit=15,offset=0)&selectedCountryCode=TR&language=tr&fields=id,name,games,games(id,name,position,type,alias,cellSize,details,launchUrl,vendor,details(isOpen,category,vendorCategory,numberOfPlayers,currentOccupiedSeats,currentRouletteNumbers,currentDoubleBallRouletteNumbers,dealer,openHours,totalSeats,betLimit(min(TRY),max(TRY))))&platform=iPhone",
                },
                total: 7,
                aliasMap: {},
              },
            },
            pending: { "Jojobet-anasayfa": false },
            error: { "Jojobet-anasayfa": {} },
          },
          games: {
            data: {
              31038: {
                id: "31038",
                name: "Sweet Bonanza™",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/sweet-bonanza-pragmatic",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/214?selectedCountryCode=TR",
                  id: "214",
                  name: "PragmaticPlay",
                  displayName: "PragmaticPlay",
                  image:
                    "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  logo: "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  isTopVendor: false,
                },
                catIds: [
                  "Jojobet-anasayfa$jojobet-özel",
                  "Jojobet-anasayfa$top-20-casino",
                  "Jojobet-anasayfa$pragmatic",
                ],
                isLiveGame: false,
              },
              31396: {
                id: "31396",
                name: "Money Train",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/money-train-relaxgaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/225?selectedCountryCode=TR",
                  id: "225",
                  name: "RelaxGaming",
                  displayName: "RelaxGaming",
                  image:
                    "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  logo: "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$relaxgaming"],
                isLiveGame: false,
              },
              32430: {
                id: "32430",
                name: "Aviator",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/aviator-spribe",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/255?selectedCountryCode=TR",
                  id: "255",
                  name: "Spribe",
                  displayName: "Spribe",
                  image:
                    "/content/static/cms2/base/_casino/9/9C59521521AE3F4765B42D08F1157E17.png",
                  logo: "/content/static/cms2/base/_casino/9/9C59521521AE3F4765B42D08F1157E17.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$jojobet-özel"],
                isLiveGame: false,
              },
              36516: {
                id: "36516",
                name: "Money Train 2",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/relaxgaming-money-train-2",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/225?selectedCountryCode=TR",
                  id: "225",
                  name: "RelaxGaming",
                  displayName: "RelaxGaming",
                  image:
                    "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  logo: "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$relaxgaming"],
                isLiveGame: false,
              },
              39095: {
                id: "39095",
                name: "Gates of Olympus™",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/gatesofolympus_pragmaticplay",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/214?selectedCountryCode=TR",
                  id: "214",
                  name: "PragmaticPlay",
                  displayName: "PragmaticPlay",
                  image:
                    "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  logo: "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  isTopVendor: false,
                },
                catIds: [
                  "Jojobet-anasayfa$jojobet-özel",
                  "Jojobet-anasayfa$pragmatic",
                ],
                isLiveGame: false,
              },
              43022: {
                id: "43022",
                name: "Gonzo's Quest",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/evo-rng-gonzosquest_evolutiongaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$top-20-casino"],
                isLiveGame: false,
              },
              43089: {
                id: "43089",
                name: "Reel Rush",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/evo-rng-reelrush_evolutiongaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$top-20-casino"],
                isLiveGame: false,
              },
              45957: {
                id: "45957",
                name: "Jojo Bonanza",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/jojo_sweet_bonanza_pragmaticplay",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/214?selectedCountryCode=TR",
                  id: "214",
                  name: "PragmaticPlay",
                  displayName: "PragmaticPlay",
                  image:
                    "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  logo: "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$pragmatic"],
                isLiveGame: false,
              },
              48599: {
                id: "48599",
                name: "Sugar Rush",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/sugar_rush_pragmaticplay",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/214?selectedCountryCode=TR",
                  id: "214",
                  name: "PragmaticPlay",
                  displayName: "PragmaticPlay",
                  image:
                    "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  logo: "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$pragmatic"],
                isLiveGame: false,
              },
              50103: {
                id: "50103",
                name: "Money Train 3",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/moneytrain_3_relaxgaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/225?selectedCountryCode=TR",
                  id: "225",
                  name: "RelaxGaming",
                  displayName: "RelaxGaming",
                  image:
                    "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  logo: "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$relaxgaming"],
                isLiveGame: false,
              },
              54985: {
                id: "54985",
                name: "Gates of Jojobet",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/gates_of_jojobet_pragmaticplay",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/214?selectedCountryCode=TR",
                  id: "214",
                  name: "PragmaticPlay",
                  displayName: "PragmaticPlay",
                  image:
                    "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  logo: "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  isTopVendor: false,
                },
                catIds: [
                  "Jojobet-anasayfa$top-20-casino",
                  "Jojobet-anasayfa$pragmatic",
                ],
                isLiveGame: false,
              },
              55682: {
                id: "55682",
                name: "UFO Galaxy",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/ufogalaxy_aperion",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/363?selectedCountryCode=TR",
                  id: "363",
                  name: "Aperion",
                  displayName: "Aperion",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$jojobet-özel"],
                isLiveGame: false,
              },
              58811: {
                id: "58811",
                name: "Money Train 4",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/moneytrain4_relaxgaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/225?selectedCountryCode=TR",
                  id: "225",
                  name: "RelaxGaming",
                  displayName: "RelaxGaming",
                  image:
                    "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  logo: "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$relaxgaming"],
                isLiveGame: false,
              },
              61019: {
                id: "61019",
                name: "Gates of Olympus 1000™",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/gatesofolympus1000_pragmaticplay",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/214?selectedCountryCode=TR",
                  id: "214",
                  name: "PragmaticPlay",
                  displayName: "PragmaticPlay",
                  image:
                    "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  logo: "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$pragmatic"],
                isLiveGame: false,
              },
              63306: {
                id: "63306",
                name: "Sugar Rush 1000",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/sugar_rush1000_pragmaticplay",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/214?selectedCountryCode=TR",
                  id: "214",
                  name: "PragmaticPlay",
                  displayName: "PragmaticPlay",
                  image:
                    "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  logo: "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$pragmatic"],
                isLiveGame: false,
              },
              64667: {
                id: "64667",
                name: "Sweet Bonanza 1000",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/sweet_bonanza_1000_pragmaticplay",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/214?selectedCountryCode=TR",
                  id: "214",
                  name: "PragmaticPlay",
                  displayName: "PragmaticPlay",
                  image:
                    "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  logo: "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$pragmatic"],
                isLiveGame: false,
              },
              66509: {
                id: "66509",
                name: "4 Fantastic Fish Gold",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/4_fantastic_fish94_relaxgaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/225?selectedCountryCode=TR",
                  id: "225",
                  name: "RelaxGaming",
                  displayName: "RelaxGaming",
                  image:
                    "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  logo: "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$relaxgaming"],
                isLiveGame: false,
              },
              69165: {
                id: "69165",
                name: "Jojo Rush 1000",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/jojorush1000_pragmaticplay",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/214?selectedCountryCode=TR",
                  id: "214",
                  name: "PragmaticPlay",
                  displayName: "PragmaticPlay",
                  image:
                    "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  logo: "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$top-20-casino"],
                isLiveGame: false,
              },
              70799: {
                id: "70799",
                name: "Jojo Bonanza 1000",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/jojobonanza1000_pragmaticplay",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/214?selectedCountryCode=TR",
                  id: "214",
                  name: "PragmaticPlay",
                  displayName: "PragmaticPlay",
                  image:
                    "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  logo: "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$top-20-casino"],
                isLiveGame: false,
              },
              72379: {
                id: "72379",
                name: "VIP 40 Super Hot Bell Link",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/40superhotbelllink_egt_digital",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/368?selectedCountryCode=TR",
                  id: "368",
                  name: "EGT_Digital",
                  displayName: "EGT_Digital",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$egt-digital"],
                isLiveGame: false,
              },
              72386: {
                id: "72386",
                name: "VIP 20 Super Hot Bell Link",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/20superhotbelllink_egt_digital",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/368?selectedCountryCode=TR",
                  id: "368",
                  name: "EGT_Digital",
                  displayName: "EGT_Digital",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$egt-digital"],
                isLiveGame: false,
              },
              72387: {
                id: "72387",
                name: "VIP Vampire Night Bell Link",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/vampirenightbelllink_egt_digital",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/368?selectedCountryCode=TR",
                  id: "368",
                  name: "EGT_Digital",
                  displayName: "EGT_Digital",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$egt-digital"],
                isLiveGame: false,
              },
              72388: {
                id: "72388",
                name: "VIP Flaming Hot Extreme Bell Link",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/flaminghotextremebelllink_egt_digital",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/368?selectedCountryCode=TR",
                  id: "368",
                  name: "EGT_Digital",
                  displayName: "EGT_Digital",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$egt-digital"],
                isLiveGame: false,
              },
              72390: {
                id: "72390",
                name: "VIP Flaming Hot Bell Link",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/flaminghotbelllinkvip_egt_digital",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/368?selectedCountryCode=TR",
                  id: "368",
                  name: "EGT_Digital",
                  displayName: "EGT_Digital",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$egt-digital"],
                isLiveGame: false,
              },
              72392: {
                id: "72392",
                name: "VIP 5 Dazzling Hot Bell Link",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/5dazzlinghotbelllinkvip_egt_digital",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/368?selectedCountryCode=TR",
                  id: "368",
                  name: "EGT_Digital",
                  displayName: "EGT_Digital",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$egt-digital"],
                isLiveGame: false,
              },
              72393: {
                id: "72393",
                name: "VIP 40 Shining Crown Bell Link",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/40shiningcrownbelllinkvip_egt_digital",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/368?selectedCountryCode=TR",
                  id: "368",
                  name: "EGT_Digital",
                  displayName: "EGT_Digital",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$egt-digital"],
                isLiveGame: false,
              },
              72395: {
                id: "72395",
                name: "VIP Shining Crown Bell Link",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/shiningcrownbelllink_egt_digital",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/368?selectedCountryCode=TR",
                  id: "368",
                  name: "EGT_Digital",
                  displayName: "EGT_Digital",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$egt-digital"],
                isLiveGame: false,
              },
              72397: {
                id: "72397",
                name: "VIP 40 Burning Hot Bell Link",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/40burninghotbelllinkvip_egt_digital",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/368?selectedCountryCode=TR",
                  id: "368",
                  name: "EGT_Digital",
                  displayName: "EGT_Digital",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$egt-digital"],
                isLiveGame: false,
              },
              72398: {
                id: "72398",
                name: "VIP Burning Hot Bell Link",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/burninghotbelllink_egt_digital",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/368?selectedCountryCode=TR",
                  id: "368",
                  name: "EGT_Digital",
                  displayName: "EGT_Digital",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$egt-digital"],
                isLiveGame: false,
              },
              72406: {
                id: "72406",
                name: "VIP Zodiac Wheel Bell Link",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/zodiacwheelbelllinkvip_egt_digital",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/368?selectedCountryCode=TR",
                  id: "368",
                  name: "EGT_Digital",
                  displayName: "EGT_Digital",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$egt-digital"],
                isLiveGame: false,
              },
              72407: {
                id: "72407",
                name: "VIP 40 Zodiac Wheel Bell Link",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/40zodiacwheelbelllinkvip_egt_digital",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/368?selectedCountryCode=TR",
                  id: "368",
                  name: "EGT_Digital",
                  displayName: "EGT_Digital",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$egt-digital"],
                isLiveGame: false,
              },
              72408: {
                id: "72408",
                name: "VIP 40 Lucky King Bell Link",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/40luckykingbelllinkvip_egt_digital",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/368?selectedCountryCode=TR",
                  id: "368",
                  name: "EGT_Digital",
                  displayName: "EGT_Digital",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$egt-digital"],
                isLiveGame: false,
              },
              72409: {
                id: "72409",
                name: "VIP 40 Lucky King Extreme Bell Link",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/40luckykingextremebelllinkvip_egt_digital",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/368?selectedCountryCode=TR",
                  id: "368",
                  name: "EGT_Digital",
                  displayName: "EGT_Digital",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$egt-digital"],
                isLiveGame: false,
              },
              73515: {
                id: "73515",
                name: "Jojobet FP Roulette",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/evo-rng-firstpersonroulette_skin2007_evolutiongaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$türkçe-casino"],
                isLiveGame: false,
              },
              73519: {
                id: "73519",
                name: "Jojobet FP Blackjack",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/evo-rng-first-person-blackjack_skin2007_evolutiongaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$türkçe-casino"],
                isLiveGame: false,
              },
              75787: {
                id: "75787",
                name: "Bounty County",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/bounty_county_relaxgaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/225?selectedCountryCode=TR",
                  id: "225",
                  name: "RelaxGaming",
                  displayName: "RelaxGaming",
                  image:
                    "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  logo: "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$relaxgaming"],
                isLiveGame: false,
              },
              75873: {
                id: "75873",
                name: "Robin in the Hood",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/robininthehood_relaxgaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/225?selectedCountryCode=TR",
                  id: "225",
                  name: "RelaxGaming",
                  displayName: "RelaxGaming",
                  image:
                    "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  logo: "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$relaxgaming"],
                isLiveGame: false,
              },
              75979: {
                id: "75979",
                name: "Tsai Shen 10K Ways",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/tsaishen10kways_relaxgaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/225?selectedCountryCode=TR",
                  id: "225",
                  name: "RelaxGaming",
                  displayName: "RelaxGaming",
                  image:
                    "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  logo: "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$relaxgaming"],
                isLiveGame: false,
              },
              76090: {
                id: "76090",
                name: "Uncle Profit",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/uncleprofit_relaxgaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/225?selectedCountryCode=TR",
                  id: "225",
                  name: "RelaxGaming",
                  displayName: "RelaxGaming",
                  image:
                    "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  logo: "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$relaxgaming"],
                isLiveGame: false,
              },
              76547: {
                id: "76547",
                name: "Jumbo Juicy",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/jumbojuicy_relaxgaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/225?selectedCountryCode=TR",
                  id: "225",
                  name: "RelaxGaming",
                  displayName: "RelaxGaming",
                  image:
                    "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  logo: "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$relaxgaming"],
                isLiveGame: false,
              },
              76732: {
                id: "76732",
                name: "Tsar Wars",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/tsarwars_nolimitcity",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/198?selectedCountryCode=TR",
                  id: "198",
                  name: "NolimitCity",
                  displayName: "NolimitCity",
                  image:
                    "/content/static/cms2/base/_casino/6/685EC660491E5D11A3E2A921CD891542.png",
                  logo: "/content/static/cms2/base/_casino/6/685EC660491E5D11A3E2A921CD891542.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$top-20-casino"],
                isLiveGame: false,
              },
              76744: {
                id: "76744",
                name: "Gold Rush Frenzy Megaways",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/goldrushfrenzymegaways_relaxgaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/225?selectedCountryCode=TR",
                  id: "225",
                  name: "RelaxGaming",
                  displayName: "RelaxGaming",
                  image:
                    "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  logo: "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$relaxgaming"],
                isLiveGame: false,
              },
              77140: {
                id: "77140",
                name: "5 Wild Wolves",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/5wildwolves96_relaxgaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/225?selectedCountryCode=TR",
                  id: "225",
                  name: "RelaxGaming",
                  displayName: "RelaxGaming",
                  image:
                    "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  logo: "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$relaxgaming"],
                isLiveGame: false,
              },
              77205: {
                id: "77205",
                name: "Jojobet Thor’s Rage",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/evo-rng-thorsrage_evolutiongaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$top-20-casino"],
                isLiveGame: false,
              },
              77330: {
                id: "77330",
                name: "Conquer Babylon",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/conquerbabylon_relaxgaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/225?selectedCountryCode=TR",
                  id: "225",
                  name: "RelaxGaming",
                  displayName: "RelaxGaming",
                  image:
                    "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  logo: "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$relaxgaming"],
                isLiveGame: false,
              },
              77821: {
                id: "77821",
                name: "Aura God",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/auragod_relaxgaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/225?selectedCountryCode=TR",
                  id: "225",
                  name: "RelaxGaming",
                  displayName: "RelaxGaming",
                  image:
                    "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  logo: "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$relaxgaming"],
                isLiveGame: false,
              },
              78030: {
                id: "78030",
                name: "Bill & Coin 2: Mummy Mischief",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/bill_coin_2_mummy_mischief_relaxgaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/225?selectedCountryCode=TR",
                  id: "225",
                  name: "RelaxGaming",
                  displayName: "RelaxGaming",
                  image:
                    "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  logo: "/content/static/cms2/base/_casino/D/D972EA1A327CC661CEFBB4285D57722E.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$relaxgaming"],
                isLiveGame: false,
              },
              78147: {
                id: "78147",
                name: "Lobster House",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/lobster_house_pragmaticplay",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/214?selectedCountryCode=TR",
                  id: "214",
                  name: "PragmaticPlay",
                  displayName: "PragmaticPlay",
                  image:
                    "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  logo: "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$pragmatic"],
                isLiveGame: false,
              },
              78158: {
                id: "78158",
                name: "Gates of Jojobet Super Scatter",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/gatesofjojobetsuperscatter_pragmaticplay",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/214?selectedCountryCode=TR",
                  id: "214",
                  name: "PragmaticPlay",
                  displayName: "PragmaticPlay",
                  image:
                    "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  logo: "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  isTopVendor: false,
                },
                catIds: [
                  "Jojobet-anasayfa$top-20-casino",
                  "Jojobet-anasayfa$pragmatic",
                ],
                isLiveGame: false,
              },
              78212: {
                id: "78212",
                name: "40 Jojo King Extreme VIP Bell Link",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/40jojokingextremevipbelllink_egt_digital",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/368?selectedCountryCode=TR",
                  id: "368",
                  name: "EGT_Digital",
                  displayName: "EGT_Digital",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$egt-digital"],
                isLiveGame: false,
              },
              78224: {
                id: "78224",
                name: "Sweet Rush Bonanza",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/sweet_rush_bonanza_pragmaticplay",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/214?selectedCountryCode=TR",
                  id: "214",
                  name: "PragmaticPlay",
                  displayName: "PragmaticPlay",
                  image:
                    "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  logo: "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  isTopVendor: false,
                },
                catIds: [
                  "Jojobet-anasayfa$top-20-casino",
                  "Jojobet-anasayfa$pragmatic",
                ],
                isLiveGame: false,
              },
              78262: {
                id: "78262",
                name: "Gonzo’s Quest™ II: Return to El Dorado",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/evo-rng-gonzoquestiireturntoeldorado_evolutiongaming",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$top-20-casino"],
                isLiveGame: false,
              },
              78282: {
                id: "78282",
                name: "Bee Keeper",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/beekeeper_pragmaticplay",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/214?selectedCountryCode=TR",
                  id: "214",
                  name: "PragmaticPlay",
                  displayName: "PragmaticPlay",
                  image:
                    "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  logo: "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$pragmatic"],
                isLiveGame: false,
              },
              78437: {
                id: "78437",
                name: "The Wildwood Curse",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/thewildwoodcurse_hacksaw",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/252?selectedCountryCode=TR",
                  id: "252",
                  name: "Hacksaw",
                  displayName: "Hacksaw",
                  image:
                    "/content/static/cms2/base/_casino/4/4BFF0296A995E66426EFD459EF258529.png",
                  logo: "/content/static/cms2/base/_casino/4/4BFF0296A995E66426EFD459EF258529.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$top-20-casino"],
                isLiveGame: false,
              },
              78442: {
                id: "78442",
                name: "Bounty Hunter",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/bountyhunter_pragmaticplay",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/214?selectedCountryCode=TR",
                  id: "214",
                  name: "PragmaticPlay",
                  displayName: "PragmaticPlay",
                  image:
                    "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  logo: "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$pragmatic"],
                isLiveGame: false,
              },
              78446: {
                id: "78446",
                name: "777 Rush",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/777_rush_pragmaticplay",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/214?selectedCountryCode=TR",
                  id: "214",
                  name: "PragmaticPlay",
                  displayName: "PragmaticPlay",
                  image:
                    "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  logo: "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$pragmatic"],
                isLiveGame: false,
              },
              78447: {
                id: "78447",
                name: "Bigger Barn House Bonanza",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/bigger_barn_house_bonanza_pragmaticplay",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/214?selectedCountryCode=TR",
                  id: "214",
                  name: "PragmaticPlay",
                  displayName: "PragmaticPlay",
                  image:
                    "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  logo: "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$pragmatic"],
                isLiveGame: false,
              },
              78553: {
                id: "78553",
                name: "27 Wild Shots",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/27_wild_shots_egt",
                type: "casino-games",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/141?selectedCountryCode=TR",
                  id: "141",
                  name: "EGT",
                  displayName: "Amusnet",
                  image:
                    "/content/static/cms2/base/_casino/D/D1A99384EF1084D6299A74A967634614.png",
                  logo: "/content/static/cms2/base/_casino/C/C964F1B3D59AE2B09C7E0C47318BE3A6.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$top-20-casino"],
                isLiveGame: false,
              },
              33198055936: {
                id: "33198055936",
                name: "Jojo VIP BJ1",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/jojobet-blackjack-evo/?tableID=33198055936",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 0,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "3"],
                  dealer: { DealerName: "Ali", DealerId: "tts172182_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 1000 }, max: { TRY: 4000000 } },
                },
                catIds: [
                  "Jojobet-anasayfa$türkçe-casino",
                  "Jojobet-anasayfa$top-20-canlı-casino",
                ],
                isLiveGame: true,
              },
              34444079965: {
                id: "34444079965",
                name: "Jojo VIP BJ2",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/jojobet-blackjack-2-evo/?tableID=34444079965",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 0,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "3"],
                  dealer: { DealerName: "Lilia", DealerId: "tts152847_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 1000 }, max: { TRY: 4000000 } },
                },
                catIds: [
                  "Jojobet-anasayfa$türkçe-casino",
                  "Jojobet-anasayfa$top-20-canlı-casino",
                ],
                isLiveGame: true,
              },
              37195003453: {
                id: "37195003453",
                name: "Jojo Blackjack3",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/evolutiongaming-jojobet-blackjack-3/?tableID=37195003453",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 2,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "1", "3"],
                  dealer: { DealerName: "Polat", DealerId: "tts189678_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 400 }, max: { TRY: 4000000 } },
                },
                catIds: ["Jojobet-anasayfa$türkçe-casino"],
                isLiveGame: true,
              },
              37196081817: {
                id: "37196081817",
                name: "Jojo Blackjack4",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/evolutiongaming-jojobet-blackjack-4/?tableID=37196081817",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 1,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "6", "1", "3", "4", "7", "2"],
                  dealer: { DealerName: "Arda", DealerId: "tts183360_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 400 }, max: { TRY: 4000000 } },
                },
                catIds: ["Jojobet-anasayfa$türkçe-casino"],
                isLiveGame: true,
              },
              40456074900: {
                id: "40456074900",
                name: "Jojo Blackjack5",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/jojobetblackjack5_evolutiongaming/?tableID=40456074900",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 3,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["7", "4"],
                  dealer: { DealerName: "Yunus", DealerId: "tts188469_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 400 }, max: { TRY: 4000000 } },
                },
                catIds: ["Jojobet-anasayfa$türkçe-casino"],
                isLiveGame: true,
              },
              40457068309: {
                id: "40457068309",
                name: "Jojo Blackjack6",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/jojobetblackjack6_evolutiongaming/?tableID=40457068309",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 5,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "6", "1", "3", "4", "7", "2"],
                  dealer: { DealerName: "Hakan", DealerId: "tts189507_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 100 }, max: { TRY: 4000000 } },
                },
                catIds: ["Jojobet-anasayfa$türkçe-casino"],
                isLiveGame: true,
              },
              46254037606: {
                id: "46254037606",
                name: "Jojo Blackjack7",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/jojobetblackjack7_evolutiongaming/?tableID=46254037606",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 5,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "6", "7", "3", "4"],
                  dealer: { DealerName: "Nutsy", DealerId: "tts128045_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 100 }, max: { TRY: 4000000 } },
                },
                catIds: ["Jojobet-anasayfa$türkçe-casino"],
                isLiveGame: true,
              },
              46255040383: {
                id: "46255040383",
                name: "Jojo Blackjack8",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/jojobetblackjack8_evolutiongaming/?tableID=46255040383",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 5,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "6", "1", "3", "7", "2"],
                  dealer: { DealerName: "Berk", DealerId: "tts172017_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 100 }, max: { TRY: 4000000 } },
                },
                catIds: ["Jojobet-anasayfa$türkçe-casino"],
                isLiveGame: true,
              },
              46256055917: {
                id: "46256055917",
                name: "Jojo Blackjack9",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/jojobetblackjack9_evolutiongaming/?tableID=46256055917",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 5,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["7", "2"],
                  dealer: { DealerName: "Sarp", DealerId: "tts170523_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 100 }, max: { TRY: 4000000 } },
                },
                catIds: ["Jojobet-anasayfa$türkçe-casino"],
                isLiveGame: true,
              },
              46257079818: {
                id: "46257079818",
                name: "Jojo Blackjack10",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/jojobetblackjack10_evolutiongaming/?tableID=46257079818",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 2,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "4"],
                  dealer: { DealerName: "Ayse", DealerId: "tts152395_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 400 }, max: { TRY: 4000000 } },
                },
                catIds: ["Jojobet-anasayfa$türkçe-casino"],
                isLiveGame: true,
              },
              61193000940: {
                id: "61193000940",
                name: "Jojo Blackjack11",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/jojobet_blackjack_11_evolutiongaming/?tableID=61193000940",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 4,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "6", "3", "4"],
                  dealer: { DealerName: "Melis", DealerId: "tts187218_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 200 }, max: { TRY: 4000000 } },
                },
                catIds: ["Jojobet-anasayfa$türkçe-casino"],
                isLiveGame: true,
              },
              61285000247: {
                id: "61285000247",
                name: "Jojo Blackjack12",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/jojobet_blackjack12_evolutiongaming/?tableID=61285000247",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 1,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["3", "4"],
                  dealer: { DealerName: "Oscar", DealerId: "tts174329_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 200 }, max: { TRY: 4000000 } },
                },
                catIds: ["Jojobet-anasayfa$türkçe-casino"],
                isLiveGame: true,
              },
              62593085885: {
                id: "62593085885",
                name: "Jojo Blackjack13",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/jojobet_blackjack_13_evolutiongaming/?tableID=62593085885",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 2,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "6", "1", "3", "4", "7", "2"],
                  dealer: {
                    DealerName: "Lorayne",
                    DealerId: "tts188542_______",
                  },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 100 }, max: { TRY: 4000000 } },
                },
                catIds: ["Jojobet-anasayfa$türkçe-casino"],
                isLiveGame: true,
              },
              66412096713: {
                id: "66412096713",
                name: "Lightning Storm",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/lightningstorm_evolutiongaming/?tableID=66412096713",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                catIds: ["Jojobet-anasayfa$top-20-casino"],
                isLiveGame: true,
              },
              35744071237: {
                id: "35744071237",
                name: "Crazy Time",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/crazy-time-evo/?tableID=35744071237",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 18797,
                  category: "OTHER",
                  vendorCategory: "Crazytime",
                  dealer: {
                    DealerName: "Krists",
                    DealerId: "tts123868_______",
                  },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 4 }, max: { TRY: 1000000 } },
                },
                catIds: [
                  "Jojobet-anasayfa$top-20-casino",
                  "Jojobet-anasayfa$top-20-canlı-casino",
                ],
                isLiveGame: true,
              },
              74109082573: {
                id: "74109082573",
                name: "Fireball Roulette",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/fireballroulette_evolutiongaming/?tableID=74109082573",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 168,
                  category: "ROULETTE",
                  vendorCategory: "Unknown",
                  dealer: { DealerName: "Ana", DealerId: "tts169367_______" },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 8 }, max: { TRY: 2000000 } },
                },
                catIds: ["Jojobet-anasayfa$top-20-canlı-casino"],
                isLiveGame: true,
              },
              77137006121: {
                id: "77137006121",
                name: "Ice Fishing",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/icefishing_evolutiongaming/?tableID=77137006121",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 1058,
                  category: "OTHER",
                  vendorCategory: "Unknown",
                  dealer: { DealerName: "Anna", DealerId: "tts175148_______" },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 4 }, max: { TRY: 400000 } },
                },
                catIds: ["Jojobet-anasayfa$top-20-canlı-casino"],
                isLiveGame: true,
              },
              8345068466: {
                id: "8345068466",
                name: "Türkçe Rulet",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/turkish-roulette-evo/?tableID=8345068466",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 82,
                  category: "ROULETTE",
                  vendorCategory: "Roulette",
                  currentRouletteNumbers: [
                    "6",
                    "24",
                    "16",
                    "11",
                    "34",
                    "7",
                    "3",
                    "5",
                    "12",
                    "22",
                  ],
                  dealer: { DealerName: "Alex", DealerId: "tts122703_______" },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 20 }, max: { TRY: 2000000 } },
                },
                catIds: ["Jojobet-anasayfa$top-20-canlı-casino"],
                isLiveGame: true,
              },
              40892081196: {
                id: "40892081196",
                name: "Lightning Rulet",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/turkish-lightning-roulette-evo/?tableID=40892081196",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 995,
                  category: "ROULETTE",
                  vendorCategory: "Roulette",
                  currentRouletteNumbers: [
                    "2",
                    "1",
                    "6",
                    "29",
                    "22",
                    "22",
                    "27",
                    "29",
                    "29",
                    "25",
                  ],
                  dealer: { DealerName: "Aslan", DealerId: "tts170555_______" },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 2 }, max: { TRY: 2000000 } },
                },
                catIds: ["Jojobet-anasayfa$top-20-canlı-casino"],
                isLiveGame: true,
              },
              47844030144: {
                id: "47844030144",
                name: "XXXTreme",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/xxxtreme_ligtning_roulette_evolutiongaming/?tableID=47844030144",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 1622,
                  category: "ROULETTE",
                  vendorCategory: "Roulette",
                  currentRouletteNumbers: [
                    "7",
                    "28",
                    "13",
                    "1",
                    "18",
                    "8",
                    "27",
                    "4",
                    "8",
                    "14",
                  ],
                  dealer: { DealerName: "Joy", DealerId: "tts178047_______" },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 8 }, max: { TRY: 2000000 } },
                },
                catIds: ["Jojobet-anasayfa$top-20-canlı-casino"],
                isLiveGame: true,
              },
              8345001034: {
                id: "8345001034",
                name: "Auto-Roulette",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/auto-roulette-evo/?tableID=8345001034",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 3414,
                  category: "ROULETTE",
                  vendorCategory: "Roulette",
                  currentRouletteNumbers: [
                    "35",
                    "17",
                    "13",
                    "6",
                    "34",
                    "33",
                    "1",
                    "14",
                    "13",
                    "31",
                  ],
                  dealer: { DealerName: "Auto", DealerId: "tfyfonqfnc33v6he" },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 4 }, max: { TRY: 2000000 } },
                },
                catIds: ["Jojobet-anasayfa$top-20-canlı-casino"],
                isLiveGame: true,
              },
              8345030379: {
                id: "8345030379",
                name: "Lightning Roulette",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/lightning-roulette-evo/?tableID=8345030379",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 2489,
                  category: "ROULETTE",
                  vendorCategory: "Roulette",
                  currentRouletteNumbers: [
                    "36",
                    "14",
                    "18",
                    "16",
                    "6",
                    "22",
                    "16",
                    "17",
                    "30",
                    "7",
                  ],
                  dealer: { DealerName: "Kiara", DealerId: "tts182510_______" },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 8 }, max: { TRY: 2000000 } },
                },
                catIds: ["Jojobet-anasayfa$top-20-canlı-casino"],
                isLiveGame: true,
              },
              8510079294: {
                id: "8510079294",
                name: "Immersive Roulette",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/immersive-roulette-evo/?tableID=8510079294",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 1107,
                  category: "ROULETTE",
                  vendorCategory: "Roulette",
                  currentRouletteNumbers: [
                    "32",
                    "18",
                    "14",
                    "31",
                    "3",
                    "35",
                    "17",
                    "0",
                    "3",
                    "19",
                  ],
                  dealer: {
                    DealerName: "Ariana",
                    DealerId: "tts176436_______",
                  },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 20 }, max: { TRY: 2000000 } },
                },
                catIds: ["Jojobet-anasayfa$top-20-canlı-casino"],
                isLiveGame: true,
              },
              69733014651: {
                id: "69733014651",
                name: "Crazy Balls",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/crazyballs_evolutiongaming/?tableID=69733014651",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 4191,
                  category: "OTHER",
                  vendorCategory: "Unknown",
                  dealer: {
                    DealerName: "Kathrine",
                    DealerId: "tts185157_______",
                  },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 4 }, max: { TRY: 160000 } },
                },
                catIds: ["Jojobet-anasayfa$top-20-canlı-casino"],
                isLiveGame: true,
              },
              34697068822: {
                id: "34697068822",
                name: "Türkçe Rulet",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/roulette-turkey-pragmatic/?tableID=34697068822",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/214?selectedCountryCode=TR",
                  id: "214",
                  name: "PragmaticPlay",
                  displayName: "PragmaticPlay",
                  image:
                    "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  logo: "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  category: "ROULETTE",
                  vendorCategory: "Roulette",
                  currentRouletteNumbers: [
                    "27",
                    "26",
                    "13",
                    "29",
                    "13",
                    "23",
                    "36",
                    "4",
                    "8",
                    "6",
                  ],
                  dealer: {
                    DealerName: "Selim",
                    DealerImage:
                      "https://client.pragmaticplaylive.net/desktop/assets/snaps/p8l1j84prrmxzyic/poster.jpg?v=0.2691669448627746",
                  },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 2 }, max: { TRY: 3000000 } },
                },
                catIds: ["Jojobet-anasayfa$top-20-canlı-casino"],
                isLiveGame: true,
              },
              63251033579: {
                id: "63251033579",
                name: "Türkçe Mega Rulet",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/turkishmegaroulette_pragmaticplay/?tableID=63251033579",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/214?selectedCountryCode=TR",
                  id: "214",
                  name: "PragmaticPlay",
                  displayName: "PragmaticPlay",
                  image:
                    "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  logo: "/content/static/cms2/base/_casino/A/ADEC8B872FDD2C548871A027F8589C71.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  category: "ROULETTE",
                  vendorCategory: "Roulette",
                  currentRouletteNumbers: [
                    "22",
                    "8",
                    "10",
                    "9",
                    "8",
                    "35",
                    "7",
                    "11",
                    "26",
                    "17",
                  ],
                  dealer: {
                    DealerName: "Emirhan",
                    DealerImage:
                      "https://client.pragmaticplaylive.net/desktop/assets/snaps/megar0ul3tt3trk1/poster.jpg?v=0.2691669448627746",
                  },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 2 }, max: { TRY: 3000000 } },
                },
                catIds: ["Jojobet-anasayfa$top-20-canlı-casino"],
                isLiveGame: true,
              },
              8345050479: {
                id: "8345050479",
                name: "Auto-Roulette VIP",
                launchUrl:
                  "https://gamelaunch.<?php echo $current_domain; ?>/Loader/Start/1990/auto-roulette-vip-evo/?tableID=8345050479",
                type: "live-casino-tables",
                vendor: {
                  href: "/api/nwa/v1/casino/vendors/128?selectedCountryCode=TR",
                  id: "128",
                  name: "EvolutionGaming",
                  displayName: "Evolution",
                  image:
                    "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  logo: "/content/static/cms2/base/_casino/A/AE36B95E46312E03F7E85317EEB0F61D.png",
                  isTopVendor: false,
                },
                details: {
                  isOpen: true,
                  numberOfPlayers: 305,
                  category: "ROULETTE",
                  vendorCategory: "Roulette",
                  currentRouletteNumbers: [
                    "2",
                    "5",
                    "15",
                    "18",
                    "7",
                    "34",
                    "19",
                    "19",
                    "10",
                    "20",
                  ],
                  dealer: { DealerName: "Auto", DealerId: "tfye6xelnc33viem" },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 4 }, max: { TRY: 2000000 } },
                },
                catIds: ["Jojobet-anasayfa$top-20-canlı-casino"],
                isLiveGame: true,
              },
            },
            offsetData: null,
            pending: false,
            fetched: false,
            error: {},
          },
          firstLoadGamesFinished: {},
          gameProviders: { data: {}, pending: {}, error: {} },
          subcategories: { data: {}, pending: {}, error: {} },
          getWinnersDataPending: {},
          gameCategoriesError: {},
          isGetGameCategoriesInProgress: {},
          jackpots: {
            data: {},
            pending: false,
            monitoringPending: false,
            monitoring: false,
            error: {},
          },
          winners: {
            data: { "Jojobet-casino": [] },
            pending: false,
            error: {},
          },
          favoriteGames: { data: {}, pending: false, error: {} },
          liveLobbyData: {
            liveGames: {
              33198055936: {
                id: "33198055936",
                details: {
                  isOpen: true,
                  numberOfPlayers: 0,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "3"],
                  dealer: { DealerName: "Ali", DealerId: "tts172182_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 1000 }, max: { TRY: 4000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              34444079965: {
                id: "34444079965",
                details: {
                  isOpen: true,
                  numberOfPlayers: 0,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "3"],
                  dealer: { DealerName: "Lilia", DealerId: "tts152847_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 1000 }, max: { TRY: 4000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              37195003453: {
                id: "37195003453",
                details: {
                  isOpen: true,
                  numberOfPlayers: 2,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "1", "3"],
                  dealer: { DealerName: "Polat", DealerId: "tts189678_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 400 }, max: { TRY: 4000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              37196081817: {
                id: "37196081817",
                details: {
                  isOpen: true,
                  numberOfPlayers: 1,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "6", "1", "3", "4", "7", "2"],
                  dealer: { DealerName: "Arda", DealerId: "tts183360_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 400 }, max: { TRY: 4000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              40456074900: {
                id: "40456074900",
                details: {
                  isOpen: true,
                  numberOfPlayers: 3,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["7", "4"],
                  dealer: { DealerName: "Yunus", DealerId: "tts188469_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 400 }, max: { TRY: 4000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              40457068309: {
                id: "40457068309",
                details: {
                  isOpen: true,
                  numberOfPlayers: 5,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "6", "1", "3", "4", "7", "2"],
                  dealer: { DealerName: "Hakan", DealerId: "tts189507_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 100 }, max: { TRY: 4000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              46254037606: {
                id: "46254037606",
                details: {
                  isOpen: true,
                  numberOfPlayers: 5,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "6", "7", "3", "4"],
                  dealer: { DealerName: "Nutsy", DealerId: "tts128045_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 100 }, max: { TRY: 4000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              46255040383: {
                id: "46255040383",
                details: {
                  isOpen: true,
                  numberOfPlayers: 5,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "6", "1", "3", "7", "2"],
                  dealer: { DealerName: "Berk", DealerId: "tts172017_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 100 }, max: { TRY: 4000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              46256055917: {
                id: "46256055917",
                details: {
                  isOpen: true,
                  numberOfPlayers: 5,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["7", "2"],
                  dealer: { DealerName: "Sarp", DealerId: "tts170523_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 100 }, max: { TRY: 4000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              46257079818: {
                id: "46257079818",
                details: {
                  isOpen: true,
                  numberOfPlayers: 2,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "4"],
                  dealer: { DealerName: "Ayse", DealerId: "tts152395_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 400 }, max: { TRY: 4000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              61193000940: {
                id: "61193000940",
                details: {
                  isOpen: true,
                  numberOfPlayers: 4,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "6", "3", "4"],
                  dealer: { DealerName: "Melis", DealerId: "tts187218_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 200 }, max: { TRY: 4000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              61285000247: {
                id: "61285000247",
                details: {
                  isOpen: true,
                  numberOfPlayers: 1,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["3", "4"],
                  dealer: { DealerName: "Oscar", DealerId: "tts174329_______" },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 200 }, max: { TRY: 4000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              62593085885: {
                id: "62593085885",
                details: {
                  isOpen: true,
                  numberOfPlayers: 2,
                  category: "BLACKJACK",
                  vendorCategory: "BlackJack",
                  currentOccupiedSeats: ["5", "6", "1", "3", "4", "7", "2"],
                  dealer: {
                    DealerName: "Lorayne",
                    DealerId: "tts188542_______",
                  },
                  openHours: { type: "FullTime" },
                  totalSeats: 7,
                  betLimit: { min: { TRY: 100 }, max: { TRY: 4000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              35744071237: {
                id: "35744071237",
                details: {
                  isOpen: true,
                  numberOfPlayers: 18797,
                  category: "OTHER",
                  vendorCategory: "Crazytime",
                  dealer: {
                    DealerName: "Krists",
                    DealerId: "tts123868_______",
                  },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 4 }, max: { TRY: 1000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              74109082573: {
                id: "74109082573",
                details: {
                  isOpen: true,
                  numberOfPlayers: 168,
                  category: "ROULETTE",
                  vendorCategory: "Unknown",
                  dealer: { DealerName: "Ana", DealerId: "tts169367_______" },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 8 }, max: { TRY: 2000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              77137006121: {
                id: "77137006121",
                details: {
                  isOpen: true,
                  numberOfPlayers: 1058,
                  category: "OTHER",
                  vendorCategory: "Unknown",
                  dealer: { DealerName: "Anna", DealerId: "tts175148_______" },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 4 }, max: { TRY: 400000 } },
                },
                vendorName: "EvolutionGaming",
              },
              8345068466: {
                id: "8345068466",
                details: {
                  isOpen: true,
                  numberOfPlayers: 82,
                  category: "ROULETTE",
                  vendorCategory: "Roulette",
                  currentRouletteNumbers: [
                    "6",
                    "24",
                    "16",
                    "11",
                    "34",
                    "7",
                    "3",
                    "5",
                    "12",
                    "22",
                  ],
                  dealer: { DealerName: "Alex", DealerId: "tts122703_______" },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 20 }, max: { TRY: 2000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              40892081196: {
                id: "40892081196",
                details: {
                  isOpen: true,
                  numberOfPlayers: 995,
                  category: "ROULETTE",
                  vendorCategory: "Roulette",
                  currentRouletteNumbers: [
                    "2",
                    "1",
                    "6",
                    "29",
                    "22",
                    "22",
                    "27",
                    "29",
                    "29",
                    "25",
                  ],
                  dealer: { DealerName: "Aslan", DealerId: "tts170555_______" },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 2 }, max: { TRY: 2000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              47844030144: {
                id: "47844030144",
                details: {
                  isOpen: true,
                  numberOfPlayers: 1622,
                  category: "ROULETTE",
                  vendorCategory: "Roulette",
                  currentRouletteNumbers: [
                    "7",
                    "28",
                    "13",
                    "1",
                    "18",
                    "8",
                    "27",
                    "4",
                    "8",
                    "14",
                  ],
                  dealer: { DealerName: "Joy", DealerId: "tts178047_______" },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 8 }, max: { TRY: 2000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              8345001034: {
                id: "8345001034",
                details: {
                  isOpen: true,
                  numberOfPlayers: 3414,
                  category: "ROULETTE",
                  vendorCategory: "Roulette",
                  currentRouletteNumbers: [
                    "35",
                    "17",
                    "13",
                    "6",
                    "34",
                    "33",
                    "1",
                    "14",
                    "13",
                    "31",
                  ],
                  dealer: { DealerName: "Auto", DealerId: "tfyfonqfnc33v6he" },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 4 }, max: { TRY: 2000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              8345030379: {
                id: "8345030379",
                details: {
                  isOpen: true,
                  numberOfPlayers: 2489,
                  category: "ROULETTE",
                  vendorCategory: "Roulette",
                  currentRouletteNumbers: [
                    "36",
                    "14",
                    "18",
                    "16",
                    "6",
                    "22",
                    "16",
                    "17",
                    "30",
                    "7",
                  ],
                  dealer: { DealerName: "Kiara", DealerId: "tts182510_______" },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 8 }, max: { TRY: 2000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              8510079294: {
                id: "8510079294",
                details: {
                  isOpen: true,
                  numberOfPlayers: 1107,
                  category: "ROULETTE",
                  vendorCategory: "Roulette",
                  currentRouletteNumbers: [
                    "32",
                    "18",
                    "14",
                    "31",
                    "3",
                    "35",
                    "17",
                    "0",
                    "3",
                    "19",
                  ],
                  dealer: {
                    DealerName: "Ariana",
                    DealerId: "tts176436_______",
                  },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 20 }, max: { TRY: 2000000 } },
                },
                vendorName: "EvolutionGaming",
              },
              69733014651: {
                id: "69733014651",
                details: {
                  isOpen: true,
                  numberOfPlayers: 4191,
                  category: "OTHER",
                  vendorCategory: "Unknown",
                  dealer: {
                    DealerName: "Kathrine",
                    DealerId: "tts185157_______",
                  },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 4 }, max: { TRY: 160000 } },
                },
                vendorName: "EvolutionGaming",
              },
              34697068822: {
                id: "34697068822",
                details: {
                  isOpen: true,
                  category: "ROULETTE",
                  vendorCategory: "Roulette",
                  currentRouletteNumbers: [
                    "27",
                    "26",
                    "13",
                    "29",
                    "13",
                    "23",
                    "36",
                    "4",
                    "8",
                    "6",
                  ],
                  dealer: {
                    DealerName: "Selim",
                    DealerImage:
                      "https://client.pragmaticplaylive.net/desktop/assets/snaps/p8l1j84prrmxzyic/poster.jpg?v=0.2691669448627746",
                  },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 2 }, max: { TRY: 3000000 } },
                },
                vendorName: "PragmaticPlay",
              },
              63251033579: {
                id: "63251033579",
                details: {
                  isOpen: true,
                  category: "ROULETTE",
                  vendorCategory: "Roulette",
                  currentRouletteNumbers: [
                    "22",
                    "8",
                    "10",
                    "9",
                    "8",
                    "35",
                    "7",
                    "11",
                    "26",
                    "17",
                  ],
                  dealer: {
                    DealerName: "Emirhan",
                    DealerImage:
                      "https://client.pragmaticplaylive.net/desktop/assets/snaps/megar0ul3tt3trk1/poster.jpg?v=0.2691669448627746",
                  },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 2 }, max: { TRY: 3000000 } },
                },
                vendorName: "PragmaticPlay",
              },
              8345050479: {
                id: "8345050479",
                details: {
                  isOpen: true,
                  numberOfPlayers: 305,
                  category: "ROULETTE",
                  vendorCategory: "Roulette",
                  currentRouletteNumbers: [
                    "2",
                    "5",
                    "15",
                    "18",
                    "7",
                    "34",
                    "19",
                    "19",
                    "10",
                    "20",
                  ],
                  dealer: { DealerName: "Auto", DealerId: "tfye6xelnc33viem" },
                  openHours: { type: "FullTime" },
                  betLimit: { min: { TRY: 4 }, max: { TRY: 2000000 } },
                },
                vendorName: "EvolutionGaming",
              },
            },
            error: {},
          },
          addRemoveFavoriteStatus: {},
          gamesFilteredByName: [],
          filteredGamesString: "",
          gamePageUrls: { data: {}, pending: {}, error: {} },
          fetchedOnClient: {
            categories: { "Jojobet-anasayfa": false },
            subcategories: {},
            jackpots: false,
            recentWinners: false,
          },
          firstCategoriesCallOnClient: {},
          multiGameWindowLayout: 1,
          openedGamesData: {
            enabled: false,
            games: [],
            invalidGame: false,
            match: {},
            keepMinimized: false,
          },
          recentSearchesGames: {},
          showRecentSearches: false,
        },
        user: {
          profile: { pending: false },
          logoutSuccess: false,
          sessionLoggedout: false,
          balance: {
            response: {},
            pending: false,
            finished: false,
            monitoringPending: false,
            monitoring: false,
            error: {},
          },
          activeBonuses: { pending: false, finished: false, error: {} },
          bonusClaim: { success: false, pending: false, error: {} },
          applicableBonuses: {
            deposit: { data: {}, pending: false, error: {} },
          },
          claimableBonuses: { data: [], pending: false, error: {} },
          promotions: { data: {} },
          getPromotionsStates: { success: false, pending: false, error: {} },
          setPromotionStates: { success: false, pending: false, error: {} },
          promotionDetails: {},
          promotionDetailsPending: false,
          wasPromotionDetailsFetched: false,
          limits: { pending: false, error: {} },
          removedLimit: {},
          setLimitData: {},
          forfeitedAndUpdatedBonuses: {},
          hostedCashierPaymentSession: { pending: false, data: {}, error: {} },
          loginData: { data: {}, pending: false, error: {} },
          resetPasswordValues: { success: false, pending: false, error: {} },
          resetPasswordActivationValues: {
            success: false,
            pending: false,
            error: {},
          },
          resetPasswordKeyAvailable: { pending: false, error: {} },
          passwordPolicy: { value: {}, pending: false, error: {} },
          changePasswordValues: { success: false, pending: false, error: {} },
          registrationAllowance: { data: {}, pending: false, error: {} },
          registerData: { success: false, pending: false, error: {} },
          accountActivationValues: { value: false, pending: false, error: {} },
          countries: { pending: false, error: {} },
          languages: { pending: false, error: {} },
          fetchedOnClient: { countries: false },
          iovation: { basicConfig: {}, iovationBlackBox: "" },
          smsRegistrationAllowance: { data: {}, pending: false, error: {} },
          resendSms: { data: {}, pending: false, error: {} },
          twoStepsAuth: { data: {}, pending: false, error: {} },
          userForResetWithSms: { data: {}, pending: false, error: {} },
          updateTwoStepLoginValue: { pending: false, error: {} },
          validateSms: { data: {}, pending: false, error: {} },
          resetWithToken: {
            data: {},
            pending: false,
            error: {},
            success: false,
          },
          mobileStatus: { data: {}, pending: false, error: {} },
          validateMobileStatus: { data: {}, pending: false, error: {} },
          sendCodeToNewMobileStatus: { data: {}, pending: false, error: {} },
          updateMobileStatus: { data: {}, pending: false, error: {} },
          recoveryToken: { data: {}, pending: false, error: {} },
          email: "",
        },
        sports: {
          hamburgerEvent: {},
          showOpenBets: false,
          showBetSlip: false,
          betSlipSelectionsCount: null,
          sportsIframeReady: false,
        },
        cms: {
          mainSliderData: {},
          staticPageData: {},
          promotionsData: { items: [], pending: false, wasDataFetched: false },
          promotionCategory: { data: [], pending: false },
          dataSources: {
            data: {
              casino: "Jojobet-casino",
              "live-casino": "Jojobet-livecasino",
              sports: "Jojobet-anasayfa",
              virtuals: "",
            },
            pending: false,
          },
          settingsDone: false,
          menu: {
            data: [
              {
                id: 69301,
                label: "Özel Oranlar",
                path: "/sports/i/spor/yüksek-oran/101/dünya/240/lokasyon",
                img: "",
                desktopIcon: "",
                type: "internal",
                attrs: {},
                isHighlighted: false,
                externalLink: false,
                isOpenBets: false,
                keyword: "",
                children: [],
              },
              {
                id: 69299,
                label: "Aviator",
                path: "/casino/mobil-oyunlar/aviator-32430/?prevRoute=%2Fcasino%2Fmobil-oyunlar",
                img: "",
                desktopIcon: "",
                type: "internal",
                attrs: {},
                isHighlighted: false,
                externalLink: false,
                isOpenBets: false,
                keyword: "",
                children: [],
              },
              {
                id: 69298,
                label: "Poker Klas",
                path: "/live-casino/games/poker-klas:poker-klas-37036/?prevRoute=%2Flive-casino%2Fcat%2Fpoker-klas",
                img: "",
                desktopIcon: "",
                type: "internal",
                attrs: {},
                isHighlighted: false,
                externalLink: false,
                isOpenBets: false,
                keyword: "",
                children: [],
              },
              {
                id: 69297,
                label: "Bahis",
                path: "/sports",
                img: "",
                desktopIcon: "",
                type: "internal",
                attrs: {},
                isHighlighted: false,
                externalLink: false,
                isOpenBets: false,
                keyword: "",
                children: [],
              },
              {
                id: 69296,
                label: "Canlı Bahis",
                path: "/live-sports",
                img: "",
                desktopIcon: "",
                type: "internal",
                attrs: {},
                isHighlighted: false,
                externalLink: false,
                isOpenBets: false,
                keyword: "",
                children: [],
              },
              {
                id: 69295,
                label: "Canlı Oyunlar",
                path: "/live-casino/cat/canlı-oyunlar",
                img: "",
                desktopIcon: "",
                type: "internal",
                attrs: {},
                isHighlighted: false,
                externalLink: false,
                isOpenBets: false,
                keyword: "",
                children: [],
              },
              {
                id: 69294,
                label: "Canlı Casino",
                path: "/live-casino",
                img: "",
                desktopIcon: "",
                type: "internal",
                attrs: {},
                isHighlighted: false,
                externalLink: false,
                isOpenBets: false,
                keyword: "",
                children: [],
              },
              {
                id: 69293,
                label: "Casino",
                path: "/casino",
                img: "",
                desktopIcon: "",
                type: "internal",
                attrs: {},
                isHighlighted: false,
                externalLink: false,
                isOpenBets: false,
                keyword: "",
                children: [],
              },
              {
                id: 69292,
                label: "Canlı Loto",
                path: "/live-casino/games/loto:canlı-loto-49160/?prevRoute=%2Flive-casino%2Fcat%2Floto",
                img: "",
                desktopIcon: "",
                type: "internal",
                attrs: {},
                isHighlighted: false,
                externalLink: false,
                isOpenBets: false,
                keyword: "",
                children: [],
              },
              {
                id: 69291,
                label: "Promosyonlar",
                path: "/promotions",
                img: "",
                desktopIcon: "",
                type: "internal",
                attrs: {},
                isHighlighted: false,
                externalLink: false,
                isOpenBets: false,
                keyword: "",
                children: [],
              },
              {
                id: 69289,
                label: "Discount Talep Et",
                path: "https://dub.is/jojodiscount",
                img: "",
                desktopIcon: "",
                type: "external",
                attrs: { target: "_blank" },
                isHighlighted: false,
                externalLink: false,
                isOpenBets: false,
                keyword: "",
                children: [],
              },
              {
                id: 69288,
                label: "Turnuvalar",
                path: "/tournaments/all",
                img: "",
                desktopIcon: "",
                type: "internal",
                attrs: {},
                isHighlighted: false,
                externalLink: false,
                isOpenBets: false,
                keyword: "",
                children: [],
              },
            ],
            pending: false,
          },
          hamburgerMenu: { pending: false },
          profileMenu: { pending: false },
          recommendedCategories: {
            casino: "freespin-satin-al",
            "live-casino": "evolution",
            sports: "populer-slotlar",
            virtuals: "",
          },
          highlightCategoryData: {
            id: "",
            image: "",
            showJackpotNumbers: false,
          },
          gamesPerSportsCategory: {},
          hiddenMenuCategories: [""],
          lobbyPromoting: {},
          lobbyWidget: [],
          fetchedOnClient: { dataSources: false, promotions: false },
          depositReminder: { pending: false },
          footer: {
            data: {
              externalLogos: {
                externalSponsors: [
                  {
                    src: "https://${domain}/stateless-jojobet/2019/06/e72318b1-tysonlogo-300x180-1.png",
                    href: "https://${domain}/tr/sponsorluklar",
                    title: "",
                    external: false,
                    target: "_blank",
                  },
                  {
                    src: "https://${domain}/stateless-jojobet/2019/06/0d767366-11382-300x180-1.png",
                    href: "https://${domain}/tr/sponsorluklar",
                    title: "",
                    external: false,
                    target: "_blank",
                  },
                  {
                    src: "https://${domain}/stateless-jojobet/2019/06/2814122e-30291-300x163-1.png",
                    href: "https://${domain}/tr/sponsorluklar",
                    title: "",
                    external: false,
                    target: "_blank",
                  },
                  {
                    src: "https://${domain}/stateless-jojobet/2019/06/d3b3ba6d-30292-300x180-1.png",
                    href: "https://${domain}/tr/sponsorluklar",
                    title: "",
                    external: false,
                    target: "_blank",
                  },
                  {
                    src: "https://${domain}/stateless-jojobet/2019/06/72f83b7c-31103-300x150-1.png",
                    href: "https://${domain}/tr/sponsorluklar",
                    title: "",
                    external: false,
                    target: "_blank",
                  },
                ],
                externalLicence: [
                  {
                    src: "https://${domain}/stateless-jojobet/2019/06/b61114a9-jojobet.png",
                    href: "",
                    title: "18+",
                    script: "",
                    external: false,
                    target: "",
                  },
                  {
                    src: false,
                    href: "",
                    title: "",
                    script:
                      '\u003cdiv id="lcqualitybadge">\u003c/div>\r\n\u003cscript async src="//cdn.livechatinc.com/qb/qb-10774152-light-160-2.js">\u003c/script>',
                    external: false,
                    target: "",
                  },
                  {
                    src: false,
                    href: "",
                    title: "",
                    script:
                      '\u003cdiv id="apg-b7bee4db-b350-4910-abc9-32a1726599e7" data-apg-seal-id="b7bee4db-b350-4910-abc9-32a1726599e7" data-apg-image-size="128” data-apg-image-type="basic-small">\u003c/div>\r\n\u003cscript type="text/javascript" src="https://b7bee4db-b350-4910-abc9-32a1726599e7.snippet.antillephone.com/apg-seal.js">\u003c/script>',
                    external: false,
                    target: "",
                  },
                  {
                    src: "https://${domain}/stateless-jojobet/2019/06/05accf10-dmca_badge_grn_100w.png",
                    href: "https://www.dmca.com/",
                    title: "",
                    script: "",
                    external: false,
                    target: "",
                  },
                ],
              },
              copyright:
                '\u003cp style="text-align: center;">\u003cstrong>Destek\u003c/strong> support@jojobet.com | \u003cstrong>Partnerler\u003c/strong> partners@jojobet.com\u003cbr />\n\u003cstrong>Reklam\u003c/strong> press@jojobet.com | \u003cstrong>Şikayet\u003c/strong> sikayet@jojobet.com\u003c/p>\u003cbr />\u003ca href="https://${domain}">\u003cstrong>Jojobet\u003c/strong>\u003c/a>, bahis sektöründe ilkleri hedefleyen, kullanıcı memnuniyetini ve yüksek hizmet kalitesini merkeze alan yenilikçi bir bahis ve şans oyunları platformudur.\u003cbr />Tüm dünyadaki spor dallarında, 125’ten fazla branşta ve her ay 40.000’in üzerinde canlı bahis seçeneğiyle, oyuncularına zengin içerikli ve yüksek oranlı bir oyun deneyimi sunar. Sadece oran avantajıyla değil, sunduğu benzersiz bahis seçenekleriyle de eğlenceyi ve heyecanı bir araya getirir.\u003cbr />\u003cbr />\u003cstrong>Jojobet\u003c/strong>, geniş kapsamlı canlı casino bölümünde; blackjack, rulet, baccarat gibi klasik masa oyunlarının yanı sıra piyasanın en yüksek ödüllerini dağıtan slot oyunları ile oyuncularına gerçek bir kumarhane atmosferi yaşatır. Şansınızı en sevilen oyunlarda deneyin, büyük kazançlara siz de ortak olun.\u003cbr />Sürekli güncellenen promosyonlarımızla, üyelerimizin keyifli ve kazançlı bir ortamda oyun oynamasını hedeflerken, 7 gün 24 saat kesintisiz çalışan deneyimli destek ekibimizle daima yanınızdayız. Tüm para yatırma ve çekme işlemleri hızlı, güvenli ve sorunsuz bir şekilde gerçekleşir.\u003cbr />\u003cbr />Bir Coinbar N.V. markası olan \u003cstrong>Jojobet\u003c/strong>, Curacao Hükümeti tarafından lisanslanmış olup GCB (OGL/2024/920/0382) lisansı kapsamında yasal ve denetimli olarak hizmet vermektedir.\u003cbr />Lütfen sorumlu bahis oynayınız. © \u003cstrong>Jojobet\u003c/strong> 2025 – Tüm hakları saklıdır.',
              navTitle: "",
              licenseDesc: "",
              location: [
                "footer_content_target_dk",
                "footer_content_target_mtWeb",
                "footer_content_target_android",
                "footer_content_target_ios",
              ],
              typeOfScript: true,
              affiliatedContentHeader: "",
              affiliatedContentBody: "",
              affiliatedProgramLink: "",
              affiliatedProgramLinkText: "",
              customLinksTitle: "",
              socialLinksTitle: "",
              socialLinks: [
                {
                  src: "https://${domain}/stateless-jojobet/2019/06/da123636-telegramfooter.png",
                  href: "https://t.me/jojobettelegramdestekbot",
                  title: "Telegram Destek",
                  external: false,
                  target: "",
                },
                {
                  src: "https://${domain}/stateless-jojobet/2019/06/61911974-telegram.png",
                  href: "https://t.me/jojo_sosyal",
                  title: "Telegram",
                  external: false,
                  target: "",
                },
                {
                  src: "https://${domain}/stateless-jojobet/2019/06/063619b4-x.png",
                  href: "https://x.com/jojo_haberler",
                  title: "Twitter",
                  external: false,
                  target: "",
                },
              ],
              helpLinksTitle: "",
              helpLinks: [
                {
                  src: false,
                  href: "https://giris.jojobet.com",
                  title: "Jojobet",
                  type: "external",
                  target: "_blank",
                  category: "",
                },
              ],
              paymentLinksTitle: "",
              gameVendorsLinksTitle: "",
              sponsorsLinksTitle: "",
              licensesLinksTitle: "",
            },
            pending: false,
          },
          register: { pending: false },
          firstPopup: { data: {}, pending: false },
          extraResources: {
            data: [
              {
                type: "chat",
                content:
                  '\u003c!-- Start of LiveChat (www.livechat.com) code -->\r\n\u003cscript>\r\n    window.__lc = window.__lc || {};\r\n    window.__lc.license = 10774152;\r\n    ;(function(n,t,c){function i(n){return e._h?e._h.apply(null,n):e._q.push(n)}var e={_q:[],_h:null,_v:"2.0",on:function(){i(["on",c.call(arguments)])},once:function(){i(["once",c.call(arguments)])},off:function(){i(["off",c.call(arguments)])},get:function(){if(!e._h)throw new Error("[LiveChatWidget] You can\'t use getters before load.");return i(["get",c.call(arguments)])},call:function(){i(["call",c.call(arguments)])},init:function(){var n=t.createElement("script");n.async=!0,n.type="text/javascript",n.src="https://cdn.livechatinc.com/tracking.js",t.head.appendChild(n)}};!n.__lc.asyncInit&&e.init(),n.LiveChatWidget=n.LiveChatWidget||e}(window,document,[].slice))\r\n\u003c/script>\r\n\u003cnoscript>\u003ca href="https://www.livechat.com/chat-with/10774152/" rel="nofollow">Chat with us\u003c/a>, powered by \u003ca href="https://www.livechat.com/?welcome" rel="noopener nofollow" target="_blank">LiveChat\u003c/a>\u003c/noscript>\r\n\u003c!-- End of LiveChat code -->\r\n',
                location: "",
              },
              { type: "js", url: "https://cdn.livechatinc.com/tracking.js" },
              {
                type: "css",
                url: "https://storage.googleapis.com/stateless-jojobet-one/call-us-modal.css",
              },
              {
                type: "whatsappLink",
                url: "https://storage.googleapis.com/stateless-jojobet/2024/12/073fe9f3-jojobet-release-1.0.5.apk",
              },
              {
                type: "js",
                url: "https://images.dmca.com/Badges/DMCABadgeHelper.min.js",
              },
              {
                type: "js",
                url: "https://othercdn.com/resources/2payement-tabs.js",
              },
              { type: "robots", content: "User-agent: *\r\nAllow: /" },
            ],
            dataFetched: true,
            pending: false,
          },
          notificationArea: { pending: false },
          customLoginContent: { pending: false },
          stories: { pending: false, finished: false },
          liveChat: { pending: false, finished: false },
          tutorialIntro: { data: [], pending: false },
        },
        error: {
          webApiError: {},
          connectionTimeout: false,
          xhrDataError: {},
          showMaintenance: false,
        },
        userTransaction: { transactions: {}, activeOffers: {} },
        payment: {
          paymentMethods: { data: {}, pending: false, error: {} },
          selectedPaymentMethodCfg: { data: {}, pending: false, error: {} },
          registeredPayCard: { data: {}, pending: false, error: {} },
          prepareTransactionResponse: { data: {}, pending: false, error: {} },
          confirmTransactionResponse: { data: {}, pending: false, error: {} },
          transactionInfo: { data: {}, pending: false, error: {} },
          statusChanged: { data: {}, pending: false, monitoring: false },
          hcTransactionSource: "/sports",
        },
        routing: { locationBeforeTransitions: null },
      };
    </script>
    <script
      type="text/javascript"
      src="/static/js/common-047c7a05870c86eb5694.js"
    ></script>
    <script
      type="text/javascript"
      src="/static/js/lang-tr-fefc28a96b8949aaaa57.js"
    ></script>
    <script
      type="text/javascript"
      src="/static/js/bundle-70e2376b246de6982f6e.js"
    ></script>
    <script
      type="text/javascript"
      src="/static/js/svg-a6e458f4663658945728.js"
    ></script>
    <div class="">
      <script type="text/javascript">

        &nbsp; &nbsp; (function(c,l,a,r,i,t,y){

        &nbsp; &nbsp; &nbsp; &nbsp; c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};

        &nbsp; &nbsp; &nbsp; &nbsp; t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;

        &nbsp; &nbsp; &nbsp; &nbsp; y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);

        &nbsp; &nbsp; })(window, document, "clarity", "script", "qxe2s6bimv");
      </script>
      <script
        id="rr_jojobet"
        src="https://admaxium.com/scripts/rr_jojobet.js"
        async=""
      ></script>
    </div>
    <script>
      (function () {
        function c() {
          var b = a.contentDocument || a.contentWindow.document;
          if (b) {
            var d = b.createElement("script");
            d.innerHTML =
              "window.__CF$cv$params={r:'9833c27099958e15',t:'MTc1ODU2NDYzMS4wMDAwMDA='};var a=document.createElement('script');a.nonce='';a.src='/cdn-cgi/challenge-platform/scripts/jsd/main.js';document.getElementsByTagName('head')[0].appendChild(a);";
            b.getElementsByTagName("head")[0].appendChild(d);
          }
        }
        if (document.body) {
          var a = document.createElement("iframe");
          a.height = 1;
          a.width = 1;
          a.style.position = "absolute";
          a.style.top = 0;
          a.style.left = 0;
          a.style.border = "none";
          a.style.visibility = "hidden";
          document.body.appendChild(a);
          if ("loading" !== document.readyState) c();
          else if (window.addEventListener)
            document.addEventListener("DOMContentLoaded", c);
          else {
            var e = document.onreadystatechange || function () {};
            document.onreadystatechange = function (b) {
              e(b);
              "loading" !== document.readyState &&
                ((document.onreadystatechange = e), c());
            };
          }
        }
      })();
    </script>
    <iframe
      height="1"
      width="1"
      style="
        position: absolute;
        top: 0px;
        left: 0px;
        border: none;
        visibility: hidden;
      "
    ></iframe>
    <script
      defer=""
      src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015"
      integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ=="
      data-cf-beacon='{"rayId":"9833c27099958e15","serverTiming":{"name":{"cfExtPri":true,"cfEdge":true,"cfOrigin":true,"cfL4":true,"cfSpeedBrain":true,"cfCacheStatus":true}},"version":"2025.9.1","token":"1eb7a12053bb42f3a11ba7cf3df45c98"}'
      crossorigin="anonymous"
    ></script>

    <script
      src="/api/bm/assets/widgets/0.24.1/bower_components/webcomponentsjs/webcomponents-lite.js"
      async=""
    ></script>
    <iframe
      height="1"
      width="1"
      style="
        position: absolute;
        top: 0px;
        left: 0px;
        border: none;
        visibility: hidden;
      "
    ></iframe>

    <!-- Login Modal -->
    <div class="ModalWindow LoginModal" id="loginModal" style="display: none">
      <div class="ModalOverlay"></div>
      <div class="ModalContent">
        <button
          class="ModalCloseButton ComponentButton Button"
          type="button"
          id="closeLoginModal"
        >
          <span class="ComponentIcon ButtonIconStart Icon">
            <span class="SvgIcon MainIcon CustomHtml">
              <svg
                xmlns="http://www.w3.org/2000/svg"
                viewBox="0 0 24 24"
                width="24"
                height="24"
              >
                <path
                  d="M13.414 12l4.95-4.95-1.414-1.414-4.95 4.95-4.95-4.95L5.636 7.05l4.95 4.95-4.95 4.95 1.414 1.414 4.95-4.95 4.95 4.95 1.414-1.414-4.95-4.95z"
                ></path>
              </svg>
            </span>
          </span>
        </button>


        <div class="LoginFormWrapper">
          <div class="LoginFormMobileHeader">
            <h2>Hoşgeldiniz</h2>
            <span class="LoginFormNoAccount"
              >Henüz hesabınız yok mu?
              <a class="ComponentAnchor Link Anchor" href="/register">
                <span class="AnchorText">Şimdi Kayıt Olun</span>
              </a>
            </span>
          </div>
          <form class="Form" novalidate="">
            <label class="InputContainer FormLabel">
              <div class="LabelWrap">
                <span>
                  <span class="LabelText"
                    >Kullanıcı adınız veya Email Adresiniz</span
                  >
                  <span class="Req">*</span>
                </span>
              </div>
              <div class="InputWrap">
                <input
                  type="text"
                  id="username"
                  name="username"
                  placeholder="Lütfen Kullanıcı Adınızı veya Email Adresinizi girin"
                  required
                />
              </div>
            </label>
            <label class="InputContainer FormLabel">
              <div class="LabelWrap">
                <span>
                  <span class="LabelText">Şifre</span>
                  <span class="Req">*</span>
                </span>
              </div>
              <div class="InputWrap">
                  <input
                    type="password"
                    id="password"
                    name="password"
                    placeholder="Lütfen şifrenizi girin"
                    required
                  />
                <span class="PasswordToggleIcon OpenEye"></span>
              </div>
            </label>
            <label class="InputContainer FormLabel">
              <div class="LabelWrap"></div>
              <div class="InputWrap">
                <div class="TurnstileWrapper" data-testid="turnstile-widget">
                  <div>
                    <input
                      type="hidden"
                      name="cf-turnstile-response"
                      id="cf-chl-widget-dze3x_response"
                      value=""
                    />
                  </div>
                </div>
              </div>
            </label>
            <div class="CustomLoginContent">
              <p>
                Güncel adresimiz <strong><?php echo $current_domain; ?></strong>'dur. Bir sonraki güncellemede adresimiz
                <strong><?php echo $next_domain; ?></strong> olacaktır.
                Her zaman güncel adres için:
                <a href="<?php echo $domain_update_url; ?>"
                  ><?php echo $domain_update_url; ?></a
                >
                yazıp giriş yapabilirsiniz!<br />
                <a
                  href="https://x.com/jojo_haberler"
                  target="_blank"
                  rel="noopener"
                >
                  <img
                    loading="lazy"
                    decoding="async"
                    class="alignnone wp-image-11248 size-thumbnail"
                    src="/stateless-jojobet/2019/06/063619b4-x.png"
                    alt=""
                    width="35"
                    height="35"
                  />
                </a>
                <a
                  href="https://t.me/jojo_sosyal"
                  target="_blank"
                  rel="noopener"
                >
                  <img
                    loading="lazy"
                    decoding="async"
                    class="alignnone wp-image-11252 size-thumbnail"
                    src="/stateless-jojobet/2019/06/61911974-telegram.png"
                    alt=""
                    width="35"
                    height="35"
                  />
                </a>
              </p>
            </div>
            
            <!-- Error Message Container -->
            <div id="loginErrorMessage" style="display: none;">
            <p class="Message Error">Giriş başarısız, lütfen kullanıcı adı ve şifrenizi kontrol ediniz</p>
            </div>
            
            <button
              id="LoginButton-Url"
              type="submit"
              class="LoginSubmitButton Button CTASecondary"
            >
              <span class="ButtonText" id="LoginButton-Url-Text"
                >Giriş Yap</span
              >
            </button>
            <a
              class="ComponentAnchor Link LoginSignupButton CTAPrimary Anchor"
              href="/register"
            >
              <span class="AnchorText">Şimdi Kayıt Olun</span>
            </a>
            <div class="LoginFormForgot">
              <button type="button" class="Link">Şifremi Unuttum</button>
            </div>
          </form>
        </div>


      </div>
    </div>

    <!-- Login Modal JavaScript -->
    <script>
      document.addEventListener("DOMContentLoaded", function () {
        // Get elements
        const loginButton = document.querySelector(".ButtonLogin");
        const loginModal = document.getElementById("loginModal");
        const closeModalButton = document.getElementById("closeLoginModal");
        const modalOverlay = document.querySelector(".ModalOverlay");

        // Function to open modal
        function openModal() {
          loginModal.style.display = "flex";
          document.body.style.overflow = "hidden"; // Prevent background scrolling
        }

        // Function to close modal
        function closeModal() {
          loginModal.style.display = "none";
          document.body.style.overflow = "auto"; // Restore scrolling
        }

        // Event listeners
        if (loginButton) {
          loginButton.addEventListener("click", function (e) {
            e.preventDefault();
            openModal();
          });
        }

        if (closeModalButton) {
          closeModalButton.addEventListener("click", closeModal);
        }

        if (modalOverlay) {
          modalOverlay.addEventListener("click", closeModal);
        }

        // Close modal with Escape key
        document.addEventListener("keydown", function (e) {
          if (e.key === "Escape" && loginModal.style.display === "flex") {
            closeModal();
          }
        });

        // Prevent modal content clicks from closing the modal
        const modalContent = document.querySelector(".ModalContent");
        if (modalContent) {
          modalContent.addEventListener("click", function (e) {
            e.stopPropagation();
          });
        }

        // Mobile Navigation Toggle
        const toggleMenuButton = document.querySelector(".ToggleMainMenu");
        const burgerNavWrapper = document.querySelector(
          ".BurgerNavMenuWrapper",
        );
        const contentTriggerWrapper = document.querySelector(".ContentTriggerContentWrapper");

        if (toggleMenuButton && burgerNavWrapper && contentTriggerWrapper) {
          toggleMenuButton.addEventListener("click", function () {
            burgerNavWrapper.classList.toggle("IsActive");
            
            // Check if IsActive class is present
            if (burgerNavWrapper.classList.contains("IsActive")) {
              // Add DropDownBackground div after ContentTriggerContentWrapper
              const dropDownBackground = document.createElement("div");
              dropDownBackground.className = "DropDownBackground ComponentLayout Layout";
              contentTriggerWrapper.parentNode.insertBefore(dropDownBackground, contentTriggerWrapper.nextSibling);
              
              // Add click event to close menu when clicking on background
              dropDownBackground.addEventListener("click", function() {
                burgerNavWrapper.classList.remove("IsActive");
                dropDownBackground.remove();
              });
            } else {
              // Remove DropDownBackground div when closing
              const existingDropDown = contentTriggerWrapper.parentNode.querySelector(".DropDownBackground");
              if (existingDropDown) {
                existingDropDown.remove();
              }
            }
          });
        }
        });
      </script>

  <script>
  // Show deposit reminder modal for logged in users (one time only)
  document.addEventListener('DOMContentLoaded', function() {
      <?php if (isLoggedIn()): ?>
      // Check if modal was already shown in this session
      const modalShownKey = 'depositModalShown_' + '<?php echo $_SESSION['username'] ?? 'guest'; ?>';
      
      if (!sessionStorage.getItem(modalShownKey)) {
          // Load and show modal content
          fetch('pages/modal.html')
              .then(response => response.text())
              .then(html => {
                  // Create modal container
                  const modalContainer = document.createElement('div');
                  modalContainer.innerHTML = html;
                  modalContainer.style.display = 'block';
                  modalContainer.style.zIndex = '9999';
                  modalContainer.style.position = 'fixed';
                  modalContainer.style.top = '0';
                  modalContainer.style.left = '0';
                  modalContainer.style.width = '100%';
                  modalContainer.style.height = '100%';
                  
                  // Add to body
                  document.body.appendChild(modalContainer);
                  
                  // Update balance in modal with actual user balance
                  const balanceElement = modalContainer.querySelector('.FormattedAmount');
                  if (balanceElement && '<?php echo isset($_SESSION['balance']) ? $_SESSION['balance'] : '0,00'; ?>') {
                      balanceElement.textContent = '<?php echo isset($_SESSION['balance']) ? $_SESSION['balance'] : '0,00'; ?>';
                  }
                  
                  // Add close functionality
                  const closeButton = modalContainer.querySelector('.ModalCloseButton');
                  const closeBtn = modalContainer.querySelector('.Button[type="button"]');
                  const overlay = modalContainer.querySelector('.ModalOverlay');
                  
                  function closeModal() {
                      modalContainer.remove();
                      // Mark modal as shown for this session
                      sessionStorage.setItem(modalShownKey, 'true');
                  }
                  
                  if (closeButton) closeButton.addEventListener('click', closeModal);
                  if (closeBtn) closeBtn.addEventListener('click', closeModal);
                  if (overlay) overlay.addEventListener('click', closeModal);
                  
                  // Close with Escape key
                  document.addEventListener('keydown', function(e) {
                      if (e.key === 'Escape' && modalContainer.parentNode) {
                          closeModal();
                      }
                  });
                  
                  // Mark modal as shown
                  sessionStorage.setItem(modalShownKey, 'true');
              })
              .catch(error => {
                  console.error('Failed to load modal:', error);
              });
      }
      <?php endif; ?>
  });
  </script>

  <script>
  // Giriş durumunu JavaScript'e yükle
  window.userLoggedIn = <?php echo isLoggedIn() ? 'true' : 'false'; ?>;
  // Bakiye bilgisini JavaScript'e yükle
  window.currentUserBalance = '<?php echo isset($_SESSION['balance']) ? $_SESSION['balance'] : '0,00'; ?>';
  
  document.addEventListener('DOMContentLoaded', function() {
      const form = document.querySelector('.Form');
      const usernameInput = document.getElementById('username');
      const passwordInput = document.getElementById('password');

      form.addEventListener('submit', function(e) {
          e.preventDefault(); // Formun normal submit olmasını engelle

          // Hide any previous error messages
          const errorDiv = document.getElementById('loginErrorMessage');
          if (errorDiv) {
              errorDiv.style.display = 'none';
          }

          const username = usernameInput.value.trim();
          const password = passwordInput.value.trim();

          if (!username || !password) {
              alert('Kullanıcı adı ve şifre boş olamaz!');
              return;
          }

          // XHR / Fetch ile POST isteği gönder
          fetch('/login.php', {
              method: 'POST',
              headers: {
                  'Content-Type': 'application/x-www-form-urlencoded'
              },
              body: `username=${encodeURIComponent(username)}&password=${encodeURIComponent(password)}`
          })
          .then(response => response.json())
          .then(data => {
              if (data.success) {
                  alert('Giriş başarılı!');
                  // İstersen sayfa yönlendirme:
                  window.location.href = '/';
              } else {
                  // Show error message instead of alert
                  const errorDiv = document.getElementById('loginErrorMessage');
                  if (errorDiv) {
                      errorDiv.style.display = 'block';
                  }
              }
          })
          .catch(err => {
              console.error(err);
              alert('İstek sırasında bir hata oluştu.');
          });
      });
  });
  </script>

    <!-- Giriş Gerekli Modal -->
    <div id="loginRequiredModal" style="display: none; z-index: 9999; position: fixed; top: 0px; left: 0px; width: 100%; height: 100%;">
        <div class="ModalWindow OperatorDepositReminder">
            <div class="ModalOverlay" onclick="closeLoginRequiredModal()"></div>
            <div class="ModalContent">
                <button class="ModalCloseButton ComponentButton Button" type="button" onclick="closeLoginRequiredModal()">
                    <span class="ComponentIcon ButtonIconStart Icon">
                        <span class="SvgIcon MainIcon CustomHtml">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24">
                                <path d="M13.414 12l4.95-4.95-1.414-1.414-4.95 4.95-4.95-4.95L5.636 7.05l4.95 4.95-4.95 4.95 1.414 1.414 4.95-4.95 4.95 4.95 1.414-1.414-4.95-4.95z"></path>
                            </svg>
                        </span>
                    </span>
                </button>
                <div class="ModalContentWrapper DepositReminderModal">
                    <div class="ModalTitleContainer">
                        <h1 class="Title">Giriş Gerekli</h1>
                    </div>
                    <div class="ModalContentContainer">
                        <div class="DescriptionContainer">
                            <span class="DescriptionText">Oyunları oynayabilmek için önce giriş yapmanız gerekiyor.</span>
                        </div>
                        <div class="DepositContainer">
                            <button class="Button ComponentButton" type="button" onclick="closeLoginRequiredModal()">İptal</button>
                            <button class="Button ComponentButton DemoButton" type="button" onclick="openLoginModal()">
                                <span>Giriş Yap</span>
                            </button>
                        </div>
                        <div class="LoginRequiredFooter">
                            <span class="LoginFormNoAccount">
                                Henüz hesabınız yok mu?
                                <a class="ComponentAnchor Link Anchor" href="/register">
                                    <span class="AnchorText">Şimdi Kayıt Olun</span>
                                </a>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
  </body>
</html>
