<?php
/**
 * Direct Game URLs Configuration
 * Game symbols mapped to their direct iframe URLs
 */

$direct_game_urls = [
    // Pragmatic Play Games
    'sweet-bonanza-pragmatic' => 'https://d3pvfi6m7bxu71.cloudfront.net/gs2c/openGame.do?extGame=1&gameSymbol=vs20fruitsw&lang=TR&cur=TRY&jurisdiction=99', // Sweet Bonanza
    'gates-of-olympus' => 'https://d3pvfi6m7bxu71.cloudfront.net/gs2c/openGame.do?extGame=1&gameSymbol=vs20olympx&lang=TR&cur=TRY&jurisdiction=99', // Gates of Olympus
        'gates-of-olympus-1000' => 'https://d3pvfi6m7bxu71.cloudfront.net/gs2c/openGame.do?extGame=1&gameSymbol=vs20olympx&lang=TR&cur=TRY&jurisdiction=99', // Gates of Olympus
    'vs20starlight' => 'https://d3pvfi6m7bxu71.cloudfront.net/gs2c/openGame.do?extGame=1&gameSymbol=vs20starlight&lang=TR&cur=TRY&jurisdiction=99', // Starlight Princess
    'vs20sugarrush' => 'https://d3pvfi6m7bxu71.cloudfront.net/gs2c/openGame.do?extGame=1&gameSymbol=vs20sugarrush&lang=TR&cur=TRY&jurisdiction=99', // Sugar Rush
    'vs20bigbass' => 'https://d3pvfi6m7bxu71.cloudfront.net/gs2c/openGame.do?extGame=1&gameSymbol=vs20bigbass&lang=TR&cur=TRY&jurisdiction=99', // Big Bass Bonanza
    
    // Additional Pragmatic Play Games
    'vs20wildwest' => 'https://d3pvfi6m7bxu71.cloudfront.net/gs2c/openGame.do?extGame=1&gameSymbol=vs20wildwest&lang=TR&cur=TRY&jurisdiction=99', // Wild West Gold
    'vs20gates' => 'https://d3pvfi6m7bxu71.cloudfront.net/gs2c/openGame.do?extGame=1&gameSymbol=vs20gates&lang=TR&cur=TRY&jurisdiction=99', // Gates of Olympus
    'vs20aztec' => 'https://d3pvfi6m7bxu71.cloudfront.net/gs2c/openGame.do?extGame=1&gameSymbol=vs20aztec&lang=TR&cur=TRY&jurisdiction=99', // Aztec Gems
    'vs20wolf' => 'https://d3pvfi6m7bxu71.cloudfront.net/gs2c/openGame.do?extGame=1&gameSymbol=vs20wolf&lang=TR&cur=TRY&jurisdiction=99', // Wolf Gold
    'vs20mustang' => 'https://d3pvfi6m7bxu71.cloudfront.net/gs2c/openGame.do?extGame=1&gameSymbol=vs20mustang&lang=TR&cur=TRY&jurisdiction=99', // Mustang Gold
    
    // Add more game symbols as needed
    // 'gameSymbol' => 'https://d3pvfi6m7bxu71.pragmaticplay.net/gs2c/openGame.do?extGame=1&gameSymbol=gameSymbol&lang=TR&cur=TRY&jurisdiction=99',
];

/**
 * Check if a game symbol is a Pragmatic Play game
 * @param string $gameSymbol Game symbol
 * @return bool True if it's a Pragmatic Play game
 */
function isPragmaticPlayGame($gameSymbol) {
    // Pragmatic Play oyunları genellikle 'vs20', 'vs25', 'vs40' gibi prefix'lerle başlar
    return preg_match('/^(vs20|vs25|vs40|vs10|vs5|vs1|vs|vsw|vsp|vsr|vst|vsu|vsv|vsw|vsx|vsy|vsz)/i', $gameSymbol);
}

/**
 * Get direct iframe URL for a game symbol
 * @param string $gameSymbol Game symbol (e.g., 'vs20fruitsw')
 * @return string|null Direct iframe URL or null if not found
 */
function getDirectGameUrl($gameSymbol) {
    global $direct_game_urls;
    return isset($direct_game_urls[$gameSymbol]) ? $direct_game_urls[$gameSymbol] : null;
}

/**
 * Check if a game symbol has a direct URL
 * @param string $gameSymbol Game symbol
 * @return bool True if direct URL exists
 */
function hasDirectGameUrl($gameSymbol) {
    global $direct_game_urls;
    return isset($direct_game_urls[$gameSymbol]);
}

/**
 * Get all available direct game symbols
 * @return array Array of game symbols
 */
function getAvailableDirectGameSymbols() {
    global $direct_game_urls;
    return array_keys($direct_game_urls);
}
?>
