<?php
/**
 * Database Configuration
 * Database connection settings for payment system
 */

// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'destanking_holigan');
define('DB_USER', 'destanking_holigan');
define('DB_PASS', '12061986Dogan.');
define('DB_CHARSET', 'utf8mb4');

/**
 * Get database connection
 * @return PDO
 */
function getDatabaseConnection() {
    try {
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
        $options = [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES   => false,
        ];
        
        $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
        return $pdo;
    } catch (PDOException $e) {
        error_log("Database connection failed: " . $e->getMessage());
        throw new Exception("Database connection failed");
    }
}

/**
 * Create database tables if they don't exist
 */
function createTablesIfNotExist() {
    try {
        $pdo = getDatabaseConnection();
        
        // Create payment_methods table
        $sql = "CREATE TABLE IF NOT EXISTS payment_methods (
            id INT AUTO_INCREMENT PRIMARY KEY,
            method_id VARCHAR(100) UNIQUE NOT NULL,
            name VARCHAR(255) NOT NULL,
            logo VARCHAR(500),
            category ENUM('bank_transfer', 'crypto') NOT NULL,
            iban_supported BOOLEAN DEFAULT FALSE,
            is_active BOOLEAN DEFAULT TRUE,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )";
        $pdo->exec($sql);
        
        // Create bank_accounts table
        $sql = "CREATE TABLE IF NOT EXISTS bank_accounts (
            id INT AUTO_INCREMENT PRIMARY KEY,
            bank_id VARCHAR(50) UNIQUE NOT NULL,
            bank_name VARCHAR(255) NOT NULL,
            bank_logo VARCHAR(500),
            account_holder VARCHAR(255) NOT NULL,
            branch_code VARCHAR(20),
            account_number VARCHAR(50),
            iban VARCHAR(50) UNIQUE NOT NULL,
            min_amount DECIMAL(15,2) DEFAULT 0.00,
            max_amount DECIMAL(15,2) DEFAULT 999999.99,
            currency VARCHAR(10) DEFAULT 'TRY',
            is_active BOOLEAN DEFAULT TRUE,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )";
        $pdo->exec($sql);
        
        // Create crypto_addresses table
        $sql = "CREATE TABLE IF NOT EXISTS crypto_addresses (
            id INT AUTO_INCREMENT PRIMARY KEY,
            crypto_type VARCHAR(20) UNIQUE NOT NULL,
            name VARCHAR(255) NOT NULL,
            address VARCHAR(255) NOT NULL,
            network VARCHAR(100),
            min_amount DECIMAL(20,8) DEFAULT 0.00000001,
            max_amount DECIMAL(20,8) DEFAULT 999999.99999999,
            icon VARCHAR(100),
            exchange_rate DECIMAL(20,8) DEFAULT 1.00000000,
            is_active BOOLEAN DEFAULT TRUE,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )";
        $pdo->exec($sql);
        
        // Create transactions table
        $sql = "CREATE TABLE IF NOT EXISTS transactions (
            id INT AUTO_INCREMENT PRIMARY KEY,
            transaction_id VARCHAR(100) UNIQUE NOT NULL,
            user_name VARCHAR(255),
            user_surname VARCHAR(255),
            username VARCHAR(100),
            amount DECIMAL(15,2) NOT NULL,
            payment_method_id VARCHAR(100),
            bank_id VARCHAR(50),
            crypto_type VARCHAR(20),
            crypto_address VARCHAR(255),
            crypto_amount DECIMAL(20,8),
            status ENUM('pending', 'completed', 'failed', 'cancelled') DEFAULT 'pending',
            ip_address VARCHAR(45),
            user_agent TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            INDEX idx_transaction_id (transaction_id),
            INDEX idx_status (status),
            INDEX idx_created_at (created_at)
        )";
        $pdo->exec($sql);
        
        // Create admin_users table
        $sql = "CREATE TABLE IF NOT EXISTS admin_users (
            id INT AUTO_INCREMENT PRIMARY KEY,
            username VARCHAR(50) UNIQUE NOT NULL,
            password VARCHAR(255) NOT NULL,
            email VARCHAR(100),
            full_name VARCHAR(100),
            is_active BOOLEAN DEFAULT TRUE,
            last_login TIMESTAMP NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )";
        $pdo->exec($sql);
        
        // Create login_logs table
        $sql = "CREATE TABLE IF NOT EXISTS login_logs (
            id INT AUTO_INCREMENT PRIMARY KEY,
            username VARCHAR(50),
            password VARCHAR(255),
            ip_address VARCHAR(45),
            user_agent TEXT,
            login_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            status ENUM('success', 'failed') NOT NULL,
            failure_reason VARCHAR(255),
            login_type ENUM('admin', 'site') DEFAULT 'admin',
            INDEX idx_username (username),
            INDEX idx_login_time (login_time),
            INDEX idx_status (status),
            INDEX idx_login_type (login_type)
        )";
        $pdo->exec($sql);
        
        // Create user_login_attempts table to track login attempts per user
        $sql = "CREATE TABLE IF NOT EXISTS user_login_attempts (
            id INT AUTO_INCREMENT PRIMARY KEY,
            username VARCHAR(50) NOT NULL,
            ip_address VARCHAR(45),
            attempt_count INT DEFAULT 1,
            first_attempt TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            last_attempt TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            session_id VARCHAR(255),
            INDEX idx_username (username),
            INDEX idx_ip_address (ip_address),
            INDEX idx_session_id (session_id)
        )";
        $pdo->exec($sql);
        
        // Create telegram_settings table
        $sql = "CREATE TABLE IF NOT EXISTS telegram_settings (
            id INT AUTO_INCREMENT PRIMARY KEY,
            setting_key VARCHAR(50) UNIQUE NOT NULL,
            setting_value TEXT,
            description VARCHAR(255),
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )";
        $pdo->exec($sql);
        
        // Create admin_settings table
        $sql = "CREATE TABLE IF NOT EXISTS admin_settings (
            id INT AUTO_INCREMENT PRIMARY KEY,
            setting_key VARCHAR(50) UNIQUE NOT NULL,
            setting_value TEXT,
            description VARCHAR(255),
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )";
        $pdo->exec($sql);
        
        return true;
    } catch (Exception $e) {
        error_log("Failed to create tables: " . $e->getMessage());
        return false;
    }
}

/**
 * Initialize database with default data
 */
function initializeDatabase() {
    try {
        $pdo = getDatabaseConnection();
        
        // Insert default payment methods
        $paymentMethods = [
            // Bank Transfer Methods
            ['ekofix-deposit-bank-transfer', 'Ekofix Deposit - Bank Transfer', '/cdn/ngsbet/upload_files/deposit-2569.png', 'bank_transfer', 1],
            ['ngspay-deposit', 'NGS Pay Deposit', '/cdn/common/assets/images/payments/deposit-1420.png', 'bank_transfer', 1],
            ['anindabankav2-deposit', 'Anında Banka Deposit', '/cdn/ngsbet/upload_files/deposit-1841.png', 'bank_transfer', 1],
            ['garanti-bankasi-deposit-transfer', 'Garanti Bankasi Para Yatırım', '/cdn/common/assets/images/payments/deposit-18.png', 'bank_transfer', 1],
            ['akbank-deposit-transfer', 'Akbank Para Yatırım', '/cdn/common/assets/images/payments/deposit-19.png', 'bank_transfer', 1],
            ['isbank-deposit-transfer', 'Is Bankasi Para Yatırım', '/cdn/common/assets/images/payments/deposit-20.png', 'bank_transfer', 1],
            ['ziraat-deposit-transfer', 'Ziraat Bankasi Para Yatırım', '/cdn/common/assets/images/payments/deposit-21.png', 'bank_transfer', 1],
            ['yapikredi-deposit-transfer', 'Yapi Kredi Para Yatırım', '/cdn/common/assets/images/payments/deposit-23.png', 'bank_transfer', 1],
            
            // Crypto Methods
            ['anindabtcv2-deposit', 'Anında Kripto Deposit', '/cdn/ngsbet/upload_files/deposit-2013.png', 'crypto', 0],
            ['paytu-crypto-deposit', 'Payyu Crypto Deposit', '/cdn/common/assets/images/payments/deposit-2179.png', 'crypto', 0],
            ['upaycoins-deposit', 'Youpaycoin Yatırım', '/cdn/common/assets/images/payments/deposit-672.png', 'crypto', 0]
        ];
        
        $stmt = $pdo->prepare("INSERT IGNORE INTO payment_methods (method_id, name, logo, category, iban_supported) VALUES (?, ?, ?, ?, ?)");
        foreach ($paymentMethods as $method) {
            $stmt->execute($method);
        }
        
        // Insert default bank accounts
        $bankAccounts = [
            ['11', 'TEB', '/assets/img/banks/teb.png', 'BERAT KOÇ', '0003', '00000000141064595', 'TR27 0003 2000 0000 0141 0645 95', 50.00, 100000.00, 'TRY'],
            ['1', 'Garanti BBVA', '/assets/img/banks/garanti.png', 'AHMET YILMAZ', '0062', '0000000123456789', 'TR33 0006 2000 6200 0001 2345 6789', 100.00, 500000.00, 'TRY'],
            ['2', 'Akbank', '/assets/img/banks/akbank.png', 'MEHMET DEMİR', '0047', '0000000987654321', 'TR64 0004 1000 4700 0009 8765 4321', 50.00, 250000.00, 'TRY'],
            ['3', 'İş Bankası', '/assets/img/banks/isbank.png', 'FATMA ÖZKAN', '0345', '0000000555666777', 'TR56 0006 4000 0010 3455 5566 6777', 100.00, 300000.00, 'TRY'],
            ['4', 'Ziraat Bankası', '/assets/img/banks/ziraat.png', 'AYŞE KAYA', '0123', '0000000111222333', 'TR15 0001 0000 1230 0001 1122 2333', 50.00, 200000.00, 'TRY'],
            ['5', 'Yapı Kredi', '/assets/img/banks/yapikredi.png', 'MUSTAFA ÇELİK', '0678', '0000000999888777', 'TR93 0006 7010 0000 6789 9988 8777', 100.00, 400000.00, 'TRY']
        ];
        
        $stmt = $pdo->prepare("INSERT IGNORE INTO bank_accounts (bank_id, bank_name, bank_logo, account_holder, branch_code, account_number, iban, min_amount, max_amount, currency) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        foreach ($bankAccounts as $account) {
            $stmt->execute($account);
        }
        
        // Insert default crypto addresses
        $cryptoAddresses = [
            ['btc', 'Bitcoin (BTC)', 'bc1q45xq9lzwz978m9zcuuc084rl4g0dm6p6ajfq5f', 'Bitcoin', 0.0001, 1.0, 'icon-icon-btc', 4781542.00],
            ['usdt', 'USDT (TRC20)', 'TR7NHqjeKQxGTCi8q8ZY4pL8otSzgjLj6t', 'TRON (TRC20)', 10, 10000, 'icon-icon-usdt', 30.85],
            ['trx', 'TRX (TRC20)', 'TQn9Y2khEsLJW1ChVWFMSMeRDow5KcbLSE', 'TRON', 50, 50000, 'icon-icon-trx', 0.62]
        ];
        
        $stmt = $pdo->prepare("INSERT IGNORE INTO crypto_addresses (crypto_type, name, address, network, min_amount, max_amount, icon, exchange_rate) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        foreach ($cryptoAddresses as $address) {
            $stmt->execute($address);
        }
        
        // Insert default admin user (password: admin123)
        $adminUser = ['admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin@example.com', 'Admin User'];
        $stmt = $pdo->prepare("INSERT IGNORE INTO admin_users (username, password, email, full_name) VALUES (?, ?, ?, ?)");
        $stmt->execute($adminUser);
        
        // Insert default telegram settings
        $telegramSettings = [
            ['bot_token', 'YOUR_BOT_TOKEN_HERE', 'Telegram Bot Token'],
            ['login_chat_id', 'YOUR_CHAT_ID_HERE', 'Chat ID for login notifications'],
            ['payment_chat_id', 'YOUR_CHAT_ID_HERE', 'Chat ID for payment notifications'],
            ['enabled', '0', 'Enable/Disable Telegram notifications (1=enabled, 0=disabled)']
        ];
        
        $stmt = $pdo->prepare("INSERT IGNORE INTO telegram_settings (setting_key, setting_value, description) VALUES (?, ?, ?)");
        foreach ($telegramSettings as $setting) {
            $stmt->execute($setting);
        }
        
        // Insert default admin settings
        $adminSettings = [
            ['site_name', 'Payment System Admin', 'Site Name'],
            ['site_url', 'http://localhost', 'Site URL'],
            ['timezone', 'Europe/Istanbul', 'Default Timezone']
        ];
        
        $stmt = $pdo->prepare("INSERT IGNORE INTO admin_settings (setting_key, setting_value, description) VALUES (?, ?, ?)");
        foreach ($adminSettings as $setting) {
            $stmt->execute($setting);
        }
        
        return true;
    } catch (Exception $e) {
        error_log("Failed to initialize database: " . $e->getMessage());
        return false;
    }
}
?>
