import os
import json
import requests
from urllib.parse import urlparse

# 1. Logdaki URL'leri al
log_lines = """
casino:19655  GET http://localhost/static/js/common-047c7a05870c86eb5694.js 404 (Not Found)
casino:19659  GET http://localhost/static/js/lang-tr-fefc28a96b8949aaaa57.js 404 (Not Found)
casino:19663  GET http://localhost/static/js/bundle-70e2376b246de6982f6e.js 404 (Not Found)
casino:19667  GET http://localhost/static/js/svg-a6e458f4663658945728.js 404 (Not Found)
casino:15749  GET http://localhost/stateless-holiganbet-one/2025/07/5660e7e3-holigan-bonanza-1000.svg 401 (Unauthorized)
casino:15749  GET http://localhost/stateless-holiganbet-one/2025/07/4a8f218e-sweet-bonanza-1000.svg 401 (Unauthorized)
casino:15749  GET http://localhost/stateless-holiganbet-one/2025/07/707bf01d-starlight-princess-1000.svg 401 (Unauthorized)
casino:15749  GET http://localhost/stateless-holiganbet-one/2024/09/40509e94-gates1000.svg 401 (Unauthorized)
casino:15749  GET http://localhost/stateless-holiganbet-one/2025/07/6ca11274-holigan-princess-1000.svg 401 (Unauthorized)
casino:15749  GET http://localhost/stateless-holiganbet-one/2025/07/78a050fe-sugar-rush-1000.svg 401 (Unauthorized)
casino:15749  GET http://localhost/stateless-holiganbet-one/2025/07/b7689b7d-holigan-rush-1000.svg 401 (Unauthorized)
casino:15749  GET http://localhost/stateless-holiganbet-one/2025/07/345ae950-sweet-bonanza-1000-dice.svg 401 (Unauthorized)
casino:15749  GET http://localhost/stateless-holiganbet-one/2025/07/810f02b2-gates-of-olympus-xmas-1000.svg 401 (Unauthorized)
casino:15749  GET http://localhost/stateless-holiganbet-one/2025/07/250717af-big-bass-bonanza-1000.svg 401 (Unauthorized)
casino:15749  GET http://localhost/stateless-holiganbet-one/2025/07/b53c60af-gates-of-olympus-1000-dice.svg 401 (Unauthorized)
casino:15749  GET http://localhost/stateless-holiganbet-one/2023/01/1670f240-canli-destek-copy-01-01.svg 401 (Unauthorized)
casino:15749  GET http://localhost/stateless-holiganbet-one/2025/07/1202b72e-wisdom-of-athena-1000.svg 401 (Unauthorized)
casino:15749  GET http://localhost/stateless-holiganbet-one/2024/09/dda39ec3-casino.svg 401 (Unauthorized)
casino:15749  GET http://localhost/stateless-holiganbet-one/2024/09/8a852d4e-canli-oyunlar.svg 401 (Unauthorized)
casino:15749  GET http://localhost/stateless-holiganbet-one/2024/10/2bc3c4b9-turnuva3.svg 401 (Unauthorized)
casino:15749  GET http://localhost/stateless-holiganbet-one/2025/07/c877ac99-menu-02-1.svg 401 (Unauthorized)
casino:19868  GET http://localhost/stateless-jojobet/2019/06/063619b4-x.png 404 (Not Found)
casino:19883  GET http://localhost/stateless-jojobet/2019/06/61911974-telegram.png 404 (Not Found)
bundle-32dae487fc5a692a88cb.css:1  GET http://localhost/static/img/eye-open.svg 404 (Not Found)

""".strip().splitlines()

urls = []
for line in log_lines:
    parts = line.split()
    for part in parts:
        if part.startswith("http"):
            urls.append(part)

# 2. JSON olarak kaydet
with open("urls.json", "w") as f:
    json.dump(urls, f, indent=4)

# 3. localhost URL'lerini indir
BASE_REMOTE = "https://www.holiganbet1148.com"  # localhost URL'leri buradan indirilecek

for url in urls:
    if "localhost" in url:
        # localhost path'ini remote ile değiştir
        path = urlparse(url).path  # /content/static/...
        remote_url = BASE_REMOTE + path

        # Kaydedilecek klasör ve dosya
        save_path = path.lstrip("/")  # baştaki / kaldır
        os.makedirs(os.path.dirname(save_path), exist_ok=True)

        try:
            r = requests.get(remote_url, timeout=10)
            r.raise_for_status()
            with open(save_path, "wb") as f:
                f.write(r.content)
            print(f"İndirildi: {remote_url} -> {save_path}")
        except Exception as e:
            print(f"Hata: {remote_url} ({e})")
