<?php
// /api/kur/get-crypt

header('Content-Type: text/plain; charset=utf-8');

// Güvenlik kontrolü
$token = $_POST['txtToken'] ?? '';
if (empty($token)) {
    echo "Hata: Token bulunamadı";
    exit;
}

// Verileri al
$amount = $_POST['txtAmount'] ?? '0';
$cryptoType = $_POST['rdCuzdanTipi'] ?? 'trx';

// Türkçe format temizle (500,00 veya 500.000,00 → 500.00)
$amount = str_replace('.', '', $amount);  // Binlik ayraç kaldır
$amount = str_replace(',', '.', $amount); // Virgülü noktaya çevir
$amount = floatval($amount);

if ($amount <= 0) {
    echo "Hata: Geçersiz miktar";
    exit;
}

// Güncel kurları çek (API'den veya veritabanından)
$exchangeRates = getExchangeRates();

// Kripto miktarını hesapla
$cryptoAmount = 0;
$cryptoName = strtoupper($cryptoType);

switch ($cryptoType) {
    case 'btc':
        $cryptoAmount = $amount / $exchangeRates['btc'];
        echo $cryptoName . " Miktarı : " . number_format($cryptoAmount, 8, '.', '') . " " . $cryptoName;
        break;
        
    case 'usdt':
        $cryptoAmount = $amount / $exchangeRates['usdt'];
        echo $cryptoName . " Miktarı : " . number_format($cryptoAmount, 2, '.', '') . " " . $cryptoName;
        break;
        
    case 'trx':
        $cryptoAmount = $amount / $exchangeRates['trx'];
        echo $cryptoName . " Miktarı : " . number_format($cryptoAmount, 2, '.', '') . " " . $cryptoName;
        break;
        
    default:
        echo "Hata: Geçersiz kripto tipi";
}


function getExchangeRates() {
    // CoinGecko API örneği (Ücretsiz)
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => "https://api.coingecko.com/api/v3/simple/price?ids=bitcoin,tether,tron&vs_currencies=try",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 5,
    ]);
    
    $response = curl_exec($curl);
    curl_close($curl);
    
    if ($response) {
        $data = json_decode($response, true);
        return [
            'btc' => $data['bitcoin']['try'] ?? 4781542.00,
            'usdt' => $data['tether']['try'] ?? 30.85,
            'trx' => $data['tron']['try'] ?? 0.62
        ];
    }
    
    // API başarısız olursa fallback değerler
    return [
        'btc' => 4781542.00,
        'usdt' => 30.85,
        'trx' => 0.62
    ];
}

?>