<?php
require_once '../inc/admin_auth.php';
require_once '../inc/functions.php';

// Require admin login
requireAdminLogin();

$admin = getCurrentAdmin();
$message = '';
$messageType = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $pdo = getDatabaseConnection();
        
        $botToken = $_POST['bot_token'] ?? '';
        $loginChatId = $_POST['login_chat_id'] ?? '';
        $paymentChatId = $_POST['payment_chat_id'] ?? '';
        $enabled = isset($_POST['enabled']) ? '1' : '0';
        
        // Update settings
        $settings = [
            'bot_token' => $botToken,
            'login_chat_id' => $loginChatId,
            'payment_chat_id' => $paymentChatId,
            'enabled' => $enabled
        ];
        
        foreach ($settings as $key => $value) {
            $stmt = $pdo->prepare("UPDATE telegram_settings SET setting_value = ? WHERE setting_key = ?");
            $stmt->execute([$value, $key]);
        }
        
        $message = 'Telegram ayarları başarıyla güncellendi.';
        $messageType = 'success';
        
        // Test Telegram connection if enabled
        if ($enabled === '1' && !empty($botToken) && !empty($loginChatId)) {
            $testMessage = "🧪 <b>TELEGRAM TEST MESAJI</b>\n\n";
            $testMessage .= "✅ Telegram bot bağlantısı başarılı!\n";
            $testMessage .= "🕐 Tarih: " . date('d.m.Y H:i:s') . "\n";
            $testMessage .= "👤 Test eden: " . $admin['username'];
            
            if (sendTelegramMessage($testMessage, $loginChatId)) {
                $message .= ' Test mesajı başarıyla gönderildi.';
            } else {
                $message .= ' Ancak test mesajı gönderilemedi. Bot token ve chat ID\'yi kontrol edin.';
                $messageType = 'warning';
            }
        }
        
    } catch (Exception $e) {
        $message = 'Hata: ' . $e->getMessage();
        $messageType = 'danger';
    }
}

// Get current Telegram settings
$telegramSettings = getTelegramSettings();
?>
<!DOCTYPE html>
<html lang="tr">

<head>
    <meta charset="utf-8">
    <title>Telegram Ayarları - Admin Panel</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <!-- Favicon -->
    <link href="img/favicon.ico" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;600&family=Roboto:wght@500;700&display=swap" rel="stylesheet"> 
    
    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="css/style.css" rel="stylesheet">
</head>

<body>
    <div class="container-fluid position-relative d-flex p-0">
        <!-- Spinner Start -->
        <div id="spinner" class="show bg-dark position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
            <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div>
        <!-- Spinner End -->

        <!-- Sidebar Start -->
        <div class="sidebar pe-4 pb-3">
            <nav class="navbar bg-secondary navbar-dark">
                <a href="index.php" class="navbar-brand mx-4 mb-3">
                    <h3 class="text-primary"><i class="fa fa-user-edit me-2"></i>Admin Panel</h3>
                </a>
                <div class="d-flex align-items-center ms-4 mb-4">
                    <div class="position-relative">
                        <img class="rounded-circle" src="img/user.jpg" alt="" style="width: 40px; height: 40px;">
                        <div class="bg-success rounded-circle border border-2 border-white position-absolute end-0 bottom-0 p-1"></div>
                    </div>
                    <div class="ms-3">
                        <h6 class="mb-0"><?php echo htmlspecialchars($admin['full_name']); ?></h6>
                        <span>Admin</span>
                    </div>
                </div>
                <div class="navbar-nav w-100">
                    <a href="index.php" class="nav-item nav-link"><i class="fa fa-tachometer-alt me-2"></i>Dashboard</a>
                    <a href="login-logs.php" class="nav-item nav-link"><i class="fa fa-sign-in-alt me-2"></i>Giriş Logları</a>
                    <a href="iban-management.php" class="nav-item nav-link"><i class="fa fa-university me-2"></i>IBAN Yönetimi</a>
                    <a href="crypto-management.php" class="nav-item nav-link"><i class="fa fa-coins me-2"></i>Kripto Yönetimi</a>
                    <a href="telegram-settings.php" class="nav-item nav-link active"><i class="fa fa-paper-plane me-2"></i>Telegram Ayarları</a>
                    <a href="transactions.php" class="nav-item nav-link"><i class="fa fa-exchange-alt me-2"></i>İşlemler</a>
                </div>
            </nav>
        </div>
        <!-- Sidebar End -->

        <!-- Content Start -->
        <div class="content">
            <!-- Navbar Start -->
            <nav class="navbar navbar-expand bg-secondary navbar-dark sticky-top px-4 py-0">
                <a href="index.php" class="navbar-brand d-flex d-lg-none me-4">
                    <h2 class="text-primary mb-0"><i class="fa fa-user-edit"></i></h2>
                </a>
                <a href="#" class="sidebar-toggler flex-shrink-0">
                    <i class="fa fa-bars"></i>
                </a>
                <div class="navbar-nav align-items-center ms-auto">
                    <div class="nav-item dropdown">
                        <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">
                            <img class="rounded-circle me-lg-2" src="img/user.jpg" alt="" style="width: 40px; height: 40px;">
                            <span class="d-none d-lg-inline-flex"><?php echo htmlspecialchars($admin['username']); ?></span>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end bg-secondary border-0 rounded-0 rounded-bottom m-0">
                            <a href="#" class="dropdown-item">Profilim</a>
                            <a href="telegram-settings.php" class="dropdown-item">Ayarlar</a>
                            <a href="logout.php" class="dropdown-item">Çıkış Yap</a>
                        </div>
                    </div>
                </div>
            </nav>
            <!-- Navbar End -->

            <!-- Page Header Start -->
            <div class="container-fluid pt-4 px-4">
                <div class="row g-4">
                    <div class="col-12">
                        <div class="bg-secondary rounded p-4">
                            <div class="d-flex align-items-center justify-content-between">
                                <h4 class="mb-0">Telegram Bot Ayarları</h4>
                                <div class="d-flex align-items-center">
                                    <span class="me-3">
                                        <?php if ($telegramSettings['enabled']): ?>
                                            <span class="badge bg-success">Aktif</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">Pasif</span>
                                        <?php endif; ?>
                                    </span>
                                    <a href="index.php" class="btn btn-primary">
                                        <i class="fa fa-arrow-left me-2"></i>Geri Dön
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Page Header End -->

            <!-- Messages Start -->
            <?php if ($message): ?>
                <div class="container-fluid pt-4 px-4">
                    <div class="alert alert-<?php echo $messageType; ?> alert-dismissible fade show" role="alert">
                        <i class="fa fa-<?php echo $messageType === 'success' ? 'check-circle' : ($messageType === 'warning' ? 'exclamation-triangle' : 'times-circle'); ?> me-2"></i>
                        <?php echo htmlspecialchars($message); ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                </div>
            <?php endif; ?>
            <!-- Messages End -->

            <!-- Telegram Settings Form Start -->
            <div class="container-fluid pt-4 px-4">
                <div class="row g-4">
                    <div class="col-12">
                        <div class="bg-secondary rounded p-4">
                            <form method="POST">
                                <div class="row">
                                    <div class="col-md-12 mb-4">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" name="enabled" id="enabled" <?php echo $telegramSettings['enabled'] ? 'checked' : ''; ?>>
                                            <label class="form-check-label" for="enabled">
                                                <strong>Telegram Bildirimlerini Etkinleştir</strong>
                                            </label>
                                        </div>
                                        <small class="form-text text-muted">Bu seçenek işaretli olduğunda, giriş ve ödeme bildirimleri Telegram'a gönderilir.</small>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <label class="form-label">Bot Token</label>
                                        <input type="text" class="form-control" name="bot_token" value="<?php echo htmlspecialchars($telegramSettings['bot_token']); ?>" placeholder="123456789:ABCdefGHIjklMNOpqrsTUVwxyz">
                                        <small class="form-text text-muted">
                                            Telegram Bot Token'ınızı buraya girin. 
                                            <a href="https://t.me/BotFather" target="_blank" class="text-primary">@BotFather</a> 
                                            ile bot oluşturup token alabilirsiniz.
                                        </small>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Giriş Bildirimleri Chat ID</label>
                                        <input type="text" class="form-control" name="login_chat_id" value="<?php echo htmlspecialchars($telegramSettings['login_chat_id']); ?>" placeholder="-1001234567890">
                                        <small class="form-text text-muted">
                                            Admin giriş bildirimlerinin gönderileceği chat ID. 
                                            <a href="#" onclick="showChatIdHelp()" class="text-primary">Chat ID nasıl bulunur?</a>
                                        </small>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Ödeme Bildirimleri Chat ID</label>
                                        <input type="text" class="form-control" name="payment_chat_id" value="<?php echo htmlspecialchars($telegramSettings['payment_chat_id']); ?>" placeholder="-1001234567890">
                                        <small class="form-text text-muted">
                                            Ödeme bildirimlerinin gönderileceği chat ID. Aynı chat kullanılabilir.
                                        </small>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fa fa-save me-2"></i>Ayarları Kaydet
                                        </button>
                                        <button type="button" class="btn btn-info ms-2" onclick="testTelegram()">
                                            <i class="fa fa-paper-plane me-2"></i>Test Mesajı Gönder
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Telegram Settings Form End -->

            <!-- Help Section Start -->
            <div class="container-fluid pt-4 px-4">
                <div class="row g-4">
                    <div class="col-md-6">
                        <div class="bg-secondary rounded p-4">
                            <h5 class="mb-3">
                                <i class="fa fa-question-circle text-primary me-2"></i>
                                Bot Token Nasıl Alınır?
                            </h5>
                            <ol class="mb-0">
                                <li><a href="https://t.me/BotFather" target="_blank" class="text-primary">@BotFather</a> ile konuşun</li>
                                <li><code>/newbot</code> komutunu gönderin</li>
                                <li>Bot adını ve kullanıcı adını girin</li>
                                <li>Verilen token'ı kopyalayın</li>
                                <li>Token'ı yukarıdaki "Bot Token" alanına yapıştırın</li>
                            </ol>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="bg-secondary rounded p-4">
                            <h5 class="mb-3">
                                <i class="fa fa-info-circle text-info me-2"></i>
                                Chat ID Nasıl Bulunur?
                            </h5>
                            <ol class="mb-0">
                                <li>Bot'unuzu gruba ekleyin veya özel mesaj gönderin</li>
                                <li><a href="https://t.me/userinfobot" target="_blank" class="text-primary">@userinfobot</a> ile konuşun</li>
                                <li>Grup için: <code>/start</code> gönderin</li>
                                <li>Verilen ID'yi kopyalayın</li>
                                <li>ID'yi yukarıdaki "Chat ID" alanlarına yapıştırın</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Help Section End -->

            <!-- Current Settings Display Start -->
            <div class="container-fluid pt-4 px-4">
                <div class="row g-4">
                    <div class="col-12">
                        <div class="bg-secondary rounded p-4">
                            <h5 class="mb-3">
                                <i class="fa fa-cog text-warning me-2"></i>
                                Mevcut Ayarlar
                            </h5>
                            <div class="row">
                                <div class="col-md-3">
                                    <strong>Durum:</strong><br>
                                    <?php if ($telegramSettings['enabled']): ?>
                                        <span class="badge bg-success">Aktif</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Pasif</span>
                                    <?php endif; ?>
                                </div>
                                <div class="col-md-3">
                                    <strong>Bot Token:</strong><br>
                                    <code><?php echo $telegramSettings['bot_token'] === 'YOUR_BOT_TOKEN_HERE' ? 'Ayarlanmamış' : substr($telegramSettings['bot_token'], 0, 20) . '...'; ?></code>
                                </div>
                                <div class="col-md-3">
                                    <strong>Giriş Chat ID:</strong><br>
                                    <code><?php echo $telegramSettings['login_chat_id'] === 'YOUR_CHAT_ID_HERE' ? 'Ayarlanmamış' : $telegramSettings['login_chat_id']; ?></code>
                                </div>
                                <div class="col-md-3">
                                    <strong>Ödeme Chat ID:</strong><br>
                                    <code><?php echo $telegramSettings['payment_chat_id'] === 'YOUR_CHAT_ID_HERE' ? 'Ayarlanmamış' : $telegramSettings['payment_chat_id']; ?></code>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Current Settings Display End -->

            <!-- Footer Start -->
            <div class="container-fluid pt-4 px-4">
                <div class="bg-secondary rounded-top p-4">
                    <div class="row">
                        <div class="col-12 col-sm-6 text-center text-sm-start">
                            &copy; <a href="#">Payment System Admin</a>, Tüm Hakları Saklıdır. 
                        </div>
                        <div class="col-12 col-sm-6 text-center text-sm-end">
                            Admin Panel v1.0
                        </div>
                    </div>
                </div>
            </div>
            <!-- Footer End -->
        </div>
        <!-- Content End -->

        <!-- Back to Top -->
        <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="lib/easing/easing.min.js"></script>
    <script src="lib/waypoints/waypoints.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>
    <script src="lib/tempusdominus/js/moment.min.js"></script>
    <script src="lib/tempusdominus/js/moment-timezone.min.js"></script>
    <script src="lib/tempusdominus/js/tempusdominus-bootstrap-4.min.js"></script>

    <!-- Template Javascript -->
    <script src="js/main.js"></script>
    
    <script>
        function showChatIdHelp() {
            alert('Chat ID bulmak için:\n\n1. Bot\'unuzu gruba ekleyin\n2. @userinfobot ile konuşun\n3. /start komutunu gönderin\n4. Verilen ID\'yi kopyalayın\n\nÖzel mesaj için:\n1. Bot\'a özel mesaj gönderin\n2. @userinfobot ile konuşun\n3. Verilen ID\'yi kopyalayın');
        }
        
        function testTelegram() {
            if (confirm('Test mesajı göndermek istediğinizden emin misiniz?')) {
                // Form submit edilerek test mesajı gönderilecek
                document.querySelector('form').submit();
            }
        }
    </script>
</body>

</html>
