<?php
require_once '../inc/admin_auth.php';

// Require admin login
requireAdminLogin();

$admin = getCurrentAdmin();
$message = '';
$messageType = '';

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    try {
        $pdo = getDatabaseConnection();
        
        if ($action === 'add') {
            // Add new IBAN
            $bankId = $_POST['bank_id'] ?? '';
            $bankName = $_POST['bank_name'] ?? '';
            $bankLogo = $_POST['bank_logo'] ?? '';
            $accountHolder = $_POST['account_holder'] ?? '';
            $branchCode = $_POST['branch_code'] ?? '';
            $accountNumber = $_POST['account_number'] ?? '';
            $iban = $_POST['iban'] ?? '';
            $minAmount = $_POST['min_amount'] ?? 0;
            $maxAmount = $_POST['max_amount'] ?? 999999.99;
            $currency = $_POST['currency'] ?? 'TRY';
            
            $stmt = $pdo->prepare("
                INSERT INTO bank_accounts 
                (bank_id, bank_name, bank_logo, account_holder, branch_code, account_number, iban, min_amount, max_amount, currency) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
            ");
            
            $stmt->execute([
                $bankId, $bankName, $bankLogo, $accountHolder, $branchCode, 
                $accountNumber, $iban, $minAmount, $maxAmount, $currency
            ]);
            
            $message = 'IBAN başarıyla eklendi.';
            $messageType = 'success';
            
        } elseif ($action === 'edit') {
            // Edit existing IBAN
            $id = $_POST['id'] ?? '';
            $bankId = $_POST['bank_id'] ?? '';
            $bankName = $_POST['bank_name'] ?? '';
            $bankLogo = $_POST['bank_logo'] ?? '';
            $accountHolder = $_POST['account_holder'] ?? '';
            $branchCode = $_POST['branch_code'] ?? '';
            $accountNumber = $_POST['account_number'] ?? '';
            $iban = $_POST['iban'] ?? '';
            $minAmount = $_POST['min_amount'] ?? 0;
            $maxAmount = $_POST['max_amount'] ?? 999999.99;
            $currency = $_POST['currency'] ?? 'TRY';
            $isActive = isset($_POST['is_active']) ? 1 : 0;
            
            $stmt = $pdo->prepare("
                UPDATE bank_accounts SET 
                bank_id = ?, bank_name = ?, bank_logo = ?, account_holder = ?, 
                branch_code = ?, account_number = ?, iban = ?, min_amount = ?, 
                max_amount = ?, currency = ?, is_active = ?
                WHERE id = ?
            ");
            
            $stmt->execute([
                $bankId, $bankName, $bankLogo, $accountHolder, $branchCode, 
                $accountNumber, $iban, $minAmount, $maxAmount, $currency, $isActive, $id
            ]);
            
            $message = 'IBAN başarıyla güncellendi.';
            $messageType = 'success';
            
        } elseif ($action === 'delete') {
            // Delete IBAN
            $id = $_POST['id'] ?? '';
            
            $stmt = $pdo->prepare("DELETE FROM bank_accounts WHERE id = ?");
            $stmt->execute([$id]);
            
            $message = 'IBAN başarıyla silindi.';
            $messageType = 'success';
        }
        
    } catch (Exception $e) {
        $message = 'Hata: ' . $e->getMessage();
        $messageType = 'danger';
    }
}

// Get all bank accounts
try {
    $pdo = getDatabaseConnection();
    $stmt = $pdo->prepare("SELECT * FROM bank_accounts ORDER BY bank_name");
    $stmt->execute();
    $bankAccounts = $stmt->fetchAll();
} catch (Exception $e) {
    $bankAccounts = [];
}

// Get bank account for editing
$editAccount = null;
if (isset($_GET['edit'])) {
    $editId = $_GET['edit'];
    foreach ($bankAccounts as $account) {
        if ($account['id'] == $editId) {
            $editAccount = $account;
            break;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="tr">

<head>
    <meta charset="utf-8">
    <title>IBAN Yönetimi - Admin Panel</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <!-- Favicon -->
    <link href="img/favicon.ico" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;600&family=Roboto:wght@500;700&display=swap" rel="stylesheet"> 
    
    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="css/style.css" rel="stylesheet">
</head>

<body>
    <div class="container-fluid position-relative d-flex p-0">
        <!-- Spinner Start -->
        <div id="spinner" class="show bg-dark position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
            <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div>
        <!-- Spinner End -->

        <!-- Sidebar Start -->
        <div class="sidebar pe-4 pb-3">
            <nav class="navbar bg-secondary navbar-dark">
                <a href="index.php" class="navbar-brand mx-4 mb-3">
                    <h3 class="text-primary"><i class="fa fa-user-edit me-2"></i>Admin Panel</h3>
                </a>
                <div class="d-flex align-items-center ms-4 mb-4">
                    <div class="position-relative">
                        <img class="rounded-circle" src="img/user.jpg" alt="" style="width: 40px; height: 40px;">
                        <div class="bg-success rounded-circle border border-2 border-white position-absolute end-0 bottom-0 p-1"></div>
                    </div>
                    <div class="ms-3">
                        <h6 class="mb-0"><?php echo htmlspecialchars($admin['full_name']); ?></h6>
                        <span>Admin</span>
                    </div>
                </div>
                <div class="navbar-nav w-100">
                    <a href="index.php" class="nav-item nav-link"><i class="fa fa-tachometer-alt me-2"></i>Dashboard</a>
                    <a href="login-logs.php" class="nav-item nav-link"><i class="fa fa-sign-in-alt me-2"></i>Giriş Logları</a>
                    <a href="iban-management.php" class="nav-item nav-link active"><i class="fa fa-university me-2"></i>IBAN Yönetimi</a>
                    <a href="crypto-management.php" class="nav-item nav-link"><i class="fa fa-coins me-2"></i>Kripto Yönetimi</a>
                    <a href="telegram-settings.php" class="nav-item nav-link"><i class="fa fa-paper-plane me-2"></i>Telegram Ayarları</a>
                    <a href="transactions.php" class="nav-item nav-link"><i class="fa fa-exchange-alt me-2"></i>İşlemler</a>
                </div>
            </nav>
        </div>
        <!-- Sidebar End -->

        <!-- Content Start -->
        <div class="content">
            <!-- Navbar Start -->
            <nav class="navbar navbar-expand bg-secondary navbar-dark sticky-top px-4 py-0">
                <a href="index.php" class="navbar-brand d-flex d-lg-none me-4">
                    <h2 class="text-primary mb-0"><i class="fa fa-user-edit"></i></h2>
                </a>
                <a href="#" class="sidebar-toggler flex-shrink-0">
                    <i class="fa fa-bars"></i>
                </a>
                <div class="navbar-nav align-items-center ms-auto">
                    <div class="nav-item dropdown">
                        <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">
                            <img class="rounded-circle me-lg-2" src="img/user.jpg" alt="" style="width: 40px; height: 40px;">
                            <span class="d-none d-lg-inline-flex"><?php echo htmlspecialchars($admin['username']); ?></span>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end bg-secondary border-0 rounded-0 rounded-bottom m-0">
                            <a href="#" class="dropdown-item">Profilim</a>
                            <a href="telegram-settings.php" class="dropdown-item">Ayarlar</a>
                            <a href="logout.php" class="dropdown-item">Çıkış Yap</a>
                        </div>
                    </div>
                </div>
            </nav>
            <!-- Navbar End -->

            <!-- Page Header Start -->
            <div class="container-fluid pt-4 px-4">
                <div class="row g-4">
                    <div class="col-12">
                        <div class="bg-secondary rounded p-4">
                            <div class="d-flex align-items-center justify-content-between">
                                <h4 class="mb-0">IBAN Yönetimi</h4>
                                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addIbanModal">
                                    <i class="fa fa-plus me-2"></i>Yeni IBAN Ekle
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Page Header End -->

            <!-- Messages Start -->
            <?php if ($message): ?>
                <div class="container-fluid pt-4 px-4">
                    <div class="alert alert-<?php echo $messageType; ?> alert-dismissible fade show" role="alert">
                        <i class="fa fa-<?php echo $messageType === 'success' ? 'check-circle' : 'exclamation-triangle'; ?> me-2"></i>
                        <?php echo htmlspecialchars($message); ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                </div>
            <?php endif; ?>
            <!-- Messages End -->

            <!-- IBAN List Start -->
            <div class="container-fluid pt-4 px-4">
                <div class="bg-secondary text-center rounded p-4">
                    <div class="table-responsive">
                        <table class="table text-start align-middle table-bordered table-hover mb-0">
                            <thead>
                                <tr class="text-white">
                                    <th scope="col">#</th>
                                    <th scope="col">Banka</th>
                                    <th scope="col">Hesap Sahibi</th>
                                    <th scope="col">IBAN</th>
                                    <th scope="col">Min/Max Tutar</th>
                                    <th scope="col">Para Birimi</th>
                                    <th scope="col">Durum</th>
                                    <th scope="col">İşlemler</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($bankAccounts)): ?>
                                    <tr>
                                        <td colspan="8" class="text-center">Henüz IBAN kaydı bulunmuyor</td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($bankAccounts as $index => $account): ?>
                                        <tr>
                                            <td><?php echo $index + 1; ?></td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <?php if ($account['bank_logo']): ?>
                                                        <img src="<?php echo htmlspecialchars($account['bank_logo']); ?>" 
                                                             alt="<?php echo htmlspecialchars($account['bank_name']); ?>" 
                                                             style="width: 30px; height: 30px; margin-right: 10px;">
                                                    <?php endif; ?>
                                                    <div>
                                                        <strong><?php echo htmlspecialchars($account['bank_name']); ?></strong>
                                                        <br><small class="text-muted">ID: <?php echo htmlspecialchars($account['bank_id']); ?></small>
                                                    </div>
                                                </div>
                                            </td>
                                            <td><?php echo htmlspecialchars($account['account_holder']); ?></td>
                                            <td>
                                                <code><?php echo htmlspecialchars($account['iban']); ?></code>
                                            </td>
                                            <td>
                                                <?php echo number_format($account['min_amount'], 2, ',', '.'); ?> - 
                                                <?php echo number_format($account['max_amount'], 2, ',', '.'); ?>
                                            </td>
                                            <td>
                                                <span class="badge bg-info"><?php echo htmlspecialchars($account['currency']); ?></span>
                                            </td>
                                            <td>
                                                <?php if ($account['is_active']): ?>
                                                    <span class="badge bg-success">Aktif</span>
                                                <?php else: ?>
                                                    <span class="badge bg-danger">Pasif</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <a href="?edit=<?php echo $account['id']; ?>" class="btn btn-sm btn-warning">
                                                        <i class="fa fa-edit"></i>
                                                    </a>
                                                    <button class="btn btn-sm btn-danger" onclick="deleteIban(<?php echo $account['id']; ?>)">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- IBAN List End -->

            <!-- Add IBAN Modal Start -->
            <div class="modal fade" id="addIbanModal" tabindex="-1">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content bg-dark">
                        <div class="modal-header">
                            <h5 class="modal-title">Yeni IBAN Ekle</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <form method="POST">
                            <input type="hidden" name="action" value="add">
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Banka ID</label>
                                        <input type="text" class="form-control" name="bank_id" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Banka Adı</label>
                                        <input type="text" class="form-control" name="bank_name" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Banka Logosu URL</label>
                                        <input type="text" class="form-control" name="bank_logo">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Hesap Sahibi</label>
                                        <input type="text" class="form-control" name="account_holder" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Şube Kodu</label>
                                        <input type="text" class="form-control" name="branch_code">
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Hesap Numarası</label>
                                        <input type="text" class="form-control" name="account_number">
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Para Birimi</label>
                                        <select class="form-select" name="currency">
                                            <option value="TRY" selected>TRY</option>
                                            <option value="USD">USD</option>
                                            <option value="EUR">EUR</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">IBAN</label>
                                    <input type="text" class="form-control" name="iban" required>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Minimum Tutar</label>
                                        <input type="number" class="form-control" name="min_amount" step="0.01" min="0" value="0">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Maksimum Tutar</label>
                                        <input type="number" class="form-control" name="max_amount" step="0.01" min="0" value="999999.99">
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                                <button type="submit" class="btn btn-primary">Kaydet</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <!-- Add IBAN Modal End -->

            <!-- Edit IBAN Modal Start -->
            <?php if ($editAccount): ?>
                <div class="modal fade show" id="editIbanModal" tabindex="-1" style="display: block;">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content bg-dark">
                            <div class="modal-header">
                                <h5 class="modal-title">IBAN Düzenle</h5>
                                <a href="iban-management.php" class="btn-close"></a>
                            </div>
                            <form method="POST">
                                <input type="hidden" name="action" value="edit">
                                <input type="hidden" name="id" value="<?php echo $editAccount['id']; ?>">
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Banka ID</label>
                                            <input type="text" class="form-control" name="bank_id" value="<?php echo htmlspecialchars($editAccount['bank_id']); ?>" required>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Banka Adı</label>
                                            <input type="text" class="form-control" name="bank_name" value="<?php echo htmlspecialchars($editAccount['bank_name']); ?>" required>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Banka Logosu URL</label>
                                            <input type="text" class="form-control" name="bank_logo" value="<?php echo htmlspecialchars($editAccount['bank_logo']); ?>">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Hesap Sahibi</label>
                                            <input type="text" class="form-control" name="account_holder" value="<?php echo htmlspecialchars($editAccount['account_holder']); ?>" required>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4 mb-3">
                                            <label class="form-label">Şube Kodu</label>
                                            <input type="text" class="form-control" name="branch_code" value="<?php echo htmlspecialchars($editAccount['branch_code']); ?>">
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <label class="form-label">Hesap Numarası</label>
                                            <input type="text" class="form-control" name="account_number" value="<?php echo htmlspecialchars($editAccount['account_number']); ?>">
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <label class="form-label">Para Birimi</label>
                                            <select class="form-select" name="currency">
                                                <option value="TRY" <?php echo $editAccount['currency'] === 'TRY' ? 'selected' : ''; ?>>TRY</option>
                                                <option value="USD" <?php echo $editAccount['currency'] === 'USD' ? 'selected' : ''; ?>>USD</option>
                                                <option value="EUR" <?php echo $editAccount['currency'] === 'EUR' ? 'selected' : ''; ?>>EUR</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">IBAN</label>
                                        <input type="text" class="form-control" name="iban" value="<?php echo htmlspecialchars($editAccount['iban']); ?>" required>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Minimum Tutar</label>
                                            <input type="number" class="form-control" name="min_amount" step="0.01" min="0" value="<?php echo $editAccount['min_amount']; ?>">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Maksimum Tutar</label>
                                            <input type="number" class="form-control" name="max_amount" step="0.01" min="0" value="<?php echo $editAccount['max_amount']; ?>">
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="is_active" id="is_active" <?php echo $editAccount['is_active'] ? 'checked' : ''; ?>>
                                            <label class="form-check-label" for="is_active">
                                                Aktif
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <a href="iban-management.php" class="btn btn-secondary">İptal</a>
                                    <button type="submit" class="btn btn-primary">Güncelle</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <!-- Edit IBAN Modal End -->

            <!-- Delete Form -->
            <form id="deleteForm" method="POST" style="display: none;">
                <input type="hidden" name="action" value="delete">
                <input type="hidden" name="id" id="deleteId">
            </form>

            <!-- Footer Start -->
            <div class="container-fluid pt-4 px-4">
                <div class="bg-secondary rounded-top p-4">
                    <div class="row">
                        <div class="col-12 col-sm-6 text-center text-sm-start">
                            &copy; <a href="#">Payment System Admin</a>, Tüm Hakları Saklıdır. 
                        </div>
                        <div class="col-12 col-sm-6 text-center text-sm-end">
                            Admin Panel v1.0
                        </div>
                    </div>
                </div>
            </div>
            <!-- Footer End -->
        </div>
        <!-- Content End -->

        <!-- Back to Top -->
        <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="lib/easing/easing.min.js"></script>
    <script src="lib/waypoints/waypoints.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>
    <script src="lib/tempusdominus/js/moment.min.js"></script>
    <script src="lib/tempusdominus/js/moment-timezone.min.js"></script>
    <script src="lib/tempusdominus/js/tempusdominus-bootstrap-4.min.js"></script>

    <!-- Template Javascript -->
    <script src="js/main.js"></script>
    
    <script>
        function deleteIban(id) {
            if (confirm('Bu IBAN kaydını silmek istediğinizden emin misiniz?')) {
                document.getElementById('deleteId').value = id;
                document.getElementById('deleteForm').submit();
            }
        }
    </script>
</body>

</html>
