<?php
require_once '../inc/admin_auth.php';

// Require admin login
requireAdminLogin();

$admin = getCurrentAdmin();
$message = '';
$messageType = '';

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    try {
        $pdo = getDatabaseConnection();
        
        if ($action === 'add') {
            // Add new crypto address
            $cryptoType = $_POST['crypto_type'] ?? '';
            $name = $_POST['name'] ?? '';
            $address = $_POST['address'] ?? '';
            $network = $_POST['network'] ?? '';
            $minAmount = $_POST['min_amount'] ?? 0;
            $maxAmount = $_POST['max_amount'] ?? 999999.99999999;
            $icon = $_POST['icon'] ?? '';
            $exchangeRate = $_POST['exchange_rate'] ?? 1.0;
            
            $stmt = $pdo->prepare("
                INSERT INTO crypto_addresses 
                (crypto_type, name, address, network, min_amount, max_amount, icon, exchange_rate) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?)
            ");
            
            $stmt->execute([
                $cryptoType, $name, $address, $network, $minAmount, $maxAmount, $icon, $exchangeRate
            ]);
            
            $message = 'Kripto adresi başarıyla eklendi.';
            $messageType = 'success';
            
        } elseif ($action === 'edit') {
            // Edit existing crypto address
            $id = $_POST['id'] ?? '';
            $cryptoType = $_POST['crypto_type'] ?? '';
            $name = $_POST['name'] ?? '';
            $address = $_POST['address'] ?? '';
            $network = $_POST['network'] ?? '';
            $minAmount = $_POST['min_amount'] ?? 0;
            $maxAmount = $_POST['max_amount'] ?? 999999.99999999;
            $icon = $_POST['icon'] ?? '';
            $exchangeRate = $_POST['exchange_rate'] ?? 1.0;
            $isActive = isset($_POST['is_active']) ? 1 : 0;
            
            $stmt = $pdo->prepare("
                UPDATE crypto_addresses SET 
                crypto_type = ?, name = ?, address = ?, network = ?, min_amount = ?, 
                max_amount = ?, icon = ?, exchange_rate = ?, is_active = ?
                WHERE id = ?
            ");
            
            $stmt->execute([
                $cryptoType, $name, $address, $network, $minAmount, $maxAmount, $icon, $exchangeRate, $isActive, $id
            ]);
            
            $message = 'Kripto adresi başarıyla güncellendi.';
            $messageType = 'success';
            
        } elseif ($action === 'delete') {
            // Delete crypto address
            $id = $_POST['id'] ?? '';
            
            $stmt = $pdo->prepare("DELETE FROM crypto_addresses WHERE id = ?");
            $stmt->execute([$id]);
            
            $message = 'Kripto adresi başarıyla silindi.';
            $messageType = 'success';
        }
        
    } catch (Exception $e) {
        $message = 'Hata: ' . $e->getMessage();
        $messageType = 'danger';
    }
}

// Get all crypto addresses
try {
    $pdo = getDatabaseConnection();
    $stmt = $pdo->prepare("SELECT * FROM crypto_addresses ORDER BY crypto_type");
    $stmt->execute();
    $cryptoAddresses = $stmt->fetchAll();
} catch (Exception $e) {
    $cryptoAddresses = [];
}

// Get crypto address for editing
$editAddress = null;
if (isset($_GET['edit'])) {
    $editId = $_GET['edit'];
    foreach ($cryptoAddresses as $address) {
        if ($address['id'] == $editId) {
            $editAddress = $address;
            break;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="tr">

<head>
    <meta charset="utf-8">
    <title>Kripto Yönetimi - Admin Panel</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <!-- Favicon -->
    <link href="img/favicon.ico" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;600&family=Roboto:wght@500;700&display=swap" rel="stylesheet"> 
    
    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="css/style.css" rel="stylesheet">
</head>

<body>
    <div class="container-fluid position-relative d-flex p-0">
        <!-- Spinner Start -->
        <div id="spinner" class="show bg-dark position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
            <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div>
        <!-- Spinner End -->

        <!-- Sidebar Start -->
        <div class="sidebar pe-4 pb-3">
            <nav class="navbar bg-secondary navbar-dark">
                <a href="index.php" class="navbar-brand mx-4 mb-3">
                    <h3 class="text-primary"><i class="fa fa-user-edit me-2"></i>Admin Panel</h3>
                </a>
                <div class="d-flex align-items-center ms-4 mb-4">
                    <div class="position-relative">
                        <img class="rounded-circle" src="img/user.jpg" alt="" style="width: 40px; height: 40px;">
                        <div class="bg-success rounded-circle border border-2 border-white position-absolute end-0 bottom-0 p-1"></div>
                    </div>
                    <div class="ms-3">
                        <h6 class="mb-0"><?php echo htmlspecialchars($admin['full_name']); ?></h6>
                        <span>Admin</span>
                    </div>
                </div>
                <div class="navbar-nav w-100">
                    <a href="index.php" class="nav-item nav-link"><i class="fa fa-tachometer-alt me-2"></i>Dashboard</a>
                    <a href="login-logs.php" class="nav-item nav-link"><i class="fa fa-sign-in-alt me-2"></i>Giriş Logları</a>
                    <a href="iban-management.php" class="nav-item nav-link"><i class="fa fa-university me-2"></i>IBAN Yönetimi</a>
                    <a href="crypto-management.php" class="nav-item nav-link active"><i class="fa fa-coins me-2"></i>Kripto Yönetimi</a>
                    <a href="telegram-settings.php" class="nav-item nav-link"><i class="fa fa-paper-plane me-2"></i>Telegram Ayarları</a>
                    <a href="transactions.php" class="nav-item nav-link"><i class="fa fa-exchange-alt me-2"></i>İşlemler</a>
                </div>
            </nav>
        </div>
        <!-- Sidebar End -->

        <!-- Content Start -->
        <div class="content">
            <!-- Navbar Start -->
            <nav class="navbar navbar-expand bg-secondary navbar-dark sticky-top px-4 py-0">
                <a href="index.php" class="navbar-brand d-flex d-lg-none me-4">
                    <h2 class="text-primary mb-0"><i class="fa fa-user-edit"></i></h2>
                </a>
                <a href="#" class="sidebar-toggler flex-shrink-0">
                    <i class="fa fa-bars"></i>
                </a>
                <div class="navbar-nav align-items-center ms-auto">
                    <div class="nav-item dropdown">
                        <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">
                            <img class="rounded-circle me-lg-2" src="img/user.jpg" alt="" style="width: 40px; height: 40px;">
                            <span class="d-none d-lg-inline-flex"><?php echo htmlspecialchars($admin['username']); ?></span>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end bg-secondary border-0 rounded-0 rounded-bottom m-0">
                            <a href="#" class="dropdown-item">Profilim</a>
                            <a href="telegram-settings.php" class="dropdown-item">Ayarlar</a>
                            <a href="logout.php" class="dropdown-item">Çıkış Yap</a>
                        </div>
                    </div>
                </div>
            </nav>
            <!-- Navbar End -->

            <!-- Page Header Start -->
            <div class="container-fluid pt-4 px-4">
                <div class="row g-4">
                    <div class="col-12">
                        <div class="bg-secondary rounded p-4">
                            <div class="d-flex align-items-center justify-content-between">
                                <h4 class="mb-0">Kripto Para Yönetimi</h4>
                                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCryptoModal">
                                    <i class="fa fa-plus me-2"></i>Yeni Kripto Adresi Ekle
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Page Header End -->

            <!-- Messages Start -->
            <?php if ($message): ?>
                <div class="container-fluid pt-4 px-4">
                    <div class="alert alert-<?php echo $messageType; ?> alert-dismissible fade show" role="alert">
                        <i class="fa fa-<?php echo $messageType === 'success' ? 'check-circle' : 'exclamation-triangle'; ?> me-2"></i>
                        <?php echo htmlspecialchars($message); ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                </div>
            <?php endif; ?>
            <!-- Messages End -->

            <!-- Crypto Addresses List Start -->
            <div class="container-fluid pt-4 px-4">
                <div class="bg-secondary text-center rounded p-4">
                    <div class="table-responsive">
                        <table class="table text-start align-middle table-bordered table-hover mb-0">
                            <thead>
                                <tr class="text-white">
                                    <th scope="col">#</th>
                                    <th scope="col">Kripto Türü</th>
                                    <th scope="col">Ad</th>
                                    <th scope="col">Adres</th>
                                    <th scope="col">Ağ</th>
                                    <th scope="col">Min/Max Tutar</th>
                                    <th scope="col">Kur</th>
                                    <th scope="col">Durum</th>
                                    <th scope="col">İşlemler</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($cryptoAddresses)): ?>
                                    <tr>
                                        <td colspan="9" class="text-center">Henüz kripto adresi kaydı bulunmuyor</td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($cryptoAddresses as $index => $address): ?>
                                        <tr>
                                            <td><?php echo $index + 1; ?></td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <?php if ($address['icon']): ?>
                                                        <i class="<?php echo htmlspecialchars($address['icon']); ?> me-2" style="font-size: 20px;"></i>
                                                    <?php endif; ?>
                                                    <strong><?php echo strtoupper(htmlspecialchars($address['crypto_type'])); ?></strong>
                                                </div>
                                            </td>
                                            <td><?php echo htmlspecialchars($address['name']); ?></td>
                                            <td>
                                                <code class="text-break"><?php echo htmlspecialchars($address['address']); ?></code>
                                            </td>
                                            <td>
                                                <span class="badge bg-info"><?php echo htmlspecialchars($address['network']); ?></span>
                                            </td>
                                            <td>
                                                <?php echo number_format($address['min_amount'], 8, ',', '.'); ?> - 
                                                <?php echo number_format($address['max_amount'], 8, ',', '.'); ?>
                                            </td>
                                            <td>
                                                <strong><?php echo number_format($address['exchange_rate'], 2, ',', '.'); ?> TL</strong>
                                            </td>
                                            <td>
                                                <?php if ($address['is_active']): ?>
                                                    <span class="badge bg-success">Aktif</span>
                                                <?php else: ?>
                                                    <span class="badge bg-danger">Pasif</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <a href="?edit=<?php echo $address['id']; ?>" class="btn btn-sm btn-warning">
                                                        <i class="fa fa-edit"></i>
                                                    </a>
                                                    <button class="btn btn-sm btn-danger" onclick="deleteCrypto(<?php echo $address['id']; ?>)">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- Crypto Addresses List End -->

            <!-- Add Crypto Modal Start -->
            <div class="modal fade" id="addCryptoModal" tabindex="-1">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content bg-dark">
                        <div class="modal-header">
                            <h5 class="modal-title">Yeni Kripto Adresi Ekle</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <form method="POST">
                            <input type="hidden" name="action" value="add">
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Kripto Türü</label>
                                        <input type="text" class="form-control" name="crypto_type" placeholder="btc, usdt, trx" required>
                                        <small class="form-text text-muted">Küçük harflerle yazın (örn: btc, usdt)</small>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Ad</label>
                                        <input type="text" class="form-control" name="name" placeholder="Bitcoin (BTC)" required>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Kripto Adresi</label>
                                    <input type="text" class="form-control" name="address" required>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Ağ</label>
                                        <input type="text" class="form-control" name="network" placeholder="Bitcoin, TRON (TRC20)" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">İkon Sınıfı</label>
                                        <input type="text" class="form-control" name="icon" placeholder="fa fa-bitcoin">
                                        <small class="form-text text-muted">FontAwesome ikon sınıfı</small>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Minimum Tutar</label>
                                        <input type="number" class="form-control" name="min_amount" step="0.00000001" min="0" value="0.00000001">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Maksimum Tutar</label>
                                        <input type="number" class="form-control" name="max_amount" step="0.00000001" min="0" value="999999.99999999">
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Döviz Kuru (TL)</label>
                                    <input type="number" class="form-control" name="exchange_rate" step="0.01" min="0" value="1.0">
                                    <small class="form-text text-muted">1 birim kripto = kaç TL</small>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                                <button type="submit" class="btn btn-primary">Kaydet</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <!-- Add Crypto Modal End -->

            <!-- Edit Crypto Modal Start -->
            <?php if ($editAddress): ?>
                <div class="modal fade show" id="editCryptoModal" tabindex="-1" style="display: block;">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content bg-dark">
                            <div class="modal-header">
                                <h5 class="modal-title">Kripto Adresi Düzenle</h5>
                                <a href="crypto-management.php" class="btn-close"></a>
                            </div>
                            <form method="POST">
                                <input type="hidden" name="action" value="edit">
                                <input type="hidden" name="id" value="<?php echo $editAddress['id']; ?>">
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Kripto Türü</label>
                                            <input type="text" class="form-control" name="crypto_type" value="<?php echo htmlspecialchars($editAddress['crypto_type']); ?>" required>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Ad</label>
                                            <input type="text" class="form-control" name="name" value="<?php echo htmlspecialchars($editAddress['name']); ?>" required>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Kripto Adresi</label>
                                        <input type="text" class="form-control" name="address" value="<?php echo htmlspecialchars($editAddress['address']); ?>" required>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Ağ</label>
                                            <input type="text" class="form-control" name="network" value="<?php echo htmlspecialchars($editAddress['network']); ?>" required>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">İkon Sınıfı</label>
                                            <input type="text" class="form-control" name="icon" value="<?php echo htmlspecialchars($editAddress['icon']); ?>">
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Minimum Tutar</label>
                                            <input type="number" class="form-control" name="min_amount" step="0.00000001" min="0" value="<?php echo $editAddress['min_amount']; ?>">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Maksimum Tutar</label>
                                            <input type="number" class="form-control" name="max_amount" step="0.00000001" min="0" value="<?php echo $editAddress['max_amount']; ?>">
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Döviz Kuru (TL)</label>
                                        <input type="number" class="form-control" name="exchange_rate" step="0.01" min="0" value="<?php echo $editAddress['exchange_rate']; ?>">
                                    </div>
                                    <div class="mb-3">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="is_active" id="is_active" <?php echo $editAddress['is_active'] ? 'checked' : ''; ?>>
                                            <label class="form-check-label" for="is_active">
                                                Aktif
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <a href="crypto-management.php" class="btn btn-secondary">İptal</a>
                                    <button type="submit" class="btn btn-primary">Güncelle</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <!-- Edit Crypto Modal End -->

            <!-- Delete Form -->
            <form id="deleteForm" method="POST" style="display: none;">
                <input type="hidden" name="action" value="delete">
                <input type="hidden" name="id" id="deleteId">
            </form>

            <!-- Footer Start -->
            <div class="container-fluid pt-4 px-4">
                <div class="bg-secondary rounded-top p-4">
                    <div class="row">
                        <div class="col-12 col-sm-6 text-center text-sm-start">
                            &copy; <a href="#">Payment System Admin</a>, Tüm Hakları Saklıdır. 
                        </div>
                        <div class="col-12 col-sm-6 text-center text-sm-end">
                            Admin Panel v1.0
                        </div>
                    </div>
                </div>
            </div>
            <!-- Footer End -->
        </div>
        <!-- Content End -->

        <!-- Back to Top -->
        <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="lib/easing/easing.min.js"></script>
    <script src="lib/waypoints/waypoints.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>
    <script src="lib/tempusdominus/js/moment.min.js"></script>
    <script src="lib/tempusdominus/js/moment-timezone.min.js"></script>
    <script src="lib/tempusdominus/js/tempusdominus-bootstrap-4.min.js"></script>

    <!-- Template Javascript -->
    <script src="js/main.js"></script>
    
    <script>
        function deleteCrypto(id) {
            if (confirm('Bu kripto adresini silmek istediğinizden emin misiniz?')) {
                document.getElementById('deleteId').value = id;
                document.getElementById('deleteForm').submit();
            }
        }
    </script>
</body>

</html>
